/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.raknet;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.ThreadGroups;
import zombie.core.Translator;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.RakNetPeerInterface;
import zombie.core.raknet.UdpConnection;
import zombie.core.raknet.VoiceManager;
import zombie.core.secure.PZcrypt;
import zombie.core.znet.SteamUser;
import zombie.core.znet.SteamUtils;
import zombie.debug.DebugLog;
import zombie.debug.LogSeverity;
import zombie.network.ConnectionManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.PacketValidator;
import zombie.network.RequestDataManager;
import zombie.network.ServerOptions;
import zombie.network.ServerWorldDatabase;

public class UdpEngine {
    private int maxConnections = 0;
    private final Map<Long, UdpConnection> connectionMap = new HashMap<Long, UdpConnection>();
    public final List<UdpConnection> connections = new ArrayList<UdpConnection>();
    protected final RakNetPeerInterface peer;
    final boolean bServer;
    Lock bufferLock = new ReentrantLock();
    private ByteBuffer bb = ByteBuffer.allocate(500000);
    private ByteBufferWriter bbw = new ByteBufferWriter(this.bb);
    public int port = 0;
    private final Thread thread;
    private boolean bQuit;
    UdpConnection[] connectionArray = new UdpConnection[256];
    ByteBuffer buf = ByteBuffer.allocate(1000000);

    public UdpEngine(int n, int n2, int n3, String string, boolean bl) throws ConnectException {
        this.port = n;
        this.peer = new RakNetPeerInterface();
        DebugLog.Network.println("Initialising RakNet...");
        this.peer.Init(SteamUtils.isSteamModeEnabled());
        this.peer.SetMaximumIncomingConnections(n3);
        this.bServer = bl;
        if (this.bServer) {
            if (GameServer.IPCommandline != null) {
                this.peer.SetServerIP(GameServer.IPCommandline);
            }
            this.peer.SetServerPort(n, n2);
            this.peer.SetIncomingPassword(this.hashServerPassword(string));
        } else {
            this.peer.SetClientPort(GameServer.DEFAULT_PORT + Rand.Next(10000) + 1234);
        }
        this.peer.SetOccasionalPing(true);
        this.maxConnections = n3;
        int n4 = this.peer.Startup(n3);
        DebugLog.Network.println("RakNet.Startup() return code: %s (0 means success)", n4);
        if (n4 != 0) {
            throw new ConnectException("Connection Startup Failed. Code: " + n4);
        }
        if (bl) {
            VoiceManager.instance.InitVMServer();
        }
        this.thread = new Thread(ThreadGroups.Network, this::threadRun, "UdpEngine");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadRun() {
        while (!this.bQuit) {
            ByteBuffer byteBuffer = this.Receive();
            if (this.bQuit) break;
            try {
                this.decode(byteBuffer);
            }
            catch (Exception exception) {
                DebugLog.Network.printException(exception, "Exception thrown during decode.", LogSeverity.Error);
            }
        }
    }

    public void Shutdown() {
        DebugLog.log("waiting for UdpEngine thread termination");
        this.bQuit = true;
        while (this.thread.isAlive()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.peer.Shutdown();
    }

    public void SetServerPassword(String string) {
        if (this.peer != null) {
            this.peer.SetIncomingPassword(string);
        }
    }

    public String hashServerPassword(String string) {
        return PZcrypt.hash(string, true);
    }

    public String getServerIP() {
        return this.peer.GetServerIP();
    }

    public long getClientSteamID(long l) {
        return this.peer.GetClientSteamID(l);
    }

    public long getClientOwnerSteamID(long l) {
        return this.peer.GetClientOwnerSteamID(l);
    }

    public ByteBufferWriter startPacket() {
        this.bufferLock.lock();
        this.bb.clear();
        return this.bbw;
    }

    public void endPacketBroadcast(PacketTypes.PacketType packetType) {
        this.bb.flip();
        this.peer.Send(this.bb, packetType.PacketPriority, packetType.PacketPriority, (byte)0, -1L, true);
        this.bufferLock.unlock();
    }

    public void endPacketBroadcastExcept(int n, int n2, UdpConnection udpConnection) {
        this.bb.flip();
        this.peer.Send(this.bb, n, n2, (byte)0, udpConnection.connectedGUID, true);
        this.bufferLock.unlock();
    }

    public void connected() {
        VoiceManager.instance.VoiceConnectReq(GameClient.connection.getConnectedGUID());
        if (GameClient.bClient && !GameClient.askPing) {
            GameClient.startAuth = Calendar.getInstance();
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.Login.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(GameClient.username);
            byteBufferWriter.putUTF(PZcrypt.hash(ServerWorldDatabase.encrypt(GameClient.password)));
            byteBufferWriter.putUTF(Core.getInstance().getVersion());
            PacketTypes.PacketType.Login.send(GameClient.connection);
            RequestDataManager.getInstance().clear();
            ConnectionManager.log("send-packet", "login", GameClient.connection);
        } else if (GameClient.bClient && GameClient.askPing) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.Ping.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(GameClient.ip);
            PacketTypes.PacketType.Ping.send(GameClient.connection);
            RequestDataManager.getInstance().clear();
        }
    }

    private void decode(ByteBuffer byteBuffer) {
        int n = byteBuffer.get() & 0xFF;
        switch (n) {
            case 21: {
                int n2 = byteBuffer.get() & 0xFF;
                long l = this.peer.getGuidOfPacket();
                ConnectionManager.log("RakNet", "disconnection-notification", this.connectionArray[n2]);
                this.removeConnection(n2);
                if (!GameClient.bClient) break;
                GameClient.instance.addDisconnectPacket(n);
                break;
            }
            case 19: {
                int n3 = byteBuffer.get() & 0xFF;
                long l = this.peer.getGuidOfPacket();
                this.addConnection(n3, l);
                ConnectionManager.log("RakNet", "new-incoming-connection", this.connectionArray[n3]);
                break;
            }
            case 44: {
                long l = this.peer.getGuidOfPacket();
                VoiceManager.instance.VoiceConnectAccept(l);
                break;
            }
            case 45: {
                long l = this.peer.getGuidOfPacket();
                VoiceManager.instance.VoiceOpenChannelReply(l, byteBuffer);
                break;
            }
            case 46: {
                long l = this.peer.getGuidOfPacket();
                UdpConnection udpConnection = this.connectionMap.get(l);
                break;
            }
            case 16: {
                int n4 = byteBuffer.get() & 0xFF;
                long l = this.peer.getGuidOfPacket();
                if (GameClient.bClient) {
                    GameClient.connection = this.addConnection(n4, l);
                    ConnectionManager.log("RakNet", "connection-request-accepted", this.connectionArray[n4]);
                    if (!SteamUtils.isSteamModeEnabled()) {
                        this.connected();
                        break;
                    }
                    GameClient.steamID = SteamUser.GetSteamID();
                    break;
                }
                ConnectionManager.log("RakNet", "connection-request-accepted", this.connectionArray[n4]);
                break;
            }
            case 25: {
                ConnectionManager.log("RakNet", "incompatible-protocol-version", null);
                String string = GameWindow.ReadString(byteBuffer);
                LuaEventManager.triggerEvent("OnConnectionStateChanged", "ClientVersionMismatch", string);
                break;
            }
            case 0: 
            case 1: {
                break;
            }
            case 22: {
                int n5 = byteBuffer.get() & 0xFF;
                ConnectionManager.log("RakNet", "connection-lost", this.connectionArray[n5]);
                this.removeConnection(n5);
                break;
            }
            case 18: {
                ConnectionManager.log("RakNet", "already-connected", null);
                if (!GameClient.bClient) break;
                GameClient.instance.addDisconnectPacket(n);
                break;
            }
            case 31: {
                int n6 = byteBuffer.get() & 0xFF;
                ConnectionManager.log("RakNet", "remote-disconnection-notification", this.connectionArray[n6]);
                break;
            }
            case 32: {
                int n7 = byteBuffer.get() & 0xFF;
                ConnectionManager.log("RakNet", "remote-connection-lost", this.connectionArray[n7]);
                if (!GameClient.bClient) break;
                GameClient.instance.addDisconnectPacket(n);
                break;
            }
            case 33: {
                int n8 = byteBuffer.get() & 0xFF;
                ConnectionManager.log("RakNet", "remote-new-incoming-connection", this.connectionArray[n8]);
                break;
            }
            case 23: {
                int n9 = byteBuffer.get() & 0xFF;
                ConnectionManager.log("RakNet", "connection-banned", this.connectionArray[n9]);
                if (!GameClient.bClient) break;
                GameClient.instance.addDisconnectPacket(n);
                break;
            }
            case 17: {
                ConnectionManager.log("RakNet", "connection-attempt-failed", null);
                if (!GameClient.bClient) break;
                GameClient.instance.addDisconnectPacket(n);
                break;
            }
            case 20: {
                int n10 = byteBuffer.get() & 0xFF;
                ConnectionManager.log("RakNet", "no-free-incoming-connections", this.connectionArray[n10]);
                break;
            }
            case 24: {
                int n11 = byteBuffer.get() & 0xFF;
                ConnectionManager.log("RakNet", "invalid-password", this.connectionArray[n11]);
                if (!GameClient.bClient) break;
                GameClient.instance.addDisconnectPacket(n);
                break;
            }
            case 134: {
                short s = byteBuffer.getShort();
                if (GameServer.bServer) {
                    long l = this.peer.getGuidOfPacket();
                    UdpConnection udpConnection = this.connectionMap.get(l);
                    if (udpConnection == null) {
                        DebugLog.Network.warn("GOT PACKET FROM UNKNOWN CONNECTION guid=%s packetId=%s", l, s);
                        return;
                    }
                    GameServer.addIncoming(s, byteBuffer, udpConnection);
                    break;
                }
                GameClient.instance.addIncoming(s, byteBuffer);
                break;
            }
            default: {
                DebugLog.Network.warn("Received unknown packet: %s", n);
                if (!GameServer.bServer) break;
                long l = this.peer.getGuidOfPacket();
                UdpConnection udpConnection = this.connectionMap.get(l);
                try {
                    if (!ServerOptions.instance.AntiCheatProtectionType10.getValue() || !PacketValidator.checkUser(udpConnection)) break;
                    PacketValidator.doKickUser(udpConnection, String.valueOf(n), "Type10", null);
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void removeConnection(int n) {
        UdpConnection udpConnection = this.connectionArray[n];
        if (udpConnection != null) {
            this.connectionArray[n] = null;
            this.connectionMap.remove(udpConnection.getConnectedGUID());
            if (GameClient.bClient) {
                GameClient.instance.connectionLost();
            }
            if (GameServer.bServer) {
                GameServer.addDisconnect(udpConnection);
            }
        }
    }

    private UdpConnection addConnection(int n, long l) {
        UdpConnection udpConnection = new UdpConnection(this, l, n);
        this.connectionMap.put(l, udpConnection);
        this.connectionArray[n] = udpConnection;
        if (GameServer.bServer) {
            GameServer.addConnection(udpConnection);
        }
        return udpConnection;
    }

    public ByteBuffer Receive() {
        boolean bl = false;
        do {
            if (bl = this.peer.Receive(this.buf)) {
                return this.buf;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } while (!this.bQuit && !bl);
        return this.buf;
    }

    public UdpConnection getActiveConnection(long l) {
        if (!this.connectionMap.containsKey(l)) {
            return null;
        }
        return this.connectionMap.get(l);
    }

    public void Connect(String string, int n, String string2, boolean bl) {
        if (n == 0 && SteamUtils.isSteamModeEnabled()) {
            long l = 0L;
            try {
                l = SteamUtils.convertStringToSteamID(string);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                LuaEventManager.triggerEvent("OnConnectFailed", Translator.getText("UI_OnConnectFailed_UnknownHost"));
                return;
            }
            this.peer.ConnectToSteamServer(l, this.hashServerPassword(string2), bl);
        } else {
            String string3 = string;
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                string3 = inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace();
                LuaEventManager.triggerEvent("OnConnectFailed", Translator.getText("UI_OnConnectFailed_UnknownHost"));
                return;
            }
            this.peer.Connect(string3, n, this.hashServerPassword(string2), bl);
        }
    }

    public void forceDisconnect(long l, String string) {
        this.peer.disconnect(l, string);
        this.removeConnection(l);
    }

    private void removeConnection(long l) {
        UdpConnection udpConnection = this.connectionMap.remove(l);
        if (udpConnection != null) {
            this.removeConnection(udpConnection.index);
        }
    }

    public RakNetPeerInterface getPeer() {
        return this.peer;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public String getDescription() {
        return "connections=[" + this.connections.size() + "/" + this.connectionMap.size() + "/" + Arrays.stream(this.connectionArray).filter(Objects::nonNull).count() + "/" + this.peer.GetConnectionsNumber() + "]";
    }
}

