/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.profiling;

import zombie.core.profiling.AbstractPerformanceProfileProbe;
import zombie.core.profiling.PerformanceProfileProbe;
import zombie.util.list.PZArrayUtil;

public class PerformanceProfileProbeList<Probe extends PerformanceProfileProbe> {
    final String m_prefix;
    final Probe[] layers;

    public static PerformanceProfileProbeList<PerformanceProfileProbe> construct(String string, int n) {
        return new PerformanceProfileProbeList<PerformanceProfileProbe>(string, n, PerformanceProfileProbe.class, PerformanceProfileProbe::new);
    }

    public static <Probe extends PerformanceProfileProbe> PerformanceProfileProbeList<Probe> construct(String string, int n, Class<Probe> clazz, Constructor<Probe> constructor) {
        return new PerformanceProfileProbeList<Probe>(string, n, clazz, constructor);
    }

    protected PerformanceProfileProbeList(String string, int n, Class<Probe> clazz, Constructor<Probe> constructor) {
        this.m_prefix = string;
        this.layers = (PerformanceProfileProbe[])PZArrayUtil.newInstance(clazz, n + 1);
        for (int i = 0; i < n; ++i) {
            this.layers[i] = constructor.get(string + "_" + i);
        }
        this.layers[n] = constructor.get(string + "_etc");
    }

    public int count() {
        return this.layers.length;
    }

    public Probe at(int n) {
        if (n < this.count()) {
            return this.layers[n];
        }
        return this.layers[this.count() - 1];
    }

    public Probe start(int n) {
        Probe Probe = this.at(n);
        ((AbstractPerformanceProfileProbe)Probe).start();
        return Probe;
    }

    public static interface Constructor<Probe extends PerformanceProfileProbe> {
        public Probe get(String var1);
    }
}

