/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.physics;

import gnu.trove.list.array.TFloatArrayList;
import org.lwjgl.opengl.GL11;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.opengl.VBOLines;
import zombie.core.physics.WorldSimulation;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.iso.IsoCamera;
import zombie.iso.IsoUtils;
import zombie.popman.ObjectPool;

public final class PhysicsDebugRenderer
extends TextureDraw.GenericDrawer {
    private static final ObjectPool<PhysicsDebugRenderer> POOL = new ObjectPool<PhysicsDebugRenderer>(PhysicsDebugRenderer::new);
    private static final VBOLines vboLines = new VBOLines();
    private float camOffX;
    private float camOffY;
    private float deferredX;
    private float deferredY;
    private int drawOffsetX;
    private int drawOffsetY;
    private int playerIndex;
    private float playerX;
    private float playerY;
    private float playerZ;
    private float offscreenWidth;
    private float offscreenHeight;
    private final TFloatArrayList elements = new TFloatArrayList();

    public static PhysicsDebugRenderer alloc() {
        return POOL.alloc();
    }

    public void release() {
        POOL.release(this);
    }

    public void init(IsoPlayer isoPlayer) {
        this.playerIndex = isoPlayer.getPlayerNum();
        this.camOffX = IsoCamera.getRightClickOffX() + (float)IsoCamera.PLAYER_OFFSET_X;
        this.camOffY = IsoCamera.getRightClickOffY() + (float)IsoCamera.PLAYER_OFFSET_Y;
        this.camOffX += this.XToScreenExact(isoPlayer.x - (float)((int)isoPlayer.x), isoPlayer.y - (float)((int)isoPlayer.y), 0.0f, 0);
        this.camOffY += this.YToScreenExact(isoPlayer.x - (float)((int)isoPlayer.x), isoPlayer.y - (float)((int)isoPlayer.y), 0.0f, 0);
        this.deferredX = IsoCamera.cameras[this.playerIndex].DeferedX;
        this.deferredY = IsoCamera.cameras[this.playerIndex].DeferedY;
        this.drawOffsetX = (int)isoPlayer.x;
        this.drawOffsetY = (int)isoPlayer.y;
        this.playerX = isoPlayer.x;
        this.playerY = isoPlayer.y;
        this.playerZ = isoPlayer.z;
        this.offscreenWidth = Core.getInstance().getOffscreenWidth(this.playerIndex);
        this.offscreenHeight = Core.getInstance().getOffscreenHeight(this.playerIndex);
        this.elements.clear();
        int n = (int)WorldSimulation.instance.offsetX - this.drawOffsetX;
        int n2 = (int)WorldSimulation.instance.offsetY - this.drawOffsetY;
        this.n_debugDrawWorld(n, n2);
    }

    @Override
    public void render() {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.offscreenWidth, (double)this.offscreenHeight, (double)0.0, (double)10000.0, (double)-10000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        int n = -this.drawOffsetX;
        int n2 = -this.drawOffsetY;
        float f = this.deferredX;
        float f2 = this.deferredY;
        GL11.glTranslatef((float)(this.offscreenWidth / 2.0f), (float)(this.offscreenHeight / 2.0f), (float)0.0f);
        float f3 = this.XToScreenExact(f, f2, this.playerZ, 0);
        float f4 = this.YToScreenExact(f, f2, this.playerZ, 0);
        GL11.glTranslatef((float)(-(f3 += this.camOffX)), (float)(-(f4 += this.camOffY)), (float)0.0f);
        n = (int)((float)n + WorldSimulation.instance.offsetX);
        n2 = (int)((float)n2 + WorldSimulation.instance.offsetY);
        int n3 = 32 * Core.TileScale;
        float f5 = (float)Math.sqrt(n3 * n3 + n3 * n3);
        GL11.glScalef((float)f5, (float)f5, (float)f5);
        GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        vboLines.setLineWidth(1.0f);
        int n4 = 0;
        while (n4 < this.elements.size()) {
            float f6 = this.elements.getQuick(n4++);
            float f7 = this.elements.getQuick(n4++);
            float f8 = this.elements.getQuick(n4++);
            float f9 = this.elements.getQuick(n4++);
            float f10 = this.elements.getQuick(n4++);
            float f11 = this.elements.getQuick(n4++);
            float f12 = this.elements.getQuick(n4++);
            float f13 = this.elements.getQuick(n4++);
            float f14 = this.elements.getQuick(n4++);
            float f15 = this.elements.getQuick(n4++);
            float f16 = this.elements.getQuick(n4++);
            float f17 = this.elements.getQuick(n4++);
            vboLines.addLine(f6, f7, f8, f9, f10, f11, f12, f13, f14, 1.0f, f15, f16, f17, 1.0f);
        }
        vboLines.flush();
        GL11.glLineWidth((float)1.0f);
        GL11.glBegin((int)1);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)1.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)1.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)1.0);
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopAttrib();
        Texture.lastTextureID = -1;
    }

    @Override
    public void postRender() {
        this.release();
    }

    public float YToScreenExact(float f, float f2, float f3, int n) {
        return IsoUtils.YToScreen(f, f2, f3, n);
    }

    public float XToScreenExact(float f, float f2, float f3, int n) {
        return IsoUtils.XToScreen(f, f2, f3, n);
    }

    public void drawLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        if (f < -1000.0f || f > 1000.0f || f2 < -1000.0f || f2 > 1000.0f) {
            return;
        }
        this.elements.add(f);
        this.elements.add(f2);
        this.elements.add(f3);
        this.elements.add(f4);
        this.elements.add(f5);
        this.elements.add(f6);
        this.elements.add(f7);
        this.elements.add(f8);
        this.elements.add(f9);
        this.elements.add(f10);
        this.elements.add(f11);
        this.elements.add(f12);
    }

    public void drawSphere(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
    }

    public void drawTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
    }

    public void drawContactPoint(float f, float f2, float f3, float f4, float f5, float f6, float f7, int n, float f8, float f9, float f10) {
    }

    public native void n_debugDrawWorld(int var1, int var2);
}

