/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.physics;

import org.joml.Vector3f;
import org.joml.Vector3fc;
import zombie.GameTime;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.Moodles.MoodleType;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.core.physics.Bullet;
import zombie.core.physics.Transform;
import zombie.core.physics.WorldSimulation;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.input.GameKeyboard;
import zombie.input.JoypadManager;
import zombie.iso.Vector2;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerOptions;
import zombie.scripting.objects.VehicleScript;
import zombie.ui.UIManager;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.EngineRPMData;
import zombie.vehicles.PolygonalMap2;
import zombie.vehicles.TransmissionNumber;

public final class CarController {
    public final BaseVehicle vehicleObject;
    public float clientForce = 0.0f;
    public float EngineForce = 0.0f;
    public float BrakingForce = 0.0f;
    private float VehicleSteering = 0.0f;
    boolean isGas = false;
    boolean isGasR = false;
    boolean isBreak = false;
    private float atRestTimer = -1.0f;
    private float regulatorTimer = 0.0f;
    public boolean isEnable = false;
    private final Transform tempXfrm = new Transform();
    private final Vector2 tempVec2 = new Vector2();
    private final Vector3f tempVec3f = new Vector3f();
    private final Vector3f tempVec3f_2 = new Vector3f();
    private final Vector3f tempVec3f_3 = new Vector3f();
    private static final Vector3f _UNIT_Y = new Vector3f(0.0f, 1.0f, 0.0f);
    public boolean acceleratorOn = false;
    public boolean brakeOn = false;
    public float speed = 0.0f;
    public static GearInfo[] gears = new GearInfo[3];
    public final ClientControls clientControls = new ClientControls();
    private boolean engineStartingFromKeyboard;
    private static final BulletVariables bulletVariables;
    float drunkDelayCommandTimer = 0.0f;
    boolean wasBreaking = false;
    boolean wasGas = false;
    boolean wasGasR = false;
    boolean wasSteering = false;

    public CarController(BaseVehicle baseVehicle) {
        this.vehicleObject = baseVehicle;
        this.engineStartingFromKeyboard = false;
        VehicleScript vehicleScript = baseVehicle.getScript();
        float f = baseVehicle.savedPhysicsZ;
        if (Float.isNaN(f)) {
            float f2 = Math.max((float)((int)baseVehicle.z), 0.0f);
            if (vehicleScript.getWheelCount() > 0) {
                Vector3f vector3f = vehicleScript.getModelOffset();
                f2 += vector3f.y();
                f2 += vehicleScript.getWheel(0).getOffset().y() - vehicleScript.getWheel((int)0).radius;
            }
            float f3 = vehicleScript.getCenterOfMassOffset().y() - vehicleScript.getExtents().y() / 2.0f;
            baseVehicle.jniTransform.origin.y = f = 0.0f - Math.min(f2, f3);
        }
        if (!GameServer.bServer) {
            Bullet.addVehicle(baseVehicle.VehicleID, baseVehicle.x, baseVehicle.y, f, baseVehicle.savedRot.x, baseVehicle.savedRot.y, baseVehicle.savedRot.z, baseVehicle.savedRot.w, vehicleScript.getFullName());
            Bullet.setVehicleStatic(baseVehicle, baseVehicle.isNetPlayerAuthorization(BaseVehicle.Authorization.Remote));
            DebugLog.Vehicle.debugln("Vehicle vid=%d type=%s has been added at (%f;%f;%f) auth=%s", baseVehicle.VehicleID, vehicleScript.getFullName(), Float.valueOf(baseVehicle.x), Float.valueOf(baseVehicle.y), Float.valueOf(f), baseVehicle.getAuthorizationDescription());
        }
    }

    public GearInfo findGear(float f) {
        for (int i = 0; i < gears.length; ++i) {
            if (!(f >= (float)CarController.gears[i].minSpeed) || !(f < (float)CarController.gears[i].maxSpeed)) continue;
            return gears[i];
        }
        return null;
    }

    public void accelerator(boolean bl) {
        this.acceleratorOn = bl;
    }

    public void brake(boolean bl) {
        this.brakeOn = bl;
    }

    public ClientControls getClientControls() {
        return this.clientControls;
    }

    public void update() {
        float f;
        float f2;
        if (this.vehicleObject.getVehicleTowedBy() != null) {
            return;
        }
        VehicleScript vehicleScript = this.vehicleObject.getScript();
        this.speed = this.vehicleObject.getCurrentSpeedKmHour();
        boolean bl = this.vehicleObject.getDriver() != null && this.vehicleObject.getDriver().getMoodles().getMoodleLevel(MoodleType.Drunk) > 1;
        float f3 = 0.0f;
        Vector3f vector3f = this.vehicleObject.getLinearVelocity(this.tempVec3f_2);
        vector3f.y = 0.0f;
        if ((double)vector3f.length() > 0.5) {
            vector3f.normalize();
            Vector3f vector3f2 = this.tempVec3f;
            this.vehicleObject.getForwardVector(vector3f2);
            f3 = vector3f.dot((Vector3fc)vector3f2);
        }
        float f4 = 1.0f;
        if (GameClient.bClient) {
            f2 = this.vehicleObject.jniSpeed / Math.min(120.0f, (float)ServerOptions.instance.SpeedLimit.getValue());
            f2 *= f2;
            f4 = GameTime.getInstance().Lerp(1.0f, BaseVehicle.getFakeSpeedModifier(), f2);
        }
        f2 = this.vehicleObject.getCurrentSpeedKmHour() * f4;
        this.isGas = false;
        this.isGasR = false;
        this.isBreak = false;
        if (this.clientControls.forward) {
            if (f3 < 0.0f) {
                this.isBreak = true;
            }
            if (f3 >= 0.0f) {
                this.isGas = true;
            }
            this.isGasR = false;
        }
        if (this.clientControls.backward) {
            if (f3 > 0.0f) {
                this.isBreak = true;
            }
            if (f3 <= 0.0f) {
                this.isGasR = true;
            }
            this.isGas = false;
        }
        if (this.clientControls.brake) {
            this.isBreak = true;
            this.isGas = false;
            this.isGasR = false;
        }
        if (this.clientControls.forward && this.clientControls.backward) {
            this.isBreak = true;
            this.isGas = false;
            this.isGasR = false;
        }
        if (bl && this.vehicleObject.engineState != BaseVehicle.engineStateTypes.Idle) {
            if (this.isBreak && !this.wasBreaking) {
                this.isBreak = this.delayCommandWhileDrunk(this.isBreak);
            }
            if (this.isGas && !this.wasGas) {
                this.isGas = this.delayCommandWhileDrunk(this.isGas);
            }
            if (this.isGasR && !this.wasGasR) {
                this.isGasR = this.delayCommandWhileDrunk(this.isGas);
            }
            if (this.clientControls.steering != 0.0f && !this.wasSteering) {
                this.clientControls.steering = this.delayCommandWhileDrunk(this.clientControls.steering);
            }
        }
        this.updateRegulator();
        this.wasBreaking = this.isBreak;
        this.wasGas = this.isGas;
        this.wasGasR = this.isGasR;
        boolean bl2 = this.wasSteering = this.clientControls.steering != 0.0f;
        if (!this.isGasR && this.vehicleObject.isInvalidChunkAhead()) {
            this.isBreak = true;
            this.isGas = false;
            this.isGasR = false;
        } else if (!this.isGas && this.vehicleObject.isInvalidChunkBehind()) {
            this.isBreak = true;
            this.isGas = false;
            this.isGasR = false;
        }
        if (this.clientControls.shift) {
            this.isGas = false;
            this.isBreak = false;
            this.isGasR = false;
            this.clientControls.wasUsingParkingBrakes = false;
        }
        float f5 = this.vehicleObject.throttle;
        f5 = this.isGas || this.isGasR ? (f5 += GameTime.getInstance().getMultiplier() / 30.0f) : (f5 -= GameTime.getInstance().getMultiplier() / 30.0f);
        if (f5 < 0.0f) {
            f5 = 0.0f;
        }
        if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        if (this.vehicleObject.isRegulator() && !this.isGas && !this.isGasR) {
            f5 = 0.5f;
            if (f2 < this.vehicleObject.getRegulatorSpeed()) {
                this.isGas = true;
            }
        }
        this.vehicleObject.throttle = f5;
        float f6 = GameTime.getInstance().getMultiplier() / 0.8f;
        ControlState controlState = ControlState.NoControl;
        if (this.isBreak) {
            controlState = ControlState.Braking;
        } else if (this.isGas && !this.isGasR) {
            controlState = ControlState.Forward;
        } else if (!this.isGas && this.isGasR) {
            controlState = ControlState.Reverse;
        }
        if (controlState != ControlState.NoControl) {
            UIManager.speedControls.SetCurrentGameSpeed(1);
        }
        if (controlState == ControlState.NoControl) {
            this.control_NoControl();
        }
        if (controlState == ControlState.Reverse) {
            this.control_Reverse(f2);
        }
        if (controlState == ControlState.Forward) {
            this.control_ForwardNew(f2);
        }
        this.updateBackSignal();
        if (controlState == ControlState.Braking) {
            this.control_Braking();
        }
        this.updateBrakeLights();
        BaseVehicle baseVehicle = this.vehicleObject.getVehicleTowedBy();
        if (baseVehicle != null && baseVehicle.getDriver() == null && this.vehicleObject.getDriver() != null && !GameClient.bClient) {
            this.vehicleObject.addPointConstraint(null, baseVehicle, this.vehicleObject.getTowAttachmentSelf(), baseVehicle.getTowAttachmentSelf());
        }
        this.updateRammingSound(f2);
        if (Math.abs(this.clientControls.steering) > 0.1f) {
            f = 1.0f - this.speed / this.vehicleObject.getMaxSpeed();
            if (f < 0.1f) {
                f = 0.1f;
            }
            this.VehicleSteering -= (this.clientControls.steering + this.VehicleSteering) * 0.06f * f6 * f;
        } else if ((double)Math.abs(this.VehicleSteering) <= 0.04) {
            this.VehicleSteering = 0.0f;
        } else if (this.VehicleSteering > 0.0f) {
            this.VehicleSteering -= 0.04f * f6;
            this.VehicleSteering = Math.max(this.VehicleSteering, 0.0f);
        } else {
            this.VehicleSteering += 0.04f * f6;
            this.VehicleSteering = Math.min(this.VehicleSteering, 0.0f);
        }
        f = vehicleScript.getSteeringClamp(this.speed);
        this.VehicleSteering = PZMath.clamp(this.VehicleSteering, -f, f);
        BulletVariables bulletVariables = CarController.bulletVariables.set(this.vehicleObject, this.EngineForce, this.BrakingForce, this.VehicleSteering);
        this.checkTire(bulletVariables);
        this.EngineForce = bulletVariables.engineForce;
        this.BrakingForce = bulletVariables.brakingForce;
        this.VehicleSteering = bulletVariables.vehicleSteering;
        if (this.vehicleObject.isDoingOffroad()) {
            int n = this.vehicleObject.getTransmissionNumber();
            if (n <= 0) {
                n = 1;
            }
            this.EngineForce = (float)((double)this.EngineForce / ((double)n * 1.5));
        }
        this.vehicleObject.setCurrentSteering(this.VehicleSteering);
        this.vehicleObject.setBraking(this.isBreak);
        if (!GameServer.bServer) {
            this.checkShouldBeActive();
            Bullet.controlVehicle(this.vehicleObject.VehicleID, this.EngineForce, this.BrakingForce, this.VehicleSteering);
            if (this.EngineForce > 0.0f && this.vehicleObject.engineState == BaseVehicle.engineStateTypes.Idle && !this.engineStartingFromKeyboard) {
                this.engineStartingFromKeyboard = true;
                if (GameClient.bClient) {
                    Boolean bl3 = this.vehicleObject.getDriver().getInventory().haveThisKeyId(this.vehicleObject.getKeyId()) != null ? Boolean.TRUE : Boolean.FALSE;
                    GameClient.instance.sendClientCommandV((IsoPlayer)this.vehicleObject.getDriver(), "vehicle", "startEngine", "haveKey", bl3);
                } else {
                    this.vehicleObject.tryStartEngine();
                }
            }
            if (this.engineStartingFromKeyboard && this.EngineForce == 0.0f) {
                this.engineStartingFromKeyboard = false;
            }
        }
        if (this.vehicleObject.engineState != BaseVehicle.engineStateTypes.Running) {
            this.acceleratorOn = false;
            if (!GameServer.bServer && this.vehicleObject.jniSpeed > 5.0f && this.vehicleObject.getScript().getWheelCount() > 0) {
                Bullet.controlVehicle(this.vehicleObject.VehicleID, 0.0f, this.BrakingForce, this.VehicleSteering);
            } else {
                this.park();
            }
        }
    }

    public void updateTrailer() {
        BaseVehicle baseVehicle = this.vehicleObject.getVehicleTowedBy();
        if (baseVehicle == null) {
            return;
        }
        if (GameServer.bServer) {
            if (baseVehicle.getDriver() == null && this.vehicleObject.getDriver() != null) {
                this.vehicleObject.addPointConstraint(null, baseVehicle, this.vehicleObject.getTowAttachmentSelf(), baseVehicle.getTowAttachmentSelf());
            }
            return;
        }
        this.speed = this.vehicleObject.getCurrentSpeedKmHour();
        this.isGas = false;
        this.isGasR = false;
        this.isBreak = false;
        this.wasGas = false;
        this.wasGasR = false;
        this.wasBreaking = false;
        this.vehicleObject.throttle = 0.0f;
        if (baseVehicle.getDriver() == null && this.vehicleObject.getDriver() != null && !GameClient.bClient) {
            this.vehicleObject.addPointConstraint(null, baseVehicle, this.vehicleObject.getTowAttachmentSelf(), baseVehicle.getTowAttachmentSelf());
            return;
        }
        this.checkShouldBeActive();
        this.EngineForce = 0.0f;
        this.BrakingForce = 0.0f;
        this.VehicleSteering = 0.0f;
        if (!this.vehicleObject.getScriptName().contains("Trailer")) {
            this.BrakingForce = 10.0f;
        }
        Bullet.controlVehicle(this.vehicleObject.VehicleID, this.EngineForce, this.BrakingForce, this.VehicleSteering);
    }

    private void updateRegulator() {
        if (this.regulatorTimer > 0.0f) {
            this.regulatorTimer -= GameTime.getInstance().getMultiplier() / 1.6f;
        }
        if (this.clientControls.shift) {
            if (this.clientControls.forward && this.regulatorTimer <= 0.0f) {
                if (this.vehicleObject.getRegulatorSpeed() < this.vehicleObject.getMaxSpeed() + 20.0f && (!this.vehicleObject.isRegulator() && this.vehicleObject.getRegulatorSpeed() == 0.0f || this.vehicleObject.isRegulator())) {
                    if (this.vehicleObject.getRegulatorSpeed() == 0.0f && this.vehicleObject.getCurrentSpeedForRegulator() != this.vehicleObject.getRegulatorSpeed()) {
                        this.vehicleObject.setRegulatorSpeed(this.vehicleObject.getCurrentSpeedForRegulator());
                    } else {
                        this.vehicleObject.setRegulatorSpeed(this.vehicleObject.getRegulatorSpeed() + 5.0f);
                    }
                }
                this.vehicleObject.setRegulator(true);
                this.regulatorTimer = 20.0f;
            } else if (this.clientControls.backward && this.regulatorTimer <= 0.0f) {
                this.regulatorTimer = 20.0f;
                if (this.vehicleObject.getRegulatorSpeed() >= 5.0f && (!this.vehicleObject.isRegulator() && this.vehicleObject.getRegulatorSpeed() == 0.0f || this.vehicleObject.isRegulator())) {
                    this.vehicleObject.setRegulatorSpeed(this.vehicleObject.getRegulatorSpeed() - 5.0f);
                }
                this.vehicleObject.setRegulator(true);
                if (this.vehicleObject.getRegulatorSpeed() <= 0.0f) {
                    this.vehicleObject.setRegulatorSpeed(0.0f);
                    this.vehicleObject.setRegulator(false);
                }
            }
        } else if (this.isGasR || this.isBreak) {
            this.vehicleObject.setRegulator(false);
        }
    }

    public void control_NoControl() {
        float f = GameTime.getInstance().getMultiplier() / 0.8f;
        if (!this.vehicleObject.isEngineRunning()) {
            if (this.vehicleObject.engineSpeed > 0.0) {
                this.vehicleObject.engineSpeed = Math.max(this.vehicleObject.engineSpeed - (double)(50.0f * f), 0.0);
            }
        } else if (this.vehicleObject.engineSpeed > (double)this.vehicleObject.getScript().getEngineIdleSpeed()) {
            if (!this.vehicleObject.isRegulator()) {
                this.vehicleObject.engineSpeed -= (double)(20.0f * f);
            }
        } else {
            this.vehicleObject.engineSpeed += (double)(20.0f * f);
        }
        if (!this.vehicleObject.isRegulator()) {
            this.vehicleObject.transmissionNumber = TransmissionNumber.N;
        }
        this.EngineForce = 0.0f;
        this.BrakingForce = this.vehicleObject.engineSpeed > 1000.0 ? 15.0f : 10.0f;
    }

    private void control_Braking() {
        float f = GameTime.getInstance().getMultiplier() / 0.8f;
        this.vehicleObject.engineSpeed = this.vehicleObject.engineSpeed > (double)this.vehicleObject.getScript().getEngineIdleSpeed() ? (this.vehicleObject.engineSpeed -= (double)((float)Rand.Next(10, 30) * f)) : (this.vehicleObject.engineSpeed += (double)((float)Rand.Next(20) * f));
        this.vehicleObject.transmissionNumber = TransmissionNumber.N;
        this.EngineForce = 0.0f;
        this.BrakingForce = this.vehicleObject.getBrakingForce();
        if (this.clientControls.brake) {
            this.BrakingForce *= 13.0f;
        }
    }

    private void control_Forward(float f) {
        boolean bl;
        float f2 = GameTime.getInstance().getMultiplier() / 0.8f;
        IsoGameCharacter isoGameCharacter = this.vehicleObject.getDriver();
        boolean bl2 = isoGameCharacter != null && isoGameCharacter.Traits.SpeedDemon.isSet();
        boolean bl3 = isoGameCharacter != null && isoGameCharacter.Traits.SundayDriver.isSet();
        int n = this.vehicleObject.getScript().gearRatioCount;
        float f3 = 0.0f;
        if (this.vehicleObject.transmissionNumber == TransmissionNumber.N) {
            this.vehicleObject.transmissionNumber = TransmissionNumber.Speed1;
            bl = false;
            while (true) {
                if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed1) {
                    f3 = 3000.0f * f / 30.0f;
                }
                if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed2) {
                    f3 = 3000.0f * f / 40.0f;
                }
                if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed3) {
                    f3 = 3000.0f * f / 60.0f;
                }
                if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed4) {
                    f3 = 3000.0f * f / 85.0f;
                }
                if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed5) {
                    f3 = 3000.0f * f / 105.0f;
                }
                if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed6) {
                    f3 = 3000.0f * f / 130.0f;
                }
                if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed7) {
                    f3 = 3000.0f * f / 160.0f;
                }
                if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed8) {
                    f3 = 3000.0f * f / 200.0f;
                }
                if (bl2) {
                    if (f3 > 6000.0f) {
                        this.vehicleObject.changeTransmission(this.vehicleObject.transmissionNumber.getNext(n));
                        bl = true;
                    }
                } else if (f3 > 3000.0f) {
                    this.vehicleObject.changeTransmission(this.vehicleObject.transmissionNumber.getNext(n));
                    bl = true;
                }
                if (!bl || this.vehicleObject.transmissionNumber.getIndex() >= n) break;
                bl = false;
            }
        }
        if (bl2) {
            if (this.vehicleObject.engineSpeed > 6000.0 && this.vehicleObject.transmissionChangeTime.Check()) {
                this.vehicleObject.changeTransmission(this.vehicleObject.transmissionNumber.getNext(n));
            }
        } else if (this.vehicleObject.engineSpeed > 3000.0 && this.vehicleObject.transmissionChangeTime.Check()) {
            this.vehicleObject.changeTransmission(this.vehicleObject.transmissionNumber.getNext(n));
        }
        if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed1) {
            f3 = 3000.0f * f / 30.0f;
        }
        if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed2) {
            f3 = 3000.0f * f / 40.0f;
        }
        if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed3) {
            f3 = 3000.0f * f / 60.0f;
        }
        if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed4) {
            f3 = 3000.0f * f / 85.0f;
        }
        if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed5) {
            f3 = 3000.0f * f / 105.0f;
        }
        if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed6) {
            f3 = 3000.0f * f / 130.0f;
        }
        if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed7) {
            f3 = 3000.0f * f / 160.0f;
        }
        if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed8) {
            f3 = 3000.0f * f / 200.0f;
        }
        this.vehicleObject.engineSpeed -= Math.min(0.5 * (this.vehicleObject.engineSpeed - (double)f3), 100.0) * (double)f2;
        if (bl2) {
            if (f < 50.0f) {
                this.vehicleObject.engineSpeed -= Math.min(0.06 * (this.vehicleObject.engineSpeed - 7000.0), (double)(30.0f - f)) * (double)f2;
            }
        } else if (f < 30.0f) {
            this.vehicleObject.engineSpeed -= Math.min(0.02 * (this.vehicleObject.engineSpeed - 7000.0), (double)(30.0f - f)) * (double)f2;
        }
        this.EngineForce = (float)((double)this.vehicleObject.getEnginePower() * (0.5 + this.vehicleObject.engineSpeed / 24000.0));
        this.EngineForce -= this.EngineForce * (f / 200.0f);
        bl = false;
        if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed1 && this.vehicleObject.getVehicleTowedBy() != null) {
            if (this.vehicleObject.getVehicleTowedBy().getScript().getPassengerCount() == 0 && this.vehicleObject.getVehicleTowedBy().getScript().getMass() > 200.0f) {
                bl = true;
            }
            int n2 = bl ? 20 : 5;
            if (f < (float)n2) {
                this.EngineForce *= Math.min(1.2f, this.vehicleObject.getVehicleTowedBy().getMass() / 500.0f);
                if (bl) {
                    this.EngineForce *= 4.0f;
                }
            }
        }
        if (this.vehicleObject.engineSpeed > 6000.0) {
            this.EngineForce = (float)((double)this.EngineForce * ((7000.0 - this.vehicleObject.engineSpeed) / 1000.0));
        }
        if (bl3) {
            this.EngineForce *= 0.6f;
            if (f > 20.0f) {
                this.EngineForce *= (40.0f - f) / 20.0f;
            }
        }
        if (bl2) {
            if (f > this.vehicleObject.getMaxSpeed() * 1.15f) {
                this.EngineForce *= (this.vehicleObject.getMaxSpeed() * 1.15f + 20.0f - f) / 20.0f;
            }
        } else if (f > this.vehicleObject.getMaxSpeed()) {
            this.EngineForce *= (this.vehicleObject.getMaxSpeed() + 20.0f - f) / 20.0f;
        }
        this.BrakingForce = 0.0f;
        if (this.clientControls.wasUsingParkingBrakes) {
            this.clientControls.wasUsingParkingBrakes = false;
            this.EngineForce *= 8.0f;
        }
        if (GameClient.bClient && (double)this.vehicleObject.jniSpeed >= ServerOptions.instance.SpeedLimit.getValue()) {
            this.EngineForce = 0.0f;
        }
    }

    private void control_ForwardNew(float f) {
        float f2;
        float f3 = GameTime.getInstance().getMultiplier() / 0.8f;
        IsoGameCharacter isoGameCharacter = this.vehicleObject.getDriver();
        boolean bl = isoGameCharacter != null && isoGameCharacter.Traits.SpeedDemon.isSet();
        boolean bl2 = isoGameCharacter != null && isoGameCharacter.Traits.SundayDriver.isSet();
        int n = this.vehicleObject.getScript().gearRatioCount;
        float f4 = 0.0f;
        EngineRPMData[] engineRPMDataArray = this.vehicleObject.getVehicleEngineRPM().m_rpmData;
        float f5 = this.vehicleObject.getMaxSpeed() / (float)n;
        float f6 = PZMath.clamp(f, 0.0f, this.vehicleObject.getMaxSpeed());
        int n2 = (int)PZMath.floor(f6 / f5) + 1;
        n2 = PZMath.min(n2, n);
        f4 = engineRPMDataArray[n2 - 1].gearChange;
        TransmissionNumber transmissionNumber = TransmissionNumber.Speed1;
        switch (n2) {
            case 1: {
                transmissionNumber = TransmissionNumber.Speed1;
                break;
            }
            case 2: {
                transmissionNumber = TransmissionNumber.Speed2;
                break;
            }
            case 3: {
                transmissionNumber = TransmissionNumber.Speed3;
                break;
            }
            case 4: {
                transmissionNumber = TransmissionNumber.Speed4;
                break;
            }
            case 5: {
                transmissionNumber = TransmissionNumber.Speed5;
                break;
            }
            case 6: {
                transmissionNumber = TransmissionNumber.Speed6;
                break;
            }
            case 7: {
                transmissionNumber = TransmissionNumber.Speed7;
                break;
            }
            case 8: {
                transmissionNumber = TransmissionNumber.Speed8;
            }
        }
        if (this.vehicleObject.transmissionNumber == TransmissionNumber.N) {
            this.vehicleObject.transmissionNumber = transmissionNumber;
        } else if (this.vehicleObject.transmissionNumber.getIndex() - 1 >= 0 && this.vehicleObject.transmissionNumber.getIndex() < transmissionNumber.getIndex() && this.vehicleObject.getEngineSpeed() >= (double)engineRPMDataArray[this.vehicleObject.transmissionNumber.getIndex() - 1].gearChange && f >= f5 * (float)this.vehicleObject.transmissionNumber.getIndex()) {
            this.vehicleObject.transmissionNumber = transmissionNumber;
            this.vehicleObject.engineSpeed = engineRPMDataArray[this.vehicleObject.transmissionNumber.getIndex() - 1].afterGearChange;
        }
        if (this.vehicleObject.transmissionNumber.getIndex() < n && this.vehicleObject.transmissionNumber.getIndex() - 1 >= 0) {
            this.vehicleObject.engineSpeed = Math.min(this.vehicleObject.engineSpeed, (double)(engineRPMDataArray[this.vehicleObject.transmissionNumber.getIndex() - 1].gearChange + 100.0f));
        }
        if (this.vehicleObject.engineSpeed > (double)f4) {
            this.vehicleObject.engineSpeed -= Math.min(0.5 * (this.vehicleObject.engineSpeed - (double)f4), 10.0) * (double)f3;
        } else {
            f2 = switch (this.vehicleObject.transmissionNumber) {
                case TransmissionNumber.Speed1 -> 10.0f;
                case TransmissionNumber.Speed2 -> 8.0f;
                case TransmissionNumber.Speed3 -> 7.0f;
                case TransmissionNumber.Speed4 -> 6.0f;
                case TransmissionNumber.Speed5 -> 5.0f;
                default -> 4.0f;
            };
            this.vehicleObject.engineSpeed += (double)(f2 * f3);
        }
        f2 = this.vehicleObject.getEnginePower();
        f2 = this.vehicleObject.getScript().getEngineForce();
        this.EngineForce = (float)((double)(f2 *= (switch (this.vehicleObject.transmissionNumber) {
            case TransmissionNumber.Speed1 -> 1.5f;
            default -> 1.0f;
        })) * ((double)0.3f + this.vehicleObject.engineSpeed / 30000.0));
        this.EngineForce -= this.EngineForce * (f / 200.0f);
        boolean bl3 = false;
        if (this.vehicleObject.transmissionNumber == TransmissionNumber.Speed1 && this.vehicleObject.getVehicleTowedBy() != null) {
            if (this.vehicleObject.getVehicleTowedBy().getScript().getPassengerCount() == 0 && this.vehicleObject.getVehicleTowedBy().getScript().getMass() > 200.0f) {
                bl3 = true;
            }
            int n3 = bl3 ? 20 : 5;
            if (f < (float)n3) {
                this.EngineForce *= Math.min(1.2f, this.vehicleObject.getVehicleTowedBy().getMass() / 500.0f);
                if (bl3) {
                    this.EngineForce *= 4.0f;
                }
            }
        }
        if (this.vehicleObject.engineSpeed > 6000.0) {
            this.EngineForce = (float)((double)this.EngineForce * ((7000.0 - this.vehicleObject.engineSpeed) / 1000.0));
        }
        if (bl2) {
            this.EngineForce *= 0.6f;
            if (f > 20.0f) {
                this.EngineForce *= (40.0f - f) / 20.0f;
            }
        }
        if (bl) {
            if (f > this.vehicleObject.getMaxSpeed() * 1.15f) {
                this.EngineForce *= (this.vehicleObject.getMaxSpeed() * 1.15f + 20.0f - f) / 20.0f;
            }
        } else if (f > this.vehicleObject.getMaxSpeed()) {
            this.EngineForce *= (this.vehicleObject.getMaxSpeed() + 20.0f - f) / 20.0f;
        }
        this.BrakingForce = 0.0f;
        if (this.clientControls.wasUsingParkingBrakes) {
            this.clientControls.wasUsingParkingBrakes = false;
            this.EngineForce *= 8.0f;
        }
        if (GameClient.bClient && (double)this.vehicleObject.jniSpeed >= ServerOptions.instance.SpeedLimit.getValue()) {
            this.EngineForce = 0.0f;
        }
    }

    private void control_Reverse(float f) {
        float f2 = GameTime.getInstance().getMultiplier() / 0.8f;
        IsoGameCharacter isoGameCharacter = this.vehicleObject.getDriver();
        boolean bl = isoGameCharacter != null && isoGameCharacter.Traits.SpeedDemon.isSet();
        boolean bl2 = isoGameCharacter != null && isoGameCharacter.Traits.SundayDriver.isSet();
        this.vehicleObject.transmissionNumber = TransmissionNumber.R;
        float f3 = 1000.0f * (f *= 1.5f) / 30.0f;
        this.vehicleObject.engineSpeed -= Math.min(0.5 * (this.vehicleObject.engineSpeed - (double)f3), 100.0) * (double)f2;
        this.vehicleObject.engineSpeed = bl ? (this.vehicleObject.engineSpeed -= Math.min(0.06 * (this.vehicleObject.engineSpeed - 7000.0), (double)(30.0f - f)) * (double)f2) : (this.vehicleObject.engineSpeed -= Math.min(0.02 * (this.vehicleObject.engineSpeed - 7000.0), (double)(30.0f - f)) * (double)f2);
        this.EngineForce = (float)((double)(-1.0f * (float)this.vehicleObject.getEnginePower()) * (0.75 + this.vehicleObject.engineSpeed / 24000.0));
        if (this.vehicleObject.engineSpeed > 6000.0) {
            this.EngineForce = (float)((double)this.EngineForce * ((7000.0 - this.vehicleObject.engineSpeed) / 1000.0));
        }
        if (bl2) {
            this.EngineForce *= 0.7f;
            if (f < -5.0f) {
                this.EngineForce *= (15.0f + f) / 10.0f;
            }
        }
        if (f < -30.0f) {
            this.EngineForce *= (40.0f + f) / 10.0f;
        }
        this.BrakingForce = 0.0f;
    }

    private void updateRammingSound(float f) {
        if (this.vehicleObject.isEngineRunning() && (f < 1.0f && this.EngineForce > this.vehicleObject.getScript().getEngineIdleSpeed() * 2.0f || f > -0.5f && this.EngineForce < this.vehicleObject.getScript().getEngineIdleSpeed() * -2.0f)) {
            if (this.vehicleObject.ramSound == 0L) {
                this.vehicleObject.ramSound = this.vehicleObject.playSoundImpl("VehicleSkid", null);
                this.vehicleObject.ramSoundTime = System.currentTimeMillis() + 1000L + (long)Rand.Next(2000);
            }
            if (this.vehicleObject.ramSound != 0L && this.vehicleObject.ramSoundTime < System.currentTimeMillis()) {
                this.vehicleObject.stopSound(this.vehicleObject.ramSound);
                this.vehicleObject.ramSound = 0L;
            }
        } else if (this.vehicleObject.ramSound != 0L) {
            this.vehicleObject.stopSound(this.vehicleObject.ramSound);
            this.vehicleObject.ramSound = 0L;
        }
    }

    private void updateBackSignal() {
        if (this.isGasR && this.vehicleObject.isEngineRunning() && this.vehicleObject.hasBackSignal() && !this.vehicleObject.isBackSignalEmitting()) {
            if (GameClient.bClient) {
                GameClient.instance.sendClientCommandV((IsoPlayer)this.vehicleObject.getDriver(), "vehicle", "onBackSignal", "state", "start");
            } else {
                this.vehicleObject.onBackMoveSignalStart();
            }
        }
        if (!this.isGasR && this.vehicleObject.isBackSignalEmitting()) {
            if (GameClient.bClient) {
                GameClient.instance.sendClientCommandV((IsoPlayer)this.vehicleObject.getDriver(), "vehicle", "onBackSignal", "state", "stop");
            } else {
                this.vehicleObject.onBackMoveSignalStop();
            }
        }
    }

    private void updateBrakeLights() {
        if (this.isBreak) {
            if (this.vehicleObject.getStoplightsOn()) {
                return;
            }
            if (GameClient.bClient) {
                GameClient.instance.sendClientCommandV((IsoPlayer)this.vehicleObject.getDriver(), "vehicle", "setStoplightsOn", "on", Boolean.TRUE);
            }
            if (!GameServer.bServer) {
                this.vehicleObject.setStoplightsOn(true);
            }
        } else {
            if (!this.vehicleObject.getStoplightsOn()) {
                return;
            }
            if (GameClient.bClient) {
                GameClient.instance.sendClientCommandV((IsoPlayer)this.vehicleObject.getDriver(), "vehicle", "setStoplightsOn", "on", Boolean.FALSE);
            }
            if (!GameServer.bServer) {
                this.vehicleObject.setStoplightsOn(false);
            }
        }
    }

    private boolean delayCommandWhileDrunk(boolean bl) {
        this.drunkDelayCommandTimer += GameTime.getInstance().getMultiplier();
        if ((float)Rand.AdjustForFramerate(4 * this.vehicleObject.getDriver().getMoodles().getMoodleLevel(MoodleType.Drunk)) < this.drunkDelayCommandTimer) {
            this.drunkDelayCommandTimer = 0.0f;
            return true;
        }
        return false;
    }

    private float delayCommandWhileDrunk(float f) {
        this.drunkDelayCommandTimer += GameTime.getInstance().getMultiplier();
        if ((float)Rand.AdjustForFramerate(4 * this.vehicleObject.getDriver().getMoodles().getMoodleLevel(MoodleType.Drunk)) < this.drunkDelayCommandTimer) {
            this.drunkDelayCommandTimer = 0.0f;
            return f;
        }
        return 0.0f;
    }

    private void checkTire(BulletVariables bulletVariables) {
        if (this.vehicleObject.getPartById("TireFrontLeft") == null || this.vehicleObject.getPartById("TireFrontLeft").getInventoryItem() == null) {
            bulletVariables.brakingForce = (float)((double)bulletVariables.brakingForce / 1.2);
            bulletVariables.engineForce = (float)((double)bulletVariables.engineForce / 1.2);
        }
        if (this.vehicleObject.getPartById("TireFrontRight") == null || this.vehicleObject.getPartById("TireFrontRight").getInventoryItem() == null) {
            bulletVariables.brakingForce = (float)((double)bulletVariables.brakingForce / 1.2);
            bulletVariables.engineForce = (float)((double)bulletVariables.engineForce / 1.2);
        }
        if (this.vehicleObject.getPartById("TireRearLeft") == null || this.vehicleObject.getPartById("TireRearLeft").getInventoryItem() == null) {
            bulletVariables.brakingForce = (float)((double)bulletVariables.brakingForce / 1.3);
            bulletVariables.engineForce = (float)((double)bulletVariables.engineForce / 1.3);
        }
        if (this.vehicleObject.getPartById("TireRearRight") == null || this.vehicleObject.getPartById("TireRearRight").getInventoryItem() == null) {
            bulletVariables.brakingForce = (float)((double)bulletVariables.brakingForce / 1.3);
            bulletVariables.engineForce = (float)((double)bulletVariables.engineForce / 1.3);
        }
    }

    public void updateControls() {
        if (!GameServer.bServer) {
            long l;
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            int n;
            if (this.vehicleObject.isKeyboardControlled()) {
                n = GameKeyboard.isKeyDown(Core.getInstance().getKey("Left")) ? 1 : 0;
                bl5 = GameKeyboard.isKeyDown(Core.getInstance().getKey("Right"));
                bl4 = GameKeyboard.isKeyDown(Core.getInstance().getKey("Forward"));
                bl3 = GameKeyboard.isKeyDown(Core.getInstance().getKey("Backward"));
                bl2 = GameKeyboard.isKeyDown(57);
                bl = GameKeyboard.isKeyDown(42);
                this.clientControls.steering = 0.0f;
                if (n != 0) {
                    this.clientControls.steering -= 1.0f;
                }
                if (bl5) {
                    this.clientControls.steering += 1.0f;
                }
                this.clientControls.forward = bl4;
                this.clientControls.backward = bl3;
                this.clientControls.brake = bl2;
                this.clientControls.shift = bl;
                if (this.clientControls.brake) {
                    this.clientControls.wasUsingParkingBrakes = true;
                }
            }
            if ((n = this.vehicleObject.getJoypad()) != -1) {
                float f;
                bl5 = JoypadManager.instance.isLeftPressed(n);
                bl4 = JoypadManager.instance.isRightPressed(n);
                bl3 = JoypadManager.instance.isRTPressed(n);
                bl2 = JoypadManager.instance.isLTPressed(n);
                bl = JoypadManager.instance.isBPressed(n);
                this.clientControls.steering = f = JoypadManager.instance.getMovementAxisX(n);
                this.clientControls.forward = bl3;
                this.clientControls.backward = bl2;
                this.clientControls.brake = bl;
            }
            if (this.clientControls.forceBrake != 0L && (l = System.currentTimeMillis() - this.clientControls.forceBrake) > 0L && l < 1000L) {
                this.clientControls.brake = true;
                this.clientControls.shift = false;
            }
        }
    }

    public void park() {
        if (!GameServer.bServer && this.vehicleObject.getScript().getWheelCount() > 0) {
            Bullet.controlVehicle(this.vehicleObject.VehicleID, 0.0f, this.vehicleObject.getBrakingForce(), 0.0f);
        }
        this.wasGas = false;
        this.isGas = false;
        this.wasGasR = false;
        this.isGasR = false;
        this.clientControls.reset();
        this.vehicleObject.transmissionNumber = TransmissionNumber.N;
        if (this.vehicleObject.getVehicleTowing() != null) {
            this.vehicleObject.getVehicleTowing().getController().park();
        }
    }

    protected boolean shouldBeActive() {
        if (this.vehicleObject.physicActiveCheck != -1L) {
            return true;
        }
        BaseVehicle baseVehicle = this.vehicleObject.getVehicleTowedBy();
        if (baseVehicle == null) {
            float f = this.vehicleObject.isEngineRunning() ? this.EngineForce : 0.0f;
            return Math.abs(f) > 0.01f;
        }
        if (baseVehicle.getController() == null) {
            return false;
        }
        return baseVehicle.getController().shouldBeActive();
    }

    public void checkShouldBeActive() {
        if (this.shouldBeActive()) {
            if (!this.isEnable) {
                Bullet.setVehicleActive(this.vehicleObject.VehicleID, true);
                this.isEnable = true;
            }
            this.atRestTimer = 1.0f;
        } else if (this.isEnable && this.vehicleObject.isAtRest()) {
            if (this.atRestTimer > 0.0f) {
                this.atRestTimer -= GameTime.getInstance().getTimeDelta();
            }
            if (this.atRestTimer <= 0.0f) {
                Bullet.setVehicleActive(this.vehicleObject.VehicleID, false);
                this.isEnable = false;
            }
        }
    }

    public boolean isGasPedalPressed() {
        return this.isGas || this.isGasR;
    }

    public boolean isBrakePedalPressed() {
        return this.isBreak;
    }

    public void debug() {
        float f;
        float f2;
        int n;
        if (!Core.bDebug || !DebugOptions.instance.VehicleRenderOutline.getValue()) {
            return;
        }
        VehicleScript vehicleScript = this.vehicleObject.getScript();
        Vector3f vector3f = this.tempVec3f;
        this.vehicleObject.getForwardVector(vector3f);
        Transform transform = this.tempXfrm;
        this.vehicleObject.getWorldTransform(transform);
        PolygonalMap2.VehiclePoly vehiclePoly = this.vehicleObject.getPoly();
        LineDrawer.addLine(vehiclePoly.x1, vehiclePoly.y1, 0.0f, vehiclePoly.x2, vehiclePoly.y2, 0.0f, 1.0f, 1.0f, 1.0f, null, true);
        LineDrawer.addLine(vehiclePoly.x2, vehiclePoly.y2, 0.0f, vehiclePoly.x3, vehiclePoly.y3, 0.0f, 1.0f, 1.0f, 1.0f, null, true);
        LineDrawer.addLine(vehiclePoly.x3, vehiclePoly.y3, 0.0f, vehiclePoly.x4, vehiclePoly.y4, 0.0f, 1.0f, 1.0f, 1.0f, null, true);
        LineDrawer.addLine(vehiclePoly.x4, vehiclePoly.y4, 0.0f, vehiclePoly.x1, vehiclePoly.y1, 0.0f, 1.0f, 1.0f, 1.0f, null, true);
        _UNIT_Y.set(0.0f, 1.0f, 0.0f);
        for (n = 0; n < this.vehicleObject.getScript().getWheelCount(); ++n) {
            VehicleScript.Wheel wheel = vehicleScript.getWheel(n);
            this.tempVec3f.set((Vector3fc)wheel.getOffset());
            if (vehicleScript.getModel() != null) {
                this.tempVec3f.add((Vector3fc)vehicleScript.getModelOffset());
            }
            this.vehicleObject.getWorldPos(this.tempVec3f, this.tempVec3f);
            f2 = this.tempVec3f.x;
            f = this.tempVec3f.y;
            this.vehicleObject.getWheelForwardVector(n, this.tempVec3f);
            LineDrawer.addLine(f2, f, 0.0f, f2 + this.tempVec3f.x, f + this.tempVec3f.z, 0.0f, 1.0f, 1.0f, 1.0f, null, true);
            this.drawRect(this.tempVec3f, f2 - WorldSimulation.instance.offsetX, f - WorldSimulation.instance.offsetY, wheel.width, wheel.radius);
        }
        if (this.vehicleObject.collideX != -1.0f) {
            this.vehicleObject.getForwardVector(vector3f);
            this.drawCircle(this.vehicleObject.collideX, this.vehicleObject.collideY, 0.3f);
            this.vehicleObject.collideX = -1.0f;
            this.vehicleObject.collideY = -1.0f;
        }
        if ((n = this.vehicleObject.getJoypad()) != -1) {
            float f3 = JoypadManager.instance.getMovementAxisX(n);
            f2 = JoypadManager.instance.getMovementAxisY(n);
            f = JoypadManager.instance.getDeadZone(n, 0);
            if (Math.abs(f2) > f || Math.abs(f3) > f) {
                Vector2 vector22 = this.tempVec2.set(f3, f2);
                vector22.setLength(4.0f);
                vector22.rotate(-0.7853982f);
                LineDrawer.addLine(this.vehicleObject.getX(), this.vehicleObject.getY(), this.vehicleObject.z, this.vehicleObject.getX() + vector22.x, this.vehicleObject.getY() + vector22.y, this.vehicleObject.z, 1.0f, 1.0f, 1.0f, null, true);
            }
        }
        float f4 = this.vehicleObject.x;
        f2 = this.vehicleObject.y;
        f = this.vehicleObject.z;
        LineDrawer.DrawIsoLine(f4 - 0.5f, f2, f, f4 + 0.5f, f2, f, 1.0f, 1.0f, 1.0f, 0.25f, 1);
        LineDrawer.DrawIsoLine(f4, f2 - 0.5f, f, f4, f2 + 0.5f, f, 1.0f, 1.0f, 1.0f, 0.25f, 1);
    }

    public void drawRect(Vector3f vector3f, float f, float f2, float f3, float f4) {
        this.drawRect(vector3f, f, f2, f3, f4, 1.0f, 1.0f, 1.0f);
    }

    public void drawRect(Vector3f vector3f, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = vector3f.x;
        float f9 = vector3f.y;
        float f10 = vector3f.z;
        Vector3f vector3f2 = this.tempVec3f_3;
        vector3f.cross((Vector3fc)_UNIT_Y, vector3f2);
        float f11 = 1.0f;
        vector3f.x *= f11 * f4;
        vector3f.z *= f11 * f4;
        vector3f2.x *= f11 * f3;
        vector3f2.z *= f11 * f3;
        float f12 = f + vector3f.x;
        float f13 = f2 + vector3f.z;
        float f14 = f - vector3f.x;
        float f15 = f2 - vector3f.z;
        float f16 = f12 - vector3f2.x / 2.0f;
        float f17 = f12 + vector3f2.x / 2.0f;
        float f18 = f14 - vector3f2.x / 2.0f;
        float f19 = f14 + vector3f2.x / 2.0f;
        float f20 = f15 - vector3f2.z / 2.0f;
        float f21 = f15 + vector3f2.z / 2.0f;
        float f22 = f13 - vector3f2.z / 2.0f;
        float f23 = f13 + vector3f2.z / 2.0f;
        LineDrawer.addLine(f16 += WorldSimulation.instance.offsetX, f22 += WorldSimulation.instance.offsetY, 0.0f, f17 += WorldSimulation.instance.offsetX, f23 += WorldSimulation.instance.offsetY, 0.0f, f5, f6, f7, null, true);
        LineDrawer.addLine(f16, f22, 0.0f, f18 += WorldSimulation.instance.offsetX, f20 += WorldSimulation.instance.offsetY, 0.0f, f5, f6, f7, null, true);
        LineDrawer.addLine(f17, f23, 0.0f, f19 += WorldSimulation.instance.offsetX, f21 += WorldSimulation.instance.offsetY, 0.0f, f5, f6, f7, null, true);
        LineDrawer.addLine(f18, f20, 0.0f, f19, f21, 0.0f, f5, f6, f7, null, true);
        vector3f.set(f8, f9, f10);
    }

    public void drawCircle(float f, float f2, float f3) {
        this.drawCircle(f, f2, f3, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void drawCircle(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        LineDrawer.DrawIsoCircle(f, f2, 0.0f, f3, 16, f4, f5, f6, f7);
    }

    static {
        CarController.gears[0] = new GearInfo(0, 25, 0.0f);
        CarController.gears[1] = new GearInfo(25, 50, 0.5f);
        CarController.gears[2] = new GearInfo(50, 1000, 0.5f);
        bulletVariables = new BulletVariables();
    }

    public static final class ClientControls {
        public float steering;
        public boolean forward;
        public boolean backward;
        public boolean brake;
        public boolean shift;
        public boolean wasUsingParkingBrakes;
        public long forceBrake = 0L;

        public void reset() {
            this.steering = 0.0f;
            this.forward = false;
            this.backward = false;
            this.brake = false;
            this.shift = false;
            this.wasUsingParkingBrakes = false;
            this.forceBrake = 0L;
        }
    }

    public static final class GearInfo {
        int minSpeed;
        int maxSpeed;
        float minRPM;

        GearInfo(int n, int n2, float f) {
            this.minSpeed = n;
            this.maxSpeed = n2;
            this.minRPM = f;
        }
    }

    static enum ControlState {
        NoControl,
        Braking,
        Forward,
        Reverse;

    }

    public static final class BulletVariables {
        float engineForce;
        float brakingForce;
        float vehicleSteering;
        BaseVehicle vehicle;

        BulletVariables set(BaseVehicle baseVehicle, float f, float f2, float f3) {
            this.vehicle = baseVehicle;
            this.engineForce = f;
            this.brakingForce = f2;
            this.vehicleSteering = f3;
            return this;
        }
    }
}

