/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.opengl;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;
import zombie.core.SpriteRenderer;
import zombie.core.VBO.GLVertexBufferObject;
import zombie.core.VBO.IGLBufferObject;
import zombie.core.math.PZMath;

public final class VBOLines {
    private final int VERTEX_SIZE = 12;
    private final int COLOR_SIZE = 16;
    private final int ELEMENT_SIZE = 28;
    private final int COLOR_OFFSET = 12;
    private final int NUM_LINES = 128;
    private final int NUM_ELEMENTS = 256;
    private final int INDEX_SIZE = 2;
    private GLVertexBufferObject m_vbo;
    private GLVertexBufferObject m_ibo;
    private ByteBuffer m_elements;
    private ByteBuffer m_indices;
    private float m_lineWidth = 1.0f;
    private float m_dx = 0.0f;
    private float m_dy = 0.0f;
    private float m_dz = 0.0f;
    private int m_mode = 1;
    private boolean m_depth_test = false;

    private void create() {
        this.m_elements = BufferUtils.createByteBuffer((int)7168);
        this.m_indices = BufferUtils.createByteBuffer((int)512);
        IGLBufferObject iGLBufferObject = GLVertexBufferObject.funcs;
        this.m_vbo = new GLVertexBufferObject(7168L, iGLBufferObject.GL_ARRAY_BUFFER(), iGLBufferObject.GL_STREAM_DRAW());
        this.m_vbo.create();
        this.m_ibo = new GLVertexBufferObject(512L, iGLBufferObject.GL_ELEMENT_ARRAY_BUFFER(), iGLBufferObject.GL_STREAM_DRAW());
        this.m_ibo.create();
    }

    public void setOffset(float f, float f2, float f3) {
        this.m_dx = f;
        this.m_dy = f2;
        this.m_dz = f3;
    }

    public void addElement(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        if (this.isFull()) {
            this.flush();
        }
        if (this.m_elements == null) {
            this.create();
        }
        this.m_elements.putFloat(this.m_dx + f);
        this.m_elements.putFloat(this.m_dy + f2);
        this.m_elements.putFloat(this.m_dz + f3);
        this.m_elements.putFloat(f4);
        this.m_elements.putFloat(f5);
        this.m_elements.putFloat(f6);
        this.m_elements.putFloat(f7);
        short s = (short)(this.m_indices.position() / 2);
        this.m_indices.putShort(s);
    }

    public void addLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.reserve(2);
        this.addElement(f, f2, f3, f7, f8, f9, f10);
        this.addElement(f4, f5, f6, f7, f8, f9, f10);
    }

    public void addLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14) {
        this.reserve(2);
        this.addElement(f, f2, f3, f7, f8, f9, f10);
        this.addElement(f4, f5, f6, f11, f12, f13, f14);
    }

    public void addTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        this.reserve(3);
        this.addElement(f, f2, f3, f10, f11, f12, f13);
        this.addElement(f4, f5, f6, f10, f11, f12, f13);
        this.addElement(f7, f8, f9, f10, f11, f12, f13);
    }

    public void addQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.reserve(6);
        this.addTriangle(f, f2, f5, f3, f2, f5, f, f4, f5, f6, f7, f8, f9);
        this.addTriangle(f3, f2, f5, f3, f4, f5, f, f4, f5, f6, f7, f8, f9);
    }

    boolean isFull() {
        if (this.m_elements == null) {
            return false;
        }
        if (this.m_mode == 4 && this.m_elements.position() % 84 == 0 && this.m_elements.position() + 84 > 7168) {
            return true;
        }
        return this.m_elements.position() == 7168;
    }

    public void reserve(int n) {
        if (!this.hasRoomFor(n)) {
            this.flush();
        }
    }

    boolean hasRoomFor(int n) {
        return this.m_elements == null || this.m_elements.position() / 28 + n <= 256;
    }

    public void flush() {
        int n;
        if (this.m_elements == null || this.m_elements.position() == 0) {
            return;
        }
        this.m_elements.flip();
        this.m_indices.flip();
        GL13.glClientActiveTexture((int)33984);
        GL11.glDisableClientState((int)32888);
        this.m_vbo.bind();
        this.m_vbo.bufferData(this.m_elements);
        this.m_ibo.bind();
        this.m_ibo.bufferData(this.m_indices);
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32886);
        GL11.glVertexPointer((int)3, (int)5126, (int)28, (long)0L);
        GL11.glColorPointer((int)4, (int)5126, (int)28, (long)12L);
        for (n = 7; n >= 0; --n) {
            GL13.glActiveTexture((int)(33984 + n));
            GL11.glDisable((int)3553);
        }
        if (this.m_depth_test) {
            GL11.glEnable((int)2929);
        } else {
            GL11.glDisable((int)2929);
        }
        GL11.glEnable((int)2848);
        GL11.glLineWidth((float)this.m_lineWidth);
        n = 0;
        int n2 = this.m_elements.limit() / 28;
        int n3 = 0;
        int n4 = this.m_indices.limit() / 2;
        GL12.glDrawRangeElements((int)this.m_mode, (int)n, (int)(n + n2), (int)(n4 - n3), (int)5123, (long)(n3 * 2));
        this.m_vbo.bindNone();
        this.m_ibo.bindNone();
        this.m_elements.clear();
        this.m_indices.clear();
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2848);
        GL13.glClientActiveTexture((int)33984);
        GL11.glEnableClientState((int)32888);
        SpriteRenderer.ringBuffer.restoreVBOs = true;
    }

    public void setLineWidth(float f) {
        if (!PZMath.equal(this.m_lineWidth, f, 0.01f)) {
            this.flush();
            this.m_lineWidth = f;
        }
    }

    public void setMode(int n) {
        assert (n == 1 || n == 4);
        if (n != this.m_mode) {
            this.flush();
            this.m_mode = n;
        }
    }

    public void setDepthTest(boolean bl) {
        if (bl != this.m_depth_test) {
            this.flush();
            this.m_depth_test = bl;
        }
    }
}

