/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjglx.BufferUtils;
import zombie.DebugFileWatcher;
import zombie.PredicatedFileWatcher;
import zombie.SystemDisabler;
import zombie.ZomboidFileSystem;
import zombie.core.opengl.IShaderProgramListener;
import zombie.core.opengl.PZGLUtil;
import zombie.core.opengl.RenderThread;
import zombie.core.opengl.ShaderUnit;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.iso.Vector2;
import zombie.iso.Vector3;

public final class ShaderProgram {
    private int m_shaderID = 0;
    private final String m_name;
    private final boolean m_isStatic;
    private final ArrayList<ShaderUnit> m_vertexUnits = new ArrayList();
    private final ArrayList<ShaderUnit> m_fragmentUnits = new ArrayList();
    private final HashMap<String, PredicatedFileWatcher> m_fileWatchers = new HashMap();
    private boolean m_sourceFilesChanged = false;
    private boolean m_compileFailed = false;
    private final HashMap<String, Uniform> uniformsByName = new HashMap();
    private final ArrayList<IShaderProgramListener> m_onCompiledListeners = new ArrayList();
    private final int[] m_uvScaleUniforms = new int[10];
    private static FloatBuffer floatBuffer;

    private ShaderProgram(String string, boolean bl) {
        this.m_name = string;
        this.m_isStatic = bl;
    }

    public String getName() {
        return this.m_name;
    }

    public void addCompileListener(IShaderProgramListener iShaderProgramListener) {
        if (this.m_onCompiledListeners.contains(iShaderProgramListener)) {
            return;
        }
        this.m_onCompiledListeners.add(iShaderProgramListener);
    }

    public void removeCompileListener(IShaderProgramListener iShaderProgramListener) {
        this.m_onCompiledListeners.remove(iShaderProgramListener);
    }

    private void invokeProgramCompiledEvent() {
        this.Start();
        this.m_uvScaleUniforms[0] = ARBShaderObjects.glGetUniformLocationARB((int)this.m_shaderID, (CharSequence)"UVScale");
        for (int i = 1; i < this.m_uvScaleUniforms.length; ++i) {
            this.m_uvScaleUniforms[i] = ARBShaderObjects.glGetUniformLocationARB((int)this.m_shaderID, (CharSequence)("UVScale" + i));
        }
        this.End();
        if (this.m_onCompiledListeners.isEmpty()) {
            return;
        }
        ArrayList<IShaderProgramListener> arrayList = new ArrayList<IShaderProgramListener>(this.m_onCompiledListeners);
        for (IShaderProgramListener iShaderProgramListener : arrayList) {
            iShaderProgramListener.callback(this);
        }
    }

    public void compile() {
        this.m_sourceFilesChanged = false;
        this.m_compileFailed = false;
        if (this.isCompiled()) {
            this.destroy();
        }
        String string = this.getName();
        if (DebugLog.isEnabled(DebugType.Shader)) {
            DebugLog.Shader.debugln(string + (this.m_isStatic ? "(Static)" : ""));
        }
        this.m_shaderID = ARBShaderObjects.glCreateProgramObjectARB();
        if (this.m_shaderID == 0) {
            DebugLog.Shader.error("Failed to create Shader: " + string + " could not create new Shader Program ID.");
            return;
        }
        this.addShader(this.getRootVertFileName(), ShaderUnit.Type.Vert);
        this.addShader(this.getRootFragFileName(string), ShaderUnit.Type.Frag);
        this.registerFileWatchers();
        if (!this.compileAllShaderUnits()) {
            this.m_compileFailed = true;
            this.destroy();
            return;
        }
        if (!this.attachAllShaderUnits()) {
            this.m_compileFailed = true;
            this.destroy();
            return;
        }
        this.registerFileWatchers();
        ARBShaderObjects.glLinkProgramARB((int)this.m_shaderID);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.m_shaderID, (int)35714) == 0) {
            this.m_compileFailed = true;
            DebugLog.Shader.error("Failed to link new Shader Program:" + string + " bStatic:" + this.m_isStatic);
            DebugLog.Shader.error(ShaderProgram.getLogInfo(this.m_shaderID));
            this.destroy();
            return;
        }
        ARBShaderObjects.glValidateProgramARB((int)this.m_shaderID);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.m_shaderID, (int)35715) == 0) {
            this.m_compileFailed = true;
            DebugLog.Shader.error("Failed to validate Shader Program:" + string + " bStatic:" + this.m_isStatic);
            DebugLog.Shader.error(ShaderProgram.getLogInfo(this.m_shaderID));
            this.destroy();
            return;
        }
        this.onCompileSuccess();
    }

    private void onCompileSuccess() {
        if (!this.isCompiled()) {
            return;
        }
        this.uniformsByName.clear();
        this.Start();
        int n = this.m_shaderID;
        int n2 = GL20.glGetProgrami((int)n, (int)35718);
        int n3 = 0;
        IntBuffer intBuffer = MemoryUtil.memAllocInt((int)1);
        IntBuffer intBuffer2 = MemoryUtil.memAllocInt((int)1);
        for (int i = 0; i < n2; ++i) {
            String string = GL20.glGetActiveUniform((int)n, (int)i, (int)255, (IntBuffer)intBuffer, (IntBuffer)intBuffer2);
            int n4 = GL20.glGetUniformLocation((int)n, (CharSequence)string);
            if (n4 == -1) continue;
            int n5 = intBuffer.get(0);
            int n6 = intBuffer2.get(0);
            Uniform uniform = new Uniform();
            this.uniformsByName.put(string, uniform);
            uniform.name = string;
            uniform.loc = n4;
            uniform.size = n5;
            uniform.type = n6;
            if (DebugLog.isEnabled(DebugType.Shader)) {
                DebugLog.Shader.debugln(string + ", Loc: " + n4 + ", Type: " + n6 + ", Size: " + n5);
            }
            if (uniform.type != 35678) continue;
            if (n3 != 0) {
                GL20.glUniform1i((int)uniform.loc, (int)n3);
            }
            uniform.sampler = n3++;
        }
        MemoryUtil.memFree((Buffer)intBuffer);
        MemoryUtil.memFree((Buffer)intBuffer2);
        this.End();
        PZGLUtil.checkGLError(true);
        this.invokeProgramCompiledEvent();
    }

    private void registerFileWatchers() {
        for (PredicatedFileWatcher object : this.m_fileWatchers.values()) {
            DebugFileWatcher.instance.remove(object);
        }
        this.m_fileWatchers.clear();
        for (ShaderUnit shaderUnit : this.m_vertexUnits) {
            this.registerFileWatcherInternal(shaderUnit.getFileName(), string -> this.onShaderFileChanged());
        }
        for (ShaderUnit shaderUnit : this.m_fragmentUnits) {
            this.registerFileWatcherInternal(shaderUnit.getFileName(), string -> this.onShaderFileChanged());
        }
    }

    private void registerFileWatcherInternal(String string, PredicatedFileWatcher.IPredicatedFileWatcherCallback iPredicatedFileWatcherCallback) {
        string = ZomboidFileSystem.instance.getString(string);
        PredicatedFileWatcher predicatedFileWatcher = new PredicatedFileWatcher(string, iPredicatedFileWatcherCallback);
        this.m_fileWatchers.put(string, predicatedFileWatcher);
        DebugFileWatcher.instance.add(predicatedFileWatcher);
    }

    private void onShaderFileChanged() {
        this.m_sourceFilesChanged = true;
    }

    private boolean compileAllShaderUnits() {
        for (ShaderUnit shaderUnit : this.getShaderUnits()) {
            if (shaderUnit.compile()) continue;
            DebugLog.Shader.error("Failed to create Shader: " + this.getName() + " Shader unit failed to compile: " + shaderUnit.getFileName());
            return false;
        }
        return true;
    }

    private boolean attachAllShaderUnits() {
        for (ShaderUnit shaderUnit : this.getShaderUnits()) {
            if (shaderUnit.attach()) continue;
            DebugLog.Shader.error("Failed to create Shader: " + this.getName() + " Shader unit failed to attach: " + shaderUnit.getFileName());
            return false;
        }
        return true;
    }

    private ArrayList<ShaderUnit> getShaderUnits() {
        ArrayList<ShaderUnit> arrayList = new ArrayList<ShaderUnit>();
        arrayList.addAll(this.m_vertexUnits);
        arrayList.addAll(this.m_fragmentUnits);
        return arrayList;
    }

    private String getRootVertFileName() {
        if (this.m_isStatic) {
            return "media/shaders/" + this.getName() + "_static.vert";
        }
        return "media/shaders/" + this.getName() + ".vert";
    }

    private String getRootFragFileName(String string) {
        return "media/shaders/" + string + ".frag";
    }

    public ShaderUnit addShader(String string, ShaderUnit.Type type) {
        ShaderUnit shaderUnit = this.findShader(string, type);
        if (shaderUnit != null) {
            return shaderUnit;
        }
        ArrayList<ShaderUnit> arrayList = this.getShaderList(type);
        shaderUnit = new ShaderUnit(this, string, type);
        arrayList.add(shaderUnit);
        return shaderUnit;
    }

    private ArrayList<ShaderUnit> getShaderList(ShaderUnit.Type type) {
        return type == ShaderUnit.Type.Vert ? this.m_vertexUnits : this.m_fragmentUnits;
    }

    private ShaderUnit findShader(String string, ShaderUnit.Type type) {
        ArrayList<ShaderUnit> arrayList = this.getShaderList(type);
        ShaderUnit shaderUnit = null;
        for (ShaderUnit shaderUnit2 : arrayList) {
            if (!shaderUnit2.getFileName().equals(string)) continue;
            shaderUnit = shaderUnit2;
            break;
        }
        return shaderUnit;
    }

    public static ShaderProgram createShaderProgram(String string, boolean bl, boolean bl2) {
        ShaderProgram shaderProgram = new ShaderProgram(string, bl);
        if (bl2) {
            shaderProgram.compile();
        }
        return shaderProgram;
    }

    @Deprecated
    public static int createVertShader(String string) {
        ShaderUnit shaderUnit = new ShaderUnit(null, string, ShaderUnit.Type.Vert);
        shaderUnit.compile();
        return shaderUnit.getGLID();
    }

    @Deprecated
    public static int createFragShader(String string) {
        ShaderUnit shaderUnit = new ShaderUnit(null, string, ShaderUnit.Type.Frag);
        shaderUnit.compile();
        return shaderUnit.getGLID();
    }

    public static void printLogInfo(int n) {
        IntBuffer intBuffer = MemoryUtil.memAllocInt((int)1);
        ARBShaderObjects.glGetObjectParameterivARB((int)n, (int)35716, (IntBuffer)intBuffer);
        int n2 = intBuffer.get();
        MemoryUtil.memFree((Buffer)intBuffer);
        if (n2 <= 1) {
            return;
        }
        ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)n2);
        intBuffer.flip();
        ARBShaderObjects.glGetInfoLogARB((int)n, (IntBuffer)intBuffer, (ByteBuffer)byteBuffer);
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        String string = new String(byArray);
        DebugLog.Shader.debugln(":\n" + string);
        MemoryUtil.memFree((Buffer)byteBuffer);
    }

    public static String getLogInfo(int n) {
        return ARBShaderObjects.glGetInfoLogARB((int)n, (int)ARBShaderObjects.glGetObjectParameteriARB((int)n, (int)35716));
    }

    public boolean isCompiled() {
        return this.m_shaderID != 0;
    }

    public void destroy() {
        if (this.m_shaderID == 0) {
            this.m_vertexUnits.clear();
            this.m_fragmentUnits.clear();
            return;
        }
        try {
            DebugLog.Shader.debugln(this.getName());
            for (ShaderUnit shaderUnit : this.m_vertexUnits) {
                shaderUnit.destroy();
            }
            this.m_vertexUnits.clear();
            for (ShaderUnit shaderUnit : this.m_fragmentUnits) {
                shaderUnit.destroy();
            }
            this.m_fragmentUnits.clear();
            ARBShaderObjects.glDeleteObjectARB((int)this.m_shaderID);
            PZGLUtil.checkGLError(true);
        }
        finally {
            this.m_vertexUnits.clear();
            this.m_fragmentUnits.clear();
            this.m_shaderID = 0;
        }
    }

    public int getShaderID() {
        if (!this.m_compileFailed && !this.isCompiled() || this.m_sourceFilesChanged) {
            RenderThread.invokeOnRenderContext(this::compile);
        }
        return this.m_shaderID;
    }

    public void Start() {
        ARBShaderObjects.glUseProgramObjectARB((int)this.getShaderID());
    }

    public void End() {
        ARBShaderObjects.glUseProgramObjectARB((int)0);
    }

    public void setSamplerUnit(String string, int n) {
        Uniform uniform = this.getUniform(string, 35678);
        if (uniform != null) {
            uniform.sampler = n;
            ARBShaderObjects.glUniform1iARB((int)uniform.loc, (int)n);
        }
    }

    public void setValueColor(String string, int n) {
        this.setVector4(string, 0.003921569f * (float)(n >> 24 & 0xFF), 0.003921569f * (float)(n >> 16 & 0xFF), 0.003921569f * (float)(n >> 8 & 0xFF), 0.003921569f * (float)(n & 0xFF));
    }

    public void setValueColorRGB(String string, int n) {
        this.setValueColor(string, n & 0xFF);
    }

    public void setValue(String string, float f) {
        Uniform uniform = this.getUniform(string, 5126);
        if (uniform != null) {
            ARBShaderObjects.glUniform1fARB((int)uniform.loc, (float)f);
        }
    }

    public void setValue(String string, int n) {
        Uniform uniform = this.getUniform(string, 5124);
        if (uniform != null) {
            ARBShaderObjects.glUniform1iARB((int)uniform.loc, (int)n);
        }
    }

    public void setValue(String string, Vector3 vector3) {
        this.setVector3(string, vector3.x, vector3.y, vector3.z);
    }

    public void setValue(String string, Vector2 vector22) {
        this.setVector2(string, vector22.x, vector22.y);
    }

    public void setVector2(String string, float f, float f2) {
        Uniform uniform = this.getUniform(string, 35664);
        if (uniform != null) {
            this.setVector2(uniform.loc, f, f2);
        }
    }

    public void setVector3(String string, float f, float f2, float f3) {
        Uniform uniform = this.getUniform(string, 35665);
        if (uniform != null) {
            this.setVector3(uniform.loc, f, f2, f3);
        }
    }

    public void setVector4(String string, float f, float f2, float f3, float f4) {
        Uniform uniform = this.getUniform(string, 35666);
        if (uniform != null) {
            this.setVector4(uniform.loc, f, f2, f3, f4);
        }
    }

    public final Uniform getUniform(String string, int n) {
        return this.getUniform(string, n, false);
    }

    public Uniform getUniform(String string, int n, boolean bl) {
        Uniform uniform = this.uniformsByName.get(string);
        if (uniform == null) {
            if (bl) {
                DebugLog.Shader.warn(string + " doesn't exist in shader");
            }
            return null;
        }
        if (uniform.type != n) {
            DebugLog.Shader.warn(string + " isn't of type: " + n + ", it is of type: " + uniform.type);
            return null;
        }
        return uniform;
    }

    public void setValue(String string, Matrix4f matrix4f) {
        Uniform uniform = this.getUniform(string, 35676);
        if (uniform != null) {
            this.setTransformMatrix(uniform.loc, matrix4f);
        }
    }

    public void setValue(String string, Texture texture, int n) {
        Uniform uniform = this.getUniform(string, 35678);
        if (uniform == null || texture == null) {
            return;
        }
        if (uniform.sampler != n) {
            uniform.sampler = n;
            GL20.glUniform1i((int)uniform.loc, (int)uniform.sampler);
        }
        GL13.glActiveTexture((int)(33984 + uniform.sampler));
        GL11.glEnable((int)3553);
        int n2 = Texture.lastTextureID;
        texture.bind();
        if (uniform.sampler > 0) {
            Texture.lastTextureID = n2;
        }
        Vector2 vector22 = texture.getUVScale(L_setValue.vector2);
        this.setUVScale(n, vector22.x, vector22.y);
        if (SystemDisabler.doEnableDetectOpenGLErrorsInTexture) {
            PZGLUtil.checkGLErrorThrow("Shader.setValue<Texture> Loc: %s, Tex: %s, samplerUnit: %d", string, texture, n);
        }
    }

    private void setUVScale(int n, float f, float f2) {
        if (n < 0) {
            DebugLog.Shader.error("SamplerUnit out of range: " + n);
            return;
        }
        if (n >= this.m_uvScaleUniforms.length) {
            Object object = "UVScale";
            if (n > 0) {
                object = "UVScale" + n;
            }
            this.setVector2((String)object, f, f2);
            return;
        }
        int n2 = this.m_uvScaleUniforms[n];
        if (n2 >= 0) {
            this.setVector2(n2, f, f2);
        }
    }

    public void setVector2(int n, float f, float f2) {
        ARBShaderObjects.glUniform2fARB((int)n, (float)f, (float)f2);
    }

    public void setVector3(int n, float f, float f2, float f3) {
        ARBShaderObjects.glUniform3fARB((int)n, (float)f, (float)f2, (float)f3);
    }

    public void setVector4(int n, float f, float f2, float f3, float f4) {
        ARBShaderObjects.glUniform4fARB((int)n, (float)f, (float)f2, (float)f3, (float)f4);
    }

    void setTransformMatrix(int n, Matrix4f matrix4f) {
        if (floatBuffer == null) {
            floatBuffer = BufferUtils.createFloatBuffer((int)38400);
        }
        floatBuffer.clear();
        matrix4f.store(floatBuffer);
        floatBuffer.flip();
        ARBShaderObjects.glUniformMatrix4fvARB((int)n, (boolean)true, (FloatBuffer)floatBuffer);
    }

    public static class Uniform {
        public String name;
        public int size;
        public int loc;
        public int type;
        public int sampler;
    }

    private static final class L_setValue {
        static final Vector2 vector2 = new Vector2();

        private L_setValue() {
        }
    }
}

