/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.opengl;

import zombie.core.SpriteRenderer;
import zombie.core.opengl.IOpenGLState;
import zombie.util.Type;

public final class GLState {
    public static final CAlphaFunc AlphaFunc = new CAlphaFunc();
    public static final CAlphaTest AlphaTest = new CAlphaTest();
    public static final CBlendFunc BlendFunc = new CBlendFunc();
    public static final CBlendFuncSeparate BlendFuncSeparate = new CBlendFuncSeparate();
    public static final CColorMask ColorMask = new CColorMask();
    public static final CStencilFunc StencilFunc = new CStencilFunc();
    public static final CStencilMask StencilMask = new CStencilMask();
    public static final CStencilOp StencilOp = new CStencilOp();
    public static final CStencilTest StencilTest = new CStencilTest();

    public static void startFrame() {
        AlphaFunc.setDirty();
        AlphaTest.setDirty();
        BlendFunc.setDirty();
        BlendFuncSeparate.setDirty();
        ColorMask.setDirty();
        StencilFunc.setDirty();
        StencilMask.setDirty();
        StencilOp.setDirty();
        StencilTest.setDirty();
    }

    public static final class CAlphaFunc
    extends BaseIntFloat {
        @Override
        void Set(CIntFloatValue cIntFloatValue) {
            SpriteRenderer.instance.glAlphaFunc(cIntFloatValue.a, cIntFloatValue.b);
        }
    }

    public static final class CAlphaTest
    extends BaseBoolean {
        @Override
        void Set(CBooleanValue cBooleanValue) {
            if (cBooleanValue.value) {
                SpriteRenderer.instance.glEnable(3008);
            } else {
                SpriteRenderer.instance.glDisable(3008);
            }
        }
    }

    public static final class CBlendFunc
    extends Base2Ints {
        @Override
        void Set(C2IntsValue c2IntsValue) {
            SpriteRenderer.instance.glBlendFunc(c2IntsValue.a, c2IntsValue.b);
        }
    }

    public static final class CBlendFuncSeparate
    extends Base4Ints {
        @Override
        void Set(C4IntsValue c4IntsValue) {
            SpriteRenderer.instance.glBlendFuncSeparate(c4IntsValue.a, c4IntsValue.b, c4IntsValue.c, c4IntsValue.d);
        }
    }

    public static final class CColorMask
    extends Base4Booleans {
        @Override
        void Set(C4BooleansValue c4BooleansValue) {
            SpriteRenderer.instance.glColorMask(c4BooleansValue.a ? 1 : 0, c4BooleansValue.b ? 1 : 0, c4BooleansValue.c ? 1 : 0, c4BooleansValue.d ? 1 : 0);
        }
    }

    public static final class CStencilFunc
    extends Base3Ints {
        @Override
        void Set(C3IntsValue c3IntsValue) {
            SpriteRenderer.instance.glStencilFunc(c3IntsValue.a, c3IntsValue.b, c3IntsValue.c);
        }
    }

    public static final class CStencilMask
    extends BaseInt {
        @Override
        void Set(CIntValue cIntValue) {
            SpriteRenderer.instance.glStencilMask(cIntValue.value);
        }
    }

    public static final class CStencilOp
    extends Base3Ints {
        @Override
        void Set(C3IntsValue c3IntsValue) {
            SpriteRenderer.instance.glStencilOp(c3IntsValue.a, c3IntsValue.b, c3IntsValue.c);
        }
    }

    public static final class CStencilTest
    extends BaseBoolean {
        @Override
        void Set(CBooleanValue cBooleanValue) {
            if (cBooleanValue.value) {
                SpriteRenderer.instance.glEnable(2960);
            } else {
                SpriteRenderer.instance.glDisable(2960);
            }
        }
    }

    public static abstract class Base4Ints
    extends IOpenGLState<C4IntsValue> {
        @Override
        C4IntsValue defaultValue() {
            return new C4IntsValue();
        }
    }

    public static abstract class Base3Ints
    extends IOpenGLState<C3IntsValue> {
        @Override
        C3IntsValue defaultValue() {
            return new C3IntsValue();
        }
    }

    public static abstract class Base2Ints
    extends IOpenGLState<C2IntsValue> {
        @Override
        C2IntsValue defaultValue() {
            return new C2IntsValue();
        }
    }

    public static abstract class BaseInt
    extends IOpenGLState<CIntValue> {
        @Override
        CIntValue defaultValue() {
            return new CIntValue();
        }
    }

    public static abstract class BaseIntFloat
    extends IOpenGLState<CIntFloatValue> {
        @Override
        CIntFloatValue defaultValue() {
            return new CIntFloatValue();
        }
    }

    public static abstract class Base4Booleans
    extends IOpenGLState<C4BooleansValue> {
        @Override
        C4BooleansValue defaultValue() {
            return new C4BooleansValue();
        }
    }

    public static abstract class BaseBoolean
    extends IOpenGLState<CBooleanValue> {
        @Override
        CBooleanValue defaultValue() {
            return new CBooleanValue(true);
        }
    }

    public static final class CIntFloatValue
    implements IOpenGLState.Value {
        int a;
        float b;

        public CIntFloatValue set(int n, float f) {
            this.a = n;
            this.b = f;
            return this;
        }

        public boolean equals(Object object) {
            CIntFloatValue cIntFloatValue = Type.tryCastTo(object, CIntFloatValue.class);
            return cIntFloatValue != null && cIntFloatValue.a == this.a && cIntFloatValue.b == this.b;
        }

        @Override
        public IOpenGLState.Value set(IOpenGLState.Value value) {
            CIntFloatValue cIntFloatValue = (CIntFloatValue)value;
            this.a = cIntFloatValue.a;
            this.b = cIntFloatValue.b;
            return this;
        }
    }

    public static final class C4IntsValue
    implements IOpenGLState.Value {
        int a;
        int b;
        int c;
        int d;

        public C4IntsValue set(int n, int n2, int n3, int n4) {
            this.a = n;
            this.b = n2;
            this.c = n3;
            this.d = n4;
            return this;
        }

        public boolean equals(Object object) {
            C4IntsValue c4IntsValue = Type.tryCastTo(object, C4IntsValue.class);
            return c4IntsValue != null && c4IntsValue.a == this.a && c4IntsValue.b == this.b && c4IntsValue.c == this.c && c4IntsValue.d == this.d;
        }

        @Override
        public IOpenGLState.Value set(IOpenGLState.Value value) {
            C4IntsValue c4IntsValue = (C4IntsValue)value;
            this.a = c4IntsValue.a;
            this.b = c4IntsValue.b;
            this.c = c4IntsValue.c;
            this.d = c4IntsValue.d;
            return this;
        }
    }

    public static final class C3IntsValue
    implements IOpenGLState.Value {
        int a;
        int b;
        int c;

        public C3IntsValue set(int n, int n2, int n3) {
            this.a = n;
            this.b = n2;
            this.c = n3;
            return this;
        }

        public boolean equals(Object object) {
            C3IntsValue c3IntsValue = Type.tryCastTo(object, C3IntsValue.class);
            return c3IntsValue != null && c3IntsValue.a == this.a && c3IntsValue.b == this.b && c3IntsValue.c == this.c;
        }

        @Override
        public IOpenGLState.Value set(IOpenGLState.Value value) {
            C3IntsValue c3IntsValue = (C3IntsValue)value;
            this.a = c3IntsValue.a;
            this.b = c3IntsValue.b;
            this.c = c3IntsValue.c;
            return this;
        }
    }

    public static final class C2IntsValue
    implements IOpenGLState.Value {
        int a;
        int b;

        public C2IntsValue set(int n, int n2) {
            this.a = n;
            this.b = n2;
            return this;
        }

        public boolean equals(Object object) {
            C2IntsValue c2IntsValue = Type.tryCastTo(object, C2IntsValue.class);
            return c2IntsValue != null && c2IntsValue.a == this.a && c2IntsValue.b == this.b;
        }

        @Override
        public IOpenGLState.Value set(IOpenGLState.Value value) {
            C2IntsValue c2IntsValue = (C2IntsValue)value;
            this.a = c2IntsValue.a;
            this.b = c2IntsValue.b;
            return this;
        }
    }

    public static class CIntValue
    implements IOpenGLState.Value {
        int value;

        public CIntValue set(int n) {
            this.value = n;
            return this;
        }

        public boolean equals(Object object) {
            return object instanceof CIntValue && ((CIntValue)object).value == this.value;
        }

        @Override
        public IOpenGLState.Value set(IOpenGLState.Value value) {
            this.value = ((CIntValue)value).value;
            return this;
        }
    }

    public static final class C4BooleansValue
    implements IOpenGLState.Value {
        boolean a;
        boolean b;
        boolean c;
        boolean d;

        public C4BooleansValue set(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.a = bl;
            this.b = bl2;
            this.c = bl3;
            this.d = bl4;
            return this;
        }

        public boolean equals(Object object) {
            C4BooleansValue c4BooleansValue = Type.tryCastTo(object, C4BooleansValue.class);
            return c4BooleansValue != null && c4BooleansValue.a == this.a && c4BooleansValue.b == this.b && c4BooleansValue.c == this.c;
        }

        @Override
        public IOpenGLState.Value set(IOpenGLState.Value value) {
            C4BooleansValue c4BooleansValue = (C4BooleansValue)value;
            this.a = c4BooleansValue.a;
            this.b = c4BooleansValue.b;
            this.c = c4BooleansValue.c;
            this.d = c4BooleansValue.d;
            return this;
        }
    }

    public static class CBooleanValue
    implements IOpenGLState.Value {
        public static final CBooleanValue TRUE = new CBooleanValue(true);
        public static final CBooleanValue FALSE = new CBooleanValue(false);
        boolean value;

        CBooleanValue(boolean bl) {
            this.value = bl;
        }

        public boolean equals(Object object) {
            return object instanceof CBooleanValue && ((CBooleanValue)object).value == this.value;
        }

        @Override
        public IOpenGLState.Value set(IOpenGLState.Value value) {
            this.value = ((CBooleanValue)value).value;
            return this;
        }
    }
}

