/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.math;

import org.joml.Matrix4f;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.Vector3f;
import zombie.debug.DebugLog;
import zombie.iso.Vector2;
import zombie.util.StringUtils;
import zombie.util.list.PZArrayUtil;

public final class PZMath {
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float degToRads = (float)Math.PI / 180;
    public static final float radToDegs = 57.295776f;
    public static final long microsToNanos = 1000L;
    public static final long millisToMicros = 1000L;
    public static final long secondsToMillis = 1000L;
    public static long secondsToNanos = 1000000000L;

    public static float almostUnitIdentity(float f) {
        return f * f * (2.0f - f);
    }

    public static float almostIdentity(float f, float f2, float f3) {
        if (f > f2) {
            return f;
        }
        float f4 = 2.0f * f3 - f2;
        float f5 = 2.0f * f2 - 3.0f * f3;
        float f6 = f / f2;
        return (f4 * f6 + f5) * f6 * f6 + f3;
    }

    public static float gain(float f, float f2) {
        float f3 = (float)(0.5 * Math.pow(2.0f * (f < 0.5f ? f : 1.0f - f), f2));
        return f < 0.5f ? f3 : 1.0f - f3;
    }

    public static float clamp(float f, float f2, float f3) {
        float f4 = f;
        if (f4 < f2) {
            f4 = f2;
        }
        if (f4 > f3) {
            f4 = f3;
        }
        return f4;
    }

    public static long clamp(long l, long l2, long l3) {
        long l4 = l;
        if (l4 < l2) {
            l4 = l2;
        }
        if (l4 > l3) {
            l4 = l3;
        }
        return l4;
    }

    public static int clamp(int n, int n2, int n3) {
        int n4 = n;
        if (n4 < n2) {
            n4 = n2;
        }
        if (n4 > n3) {
            n4 = n3;
        }
        return n4;
    }

    public static float clampFloat(float f, float f2, float f3) {
        return PZMath.clamp(f, f2, f3);
    }

    public static float clamp_01(float f) {
        return PZMath.clamp(f, 0.0f, 1.0f);
    }

    public static float lerp(float f, float f2, float f3) {
        return f + (f2 - f) * f3;
    }

    public static float lerpAngle(float f, float f2, float f3) {
        float f4 = PZMath.getClosestAngle(f, f2);
        float f5 = f + f3 * f4;
        return PZMath.wrap(f5, (float)(-Math.PI), (float)Math.PI);
    }

    public static Vector3f lerp(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, float f) {
        vector3f.set(vector3f2.x + (vector3f3.x - vector3f2.x) * f, vector3f2.y + (vector3f3.y - vector3f2.y) * f, vector3f2.z + (vector3f3.z - vector3f2.z) * f);
        return vector3f;
    }

    public static Vector2 lerp(Vector2 vector22, Vector2 vector23, Vector2 vector24, float f) {
        vector22.set(vector23.x + (vector24.x - vector23.x) * f, vector23.y + (vector24.y - vector23.y) * f);
        return vector22;
    }

    public static float c_lerp(float f, float f2, float f3) {
        float f4 = (float)(1.0 - Math.cos(f3 * (float)Math.PI)) / 2.0f;
        return f * (1.0f - f4) + f2 * f4;
    }

    public static Quaternion slerp(Quaternion quaternion, Quaternion quaternion2, Quaternion quaternion3, float f) {
        double d = quaternion2.x * quaternion3.x + quaternion2.y * quaternion3.y + quaternion2.z * quaternion3.z + quaternion2.w * quaternion3.w;
        double d2 = d < 0.0 ? -d : d;
        double d3 = 1.0f - f;
        double d4 = f;
        if (1.0 - d2 > 0.1) {
            double d5 = org.joml.Math.acos((double)d2);
            double d6 = org.joml.Math.sin((double)d5);
            double d7 = 1.0 / d6;
            d3 = org.joml.Math.sin((double)(d5 * (1.0 - (double)f))) * d7;
            d4 = org.joml.Math.sin((double)(d5 * (double)f)) * d7;
        }
        if (d < 0.0) {
            d4 = -d4;
        }
        quaternion.set((float)(d3 * (double)quaternion2.x + d4 * (double)quaternion3.x), (float)(d3 * (double)quaternion2.y + d4 * (double)quaternion3.y), (float)(d3 * (double)quaternion2.z + d4 * (double)quaternion3.z), (float)(d3 * (double)quaternion2.w + d4 * (double)quaternion3.w));
        return quaternion;
    }

    public static float sqrt(float f) {
        return org.joml.Math.sqrt((float)f);
    }

    public static float lerpFunc_EaseOutQuad(float f) {
        return f * f;
    }

    public static float lerpFunc_EaseInQuad(float f) {
        float f2 = 1.0f - f;
        return 1.0f - f2 * f2;
    }

    public static float lerpFunc_EaseOutInQuad(float f) {
        if (f < 0.5f) {
            return PZMath.lerpFunc_EaseOutQuad(f) * 2.0f;
        }
        return 0.5f + PZMath.lerpFunc_EaseInQuad(2.0f * f - 1.0f) / 2.0f;
    }

    public static double tryParseDouble(String string, double d) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return d;
        }
        try {
            return Double.parseDouble(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public static float tryParseFloat(String string, float f) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return f;
        }
        try {
            return Float.parseFloat(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    public static boolean canParseFloat(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return false;
        }
        try {
            Float.parseFloat(string.trim());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static int tryParseInt(String string, int n) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return n;
        }
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static float degToRad(float f) {
        return (float)Math.PI / 180 * f;
    }

    public static float radToDeg(float f) {
        return 57.295776f * f;
    }

    public static float getClosestAngle(float f, float f2) {
        float f3 = PZMath.wrap(f, (float)Math.PI * 2);
        float f4 = PZMath.wrap(f2, (float)Math.PI * 2);
        float f5 = f4 - f3;
        float f6 = PZMath.wrap(f5, (float)(-Math.PI), (float)Math.PI);
        return f6;
    }

    public static float getClosestAngleDegrees(float f, float f2) {
        float f3 = PZMath.degToRad(f);
        float f4 = PZMath.degToRad(f2);
        float f5 = PZMath.getClosestAngle(f3, f4);
        return PZMath.radToDeg(f5);
    }

    public static int sign(float f) {
        return f > 0.0f ? 1 : (f < 0.0f ? -1 : 0);
    }

    public static int fastfloor(double d) {
        int n = (int)d;
        return d < (double)n ? n - 1 : n;
    }

    public static int fastfloor(float f) {
        int n = (int)f;
        return f < (float)n ? n - 1 : n;
    }

    public static float floor(float f) {
        return PZMath.fastfloor(f);
    }

    public static float ceil(float f) {
        if (f >= 0.0f) {
            return (int)(f + 0.9999999f);
        }
        return (int)(f - 1.0E-7f);
    }

    public static float frac(float f) {
        float f2 = PZMath.floor(f);
        float f3 = f - f2;
        return f3;
    }

    public static float wrap(float f, float f2) {
        if (f2 == 0.0f) {
            return 0.0f;
        }
        if (f2 < 0.0f) {
            return 0.0f;
        }
        if (f < 0.0f) {
            float f3 = -f / f2;
            float f4 = 1.0f - PZMath.frac(f3);
            float f5 = f4 * f2;
            return f5;
        }
        float f6 = f / f2;
        float f7 = PZMath.frac(f6);
        float f8 = f7 * f2;
        return f8;
    }

    public static float wrap(float f, float f2, float f3) {
        float f4 = PZMath.max(f3, f2);
        float f5 = PZMath.min(f3, f2);
        float f6 = f4 - f5;
        float f7 = f - f5;
        float f8 = PZMath.wrap(f7, f6);
        float f9 = f5 + f8;
        return f9;
    }

    public static float max(float f, float f2) {
        return f > f2 ? f : f2;
    }

    public static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static float min(float f, float f2) {
        return f > f2 ? f2 : f;
    }

    public static int min(int n, int n2) {
        return n > n2 ? n2 : n;
    }

    public static float abs(float f) {
        return f * (float)PZMath.sign(f);
    }

    public static boolean equal(float f, float f2) {
        return PZMath.equal(f, f2, 1.0E-7f);
    }

    public static boolean equal(float f, float f2, float f3) {
        float f4 = f2 - f;
        float f5 = PZMath.abs(f4);
        return f5 < f3;
    }

    public static org.lwjgl.util.vector.Matrix4f convertMatrix(Matrix4f matrix4f, org.lwjgl.util.vector.Matrix4f matrix4f2) {
        if (matrix4f2 == null) {
            matrix4f2 = new org.lwjgl.util.vector.Matrix4f();
        }
        matrix4f2.m00 = matrix4f.m00();
        matrix4f2.m01 = matrix4f.m01();
        matrix4f2.m02 = matrix4f.m02();
        matrix4f2.m03 = matrix4f.m03();
        matrix4f2.m10 = matrix4f.m10();
        matrix4f2.m11 = matrix4f.m11();
        matrix4f2.m12 = matrix4f.m12();
        matrix4f2.m13 = matrix4f.m13();
        matrix4f2.m20 = matrix4f.m20();
        matrix4f2.m21 = matrix4f.m21();
        matrix4f2.m22 = matrix4f.m22();
        matrix4f2.m23 = matrix4f.m23();
        matrix4f2.m30 = matrix4f.m30();
        matrix4f2.m31 = matrix4f.m31();
        matrix4f2.m32 = matrix4f.m32();
        matrix4f2.m33 = matrix4f.m33();
        return matrix4f2;
    }

    public static Matrix4f convertMatrix(org.lwjgl.util.vector.Matrix4f matrix4f, Matrix4f matrix4f2) {
        if (matrix4f2 == null) {
            matrix4f2 = new Matrix4f();
        }
        return matrix4f2.set(matrix4f.m00, matrix4f.m01, matrix4f.m02, matrix4f.m03, matrix4f.m10, matrix4f.m11, matrix4f.m12, matrix4f.m13, matrix4f.m20, matrix4f.m21, matrix4f.m22, matrix4f.m23, matrix4f.m30, matrix4f.m31, matrix4f.m32, matrix4f.m33);
    }

    public static float step(float f, float f2, float f3) {
        if (f > f2) {
            return PZMath.max(f + f3, f2);
        }
        if (f < f2) {
            return PZMath.min(f + f3, f2);
        }
        return f;
    }

    public static SideOfLine testSideOfLine(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = (f5 - f) * (f4 - f2) - (f6 - f2) * (f3 - f);
        return f7 > 0.0f ? SideOfLine.Left : (f7 < 0.0f ? SideOfLine.Right : SideOfLine.OnLine);
    }

    public static float roundToNearest(float f) {
        int n = PZMath.sign(f);
        return PZMath.floor(f + 0.5f * (float)n);
    }

    public static int roundToInt(float f) {
        return (int)(PZMath.roundToNearest(f) + 1.0E-4f);
    }

    public static float roundToIntPlus05(float f) {
        return PZMath.floor(f) + 0.5f;
    }

    public static float roundFromEdges(float f) {
        float f2 = (int)f;
        float f3 = f - f2;
        if (f3 < 0.2f) {
            return f2 + 0.2f;
        }
        if (f3 > 0.8f) {
            return f2 + 1.0f - 0.2f;
        }
        return f;
    }

    static {
        UnitTests.runAll();
    }

    public static enum SideOfLine {
        Left,
        OnLine,
        Right;

    }

    private static final class UnitTests {
        private static final Runnable[] s_unitTests = new Runnable[0];

        private UnitTests() {
        }

        private static void runAll() {
            PZArrayUtil.forEach(s_unitTests, Runnable::run);
        }

        public static final class vector2 {
            public static void run() {
                vector2.runUnitTest_direction();
            }

            private static void runUnitTest_direction() {
                DebugLog.General.println("runUnitTest_direction");
                DebugLog.General.println("x, y, angle, length, rdir.x, rdir.y, rangle, rlength, pass");
                vector2.checkDirection(1.0f, 0.0f);
                vector2.checkDirection(1.0f, 1.0f);
                vector2.checkDirection(0.0f, 1.0f);
                vector2.checkDirection(-1.0f, 1.0f);
                vector2.checkDirection(-1.0f, 0.0f);
                vector2.checkDirection(-1.0f, -1.0f);
                vector2.checkDirection(0.0f, -1.0f);
                vector2.checkDirection(1.0f, -1.0f);
                DebugLog.General.println("runUnitTest_direction. Complete");
            }

            private static void checkDirection(float f, float f2) {
                Vector2 vector22 = new Vector2(f, f2);
                float f3 = vector22.getDirection();
                float f4 = vector22.getLength();
                Vector2 vector23 = Vector2.fromLengthDirection(f4, f3);
                float f5 = vector23.getDirection();
                float f6 = vector23.getLength();
                boolean bl = PZMath.equal(vector22.x, vector23.x, 1.0E-4f) && PZMath.equal(vector22.y, vector23.y, 1.0E-4f) && PZMath.equal(f3, f5, 1.0E-4f) && PZMath.equal(f4, f6, 1.0E-4f);
                DebugLog.General.println("%f, %f, %f, %f, %f, %f, %f, %f, %s", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(vector23.x), Float.valueOf(vector23.y), Float.valueOf(f5), Float.valueOf(f6), bl ? "true" : "false");
            }
        }

        private static final class getClosestAngle {
            private getClosestAngle() {
            }

            public static void run() {
                DebugLog.General.println("runUnitTests_getClosestAngle");
                DebugLog.General.println("a, b, result, expected, pass");
                getClosestAngle.runUnitTest(0.0f, 0.0f, 0.0f);
                getClosestAngle.runUnitTest(0.0f, 15.0f, 15.0f);
                getClosestAngle.runUnitTest(15.0f, 0.0f, -15.0f);
                getClosestAngle.runUnitTest(0.0f, 179.0f, 179.0f);
                getClosestAngle.runUnitTest(180.0f, 180.0f, 0.0f);
                getClosestAngle.runUnitTest(180.0f, 359.0f, 179.0f);
                getClosestAngle.runUnitTest(90.0f, 180.0f, 90.0f);
                getClosestAngle.runUnitTest(180.0f, 90.0f, -90.0f);
                for (int i = -360; i < 360; i += 10) {
                    for (int j = -360; j < 360; j += 10) {
                        float f = i;
                        float f2 = j;
                        getClosestAngle.runUnitTest_noexp(f, f2);
                    }
                }
                DebugLog.General.println("runUnitTests_getClosestAngle. Complete");
            }

            private static void runUnitTest_noexp(float f, float f2) {
                float f3 = PZMath.getClosestAngleDegrees(f, f2);
                getClosestAngle.logResult(f, f2, f3, "N/A", "N/A");
            }

            private static void runUnitTest(float f, float f2, float f3) {
                float f4 = PZMath.getClosestAngleDegrees(f, f2);
                boolean bl = PZMath.equal(f3, f4, 1.0E-4f);
                String string = bl ? "pass" : "fail";
                getClosestAngle.logResult(f, f2, f4, String.valueOf(f3), string);
            }

            private static void logResult(float f, float f2, float f3, String string, String string2) {
                DebugLog.General.println("%f, %f, %f, %s, %s", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), string, string2);
            }
        }

        private static final class lerpFunctions {
            private lerpFunctions() {
            }

            public static void run() {
                DebugLog.General.println("UnitTest_lerpFunctions");
                DebugLog.General.println("x,Sqrt,EaseOutQuad,EaseInQuad,EaseOutInQuad");
                for (int i = 0; i < 100; ++i) {
                    float f = (float)i / 100.0f;
                    DebugLog.General.println("%f,%f,%f,%f", Float.valueOf(f), Float.valueOf(PZMath.lerpFunc_EaseOutQuad(f)), Float.valueOf(PZMath.lerpFunc_EaseInQuad(f)), Float.valueOf(PZMath.lerpFunc_EaseOutInQuad(f)));
                }
                DebugLog.General.println("UnitTest_lerpFunctions. Complete");
            }
        }
    }
}

