/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.logger;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipError;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.logger.LoggerManager;
import zombie.debug.DebugLog;
import zombie.network.MD5Checksum;

public final class ZipLogs {
    static ArrayList<String> filePaths = new ArrayList();

    public static void addZipFile(boolean bl) {
        FileSystem fileSystem = null;
        try {
            String string = ZomboidFileSystem.instance.getCacheDir() + File.separator + "logs.zip";
            String string2 = new File(string).toURI().toString();
            URI uRI = URI.create("jar:" + string2);
            Path path = FileSystems.getDefault().getPath(string, new String[0]).toAbsolutePath();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("create", String.valueOf(Files.notExists(path, new LinkOption[0])));
            try {
                fileSystem = FileSystems.newFileSystem(uRI, hashMap);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            catch (ZipError zipError) {
                zipError.printStackTrace();
                DebugLog.log("Deleting possibly-corrupt " + string);
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            long l = ZipLogs.getMD5FromZip(fileSystem, "/meta/console.txt.md5");
            long l2 = ZipLogs.getMD5FromZip(fileSystem, "/meta/coop-console.txt.md5");
            long l3 = ZipLogs.getMD5FromZip(fileSystem, "/meta/server-console.txt.md5");
            long l4 = ZipLogs.getMD5FromZip(fileSystem, "/meta/DebugLog.txt.md5");
            ZipLogs.addLogToZip(fileSystem, "console", "console.txt", l);
            ZipLogs.addLogToZip(fileSystem, "coop-console", "coop-console.txt", l2);
            ZipLogs.addLogToZip(fileSystem, "server-console", "server-console.txt", l3);
            ZipLogs.addDebugLogToZip(fileSystem, "debug-log", "DebugLog.txt", l4);
            ZipLogs.addToZip(fileSystem, "/configs/options.ini", "options.ini");
            ZipLogs.addToZip(fileSystem, "/configs/popman-options.ini", "popman-options.ini");
            ZipLogs.addToZip(fileSystem, "/configs/latestSave.ini", "latestSave.ini");
            ZipLogs.addToZip(fileSystem, "/configs/debug-options.ini", "debug-options.ini");
            ZipLogs.addToZip(fileSystem, "/configs/sounds.ini", "sounds.ini");
            ZipLogs.addToZip(fileSystem, "/addition/translationProblems.txt", "translationProblems.txt");
            ZipLogs.addToZip(fileSystem, "/addition/gamepadBinding.config", "gamepadBinding.config");
            ZipLogs.addFilelistToZip(fileSystem, "/addition/mods.txt", "mods");
            ZipLogs.addDirToZipLua(fileSystem, "/lua", "Lua");
            ZipLogs.addDirToZip(fileSystem, "/db", "db");
            ZipLogs.addDirToZip(fileSystem, "/server", "Server");
            ZipLogs.addDirToZip(fileSystem, "/statistic", "Statistic");
            if (!bl) {
                ZipLogs.addSaveOldToZip(fileSystem, "/save_old/map_t.bin", "map_t.bin");
                ZipLogs.addSaveOldToZip(fileSystem, "/save_old/map_ver.bin", "map_ver.bin");
                ZipLogs.addSaveOldToZip(fileSystem, "/save_old/map.bin", "map.bin");
                ZipLogs.addSaveOldToZip(fileSystem, "/save_old/map_sand.bin", "map_sand.bin");
                ZipLogs.addSaveOldToZip(fileSystem, "/save_old/reanimated.bin", "reanimated.bin");
                ZipLogs.addSaveOldToZip(fileSystem, "/save_old/zombies.ini", "zombies.ini");
                ZipLogs.addSaveOldToZip(fileSystem, "/save_old/z_outfits.bin", "z_outfits.bin");
                ZipLogs.addSaveOldToZip(fileSystem, "/save_old/map_p.bin", "map_p.bin");
                ZipLogs.addSaveOldToZip(fileSystem, "/save_old/map_meta.bin", "map_meta.bin");
                ZipLogs.addSaveOldToZip(fileSystem, "/save_old/map_zone.bin", "map_zone.bin");
                ZipLogs.addSaveOldToZip(fileSystem, "/save_old/serverid.dat", "serverid.dat");
                ZipLogs.addSaveOldToZip(fileSystem, "/save_old/thumb.png", "thumb.png");
                ZipLogs.addSaveOldToZip(fileSystem, "/save_old/players.db", "players.db");
                ZipLogs.addSaveOldToZip(fileSystem, "/save_old/players.db-journal", "players.db-journal");
                ZipLogs.addSaveOldToZip(fileSystem, "/save_old/vehicles.db", "vehicles.db");
                ZipLogs.addSaveOldToZip(fileSystem, "/save_old/vehicles.db-journal", "vehicles.db-journal");
                ZipLogs.putTextFile(fileSystem, "/save_old/description.txt", ZipLogs.getLastSaveDescription());
            } else {
                ZipLogs.addSaveToZip(fileSystem, "/save/map_t.bin", "map_t.bin");
                ZipLogs.addSaveToZip(fileSystem, "/save/map_ver.bin", "map_ver.bin");
                ZipLogs.addSaveToZip(fileSystem, "/save/map.bin", "map.bin");
                ZipLogs.addSaveToZip(fileSystem, "/save/map_sand.bin", "map_sand.bin");
                ZipLogs.addSaveToZip(fileSystem, "/save/reanimated.bin", "reanimated.bin");
                ZipLogs.addSaveToZip(fileSystem, "/save/zombies.ini", "zombies.ini");
                ZipLogs.addSaveToZip(fileSystem, "/save/z_outfits.bin", "z_outfits.bin");
                ZipLogs.addSaveToZip(fileSystem, "/save/map_p.bin", "map_p.bin");
                ZipLogs.addSaveToZip(fileSystem, "/save/map_meta.bin", "map_meta.bin");
                ZipLogs.addSaveToZip(fileSystem, "/save/map_zone.bin", "map_zone.bin");
                ZipLogs.addSaveToZip(fileSystem, "/save/serverid.dat", "serverid.dat");
                ZipLogs.addSaveToZip(fileSystem, "/save/thumb.png", "thumb.png");
                ZipLogs.addSaveToZip(fileSystem, "/save/players.db", "players.db");
                ZipLogs.addSaveToZip(fileSystem, "/save/players.db-journal", "players.db-journal");
                ZipLogs.addSaveToZip(fileSystem, "/save/vehicles.db", "vehicles.db");
                ZipLogs.addSaveToZip(fileSystem, "/save/vehicles.db-journal", "vehicles.db-journal");
                ZipLogs.putTextFile(fileSystem, "/save/description.txt", ZipLogs.getCurrentSaveDescription());
            }
            try {
                fileSystem.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (Exception exception) {
            if (fileSystem != null) {
                try {
                    fileSystem.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            exception.printStackTrace();
        }
    }

    private static void copyToZip(Path path, Path path2, Path path3) throws IOException {
        Path path4 = path.resolve(path2.relativize(path3).toString());
        if (Files.isDirectory(path3, new LinkOption[0])) {
            Files.createDirectories(path4, new FileAttribute[0]);
        } else {
            Files.copy(path3, path4, new CopyOption[0]);
        }
    }

    public static void addToZip(FileSystem fileSystem, String string, String string2) {
        try {
            Path path = fileSystem.getPath(string, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Path path2 = FileSystems.getDefault().getPath(ZomboidFileSystem.instance.getCacheDir() + File.separator + string2, new String[0]).toAbsolutePath();
            Files.deleteIfExists(path);
            if (Files.exists(path2, new LinkOption[0])) {
                Files.copy(path2, path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void addSaveToZip(FileSystem fileSystem, String string, String string2) {
        try {
            Path path = fileSystem.getPath(string, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Path path2 = FileSystems.getDefault().getPath(ZomboidFileSystem.instance.getFileNameInCurrentSave(string2), new String[0]).toAbsolutePath();
            Files.deleteIfExists(path);
            if (Files.exists(path2, new LinkOption[0])) {
                Files.copy(path2, path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void addSaveOldToZip(FileSystem fileSystem, String string, String string2) {
        try {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(new File(ZomboidFileSystem.instance.getCacheDir() + File.separator + "latestSave.ini")));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return;
            }
            String string3 = bufferedReader.readLine();
            String string4 = bufferedReader.readLine();
            bufferedReader.close();
            Path path = fileSystem.getPath(string, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Path path2 = FileSystems.getDefault().getPath(ZomboidFileSystem.instance.getSaveDir() + File.separator + string4 + File.separator + string3 + File.separator + string2, new String[0]).toAbsolutePath();
            Files.deleteIfExists(path);
            if (Files.exists(path2, new LinkOption[0])) {
                Files.copy(path2, path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static String getLastSaveDescription() {
        try {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(new File(ZomboidFileSystem.instance.getCacheDir() + File.separator + "latestSave.ini")));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return "-";
            }
            String string = bufferedReader.readLine();
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            return "World: " + string + "\n\rGameMode:" + string2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "-";
        }
    }

    private static String getCurrentSaveDescription() {
        String string = "Sandbox";
        if (Core.GameMode != null) {
            string = Core.GameMode;
        }
        String string2 = "-";
        if (Core.GameSaveWorld != null) {
            string2 = Core.GameSaveWorld;
        }
        return "World: " + string2 + "\n\rGameMode:" + string;
    }

    public static void addDirToZip(FileSystem fileSystem, String string, String string2) {
        try {
            Path path = fileSystem.getPath(string, new String[0]);
            ZipLogs.deleteDirectory(fileSystem, path);
            Files.createDirectories(path, new FileAttribute[0]);
            Path path2 = FileSystems.getDefault().getPath(ZomboidFileSystem.instance.getCacheDir() + File.separator + string2, new String[0]).toAbsolutePath();
            Stream<Path> stream = Files.walk(path2, new FileVisitOption[0]);
            stream.forEach(path3 -> {
                try {
                    ZipLogs.copyToZip(path, path2, path3);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addDirToZipLua(FileSystem fileSystem, String string, String string2) {
        try {
            Path path = fileSystem.getPath(string, new String[0]);
            ZipLogs.deleteDirectory(fileSystem, path);
            Files.createDirectories(path, new FileAttribute[0]);
            Path path2 = FileSystems.getDefault().getPath(ZomboidFileSystem.instance.getCacheDir() + File.separator + string2, new String[0]).toAbsolutePath();
            Stream<Path> stream = Files.walk(path2, new FileVisitOption[0]);
            stream.forEach(path3 -> {
                try {
                    if (!path3.endsWith("ServerList.txt") && !path3.endsWith("ServerListSteam.txt")) {
                        ZipLogs.copyToZip(path, path2, path3);
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addFilelistToZip(FileSystem fileSystem, String string, String string2) {
        try {
            Path path = fileSystem.getPath(string, new String[0]);
            Path path2 = FileSystems.getDefault().getPath(ZomboidFileSystem.instance.getCacheDir() + File.separator + string2, new String[0]).toAbsolutePath();
            Stream<Path> stream = Files.list(path2);
            String string3 = stream.map(Path::getFileName).map(Path::toString).collect(Collectors.joining("; "));
            Files.deleteIfExists(path);
            Files.write(path, string3.getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void deleteDirectory(FileSystem fileSystem, Path path) {
        filePaths.clear();
        ZipLogs.getDirectoryFiles(path);
        for (String string : filePaths) {
            try {
                Files.delete(fileSystem.getPath(string, new String[0]));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    static void getDirectoryFiles(Path path) {
        try {
            Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);
            stream.forEach(path2 -> {
                if (!path2.toString().equals(path.toString())) {
                    if (Files.isDirectory(path2, new LinkOption[0])) {
                        ZipLogs.getDirectoryFiles(path2);
                    } else if (!filePaths.contains(path2.toString())) {
                        filePaths.add(path2.toString());
                    }
                }
            });
            filePaths.add(path.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addLogToZip(FileSystem fileSystem, String string, String string2, long l) {
        long l2;
        try {
            l2 = MD5Checksum.createChecksum(ZomboidFileSystem.instance.getCacheDir() + File.separator + string2);
        }
        catch (Exception exception) {
            l2 = 0L;
        }
        File file = new File(ZomboidFileSystem.instance.getCacheDir() + File.separator + string2);
        if (file.exists() && !file.isDirectory() && l2 != l) {
            Path path;
            Path path2;
            try {
                Path path3 = fileSystem.getPath("/" + string + "/log_5.txt", new String[0]);
                Files.delete(path3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i = 5; i > 0; --i) {
                path2 = fileSystem.getPath("/" + string + "/log_" + i + ".txt", new String[0]);
                path = fileSystem.getPath("/" + string + "/log_" + (i + 1) + ".txt", new String[0]);
                try {
                    Files.move(path2, path, new CopyOption[0]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                Path path4 = fileSystem.getPath("/" + string + "/log_1.txt", new String[0]);
                Files.createDirectories(path4.getParent(), new FileAttribute[0]);
                path2 = FileSystems.getDefault().getPath(ZomboidFileSystem.instance.getCacheDir() + File.separator + string2, new String[0]).toAbsolutePath();
                Files.copy(path2, path4, StandardCopyOption.REPLACE_EXISTING);
                path = fileSystem.getPath("/meta/" + string2 + ".md5", new String[0]);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try {
                    Files.delete(path);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Files.write(path, String.valueOf(l2).getBytes(), new OpenOption[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void addDebugLogToZip(FileSystem fileSystem, String string, String string2, long l) {
        long l2;
        String string3 = null;
        File file = new File(LoggerManager.getLogsDir());
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (!string4.contains("DebugLog.txt")) continue;
            string3 = LoggerManager.getLogsDir() + File.separator + string4;
            break;
        }
        if (string3 == null) {
            return;
        }
        try {
            l2 = MD5Checksum.createChecksum(string3);
        }
        catch (Exception exception) {
            l2 = 0L;
        }
        File file2 = new File(string3);
        if (file2.exists() && !file2.isDirectory() && l2 != l) {
            Path path;
            Path path2;
            try {
                Path path3 = fileSystem.getPath("/" + string + "/log_5.txt", new String[0]);
                Files.delete(path3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i = 5; i > 0; --i) {
                path2 = fileSystem.getPath("/" + string + "/log_" + i + ".txt", new String[0]);
                path = fileSystem.getPath("/" + string + "/log_" + (i + 1) + ".txt", new String[0]);
                try {
                    Files.move(path2, path, new CopyOption[0]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                Path path4 = fileSystem.getPath("/" + string + "/log_1.txt", new String[0]);
                Files.createDirectories(path4.getParent(), new FileAttribute[0]);
                path2 = FileSystems.getDefault().getPath(string3, new String[0]).toAbsolutePath();
                Files.copy(path2, path4, StandardCopyOption.REPLACE_EXISTING);
                path = fileSystem.getPath("/meta/" + string2 + ".md5", new String[0]);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try {
                    Files.delete(path);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Files.write(path, String.valueOf(l2).getBytes(), new OpenOption[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static long getMD5FromZip(FileSystem fileSystem, String string) {
        long l = 0L;
        try {
            Path path = fileSystem.getPath(string, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                List<String> list = Files.readAllLines(path);
                l = Long.parseLong(list.get(0));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l;
    }

    public static void putTextFile(FileSystem fileSystem, String string, String string2) {
        try {
            Path path = fileSystem.getPath(string, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try {
                Files.delete(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Files.write(path, string2.getBytes(), new OpenOption[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

