/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.logger;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import zombie.core.logger.LoggerManager;
import zombie.debug.DebugLog;
import zombie.util.StringUtils;

public final class ZLogger {
    private final String name;
    private final OutputStreams outputStreams = new OutputStreams();
    private File file = null;
    private static final SimpleDateFormat s_fileNameSdf = new SimpleDateFormat("dd-MM-yy_HH-mm-ss");
    private static final SimpleDateFormat s_logSdf = new SimpleDateFormat("dd-MM-yy HH:mm:ss.SSS");
    private static final long s_maxSizeKo = 10000L;

    public ZLogger(String string, boolean bl) {
        this.name = string;
        try {
            this.file = new File(LoggerManager.getLogsDir() + File.separator + ZLogger.getLoggerName(string) + ".txt");
            this.outputStreams.file = new PrintStream(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        if (bl) {
            this.outputStreams.console = System.out;
        }
    }

    private static String getLoggerName(String string) {
        return s_fileNameSdf.format(Calendar.getInstance().getTime()) + "_" + string;
    }

    public void write(String string) {
        this.write(string, null);
    }

    public void write(String string, String string2) {
        this.write(string, string2, false);
    }

    public void write(String string, String string2, boolean bl) {
        try {
            this.writeUnsafe(string, string2, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void writeUnsafe(String string, String string2, boolean bl) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.setLength(0);
        if (!bl) {
            stringBuilder.append("[").append(s_logSdf.format(Calendar.getInstance().getTime())).append("]");
        }
        if (!StringUtils.isNullOrEmpty(string2)) {
            stringBuilder.append("[").append(string2).append("]");
        }
        int n = string.length();
        if (string.lastIndexOf(10) == string.length() - 1) {
            --n;
        }
        if (!bl) {
            stringBuilder.append(" ").append(string, 0, n).append(".");
        } else {
            stringBuilder.append(string, 0, n);
        }
        this.outputStreams.println(stringBuilder.toString());
        this.checkSizeUnsafe();
    }

    public synchronized void write(Exception exception) {
        exception.printStackTrace(this.outputStreams.file);
        this.checkSize();
    }

    private synchronized void checkSize() {
        try {
            this.checkSizeUnsafe();
        }
        catch (Exception exception) {
            DebugLog.General.error("Exception thrown checking log file size.");
            DebugLog.General.error(exception);
            exception.printStackTrace();
        }
    }

    private synchronized void checkSizeUnsafe() throws Exception {
        long l = this.file.length() / 1024L;
        if (l > 10000L) {
            this.outputStreams.file.close();
            this.file = new File(LoggerManager.getLogsDir() + File.separator + ZLogger.getLoggerName(this.name) + ".txt");
            this.outputStreams.file = new PrintStream(this.file);
        }
    }

    private static class OutputStreams {
        public PrintStream file;
        public PrintStream console;

        private OutputStreams() {
        }

        public void println(String string) {
            if (this.file != null) {
                this.file.println(string);
                this.file.flush();
            }
            if (this.console != null) {
                this.console.println(string);
            }
        }
    }
}

