/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.input;

import java.util.ArrayList;
import org.lwjglx.input.Controller;
import org.lwjglx.input.Keyboard;
import org.lwjglx.input.Mouse;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.core.Core;
import zombie.input.ControllerState;
import zombie.input.ControllerStateCache;
import zombie.input.GameKeyboard;
import zombie.input.JoypadManager;

public final class Input {
    public static final int ANY_CONTROLLER = -1;
    private final Controller[] controllers = new Controller[16];
    private final ArrayList<Controller> newlyConnected = new ArrayList();
    private final ArrayList<Controller> newlyDisconnected = new ArrayList();
    private final boolean[][] controllerPressed = new boolean[16][15];
    private final boolean[][] controllerWasPressed = new boolean[16][15];
    private final float[][] controllerPov = new float[16][2];
    private final ControllerStateCache m_controllerStateCache = new ControllerStateCache();

    public static String getKeyName(int n) {
        String string = Keyboard.getKeyName((int)n);
        if ("LSHIFT".equals(string)) {
            string = "Left SHIFT";
        }
        if ("RSHIFT".equals(string)) {
            string = "Right SHIFT";
        }
        if ("LMENU".equals(string)) {
            string = "Left ALT";
        } else if ("RMENU".equals(string)) {
            string = "Right ALT";
        }
        return string;
    }

    public static int getKeyCode(String string) {
        if ("Right SHIFT".equals(string)) {
            return 54;
        }
        if ("Left SHIFT".equals(string)) {
            return 42;
        }
        if ("Left ALT".equals(string)) {
            return 56;
        }
        if ("Right ALT".equals(string)) {
            return 184;
        }
        return Keyboard.getKeyIndex((String)string);
    }

    public int getControllerCount() {
        return this.controllers.length;
    }

    public int getAxisCount(int n) {
        Controller controller = this.getController(n);
        if (controller == null) {
            return 0;
        }
        return controller.getAxisCount();
    }

    public float getAxisValue(int n, int n2) {
        Controller controller = this.getController(n);
        if (controller == null) {
            return 0.0f;
        }
        return controller.getAxisValue(n2);
    }

    public String getAxisName(int n, int n2) {
        Controller controller = this.getController(n);
        if (controller == null) {
            return null;
        }
        return controller.getAxisName(n2);
    }

    public boolean isControllerLeftD(int n) {
        if (n == -1) {
            for (int i = 0; i < this.controllers.length; ++i) {
                if (!this.isControllerLeftD(i)) continue;
                return true;
            }
            return false;
        }
        Controller controller = this.getController(n);
        if (controller == null) {
            return false;
        }
        return controller.getPovX() < -0.5f;
    }

    public boolean isControllerRightD(int n) {
        if (n == -1) {
            for (int i = 0; i < this.controllers.length; ++i) {
                if (!this.isControllerRightD(i)) continue;
                return true;
            }
            return false;
        }
        Controller controller = this.getController(n);
        if (controller == null) {
            return false;
        }
        return controller.getPovX() > 0.5f;
    }

    public boolean isControllerUpD(int n) {
        if (n == -1) {
            for (int i = 0; i < this.controllers.length; ++i) {
                if (!this.isControllerUpD(i)) continue;
                return true;
            }
            return false;
        }
        Controller controller = this.getController(n);
        if (controller == null) {
            return false;
        }
        return controller.getPovY() < -0.5f;
    }

    public boolean isControllerDownD(int n) {
        if (n == -1) {
            for (int i = 0; i < this.controllers.length; ++i) {
                if (!this.isControllerDownD(i)) continue;
                return true;
            }
            return false;
        }
        Controller controller = this.getController(n);
        if (controller == null) {
            return false;
        }
        return controller.getPovY() > 0.5f;
    }

    private Controller checkControllerButton(int n, int n2) {
        Controller controller = this.getController(n);
        if (controller == null) {
            return null;
        }
        if (n2 < 0 || n2 >= controller.getButtonCount()) {
            return null;
        }
        return controller;
    }

    public boolean isButtonPressedD(int n, int n2) {
        if (n2 == -1) {
            for (int i = 0; i < this.controllers.length; ++i) {
                if (!this.isButtonPressedD(n, i)) continue;
                return true;
            }
            return false;
        }
        Controller controller = this.checkControllerButton(n2, n);
        if (controller == null) {
            return false;
        }
        return this.controllerPressed[n2][n];
    }

    public boolean wasButtonPressed(int n, int n2) {
        Controller controller = this.checkControllerButton(n, n2);
        if (controller == null) {
            return false;
        }
        return this.controllerWasPressed[n][n2];
    }

    public boolean isButtonStartPress(int n, int n2) {
        return !this.wasButtonPressed(n, n2) && this.isButtonPressedD(n2, n);
    }

    public boolean isButtonReleasePress(int n, int n2) {
        return this.wasButtonPressed(n, n2) && !this.isButtonPressedD(n2, n);
    }

    public void initControllers() {
        this.updateGameThread();
        this.updateGameThread();
    }

    private void onControllerConnected(Controller controller) {
        JoypadManager.instance.onControllerConnected(controller);
        if (LuaManager.env == null) {
            return;
        }
        LuaEventManager.triggerEvent("OnGamepadConnect", controller.getID());
    }

    private void onControllerDisconnected(Controller controller) {
        JoypadManager.instance.onControllerDisconnected(controller);
        if (LuaManager.env == null) {
            return;
        }
        LuaEventManager.triggerEvent("OnGamepadDisconnect", controller.getID());
    }

    public void poll() {
        if (!Core.getInstance().isDoingTextEntry()) {
            while (GameKeyboard.getEventQueuePolling().next()) {
            }
        }
        while (Mouse.next()) {
        }
        this.m_controllerStateCache.poll();
    }

    public Controller getController(int n) {
        if (n < 0 || n >= this.controllers.length) {
            return null;
        }
        return this.controllers[n];
    }

    public int getButtonCount(int n) {
        Controller controller = this.getController(n);
        return controller == null ? null : Integer.valueOf(controller.getButtonCount());
    }

    public String getButtonName(int n, int n2) {
        Controller controller = this.getController(n);
        return controller == null ? null : controller.getButtonName(n2);
    }

    public void updateGameThread() {
        Controller controller;
        int n;
        if (!this.m_controllerStateCache.getState().isCreated()) {
            this.m_controllerStateCache.swap();
            return;
        }
        ControllerState controllerState = this.m_controllerStateCache.getState();
        if (this.checkConnectDisconnect(controllerState)) {
            for (n = 0; n < this.newlyDisconnected.size(); ++n) {
                controller = this.newlyDisconnected.get(n);
                this.onControllerDisconnected(controller);
            }
            for (n = 0; n < this.newlyConnected.size(); ++n) {
                controller = this.newlyConnected.get(n);
                this.onControllerConnected(controller);
            }
        }
        for (n = 0; n < this.getControllerCount(); ++n) {
            float f;
            int n2;
            controller = this.getController(n);
            if (controller == null) continue;
            int n3 = controller.getButtonCount();
            for (n2 = 0; n2 < n3; ++n2) {
                this.controllerWasPressed[n][n2] = this.controllerPressed[n][n2];
                if (this.controllerPressed[n][n2] && !controller.isButtonPressed(n2)) {
                    this.controllerPressed[n][n2] = false;
                    continue;
                }
                if (this.controllerPressed[n][n2] || !controller.isButtonPressed(n2)) continue;
                this.controllerPressed[n][n2] = true;
                JoypadManager.instance.onPressed(n, n2);
            }
            n3 = controller.getAxisCount();
            for (n2 = 0; n2 < n3; ++n2) {
                f = controller.getAxisValue(n2);
                if (controller.isGamepad() && n2 == 4 || n2 == 5) {
                    if (!(f > 0.0f)) continue;
                    JoypadManager.instance.onPressedTrigger(n, n2);
                    continue;
                }
                if (f < -0.5f) {
                    JoypadManager.instance.onPressedAxisNeg(n, n2);
                }
                if (!(f > 0.5f)) continue;
                JoypadManager.instance.onPressedAxis(n, n2);
            }
            float f2 = controller.getPovX();
            f = controller.getPovY();
            if (f2 == this.controllerPov[n][0] && f == this.controllerPov[n][1]) continue;
            this.controllerPov[n][0] = f2;
            this.controllerPov[n][1] = f;
            JoypadManager.instance.onPressedPov(n);
        }
        this.m_controllerStateCache.swap();
    }

    private boolean checkConnectDisconnect(ControllerState controllerState) {
        boolean bl = false;
        this.newlyConnected.clear();
        this.newlyDisconnected.clear();
        for (int i = 0; i < 16; ++i) {
            Controller controller = controllerState.getController(i);
            if (controller == this.controllers[i]) continue;
            bl = true;
            if (controller == null || !controller.isGamepad()) {
                if (this.controllers[i] != null) {
                    this.newlyDisconnected.add(this.controllers[i]);
                }
                controller = null;
            } else {
                this.newlyConnected.add(controller);
            }
            this.controllers[i] = controller;
        }
        return bl;
    }

    public void quit() {
        this.m_controllerStateCache.quit();
    }
}

