/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.fonts;

import gnu.trove.list.array.TShortArrayList;
import gnu.trove.map.hash.TShortObjectHashMap;
import gnu.trove.procedure.TShortObjectProcedure;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.lwjgl.opengl.GL11;
import zombie.ZomboidFileSystem;
import zombie.asset.Asset;
import zombie.asset.AssetStateObserver;
import zombie.core.Color;
import zombie.core.SpriteRenderer;
import zombie.core.fonts.Font;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureID;
import zombie.util.StringUtils;

public final class AngelCodeFont
implements Font,
AssetStateObserver {
    private static final int DISPLAY_LIST_CACHE_SIZE = 200;
    private static final int MAX_CHAR = 255;
    private int baseDisplayListID = -1;
    public CharDef[] chars;
    private boolean displayListCaching = false;
    private DisplayList eldestDisplayList;
    private int eldestDisplayListID;
    private final LinkedHashMap displayLists = new LinkedHashMap(200, 1.0f, true){

        protected boolean removeEldestEntry(Map.Entry entry) {
            AngelCodeFont.this.eldestDisplayList = (DisplayList)entry.getValue();
            AngelCodeFont.this.eldestDisplayListID = AngelCodeFont.this.eldestDisplayList.id;
            return false;
        }
    };
    private Texture fontImage;
    private int lineHeight;
    private HashMap<Short, Texture> pages = new HashMap();
    private File fntFile;
    public static int xoff = 0;
    public static int yoff = 0;
    public static Color curCol = null;
    public static float curR = 0.0f;
    public static float curG = 0.0f;
    public static float curB = 0.0f;
    public static float curA = 0.0f;
    private static float s_scale = 0.0f;
    private static char[] data = new char[256];

    public AngelCodeFont(String string, Texture texture) throws FileNotFoundException {
        int n;
        this.fontImage = texture;
        Object object = string;
        FileInputStream fileInputStream = new FileInputStream(new File((String)object));
        if (((String)object).startsWith("/")) {
            object = ((String)object).substring(1);
        }
        while ((n = ((String)object).indexOf("\\")) != -1) {
            object = ((String)object).substring(0, n) + "/" + ((String)object).substring(n + 1);
        }
        this.parseFnt(fileInputStream);
    }

    public AngelCodeFont(String string, String string2) throws FileNotFoundException {
        int n;
        if (!StringUtils.isNullOrWhitespace(string2)) {
            int n2 = 0;
            this.fontImage = Texture.getSharedTexture(string2, n2 |= TextureID.bUseCompression ? 4 : 0);
            if (this.fontImage != null && !this.fontImage.isReady()) {
                this.fontImage.getObserverCb().add(this);
            }
        }
        Object object = string;
        FileInputStream fileInputStream = null;
        if (((String)object).startsWith("/")) {
            object = ((String)object).substring(1);
        }
        while ((n = ((String)object).indexOf("\\")) != -1) {
            object = ((String)object).substring(0, n) + "/" + ((String)object).substring(n + 1);
        }
        this.fntFile = new File(ZomboidFileSystem.instance.getString((String)object));
        fileInputStream = new FileInputStream(ZomboidFileSystem.instance.getString((String)object));
        this.parseFnt(fileInputStream);
    }

    @Override
    public void drawString(float f, float f2, String string) {
        this.drawString(f, f2, string, Color.white);
    }

    @Override
    public void drawString(float f, float f2, String string, Color color) {
        this.drawString(f, f2, string, color, 0, string.length() - 1);
    }

    public void drawString(float f, float f2, String string, float f3, float f4, float f5, float f6) {
        this.drawString(f, f2, string, f3, f4, f5, f6, 0, string.length() - 1);
    }

    public void drawString(float f, float f2, float f3, String string, float f4, float f5, float f6, float f7) {
        this.drawString(f, f2, f3, string, f4, f5, f6, f7, 0, string.length() - 1);
    }

    @Override
    public void drawString(float f, float f2, String string, Color color, int n, int n2) {
        xoff = (int)f;
        yoff = (int)f2;
        curR = color.r;
        curG = color.g;
        curB = color.b;
        curA = color.a;
        s_scale = 0.0f;
        Texture.lr = color.r;
        Texture.lg = color.g;
        Texture.lb = color.b;
        Texture.la = color.a;
        if (this.displayListCaching && n == 0 && n2 == string.length() - 1) {
            DisplayList displayList = (DisplayList)this.displayLists.get(string);
            if (displayList != null) {
                GL11.glCallList((int)displayList.id);
            } else {
                displayList = new DisplayList();
                displayList.text = string;
                int n3 = this.displayLists.size();
                if (n3 < 200) {
                    displayList.id = this.baseDisplayListID + n3;
                } else {
                    displayList.id = this.eldestDisplayListID;
                    this.displayLists.remove(this.eldestDisplayList.text);
                }
                this.displayLists.put(string, displayList);
                GL11.glNewList((int)displayList.id, (int)4865);
                this.render(string, n, n2);
                GL11.glEndList();
            }
        } else {
            this.render(string, n, n2);
        }
    }

    public void drawString(float f, float f2, String string, float f3, float f4, float f5, float f6, int n, int n2) {
        this.drawString(f, f2, 0.0f, string, f3, f4, f5, f6, n, n2);
    }

    public void drawString(float f, float f2, float f3, String string, float f4, float f5, float f6, float f7, int n, int n2) {
        xoff = (int)f;
        yoff = (int)f2;
        curR = f4;
        curG = f5;
        curB = f6;
        curA = f7;
        s_scale = f3;
        Texture.lr = f4;
        Texture.lg = f5;
        Texture.lb = f6;
        Texture.la = f7;
        if (this.displayListCaching && n == 0 && n2 == string.length() - 1) {
            DisplayList displayList = (DisplayList)this.displayLists.get(string);
            if (displayList != null) {
                GL11.glCallList((int)displayList.id);
            } else {
                displayList = new DisplayList();
                displayList.text = string;
                int n3 = this.displayLists.size();
                if (n3 < 200) {
                    displayList.id = this.baseDisplayListID + n3;
                } else {
                    displayList.id = this.eldestDisplayListID;
                    this.displayLists.remove(this.eldestDisplayList.text);
                }
                this.displayLists.put(string, displayList);
                GL11.glNewList((int)displayList.id, (int)4865);
                this.render(string, n, n2);
                GL11.glEndList();
            }
        } else {
            this.render(string, n, n2);
        }
    }

    @Override
    public int getHeight(String string) {
        DisplayList displayList = null;
        if (this.displayListCaching && (displayList = (DisplayList)this.displayLists.get(string)) != null && displayList.height != null) {
            return displayList.height.intValue();
        }
        int n = 1;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            CharDef charDef;
            char c = string.charAt(i);
            if (c == '\n') {
                ++n;
                n2 = 0;
                continue;
            }
            if (c == ' ' || c >= this.chars.length || (charDef = this.chars[c]) == null) continue;
            n2 = Math.max(charDef.height + charDef.yoffset, n2);
        }
        n2 = n * this.getLineHeight();
        if (displayList != null) {
            displayList.height = new Short((short)n2);
        }
        return n2;
    }

    @Override
    public int getLineHeight() {
        return this.lineHeight;
    }

    @Override
    public int getWidth(String string) {
        return this.getWidth(string, 0, string.length() - 1, false);
    }

    @Override
    public int getWidth(String string, boolean bl) {
        return this.getWidth(string, 0, string.length() - 1, bl);
    }

    @Override
    public int getWidth(String string, int n, int n2) {
        return this.getWidth(string, n, n2, false);
    }

    @Override
    public int getWidth(String string, int n, int n2, boolean bl) {
        DisplayList displayList = null;
        if (this.displayListCaching && n == 0 && n2 == string.length() - 1 && (displayList = (DisplayList)this.displayLists.get(string)) != null && displayList.width != null) {
            return displayList.width.intValue();
        }
        int n3 = n2 - n + 1;
        int n4 = 0;
        int n5 = 0;
        CharDef charDef = null;
        for (int i = 0; i < n3; ++i) {
            CharDef charDef2;
            char c = string.charAt(n + i);
            if (c == '\n') {
                n5 = 0;
                continue;
            }
            if (c >= this.chars.length || (charDef2 = this.chars[c]) == null) continue;
            if (charDef != null) {
                n5 += charDef.getKerning(c);
            }
            charDef = charDef2;
            n5 = bl || i < n3 - 1 ? (n5 += charDef2.xadvance) : (n5 += charDef2.width);
            n4 = Math.max(n4, n5);
        }
        if (displayList != null) {
            displayList.width = new Short((short)n4);
        }
        return n4;
    }

    public int getYOffset(String string) {
        DisplayList displayList = null;
        if (this.displayListCaching && (displayList = (DisplayList)this.displayLists.get(string)) != null && displayList.yOffset != null) {
            return displayList.yOffset.intValue();
        }
        int n = string.indexOf(10);
        if (n == -1) {
            n = string.length();
        }
        int n2 = 10000;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            CharDef charDef = this.chars[c];
            if (charDef == null) continue;
            n2 = Math.min(charDef.yoffset, n2);
        }
        if (displayList != null) {
            displayList.yOffset = new Short((short)n2);
        }
        return n2;
    }

    private CharDef parseChar(String string) {
        CharDef charDef = new CharDef();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " =");
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        charDef.id = Integer.parseInt(stringTokenizer.nextToken());
        if (charDef.id < 0) {
            return null;
        }
        if (charDef.id > 255) {
            // empty if block
        }
        stringTokenizer.nextToken();
        charDef.x = Short.parseShort(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        charDef.y = Short.parseShort(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        charDef.width = Short.parseShort(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        charDef.height = Short.parseShort(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        charDef.xoffset = Short.parseShort(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        charDef.yoffset = Short.parseShort(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        charDef.xadvance = Short.parseShort(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        charDef.page = Short.parseShort(stringTokenizer.nextToken());
        Texture texture = this.fontImage;
        if (this.pages.containsKey(charDef.page)) {
            texture = this.pages.get(charDef.page);
        }
        if (texture != null && texture.isReady()) {
            charDef.init();
        }
        if (charDef.id != 32) {
            this.lineHeight = Math.max(charDef.height + charDef.yoffset, this.lineHeight);
        }
        return charDef;
    }

    private void parseFnt(InputStream inputStream) {
        if (this.displayListCaching) {
            this.baseDisplayListID = GL11.glGenLists((int)200);
            if (this.baseDisplayListID == 0) {
                this.displayListCaching = false;
            }
        }
        try {
            Object object;
            Object object2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            String string2 = bufferedReader.readLine();
            TShortObjectHashMap tShortObjectHashMap = new TShortObjectHashMap(64);
            ArrayList<Object> arrayList = new ArrayList<Object>(255);
            int n = 0;
            boolean bl = false;
            while (!bl) {
                Object object3;
                int n2;
                short s;
                object2 = bufferedReader.readLine();
                if (object2 == null) {
                    bl = true;
                    continue;
                }
                if (((String)object2).startsWith("page")) {
                    object = new StringTokenizer((String)object2, " =");
                    ((StringTokenizer)object).nextToken();
                    ((StringTokenizer)object).nextToken();
                    s = Short.parseShort(((StringTokenizer)object).nextToken());
                    ((StringTokenizer)object).nextToken();
                    Object object4 = ((StringTokenizer)object).nextToken().replace("\"", "");
                    object4 = this.fntFile.getParent() + File.separatorChar + (String)object4;
                    object4 = ((String)object4).replace("\\", "/");
                    n2 = 0;
                    object3 = Texture.getSharedTexture((String)object4, n2 |= TextureID.bUseCompression ? 4 : 0);
                    if (object3 == null) {
                        System.out.println("AngelCodeFont failed to load page " + s + " texture " + (String)object4);
                    } else {
                        this.pages.put(s, (Texture)object3);
                        if (!((Asset)object3).isReady()) {
                            ((Asset)object3).getObserverCb().add(this);
                        }
                    }
                }
                if (!((String)object2).startsWith("chars c") && ((String)object2).startsWith("char") && (object = this.parseChar((String)object2)) != null) {
                    n = Math.max(n, ((CharDef)object).id);
                    arrayList.add(object);
                }
                if (((String)object2).startsWith("kernings c") || !((String)object2).startsWith("kerning")) continue;
                object = new StringTokenizer((String)object2, " =");
                ((StringTokenizer)object).nextToken();
                ((StringTokenizer)object).nextToken();
                s = Short.parseShort(((StringTokenizer)object).nextToken());
                ((StringTokenizer)object).nextToken();
                int n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
                ((StringTokenizer)object).nextToken();
                n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
                object3 = (TShortArrayList)tShortObjectHashMap.get(s);
                if (object3 == null) {
                    object3 = new TShortArrayList();
                    tShortObjectHashMap.put(s, object3);
                }
                object3.add((short)n3);
                object3.add((short)n2);
            }
            this.chars = new CharDef[n + 1];
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                this.chars[((CharDef)object).id] = object = (CharDef)object2.next();
            }
            tShortObjectHashMap.forEachEntry((TShortObjectProcedure)new TShortObjectProcedure<TShortArrayList>(){

                public boolean execute(short s, TShortArrayList tShortArrayList) {
                    CharDef charDef = AngelCodeFont.this.chars[s];
                    charDef.kerningSecond = new short[tShortArrayList.size() / 2];
                    charDef.kerningAmount = new short[tShortArrayList.size() / 2];
                    int n = 0;
                    for (int i = 0; i < tShortArrayList.size(); i += 2) {
                        charDef.kerningSecond[n] = tShortArrayList.get(i);
                        charDef.kerningAmount[n] = tShortArrayList.get(i + 1);
                        ++n;
                    }
                    short[] sArray = Arrays.copyOf(charDef.kerningSecond, charDef.kerningSecond.length);
                    short[] sArray2 = Arrays.copyOf(charDef.kerningAmount, charDef.kerningAmount.length);
                    Arrays.sort(sArray);
                    block1: for (int i = 0; i < sArray.length; ++i) {
                        for (int j = 0; j < charDef.kerningSecond.length; ++j) {
                            if (charDef.kerningSecond[j] != sArray[i]) continue;
                            charDef.kerningAmount[i] = sArray2[j];
                            continue block1;
                        }
                    }
                    charDef.kerningSecond = sArray;
                    return true;
                }
            });
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void render(String string, int n, int n2) {
        int n3 = ++n2 - n;
        float f = 0.0f;
        float f2 = 0.0f;
        CharDef charDef = null;
        if (data.length < n3) {
            data = new char[(n3 + 128 - 1) / 128 * 128];
        }
        string.getChars(n, n2, data, 0);
        for (int i = 0; i < n3; ++i) {
            CharDef charDef2;
            char c = data[i];
            if (c == '\n') {
                f = 0.0f;
                f2 += (float)this.getLineHeight();
                continue;
            }
            if (c >= this.chars.length || (charDef2 = this.chars[c]) == null) continue;
            if (charDef != null) {
                f = s_scale > 0.0f ? (f += (float)charDef.getKerning(c) * s_scale) : (f += (float)charDef.getKerning(c));
            }
            charDef = charDef2;
            charDef2.draw(f, f2);
            if (s_scale > 0.0f) {
                f += (float)charDef2.xadvance * s_scale;
                continue;
            }
            f += (float)charDef2.xadvance;
        }
    }

    @Override
    public void onStateChanged(Asset.State state, Asset.State state2, Asset asset) {
        if (asset != this.fontImage && !this.pages.containsValue(asset)) {
            return;
        }
        if (state2 != Asset.State.READY) {
            return;
        }
        for (CharDef charDef : this.chars) {
            if (charDef == null || charDef.image != null) continue;
            Texture texture = this.fontImage;
            if (this.pages.containsKey(charDef.page)) {
                texture = this.pages.get(charDef.page);
            }
            if (asset != texture) continue;
            charDef.init();
        }
    }

    public boolean isEmpty() {
        if (this.fontImage != null && this.fontImage.isEmpty()) {
            return true;
        }
        for (Texture texture : this.pages.values()) {
            if (!texture.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        for (CharDef charDef : this.chars) {
            if (charDef == null) continue;
            charDef.destroy();
        }
        Arrays.fill(this.chars, null);
        this.pages.clear();
    }

    private static class DisplayList {
        Short height;
        int id;
        String text;
        Short width;
        Short yOffset;

        private DisplayList() {
        }
    }

    public class CharDef {
        public short dlIndex;
        public short height;
        public int id;
        public Texture image;
        public short[] kerningSecond;
        public short[] kerningAmount;
        public short width;
        public short x;
        public short xadvance;
        public short xoffset;
        public short y;
        public short yoffset;
        public short page;

        public void draw(float f, float f2) {
            Texture texture = this.image;
            if (s_scale > 0.0f) {
                SpriteRenderer.instance.m_states.getPopulatingActiveState().render(texture, f + (float)this.xoffset * s_scale + (float)xoff, f2 + (float)this.yoffset * s_scale + (float)yoff, (float)this.width * s_scale, (float)this.height * s_scale, curR, curG, curB, curA, null);
            } else {
                SpriteRenderer.instance.renderi(texture, (int)(f + (float)this.xoffset + (float)xoff), (int)(f2 + (float)this.yoffset + (float)yoff), this.width, this.height, curR, curG, curB, curA, null);
            }
        }

        public int getKerning(int n) {
            if (this.kerningSecond == null) {
                return 0;
            }
            int n2 = 0;
            int n3 = this.kerningSecond.length - 1;
            while (n2 <= n3) {
                int n4 = n2 + n3 >>> 1;
                if (this.kerningSecond[n4] < n) {
                    n2 = n4 + 1;
                    continue;
                }
                if (this.kerningSecond[n4] > n) {
                    n3 = n4 - 1;
                    continue;
                }
                return this.kerningAmount[n4];
            }
            return 0;
        }

        public void init() {
            Texture texture = AngelCodeFont.this.fontImage;
            if (AngelCodeFont.this.pages.containsKey(this.page)) {
                texture = AngelCodeFont.this.pages.get(this.page);
            }
            this.image = new CharDefTexture(texture.getTextureId(), texture.getName() + "_" + this.x + "_" + this.y);
            this.image.setRegion(this.x + (int)(texture.xStart * (float)texture.getWidthHW()), this.y + (int)(texture.yStart * (float)texture.getHeightHW()), this.width, this.height);
        }

        public void destroy() {
            if (this.image != null && this.image.getTextureId() != null) {
                ((CharDefTexture)this.image).releaseCharDef();
                this.image = null;
            }
        }

        public String toString() {
            return "[CharDef id=" + this.id + " x=" + this.x + " y=" + this.y + "]";
        }
    }

    public static final class CharDefTexture
    extends Texture {
        public CharDefTexture(TextureID textureID, String string) {
            super(textureID, string);
        }

        public void releaseCharDef() {
            this.removeDependency(this.dataid);
        }
    }
}

