/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.VBO;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.opengl.ARBMapBufferRange;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjglx.opengl.OpenGLException;
import zombie.core.VBO.GLBufferObject15;
import zombie.core.VBO.GLBufferObjectARB;
import zombie.core.VBO.IGLBufferObject;
import zombie.core.skinnedmodel.model.VertexBufferObject;

public class GLVertexBufferObject {
    public static IGLBufferObject funcs;
    private long size;
    private final int type;
    private final int usage;
    private transient int id;
    private transient boolean mapped;
    private transient boolean cleared;
    private transient ByteBuffer buffer;
    private int m_vertexAttribArray = -1;

    public static void init() {
        if (GL.getCapabilities().OpenGL15) {
            System.out.println("OpenGL 1.5 buffer objects supported");
            funcs = new GLBufferObject15();
        } else if (GL.getCapabilities().GL_ARB_vertex_buffer_object) {
            System.out.println("GL_ARB_vertex_buffer_object supported");
            funcs = new GLBufferObjectARB();
        } else {
            throw new RuntimeException("Neither OpenGL 1.5 nor GL_ARB_vertex_buffer_object supported");
        }
        VertexBufferObject.funcs = funcs;
    }

    public GLVertexBufferObject(long l, int n, int n2) {
        this.size = l;
        this.type = n;
        this.usage = n2;
    }

    public GLVertexBufferObject(int n, int n2) {
        this.size = 0L;
        this.type = n;
        this.usage = n2;
    }

    public void create() {
        this.id = funcs.glGenBuffers();
    }

    public void clear() {
        if (!this.cleared) {
            funcs.glBufferData(this.type, this.size, this.usage);
            this.cleared = true;
        }
    }

    protected void doDestroy() {
        if (this.id != 0) {
            this.unmap();
            funcs.glDeleteBuffers(this.id);
            this.id = 0;
        }
    }

    public ByteBuffer map(int n) {
        if (!this.mapped) {
            if (this.size != (long)n) {
                this.size = n;
                this.clear();
            }
            if (this.buffer != null && this.buffer.capacity() < n) {
                this.buffer = null;
            }
            ByteBuffer byteBuffer = this.buffer;
            if (GL.getCapabilities().OpenGL30) {
                int n2 = 34;
                this.buffer = GL30.glMapBufferRange((int)this.type, (long)0L, (long)n, (int)n2, (ByteBuffer)this.buffer);
            } else if (GL.getCapabilities().GL_ARB_map_buffer_range) {
                int n3 = 34;
                this.buffer = ARBMapBufferRange.glMapBufferRange((int)this.type, (long)0L, (long)n, (int)n3, (ByteBuffer)this.buffer);
            } else {
                this.buffer = funcs.glMapBuffer(this.type, funcs.GL_WRITE_ONLY(), n, this.buffer);
            }
            if (this.buffer == null) {
                throw new OpenGLException("Failed to map buffer " + this);
            }
            if (this.buffer == byteBuffer || byteBuffer != null) {
                // empty if block
            }
            this.buffer.order(ByteOrder.nativeOrder()).clear().limit(n);
            this.mapped = true;
            this.cleared = false;
        }
        return this.buffer;
    }

    public ByteBuffer map() {
        if (!this.mapped) {
            assert (this.size > 0L);
            this.clear();
            ByteBuffer byteBuffer = this.buffer;
            if (GL.getCapabilities().OpenGL30) {
                int n = 34;
                this.buffer = GL30.glMapBufferRange((int)this.type, (long)0L, (long)this.size, (int)n, (ByteBuffer)this.buffer);
            } else if (GL.getCapabilities().GL_ARB_map_buffer_range) {
                int n = 34;
                this.buffer = ARBMapBufferRange.glMapBufferRange((int)this.type, (long)0L, (long)this.size, (int)n, (ByteBuffer)this.buffer);
            } else {
                this.buffer = funcs.glMapBuffer(this.type, funcs.GL_WRITE_ONLY(), this.size, this.buffer);
            }
            if (this.buffer == null) {
                throw new OpenGLException("Failed to map a buffer " + this.size + " bytes long");
            }
            if (this.buffer == byteBuffer || byteBuffer != null) {
                // empty if block
            }
            this.buffer.order(ByteOrder.nativeOrder()).clear().limit((int)this.size);
            this.mapped = true;
            this.cleared = false;
        }
        return this.buffer;
    }

    public void orphan() {
        funcs.glMapBuffer(this.type, this.usage, this.size, null);
    }

    public boolean unmap() {
        if (this.mapped) {
            this.mapped = false;
            return funcs.glUnmapBuffer(this.type);
        }
        return true;
    }

    public boolean isMapped() {
        return this.mapped;
    }

    public void bufferData(ByteBuffer byteBuffer) {
        funcs.glBufferData(this.type, byteBuffer, this.usage);
    }

    public String toString() {
        return "GLVertexBufferObject[" + this.id + ", " + this.size + "]";
    }

    public void bind() {
        funcs.glBindBuffer(this.type, this.id);
    }

    public void bindNone() {
        funcs.glBindBuffer(this.type, 0);
    }

    public int getID() {
        return this.id;
    }

    public void enableVertexAttribArray(int n) {
        if (this.m_vertexAttribArray != n) {
            this.disableVertexAttribArray();
            if (n >= 0) {
                GL20.glEnableVertexAttribArray((int)n);
            }
            this.m_vertexAttribArray = n >= 0 ? n : -1;
        }
    }

    public void disableVertexAttribArray() {
        if (this.m_vertexAttribArray != -1) {
            GL20.glDisableVertexAttribArray((int)this.m_vertexAttribArray);
            this.m_vertexAttribArray = -1;
        }
    }
}

