/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.Styles;

import java.io.Serializable;

public class ShortList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private short[] value;
    private short count = 0;
    private final boolean fastExpand;

    public ShortList() {
        this(0);
    }

    public ShortList(int n) {
        this(true, n);
    }

    public ShortList(boolean bl, int n) {
        this.fastExpand = bl;
        this.value = new short[n];
    }

    public short add(short s) {
        if (this.count == this.value.length) {
            short[] sArray = this.value;
            this.value = this.fastExpand ? new short[(sArray.length << 1) + 1] : new short[sArray.length + 1];
            System.arraycopy(sArray, 0, this.value, 0, sArray.length);
        }
        this.value[this.count] = s;
        short s2 = this.count;
        this.count = (short)(s2 + 1);
        return s2;
    }

    public short remove(int n) {
        if (n >= this.count || n < 0) {
            throw new IndexOutOfBoundsException("Referenced " + n + ", size=" + this.count);
        }
        short s = this.value[n];
        if (n < this.count - 1) {
            System.arraycopy(this.value, n + 1, this.value, n, this.count - n - 1);
        }
        this.count = (short)(this.count - 1);
        return s;
    }

    public void addAll(short[] sArray) {
        this.ensureCapacity(this.count + sArray.length);
        System.arraycopy(sArray, 0, this.value, this.count, sArray.length);
        this.count = (short)(this.count + sArray.length);
    }

    public void addAll(ShortList shortList) {
        this.ensureCapacity(this.count + shortList.count);
        System.arraycopy(shortList.value, 0, this.value, this.count, shortList.count);
        this.count = (short)(this.count + shortList.count);
    }

    public short[] array() {
        return this.value;
    }

    public int capacity() {
        return this.value.length;
    }

    public void clear() {
        this.count = 0;
    }

    public void ensureCapacity(int n) {
        if (this.value.length >= n) {
            return;
        }
        short[] sArray = this.value;
        this.value = new short[n];
        System.arraycopy(sArray, 0, this.value, 0, sArray.length);
    }

    public short get(int n) {
        return this.value[n];
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int size() {
        return this.count;
    }

    public short[] toArray(short[] sArray) {
        if (sArray == null) {
            sArray = new short[this.count];
        }
        System.arraycopy(this.value, 0, sArray, 0, this.count);
        return sArray;
    }

    public void trimToSize() {
        if (this.count == this.value.length) {
            return;
        }
        short[] sArray = this.value;
        this.value = new short[this.count];
        System.arraycopy(sArray, 0, this.value, 0, this.count);
    }
}

