/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.Styles;

import java.io.Serializable;

public class IntList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] value;
    private int count = 0;
    private final boolean fastExpand;

    public IntList() {
        this(0);
    }

    public IntList(int n) {
        this(true, n);
    }

    public IntList(boolean bl, int n) {
        this.fastExpand = bl;
        this.value = new int[n];
    }

    public int add(short s) {
        if (this.count == this.value.length) {
            int[] nArray = this.value;
            this.value = this.fastExpand ? new int[(nArray.length << 1) + 1] : new int[nArray.length + 1];
            System.arraycopy(nArray, 0, this.value, 0, nArray.length);
        }
        this.value[this.count] = s;
        return this.count++;
    }

    public int remove(int n) {
        if (n >= this.count || n < 0) {
            throw new IndexOutOfBoundsException("Referenced " + n + ", size=" + this.count);
        }
        int n2 = this.value[n];
        if (n < this.count - 1) {
            System.arraycopy(this.value, n + 1, this.value, n, this.count - n - 1);
        }
        --this.count;
        return n2;
    }

    public void addAll(short[] sArray) {
        this.ensureCapacity(this.count + sArray.length);
        System.arraycopy(sArray, 0, this.value, this.count, sArray.length);
        this.count += sArray.length;
    }

    public void addAll(IntList intList) {
        this.ensureCapacity(this.count + intList.count);
        System.arraycopy(intList.value, 0, this.value, this.count, intList.count);
        this.count += intList.count;
    }

    public int[] array() {
        return this.value;
    }

    public int capacity() {
        return this.value.length;
    }

    public void clear() {
        this.count = 0;
    }

    public void ensureCapacity(int n) {
        if (this.value.length >= n) {
            return;
        }
        int[] nArray = this.value;
        this.value = new int[n];
        System.arraycopy(nArray, 0, this.value, 0, nArray.length);
    }

    public int get(int n) {
        return this.value[n];
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int size() {
        return this.count;
    }

    public short[] toArray(short[] sArray) {
        if (sArray == null) {
            sArray = new short[this.count];
        }
        System.arraycopy(this.value, 0, sArray, 0, this.count);
        return sArray;
    }

    public void trimToSize() {
        if (this.count == this.value.length) {
            return;
        }
        int[] nArray = this.value;
        this.value = new int[this.count];
        System.arraycopy(nArray, 0, this.value, 0, this.count);
    }
}

