/*
 * Decompiled with CFR 0.152.
 */
package zombie.core;

import org.uncommons.maths.random.CellularAutomatonRNG;
import org.uncommons.maths.random.SecureRandomSeedGenerator;
import org.uncommons.maths.random.SeedException;
import org.uncommons.maths.random.SeedGenerator;
import zombie.core.PerformanceSettings;
import zombie.network.GameServer;

public final class Rand {
    public static CellularAutomatonRNG rand;
    public static CellularAutomatonRNG randlua;
    public static int id;

    public static void init() {
        try {
            rand = new CellularAutomatonRNG((SeedGenerator)new PZSeedGenerator());
            randlua = new CellularAutomatonRNG((SeedGenerator)new PZSeedGenerator());
        }
        catch (SeedException seedException) {
            seedException.printStackTrace();
        }
    }

    private static int Next(int n, CellularAutomatonRNG cellularAutomatonRNG) {
        if (n <= 0) {
            return 0;
        }
        if (++id >= 10000) {
            id = 0;
        }
        return cellularAutomatonRNG.nextInt(n);
    }

    public static int Next(int n) {
        return Rand.Next(n, rand);
    }

    public static long Next(long l, CellularAutomatonRNG cellularAutomatonRNG) {
        return Rand.Next((int)l, cellularAutomatonRNG);
    }

    public static long Next(long l) {
        return Rand.Next(l, rand);
    }

    public static int Next(int n, int n2, CellularAutomatonRNG cellularAutomatonRNG) {
        int n3;
        if (n2 == n) {
            return n;
        }
        if (n > n2) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        if (++id >= 10000) {
            id = 0;
        }
        n3 = cellularAutomatonRNG.nextInt(n2 - n);
        return n3 + n;
    }

    public static int Next(int n, int n2) {
        return Rand.Next(n, n2, rand);
    }

    public static long Next(long l, long l2, CellularAutomatonRNG cellularAutomatonRNG) {
        if (l2 == l) {
            return l;
        }
        if (l > l2) {
            long l3 = l;
            l = l2;
            l2 = l3;
        }
        if (++id >= 10000) {
            id = 0;
        }
        int n = cellularAutomatonRNG.nextInt((int)(l2 - l));
        return (long)n + l;
    }

    public static long Next(long l, long l2) {
        return Rand.Next(l, l2, rand);
    }

    public static float Next(float f, float f2, CellularAutomatonRNG cellularAutomatonRNG) {
        if (f2 == f) {
            return f;
        }
        if (f > f2) {
            float f3 = f;
            f = f2;
            f2 = f3;
        }
        if (++id >= 10000) {
            id = 0;
        }
        return f + cellularAutomatonRNG.nextFloat() * (f2 - f);
    }

    public static float Next(float f, float f2) {
        return Rand.Next(f, f2, rand);
    }

    public static boolean NextBool(int n) {
        return Rand.Next(n) == 0;
    }

    public static int AdjustForFramerate(int n) {
        n = GameServer.bServer ? (int)((float)n * 0.33333334f) : (int)((float)n * ((float)PerformanceSettings.getLockFPS() / 30.0f));
        return n;
    }

    static {
        id = 0;
    }

    public static final class PZSeedGenerator
    implements SeedGenerator {
        private static final SeedGenerator[] GENERATORS = new SeedGenerator[]{new SecureRandomSeedGenerator()};

        private PZSeedGenerator() {
        }

        public byte[] generateSeed(int n) {
            for (SeedGenerator seedGenerator : GENERATORS) {
                try {
                    byte[] byArray = seedGenerator.generateSeed(n);
                    return byArray;
                }
                catch (SeedException seedException) {
                }
            }
            throw new IllegalStateException("All available seed generation strategies failed.");
        }
    }
}

