/*
 * Decompiled with CFR 0.152.
 */
package zombie.core;

import fmod.FMOD_DriverInfo;
import fmod.javafmod;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL32;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.glu.GLU;
import org.lwjglx.LWJGLException;
import org.lwjglx.input.Controller;
import org.lwjglx.input.Keyboard;
import org.lwjglx.opengl.Display;
import org.lwjglx.opengl.DisplayMode;
import org.lwjglx.opengl.OpenGLException;
import org.lwjglx.opengl.PixelFormat;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameSounds;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.IndieGL;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaHookManager;
import zombie.Lua.LuaManager;
import zombie.Lua.MapObjects;
import zombie.MovingObjectUpdateScheduler;
import zombie.SandboxOptions;
import zombie.SoundManager;
import zombie.ZomboidFileSystem;
import zombie.ZomboidGlobals;
import zombie.characters.AttachedItems.AttachedLocations;
import zombie.characters.IsoPlayer;
import zombie.characters.SurvivorFactory;
import zombie.characters.WornItems.BodyLocations;
import zombie.characters.professions.ProfessionFactory;
import zombie.characters.skills.CustomPerks;
import zombie.characters.skills.PerkFactory;
import zombie.characters.traits.TraitFactory;
import zombie.core.Clipboard;
import zombie.core.GameVersion;
import zombie.core.Languages;
import zombie.core.PerformanceSettings;
import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.Translator;
import zombie.core.VBO.GLVertexBufferObject;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.core.opengl.PZGLUtil;
import zombie.core.opengl.RenderThread;
import zombie.core.opengl.Shader;
import zombie.core.raknet.VoiceManager;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.advancedanimation.AnimationSet;
import zombie.core.skinnedmodel.population.BeardStyles;
import zombie.core.skinnedmodel.population.ClothingDecals;
import zombie.core.skinnedmodel.population.HairStyles;
import zombie.core.skinnedmodel.population.OutfitManager;
import zombie.core.sprite.SpriteRenderState;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.MultiTextureFBO2;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureFBO;
import zombie.core.znet.SteamUtils;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.gameStates.ChooseGameInfo;
import zombie.gameStates.IngameState;
import zombie.input.GameKeyboard;
import zombie.input.JoypadManager;
import zombie.input.Mouse;
import zombie.iso.BentFences;
import zombie.iso.BrokenFences;
import zombie.iso.ContainerOverlays;
import zombie.iso.IsoCamera;
import zombie.iso.IsoPuddles;
import zombie.iso.IsoWater;
import zombie.iso.PlayerCamera;
import zombie.iso.TileOverlays;
import zombie.iso.weather.WeatherShader;
import zombie.modding.ActiveMods;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.sandbox.CustomSandboxOptions;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.ui.FPSGraph;
import zombie.ui.ObjectTooltip;
import zombie.ui.TextManager;
import zombie.ui.UIManager;
import zombie.ui.UITextBox2;
import zombie.util.StringUtils;
import zombie.vehicles.VehicleType;
import zombie.worldMap.WorldMap;

public final class Core {
    public static final boolean bDemo = false;
    public static boolean bTutorial;
    private static boolean fakefullscreen;
    private static final GameVersion gameVersion;
    private static final int buildVersion = 16;
    public String steamServerVersion = "1.0.0.0";
    public static boolean bAltMoveMethod;
    private boolean rosewoodSpawnDone = false;
    private final ColorInfo objectHighlitedColor = new ColorInfo(0.98f, 0.56f, 0.11f, 1.0f);
    private final ColorInfo goodHighlitedColor = new ColorInfo(0.0f, 1.0f, 0.0f, 1.0f);
    private final ColorInfo badHighlitedColor = new ColorInfo(1.0f, 0.0f, 0.0f, 1.0f);
    private boolean flashIsoCursor = false;
    private int isoCursorVisibility = 5;
    public static boolean OptionShowCursorWhileAiming;
    private boolean collideZombies = true;
    public final MultiTextureFBO2 OffscreenBuffer = new MultiTextureFBO2();
    private String saveFolder = null;
    public static boolean OptionZoom;
    public static boolean OptionModsEnabled;
    public static int OptionFontSize;
    public static String OptionContextMenuFont;
    public static String OptionInventoryFont;
    private static int OptionInventoryContainerSize;
    public static String OptionTooltipFont;
    public static String OptionMeasurementFormat;
    public static int OptionClockFormat;
    public static int OptionClockSize;
    public static boolean OptionClock24Hour;
    public static boolean OptionVSync;
    public static int OptionSoundVolume;
    public static int OptionMusicVolume;
    public static int OptionAmbientVolume;
    public static int OptionJumpScareVolume;
    public static int OptionMusicActionStyle;
    public static int OptionMusicLibrary;
    public static boolean OptionVoiceEnable;
    public static int OptionVoiceMode;
    public static int OptionVoiceVADMode;
    public static int OptionVoiceAGCMode;
    public static String OptionVoiceRecordDeviceName;
    public static int OptionVoiceVolumeMic;
    public static int OptionVoiceVolumePlayers;
    public static int OptionVehicleEngineVolume;
    public static int OptionReloadDifficulty;
    public static boolean OptionRackProgress;
    public static int OptionBloodDecals;
    public static boolean OptionBorderlessWindow;
    public static boolean OptionLockCursorToWindow;
    public static boolean OptionTextureCompression;
    public static boolean OptionModelTextureMipmaps;
    public static boolean OptionTexture2x;
    private static int OptionMaxTextureSize;
    private static int OptionMaxVehicleTextureSize;
    private static String OptionZoomLevels1x;
    private static String OptionZoomLevels2x;
    public static boolean OptionEnableContentTranslations;
    public static boolean OptionUIFBO;
    public static int OptionUIRenderFPS;
    public static boolean OptionRadialMenuKeyToggle;
    public static boolean OptionReloadRadialInstant;
    public static boolean OptionPanCameraWhileAiming;
    public static boolean OptionPanCameraWhileDriving;
    public static boolean OptionShowChatTimestamp;
    public static boolean OptionShowChatTitle;
    public static String OptionChatFontSize;
    public static float OptionMinChatOpaque;
    public static float OptionMaxChatOpaque;
    public static float OptionChatFadeTime;
    public static boolean OptionChatOpaqueOnFocus;
    public static boolean OptionTemperatureDisplayCelsius;
    public static boolean OptionDoWindSpriteEffects;
    public static boolean OptionDoDoorSpriteEffects;
    public static boolean OptionDoContainerOutline;
    public static boolean OptionRenderPrecipIndoors;
    public static boolean OptionAutoProneAtk;
    public static boolean Option3DGroundItem;
    public static int OptionRenderPrecipitation;
    public static boolean OptionUpdateSneakButton;
    public static boolean OptiondblTapJogToSprint;
    private static int OptionAimOutline;
    private static String OptionCycleContainerKey;
    private static boolean OptionDropItemsOnSquareCenter;
    private static boolean OptionTimedActionGameSpeedReset;
    private static int OptionShoulderButtonContainerSwitch;
    private static boolean OptionProgressBar;
    private static String OptionLanguageName;
    private static final boolean[] OptionSingleContextMenu;
    private static boolean OptionCorpseShadows;
    private static int OptionSimpleClothingTextures;
    private static boolean OptionSimpleWeaponTextures;
    private static boolean OptionAutoDrink;
    private static boolean OptionLeaveKeyInIgnition;
    private static boolean OptionAutoWalkContainer;
    private static int OptionSearchModeOverlayEffect;
    private static int OptionIgnoreProneZombieRange;
    private static boolean OptionShowItemModInfo;
    private boolean OptionShowSurvivalGuide = true;
    private static boolean OptionEnableLeftJoystickRadialMenu;
    private boolean showPing = true;
    private boolean forceSnow = false;
    private boolean zombieGroupSound = true;
    private String blinkingMoodle = null;
    private boolean tutorialDone = false;
    private boolean vehiclesWarningShow = false;
    private String poisonousBerry = null;
    private String poisonousMushroom = null;
    private boolean doneNewSaveFolder = false;
    private static String difficulty;
    public static int TileScale;
    private boolean isSelectingAll = false;
    private boolean showYourUsername = true;
    private ColorInfo mpTextColor = null;
    private boolean isAzerty = false;
    private String seenUpdateText = "";
    private boolean toggleToAim = false;
    private boolean toggleToRun = false;
    private boolean toggleToSprint = true;
    private boolean celsius = false;
    private boolean riversideDone = false;
    private boolean noSave = false;
    private boolean showFirstTimeVehicleTutorial = false;
    private boolean showFirstTimeWeatherTutorial = false;
    private boolean showFirstTimeSneakTutorial = true;
    private boolean showFirstTimeSearchTutorial = true;
    private int termsOfServiceVersion = -1;
    private boolean newReloading = true;
    private boolean gotNewBelt = false;
    private boolean bAnimPopupDone = false;
    private boolean bModsPopupDone = false;
    public static float blinkAlpha;
    public static boolean blinkAlphaIncrease;
    private boolean bLoadedOptions = false;
    private static final HashMap<String, Object> optionsOnStartup;
    private boolean bChallenge;
    public static int width;
    public static int height;
    public static int MaxJukeBoxesActive;
    public static int NumJukeBoxesActive;
    public static String GameMode;
    private static String glVersion;
    private static int glMajorVersion;
    private static final Core core;
    public static boolean bDebug;
    public static UITextBox2 CurrentTextEntryBox;
    public Shader RenderShader;
    private Map<String, Integer> keyMaps = null;
    public final boolean bUseShaders = true;
    private int iPerfSkybox = 1;
    private int iPerfSkybox_new = 1;
    public static final int iPerfSkybox_High = 0;
    public static final int iPerfSkybox_Medium = 1;
    public static final int iPerfSkybox_Static = 2;
    private int iPerfPuddles = 0;
    private int iPerfPuddles_new = 0;
    public static final int iPerfPuddles_None = 3;
    public static final int iPerfPuddles_GroundOnly = 2;
    public static final int iPerfPuddles_GroundWithRuts = 1;
    public static final int iPerfPuddles_All = 0;
    private boolean bPerfReflections = true;
    private boolean bPerfReflections_new = true;
    public int vidMem = 3;
    private boolean bSupportsFBO = true;
    public float UIRenderAccumulator = 0.0f;
    public boolean UIRenderThisFrame = true;
    public int version = 1;
    public int fileversion = 7;
    private static boolean fullScreen;
    private static final boolean[] bAutoZoom;
    public static String GameMap;
    public static String GameSaveWorld;
    public static boolean SafeMode;
    public static boolean SafeModeForced;
    public static boolean SoundDisabled;
    public int frameStage = 0;
    private int stack = 0;
    public static int xx;
    public static int yy;
    public static int zz;
    public final HashMap<Integer, Float> FloatParamMap = new HashMap();
    private final Matrix4f tempMatrix4f = new Matrix4f();
    private static final float isoAngle = 62.65607f;
    private static final float scale = 0.047085002f;
    public static boolean bLastStand;
    public static String ChallengeID;
    public static boolean bExiting;
    private String m_delayResetLua_activeMods = null;
    private String m_delayResetLua_reason = null;

    public boolean isMultiThread() {
        return true;
    }

    public void setChallenge(boolean bl) {
        this.bChallenge = bl;
    }

    public boolean isChallenge() {
        return this.bChallenge;
    }

    public String getChallengeID() {
        return ChallengeID;
    }

    public boolean getOptionTieredZombieUpdates() {
        return MovingObjectUpdateScheduler.instance.isEnabled();
    }

    public void setOptionTieredZombieUpdates(boolean bl) {
        MovingObjectUpdateScheduler.instance.setEnabled(bl);
    }

    public void setFramerate(int n) {
        PerformanceSettings.setUncappedFPS(n == 1);
        switch (n) {
            case 1: {
                PerformanceSettings.setLockFPS(60);
                break;
            }
            case 2: {
                PerformanceSettings.setLockFPS(244);
                break;
            }
            case 3: {
                PerformanceSettings.setLockFPS(240);
                break;
            }
            case 4: {
                PerformanceSettings.setLockFPS(165);
                break;
            }
            case 5: {
                PerformanceSettings.setLockFPS(120);
                break;
            }
            case 6: {
                PerformanceSettings.setLockFPS(95);
                break;
            }
            case 7: {
                PerformanceSettings.setLockFPS(90);
                break;
            }
            case 8: {
                PerformanceSettings.setLockFPS(75);
                break;
            }
            case 9: {
                PerformanceSettings.setLockFPS(60);
                break;
            }
            case 10: {
                PerformanceSettings.setLockFPS(55);
                break;
            }
            case 11: {
                PerformanceSettings.setLockFPS(45);
                break;
            }
            case 12: {
                PerformanceSettings.setLockFPS(30);
                break;
            }
            case 13: {
                PerformanceSettings.setLockFPS(24);
            }
        }
    }

    public void setMultiThread(boolean bl) {
    }

    public boolean loadedShader() {
        return this.RenderShader != null;
    }

    public static int getGLMajorVersion() {
        if (glMajorVersion == -1) {
            Core.getOpenGLVersions();
        }
        return glMajorVersion;
    }

    public boolean getUseShaders() {
        return true;
    }

    public int getPerfSkybox() {
        return this.iPerfSkybox_new;
    }

    public int getPerfSkyboxOnLoad() {
        return this.iPerfSkybox;
    }

    public void setPerfSkybox(int n) {
        this.iPerfSkybox_new = n;
    }

    public boolean getPerfReflections() {
        return this.bPerfReflections_new;
    }

    public boolean getPerfReflectionsOnLoad() {
        return this.bPerfReflections;
    }

    public void setPerfReflections(boolean bl) {
        this.bPerfReflections_new = bl;
    }

    public int getPerfPuddles() {
        return this.iPerfPuddles_new;
    }

    public int getPerfPuddlesOnLoad() {
        return this.iPerfPuddles;
    }

    public void setPerfPuddles(int n) {
        this.iPerfPuddles_new = n;
    }

    public int getVidMem() {
        if (SafeMode) {
            return 5;
        }
        return this.vidMem;
    }

    public void setVidMem(int n) {
        if (SafeMode) {
            this.vidMem = 5;
        }
        this.vidMem = n;
        try {
            this.saveOptions();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setUseShaders(boolean bl) {
    }

    public void shadersOptionChanged() {
        RenderThread.invokeOnRenderContext(() -> {
            if (!SafeModeForced) {
                try {
                    if (this.RenderShader == null) {
                        this.RenderShader = new WeatherShader("screen");
                    }
                    if (this.RenderShader != null && !this.RenderShader.isCompiled()) {
                        this.RenderShader = null;
                    }
                }
                catch (Exception exception) {
                    this.RenderShader = null;
                }
            } else if (this.RenderShader != null) {
                try {
                    this.RenderShader.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.RenderShader = null;
            }
        });
    }

    public void initShaders() {
        try {
            if (this.RenderShader == null && !SafeMode && !SafeModeForced) {
                RenderThread.invokeOnRenderContext(() -> {
                    this.RenderShader = new WeatherShader("screen");
                });
            }
            if (this.RenderShader == null || !this.RenderShader.isCompiled()) {
                this.RenderShader = null;
            }
        }
        catch (Exception exception) {
            this.RenderShader = null;
            exception.printStackTrace();
        }
        IsoPuddles.getInstance();
        IsoWater.getInstance();
    }

    public static String getGLVersion() {
        if (glVersion == null) {
            Core.getOpenGLVersions();
        }
        return glVersion;
    }

    public String getGameMode() {
        return GameMode;
    }

    public static Core getInstance() {
        return core;
    }

    public static void getOpenGLVersions() {
        glVersion = GL11.glGetString((int)7938);
        glMajorVersion = glVersion.charAt(0) - 48;
    }

    public boolean getDebug() {
        return bDebug;
    }

    public static void setFullScreen(boolean bl) {
        fullScreen = bl;
    }

    public static int[] flipPixels(int[] nArray, int n, int n2) {
        int[] nArray2 = null;
        if (nArray != null) {
            nArray2 = new int[n * n2];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    nArray2[(n2 - i - 1) * n + j] = nArray[i * n + j];
                }
            }
        }
        return nArray2;
    }

    public void TakeScreenshot() {
        this.TakeScreenshot(256, 256, 1028);
    }

    public void TakeScreenshot(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = IsoCamera.getScreenWidth(n4);
        int n6 = IsoCamera.getScreenHeight(n4);
        n = PZMath.min(n, n5);
        n2 = PZMath.min(n2, n6);
        int n7 = IsoCamera.getScreenLeft(n4) + n5 / 2 - n / 2;
        int n8 = IsoCamera.getScreenTop(n4) + n6 / 2 - n2 / 2;
        this.TakeScreenshot(n7, n8, n, n2, n3);
    }

    public void TakeScreenshot(int n, int n2, int n3, int n4, int n5) {
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glReadBuffer((int)n5);
        int n6 = 3;
        ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)(n3 * n4 * n6));
        GL11.glReadPixels((int)n, (int)n2, (int)n3, (int)n4, (int)6407, (int)5121, (ByteBuffer)byteBuffer);
        int[] nArray = new int[n3 * n4];
        File file = ZomboidFileSystem.instance.getFileInCurrentSave("thumb.png");
        String string = "png";
        for (int i = 0; i < nArray.length; ++i) {
            int n7 = i * 3;
            nArray[i] = 0xFF000000 | (byteBuffer.get(n7) & 0xFF) << 16 | (byteBuffer.get(n7 + 1) & 0xFF) << 8 | (byteBuffer.get(n7 + 2) & 0xFF) << 0;
        }
        MemoryUtil.memFree((Buffer)byteBuffer);
        nArray = Core.flipPixels(nArray, n3, n4);
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
        bufferedImage.setRGB(0, 0, n3, n4, nArray, 0, n3);
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Texture.reload(ZomboidFileSystem.instance.getFileNameInCurrentSave("thumb.png"));
    }

    public void TakeFullScreenshot(String string) {
        RenderThread.invokeOnRenderContext(string, object -> {
            Serializable serializable;
            GL11.glPixelStorei((int)3333, (int)1);
            GL11.glReadBuffer((int)1028);
            int n = Display.getDisplayMode().getWidth();
            int n2 = Display.getDisplayMode().getHeight();
            int n3 = 0;
            int n4 = 0;
            int n5 = 3;
            ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)(n * n2 * n5));
            GL11.glReadPixels((int)n3, (int)n4, (int)n, (int)n2, (int)6407, (int)5121, (ByteBuffer)byteBuffer);
            int[] nArray = new int[n * n2];
            if (object == null) {
                serializable = new SimpleDateFormat("dd-MM-yyyy_HH-mm-ss");
                object = "screenshot_" + serializable.format(Calendar.getInstance().getTime()) + ".png";
            }
            serializable = new File(ZomboidFileSystem.instance.getScreenshotDir() + File.separator + (String)object);
            for (int i = 0; i < nArray.length; ++i) {
                int n6 = i * 3;
                nArray[i] = 0xFF000000 | (byteBuffer.get(n6) & 0xFF) << 16 | (byteBuffer.get(n6 + 1) & 0xFF) << 8 | (byteBuffer.get(n6 + 2) & 0xFF) << 0;
            }
            MemoryUtil.memFree((Buffer)byteBuffer);
            nArray = Core.flipPixels(nArray, n, n2);
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
            try {
                ImageIO.write((RenderedImage)bufferedImage, "png", (File)serializable);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        });
    }

    public static boolean supportNPTTexture() {
        return false;
    }

    public boolean supportsFBO() {
        if (SafeMode) {
            this.OffscreenBuffer.bZoomEnabled = false;
            return false;
        }
        if (!this.bSupportsFBO) {
            return false;
        }
        if (this.OffscreenBuffer.Current != null) {
            return true;
        }
        try {
            if (TextureFBO.checkFBOSupport() && this.setupMultiFBO()) {
                return true;
            }
            this.bSupportsFBO = false;
            SafeMode = true;
            this.OffscreenBuffer.bZoomEnabled = false;
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.bSupportsFBO = false;
            SafeMode = true;
            this.OffscreenBuffer.bZoomEnabled = false;
            return false;
        }
    }

    private void sharedInit() {
        this.supportsFBO();
    }

    public void MoveMethodToggle() {
        bAltMoveMethod = !bAltMoveMethod;
    }

    public void EndFrameText(int n) {
        if (LuaManager.thread.bStep) {
            return;
        }
        if (this.OffscreenBuffer.Current != null) {
            // empty if block
        }
        IndieGL.glDoEndFrame();
        this.frameStage = 2;
    }

    public void EndFrame(int n) {
        if (LuaManager.thread.bStep) {
            return;
        }
        if (this.OffscreenBuffer.Current != null) {
            SpriteRenderer.instance.glBuffer(0, n);
        }
        IndieGL.glDoEndFrame();
        this.frameStage = 2;
    }

    public void EndFrame() {
        IndieGL.glDoEndFrame();
        if (this.OffscreenBuffer.Current != null) {
            SpriteRenderer.instance.glBuffer(0, 0);
        }
    }

    public void EndFrameUI() {
        if (!blinkAlphaIncrease) {
            if ((blinkAlpha -= 0.07f * (GameTime.getInstance().getMultiplier() / 1.6f)) < 0.15f) {
                blinkAlpha = 0.15f;
                blinkAlphaIncrease = true;
            }
        } else if ((blinkAlpha += 0.07f * (GameTime.getInstance().getMultiplier() / 1.6f)) > 1.0f) {
            blinkAlpha = 1.0f;
            blinkAlphaIncrease = false;
        }
        if (UIManager.useUIFBO && UIManager.UIFBO == null) {
            UIManager.CreateFBO(width, height);
        }
        if (LuaManager.thread != null && LuaManager.thread.bStep) {
            SpriteRenderer.instance.clearSprites();
            return;
        }
        ExceptionLogger.render();
        if (UIManager.useUIFBO && this.UIRenderThisFrame) {
            SpriteRenderer.instance.glBuffer(3, 0);
            IndieGL.glDoEndFrame();
            SpriteRenderer.instance.stopOffscreenUI();
            IndieGL.glDoStartFrame(width, height, 1.0f, -1);
            float f = (float)((int)(1.0f / (float)OptionUIRenderFPS * 100.0f)) / 100.0f;
            int n = (int)(this.UIRenderAccumulator / f);
            this.UIRenderAccumulator -= (float)n * f;
            if (FPSGraph.instance != null) {
                FPSGraph.instance.addUI(System.currentTimeMillis());
            }
        }
        if (UIManager.useUIFBO) {
            SpriteRenderer.instance.setDoAdditive(true);
            SpriteRenderer.instance.renderi((Texture)UIManager.UIFBO.getTexture(), 0, height, width, -height, 1.0f, 1.0f, 1.0f, 1.0f, null);
            SpriteRenderer.instance.setDoAdditive(false);
        }
        if (Core.getInstance().getOptionLockCursorToWindow()) {
            Mouse.renderCursorTexture();
        }
        IndieGL.glDoEndFrame();
        RenderThread.Ready();
        this.frameStage = 0;
    }

    public static void UnfocusActiveTextEntryBox() {
        if (CurrentTextEntryBox != null && !CurrentTextEntryBox.getUIName().contains("chat text entry")) {
            Core.CurrentTextEntryBox.DoingTextEntry = false;
            if (Core.CurrentTextEntryBox.Frame != null) {
                Core.CurrentTextEntryBox.Frame.Colour = Core.CurrentTextEntryBox.StandardFrameColour;
            }
            CurrentTextEntryBox = null;
        }
    }

    public int getOffscreenWidth(int n) {
        if (this.OffscreenBuffer == null) {
            if (IsoPlayer.numPlayers > 1) {
                return this.getScreenWidth() / 2;
            }
            return this.getScreenWidth();
        }
        return this.OffscreenBuffer.getWidth(n);
    }

    public int getOffscreenHeight(int n) {
        if (this.OffscreenBuffer == null) {
            if (IsoPlayer.numPlayers > 2) {
                return this.getScreenHeight() / 2;
            }
            return this.getScreenHeight();
        }
        return this.OffscreenBuffer.getHeight(n);
    }

    public int getOffscreenTrueWidth() {
        if (this.OffscreenBuffer == null || this.OffscreenBuffer.Current == null) {
            return this.getScreenWidth();
        }
        return this.OffscreenBuffer.getTexture(0).getWidth();
    }

    public int getOffscreenTrueHeight() {
        if (this.OffscreenBuffer == null || this.OffscreenBuffer.Current == null) {
            return this.getScreenHeight();
        }
        return this.OffscreenBuffer.getTexture(0).getHeight();
    }

    public int getScreenHeight() {
        return height;
    }

    public int getScreenWidth() {
        return width;
    }

    public void setResolutionAndFullScreen(int n, int n2, boolean bl) {
        Core.setDisplayMode(n, n2, bl);
        this.setScreenSize(Display.getWidth(), Display.getHeight());
    }

    public void setResolution(String string) {
        String[] stringArray = string.split("x");
        int n = Integer.parseInt(stringArray[0].trim());
        int n2 = Integer.parseInt(stringArray[1].trim());
        if (fullScreen) {
            Core.setDisplayMode(n, n2, true);
        } else {
            Core.setDisplayMode(n, n2, false);
        }
        this.setScreenSize(Display.getWidth(), Display.getHeight());
        try {
            this.saveOptions();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean loadOptions() throws IOException {
        block144: {
            this.bLoadedOptions = false;
            var1_1 = new File(ZomboidFileSystem.instance.getCacheDir() + File.separator + "options.ini");
            if (!var1_1.exists()) {
                this.saveFolder = Core.getMyDocumentFolder();
                var2_2 = new File(this.saveFolder);
                var2_2.mkdir();
                this.copyPasteFolders("mods");
                this.setOptionLanguageName(System.getProperty("user.language").toUpperCase());
                if (Translator.getAzertyMap().contains(Translator.getLanguage().name())) {
                    this.setAzerty(true);
                }
                if (!GameServer.bServer) {
                    try {
                        var4_5 = 0;
                        var5_7 = 0;
                        var3_15 = Display.getAvailableDisplayModes();
                        var6_19 = new int[1];
                        var7_27 = new int[1];
                        var8_34 = new int[1];
                        var9_37 = new int[1];
                        GLFW.glfwGetMonitorWorkarea((long)GLFW.glfwGetPrimaryMonitor(), (int[])var6_19, (int[])var7_27, (int[])var8_34, (int[])var9_37);
                        for (var10_39 = 0; var10_39 < var3_15.length; ++var10_39) {
                            if (var3_15[var10_39].getWidth() <= var4_5 || var3_15[var10_39].getWidth() >= var8_34[0] || var3_15[var10_39].getHeight() >= var9_37[0]) continue;
                            var4_5 = var3_15[var10_39].getWidth();
                            var5_7 = var3_15[var10_39].getHeight();
                        }
                        Core.width = var4_5;
                        Core.height = var5_7;
                    }
                    catch (LWJGLException var3_16) {
                        var3_16.printStackTrace();
                    }
                }
                this.setOptionZoomLevels2x("50;75;125;150;175;200");
                this.setOptionZoomLevels1x("50;75;125;150;175;200");
                this.saveOptions();
                return false;
            }
            this.bLoadedOptions = true;
            for (var2_3 = 0; var2_3 < 4; ++var2_3) {
                this.setAutoZoom(var2_3, false);
            }
            Core.OptionLanguageName = null;
            var2_4 = new BufferedReader(new FileReader(var1_1));
lbl42:
            // 2 sources

            try {
                while ((var3_17 = var2_4.readLine()) != null) {
                    block145: {
                        if (var3_17.startsWith("version=")) {
                            this.version = new Integer(var3_17.replaceFirst("version=", ""));
                            continue;
                        }
                        if (var3_17.startsWith("width=")) {
                            Core.width = new Integer(var3_17.replaceFirst("width=", ""));
                            continue;
                        }
                        if (var3_17.startsWith("height=")) {
                            Core.height = new Integer(var3_17.replaceFirst("height=", ""));
                            continue;
                        }
                        if (var3_17.startsWith("fullScreen=")) {
                            Core.fullScreen = Boolean.parseBoolean(var3_17.replaceFirst("fullScreen=", ""));
                            continue;
                        }
                        if (var3_17.startsWith("frameRate=")) {
                            PerformanceSettings.setLockFPS(Integer.parseInt(var3_17.replaceFirst("frameRate=", "")));
                            continue;
                        }
                        if (var3_17.startsWith("uncappedFPS=")) {
                            PerformanceSettings.setUncappedFPS(Boolean.parseBoolean(var3_17.replaceFirst("uncappedFPS=", "")));
                            continue;
                        }
                        if (var3_17.startsWith("iso_cursor=")) {
                            Core.getInstance().setIsoCursorVisibility(Integer.parseInt(var3_17.replaceFirst("iso_cursor=", "")));
                            continue;
                        }
                        if (var3_17.startsWith("showCursorWhileAiming=")) {
                            Core.OptionShowCursorWhileAiming = Boolean.parseBoolean(var3_17.replaceFirst("showCursorWhileAiming=", ""));
                            continue;
                        }
                        if (var3_17.startsWith("water=")) {
                            PerformanceSettings.WaterQuality = Integer.parseInt(var3_17.replaceFirst("water=", ""));
                            continue;
                        }
                        if (var3_17.startsWith("puddles=")) {
                            PerformanceSettings.PuddlesQuality = Integer.parseInt(var3_17.replaceFirst("puddles=", ""));
                            continue;
                        }
                        if (var3_17.startsWith("lighting=")) {
                            PerformanceSettings.LightingFrameSkip = Integer.parseInt(var3_17.replaceFirst("lighting=", ""));
                            continue;
                        }
                        if (var3_17.startsWith("lightFPS=")) {
                            PerformanceSettings.instance.setLightingFPS(Integer.parseInt(var3_17.replaceFirst("lightFPS=", "")));
                            continue;
                        }
                        if (var3_17.startsWith("perfSkybox=")) {
                            this.iPerfSkybox_new = this.iPerfSkybox = Integer.parseInt(var3_17.replaceFirst("perfSkybox=", ""));
                            continue;
                        }
                        if (var3_17.startsWith("perfPuddles=")) {
                            this.iPerfPuddles_new = this.iPerfPuddles = Integer.parseInt(var3_17.replaceFirst("perfPuddles=", ""));
                            continue;
                        }
                        if (var3_17.startsWith("bPerfReflections=")) {
                            this.bPerfReflections_new = this.bPerfReflections = Boolean.parseBoolean(var3_17.replaceFirst("bPerfReflections=", ""));
                            continue;
                        }
                        if (var3_17.startsWith("language=")) {
                            Core.OptionLanguageName = var3_17.replaceFirst("language=", "").trim();
                            continue;
                        }
                        if (var3_17.startsWith("zoom=")) {
                            Core.OptionZoom = Boolean.parseBoolean(var3_17.replaceFirst("zoom=", ""));
                            continue;
                        }
                        if (!var3_17.startsWith("autozoom=")) break block145;
                        var4_6 = var3_17.replaceFirst("autozoom=", "").split(",");
                        for (var5_8 = 0; var5_8 < ((String[])var4_6).length; ++var5_8) {
                            if (var4_6[var5_8].isEmpty() || (var6_20 = Integer.parseInt(var4_6[var5_8])) < 1 || var6_20 > 4) continue;
                            this.setAutoZoom(var6_20 - 1, true);
                        }
                        ** GOTO lbl42
                    }
                    if (var3_17.startsWith("fontSize=")) {
                        this.setOptionFontSize(Integer.parseInt(var3_17.replaceFirst("fontSize=", "").trim()));
                        continue;
                    }
                    if (var3_17.startsWith("contextMenuFont=")) {
                        Core.OptionContextMenuFont = var3_17.replaceFirst("contextMenuFont=", "").trim();
                        continue;
                    }
                    if (var3_17.startsWith("inventoryFont=")) {
                        Core.OptionInventoryFont = var3_17.replaceFirst("inventoryFont=", "").trim();
                        continue;
                    }
                    if (var3_17.startsWith("inventoryContainerSize=")) {
                        Core.OptionInventoryContainerSize = PZMath.tryParseInt(var3_17.replaceFirst("inventoryContainerSize=", ""), 1);
                        Core.OptionInventoryContainerSize = PZMath.clamp(Core.OptionInventoryContainerSize, 1, 3);
                        continue;
                    }
                    if (var3_17.startsWith("tooltipFont=")) {
                        Core.OptionTooltipFont = var3_17.replaceFirst("tooltipFont=", "").trim();
                        continue;
                    }
                    if (var3_17.startsWith("measurementsFormat=")) {
                        Core.OptionMeasurementFormat = var3_17.replaceFirst("measurementsFormat=", "").trim();
                        continue;
                    }
                    if (var3_17.startsWith("clockFormat=")) {
                        Core.OptionClockFormat = Integer.parseInt(var3_17.replaceFirst("clockFormat=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("clockSize=")) {
                        Core.OptionClockSize = Integer.parseInt(var3_17.replaceFirst("clockSize=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("clock24Hour=")) {
                        Core.OptionClock24Hour = Boolean.parseBoolean(var3_17.replaceFirst("clock24Hour=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("vsync=")) {
                        Core.OptionVSync = Boolean.parseBoolean(var3_17.replaceFirst("vsync=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("voiceEnable=")) {
                        Core.OptionVoiceEnable = Boolean.parseBoolean(var3_17.replaceFirst("voiceEnable=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("voiceMode=")) {
                        Core.OptionVoiceMode = Integer.parseInt(var3_17.replaceFirst("voiceMode=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("voiceVADMode=")) {
                        Core.OptionVoiceVADMode = Integer.parseInt(var3_17.replaceFirst("voiceVADMode=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("voiceAGCMode=")) {
                        Core.OptionVoiceAGCMode = Integer.parseInt(var3_17.replaceFirst("voiceAGCMode=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("voiceVolumeMic=")) {
                        Core.OptionVoiceVolumeMic = Integer.parseInt(var3_17.replaceFirst("voiceVolumeMic=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("voiceVolumePlayers=")) {
                        Core.OptionVoiceVolumePlayers = Integer.parseInt(var3_17.replaceFirst("voiceVolumePlayers=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("voiceRecordDeviceName=")) {
                        Core.OptionVoiceRecordDeviceName = var3_17.replaceFirst("voiceRecordDeviceName=", "");
                        continue;
                    }
                    if (var3_17.startsWith("soundVolume=")) {
                        Core.OptionSoundVolume = Integer.parseInt(var3_17.replaceFirst("soundVolume=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("musicVolume=")) {
                        Core.OptionMusicVolume = Integer.parseInt(var3_17.replaceFirst("musicVolume=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("ambientVolume=")) {
                        Core.OptionAmbientVolume = Integer.parseInt(var3_17.replaceFirst("ambientVolume=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("jumpScareVolume=")) {
                        Core.OptionJumpScareVolume = Integer.parseInt(var3_17.replaceFirst("jumpScareVolume=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("musicActionStyle=")) {
                        Core.OptionMusicActionStyle = Integer.parseInt(var3_17.replaceFirst("musicActionStyle=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("musicLibrary=")) {
                        Core.OptionMusicLibrary = Integer.parseInt(var3_17.replaceFirst("musicLibrary=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("vehicleEngineVolume=")) {
                        Core.OptionVehicleEngineVolume = Integer.parseInt(var3_17.replaceFirst("vehicleEngineVolume=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("reloadDifficulty=")) {
                        Core.OptionReloadDifficulty = Integer.parseInt(var3_17.replaceFirst("reloadDifficulty=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("rackProgress=")) {
                        Core.OptionRackProgress = Boolean.parseBoolean(var3_17.replaceFirst("rackProgress=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("controller=")) {
                        var4_6 = var3_17.replaceFirst("controller=", "");
                        if (var4_6.isEmpty()) continue;
                        JoypadManager.instance.setControllerActive((String)var4_6, true);
                        continue;
                    }
                    if (var3_17.startsWith("tutorialDone=")) {
                        this.tutorialDone = Boolean.parseBoolean(var3_17.replaceFirst("tutorialDone=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("vehiclesWarningShow=")) {
                        this.vehiclesWarningShow = Boolean.parseBoolean(var3_17.replaceFirst("vehiclesWarningShow=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("bloodDecals=")) {
                        this.setOptionBloodDecals(Integer.parseInt(var3_17.replaceFirst("bloodDecals=", "")));
                        continue;
                    }
                    if (var3_17.startsWith("borderless=")) {
                        Core.OptionBorderlessWindow = Boolean.parseBoolean(var3_17.replaceFirst("borderless=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("lockCursorToWindow=")) {
                        Core.OptionLockCursorToWindow = Boolean.parseBoolean(var3_17.replaceFirst("lockCursorToWindow=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("textureCompression=")) {
                        Core.OptionTextureCompression = Boolean.parseBoolean(var3_17.replaceFirst("textureCompression=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("modelTextureMipmaps=")) {
                        Core.OptionModelTextureMipmaps = Boolean.parseBoolean(var3_17.replaceFirst("modelTextureMipmaps=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("texture2x=")) {
                        Core.OptionTexture2x = Boolean.parseBoolean(var3_17.replaceFirst("texture2x=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("maxTextureSize=")) {
                        Core.OptionMaxTextureSize = Integer.parseInt(var3_17.replaceFirst("maxTextureSize=", ""));
                        Core.OptionMaxTextureSize = PZMath.clamp(Core.OptionMaxTextureSize, 1, 4);
                        continue;
                    }
                    if (var3_17.startsWith("maxVehicleTextureSize=")) {
                        Core.OptionMaxVehicleTextureSize = Integer.parseInt(var3_17.replaceFirst("maxVehicleTextureSize=", ""));
                        Core.OptionMaxVehicleTextureSize = PZMath.clamp(Core.OptionMaxVehicleTextureSize, 1, 4);
                        continue;
                    }
                    if (var3_17.startsWith("zoomLevels1x=")) {
                        Core.OptionZoomLevels1x = var3_17.replaceFirst("zoomLevels1x=", "");
                        continue;
                    }
                    if (var3_17.startsWith("zoomLevels2x=")) {
                        Core.OptionZoomLevels2x = var3_17.replaceFirst("zoomLevels2x=", "");
                        continue;
                    }
                    if (var3_17.startsWith("showChatTimestamp=")) {
                        Core.OptionShowChatTimestamp = Boolean.parseBoolean(var3_17.replaceFirst("showChatTimestamp=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("showChatTitle=")) {
                        Core.OptionShowChatTitle = Boolean.parseBoolean(var3_17.replaceFirst("showChatTitle=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("chatFontSize=")) {
                        Core.OptionChatFontSize = var3_17.replaceFirst("chatFontSize=", "");
                        continue;
                    }
                    if (var3_17.startsWith("minChatOpaque=")) {
                        Core.OptionMinChatOpaque = Float.parseFloat(var3_17.replaceFirst("minChatOpaque=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("maxChatOpaque=")) {
                        Core.OptionMaxChatOpaque = Float.parseFloat(var3_17.replaceFirst("maxChatOpaque=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("chatFadeTime=")) {
                        Core.OptionChatFadeTime = Float.parseFloat(var3_17.replaceFirst("chatFadeTime=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("chatOpaqueOnFocus=")) {
                        Core.OptionChatOpaqueOnFocus = Boolean.parseBoolean(var3_17.replaceFirst("chatOpaqueOnFocus=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("doneNewSaveFolder=")) {
                        this.doneNewSaveFolder = Boolean.parseBoolean(var3_17.replaceFirst("doneNewSaveFolder=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("contentTranslationsEnabled=")) {
                        Core.OptionEnableContentTranslations = Boolean.parseBoolean(var3_17.replaceFirst("contentTranslationsEnabled=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("showYourUsername=")) {
                        this.showYourUsername = Boolean.parseBoolean(var3_17.replaceFirst("showYourUsername=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("riversideDone=")) {
                        this.riversideDone = Boolean.parseBoolean(var3_17.replaceFirst("riversideDone=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("rosewoodSpawnDone=")) {
                        this.rosewoodSpawnDone = Boolean.parseBoolean(var3_17.replaceFirst("rosewoodSpawnDone=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("gotNewBelt=")) {
                        this.gotNewBelt = Boolean.parseBoolean(var3_17.replaceFirst("gotNewBelt=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("mpTextColor=")) {
                        var4_6 = var3_17.replaceFirst("mpTextColor=", "").split(",");
                        var5_9 = Float.parseFloat((String)var4_6[0]);
                        var6_21 = Float.parseFloat((String)var4_6[1]);
                        var7_28 = Float.parseFloat((String)var4_6[2]);
                        if (var5_9 < 0.19f) {
                            var5_9 = 0.19f;
                        }
                        if (var6_21 < 0.19f) {
                            var6_21 = 0.19f;
                        }
                        if (var7_28 < 0.19f) {
                            var7_28 = 0.19f;
                        }
                        this.mpTextColor = new ColorInfo(var5_9, var6_21, var7_28, 1.0f);
                        continue;
                    }
                    if (var3_17.startsWith("objHighlightColor=")) {
                        var4_6 = var3_17.replaceFirst("objHighlightColor=", "").split(",");
                        var5_10 = Float.parseFloat((String)var4_6[0]);
                        var6_22 = Float.parseFloat((String)var4_6[1]);
                        var7_29 = Float.parseFloat((String)var4_6[2]);
                        if (var5_10 < 0.19f) {
                            var5_10 = 0.19f;
                        }
                        if (var6_22 < 0.19f) {
                            var6_22 = 0.19f;
                        }
                        if (var7_29 < 0.19f) {
                            var7_29 = 0.19f;
                        }
                        this.objectHighlitedColor.set(var5_10, var6_22, var7_29, 1.0f);
                        continue;
                    }
                    if (var3_17.startsWith("goodHighlightColor=")) {
                        var4_6 = var3_17.replaceFirst("goodHighlightColor=", "").split(",");
                        var5_11 = Float.parseFloat((String)var4_6[0]);
                        var6_23 = Float.parseFloat((String)var4_6[1]);
                        var7_30 = Float.parseFloat((String)var4_6[2]);
                        this.goodHighlitedColor.set(var5_11, var6_23, var7_30, 1.0f);
                        continue;
                    }
                    if (var3_17.startsWith("badHighlightColor=")) {
                        var4_6 = var3_17.replaceFirst("badHighlightColor=", "").split(",");
                        var5_12 = Float.parseFloat((String)var4_6[0]);
                        var6_24 = Float.parseFloat((String)var4_6[1]);
                        var7_31 = Float.parseFloat((String)var4_6[2]);
                        this.badHighlitedColor.set(var5_12, var6_24, var7_31, 1.0f);
                        continue;
                    }
                    if (var3_17.startsWith("seenNews=")) {
                        this.setSeenUpdateText(var3_17.replaceFirst("seenNews=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("toggleToAim=")) {
                        this.setToggleToAim(Boolean.parseBoolean(var3_17.replaceFirst("toggleToAim=", "")));
                        continue;
                    }
                    if (var3_17.startsWith("toggleToRun=")) {
                        this.setToggleToRun(Boolean.parseBoolean(var3_17.replaceFirst("toggleToRun=", "")));
                        continue;
                    }
                    if (var3_17.startsWith("toggleToSprint=")) {
                        this.setToggleToSprint(Boolean.parseBoolean(var3_17.replaceFirst("toggleToSprint=", "")));
                        continue;
                    }
                    if (var3_17.startsWith("celsius=")) {
                        this.setCelsius(Boolean.parseBoolean(var3_17.replaceFirst("celsius=", "")));
                        continue;
                    }
                    if (var3_17.startsWith("mapOrder=")) {
                        if (this.version < 7) {
                            var3_17 = "mapOrder=";
                        }
                        for (Object var8_35 : var4_6 = var3_17.replaceFirst("mapOrder=", "").split(";")) {
                            if ((var8_35 = var8_35.trim()).isEmpty()) continue;
                            ActiveMods.getById("default").getMapOrder().add((String)var8_35);
                        }
                        ZomboidFileSystem.instance.saveModsFile();
                        continue;
                    }
                    if (var3_17.startsWith("showFirstTimeSneakTutorial=")) {
                        this.setShowFirstTimeSneakTutorial(Boolean.parseBoolean(var3_17.replaceFirst("showFirstTimeSneakTutorial=", "")));
                        continue;
                    }
                    if (var3_17.startsWith("showFirstTimeSearchTutorial=")) {
                        this.setShowFirstTimeSearchTutorial(Boolean.parseBoolean(var3_17.replaceFirst("showFirstTimeSearchTutorial=", "")));
                        continue;
                    }
                    if (var3_17.startsWith("termsOfServiceVersion=")) {
                        this.termsOfServiceVersion = Integer.parseInt(var3_17.replaceFirst("termsOfServiceVersion=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("uiRenderOffscreen=")) {
                        Core.OptionUIFBO = Boolean.parseBoolean(var3_17.replaceFirst("uiRenderOffscreen=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("uiRenderFPS=")) {
                        Core.OptionUIRenderFPS = Integer.parseInt(var3_17.replaceFirst("uiRenderFPS=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("radialMenuKeyToggle=")) {
                        Core.OptionRadialMenuKeyToggle = Boolean.parseBoolean(var3_17.replaceFirst("radialMenuKeyToggle=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("reloadRadialInstant=")) {
                        Core.OptionReloadRadialInstant = Boolean.parseBoolean(var3_17.replaceFirst("reloadRadialInstant=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("panCameraWhileAiming=")) {
                        Core.OptionPanCameraWhileAiming = Boolean.parseBoolean(var3_17.replaceFirst("panCameraWhileAiming=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("panCameraWhileDriving=")) {
                        Core.OptionPanCameraWhileDriving = Boolean.parseBoolean(var3_17.replaceFirst("panCameraWhileDriving=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("temperatureDisplayCelsius=")) {
                        Core.OptionTemperatureDisplayCelsius = Boolean.parseBoolean(var3_17.replaceFirst("temperatureDisplayCelsius=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("doWindSpriteEffects=")) {
                        Core.OptionDoWindSpriteEffects = Boolean.parseBoolean(var3_17.replaceFirst("doWindSpriteEffects=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("doDoorSpriteEffects=")) {
                        Core.OptionDoDoorSpriteEffects = Boolean.parseBoolean(var3_17.replaceFirst("doDoorSpriteEffects=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("doContainerOutline=")) {
                        Core.OptionDoContainerOutline = Boolean.parseBoolean(var3_17.replaceFirst("doContainerOutline=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("updateSneakButton2=")) {
                        Core.OptionUpdateSneakButton = true;
                        continue;
                    }
                    if (var3_17.startsWith("updateSneakButton=")) {
                        Core.OptionUpdateSneakButton = Boolean.parseBoolean(var3_17.replaceFirst("updateSneakButton=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("dblTapJogToSprint=")) {
                        Core.OptiondblTapJogToSprint = Boolean.parseBoolean(var3_17.replaceFirst("dblTapJogToSprint=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("aimOutline=")) {
                        this.setOptionAimOutline(PZMath.tryParseInt(var3_17.replaceFirst("aimOutline=", ""), 2));
                        continue;
                    }
                    if (var3_17.startsWith("cycleContainerKey=")) {
                        Core.OptionCycleContainerKey = var3_17.replaceFirst("cycleContainerKey=", "");
                        continue;
                    }
                    if (var3_17.startsWith("dropItemsOnSquareCenter=")) {
                        Core.OptionDropItemsOnSquareCenter = Boolean.parseBoolean(var3_17.replaceFirst("dropItemsOnSquareCenter=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("timedActionGameSpeedReset=")) {
                        Core.OptionTimedActionGameSpeedReset = Boolean.parseBoolean(var3_17.replaceFirst("timedActionGameSpeedReset=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("shoulderButtonContainerSwitch=")) {
                        Core.OptionShoulderButtonContainerSwitch = Integer.parseInt(var3_17.replaceFirst("shoulderButtonContainerSwitch=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("singleContextMenu=")) {
                        this.readPerPlayerBoolean(var3_17.replaceFirst("singleContextMenu=", ""), Core.OptionSingleContextMenu);
                        continue;
                    }
                    if (var3_17.startsWith("renderPrecipIndoors=")) {
                        Core.OptionRenderPrecipIndoors = Boolean.parseBoolean(var3_17.replaceFirst("renderPrecipIndoors=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("autoProneAtk=")) {
                        Core.OptionAutoProneAtk = Boolean.parseBoolean(var3_17.replaceFirst("autoProneAtk=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("3DGroundItem=")) {
                        Core.Option3DGroundItem = Boolean.parseBoolean(var3_17.replaceFirst("3DGroundItem=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("tieredZombieUpdates=")) {
                        this.setOptionTieredZombieUpdates(Boolean.parseBoolean(var3_17.replaceFirst("tieredZombieUpdates=", "")));
                        continue;
                    }
                    if (var3_17.startsWith("progressBar=")) {
                        this.setOptionProgressBar(Boolean.parseBoolean(var3_17.replaceFirst("progressBar=", "")));
                        continue;
                    }
                    if (var3_17.startsWith("corpseShadows=")) {
                        Core.OptionCorpseShadows = Boolean.parseBoolean(var3_17.replaceFirst("corpseShadows=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("simpleClothingTextures=")) {
                        this.setOptionSimpleClothingTextures(PZMath.tryParseInt(var3_17.replaceFirst("simpleClothingTextures=", ""), 1));
                        continue;
                    }
                    if (var3_17.startsWith("simpleWeaponTextures=")) {
                        Core.OptionSimpleWeaponTextures = Boolean.parseBoolean(var3_17.replaceFirst("simpleWeaponTextures=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("autoDrink=")) {
                        Core.OptionAutoDrink = Boolean.parseBoolean(var3_17.replaceFirst("autoDrink=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("leaveKeyInIgnition=")) {
                        Core.OptionLeaveKeyInIgnition = Boolean.parseBoolean(var3_17.replaceFirst("leaveKeyInIgnition=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("autoWalkContainer=")) {
                        Core.OptionAutoWalkContainer = Boolean.parseBoolean(var3_17.replaceFirst("autoWalkContainer=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("searchModeOverlayEffect=")) {
                        Core.OptionSearchModeOverlayEffect = Integer.parseInt(var3_17.replaceFirst("searchModeOverlayEffect=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("ignoreProneZombieRange=")) {
                        this.setOptionIgnoreProneZombieRange(PZMath.tryParseInt(var3_17.replaceFirst("ignoreProneZombieRange=", ""), 1));
                        continue;
                    }
                    if (var3_17.startsWith("fogQuality=")) {
                        PerformanceSettings.FogQuality = Integer.parseInt(var3_17.replaceFirst("fogQuality=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("renderPrecipitation=")) {
                        Core.OptionRenderPrecipitation = Integer.parseInt(var3_17.replaceFirst("renderPrecipitation=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("showItemModInfo=")) {
                        Core.OptionShowItemModInfo = Boolean.parseBoolean(var3_17.replaceFirst("showItemModInfo=", ""));
                        continue;
                    }
                    if (var3_17.startsWith("showSurvivalGuide=")) {
                        this.OptionShowSurvivalGuide = Boolean.parseBoolean(var3_17.replaceFirst("showSurvivalGuide=", ""));
                        continue;
                    }
                    if (!var3_17.startsWith("enableLeftJoystickRadialMenu=")) continue;
                    Core.OptionEnableLeftJoystickRadialMenu = Boolean.parseBoolean(var3_17.replaceFirst("enableLeftJoystickRadialMenu=", ""));
                }
                if (Core.OptionLanguageName == null) {
                    Core.OptionLanguageName = System.getProperty("user.language").toUpperCase();
                }
                if (this.doneNewSaveFolder) break block144;
                var4_6 = new File(ZomboidFileSystem.instance.getSaveDir());
                var4_6.mkdir();
                var5_14 = new ArrayList<String>();
                var5_14.add("Beginner");
                var5_14.add("Survival");
                var5_14.add("A Really CD DA");
                var5_14.add("LastStand");
                var5_14.add("Opening Hours");
                var5_14.add("Sandbox");
                var5_14.add("Tutorial");
                var5_14.add("Winter is Coming");
                var5_14.add("You Have One Day");
                var6_26 = null;
                var7_33 = null;
                try {
                    for (String var9_38 : var5_14) {
                        var6_26 = new File(ZomboidFileSystem.instance.getCacheDir() + File.separator + var9_38);
                        var7_33 = new File(ZomboidFileSystem.instance.getSaveDir() + File.separator + var9_38);
                        if (!var6_26.exists()) continue;
                        var7_33.mkdir();
                        Files.move(var6_26.toPath(), var7_33.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    }
                }
                catch (Exception var8_36) {
                    // empty catch block
                }
                this.doneNewSaveFolder = true;
            }
            catch (Exception var3_18) {
                var3_18.printStackTrace();
            }
            finally {
                var2_4.close();
            }
        }
        this.saveOptions();
        return true;
    }

    public boolean isDefaultOptions() {
        return !this.bLoadedOptions;
    }

    public boolean isDedicated() {
        return GameServer.bServer;
    }

    private void copyPasteFolders(String string) {
        File file = new File(string).getAbsoluteFile();
        if (file.exists()) {
            this.searchFolders(file, string);
        }
    }

    private void searchFolders(File file, String string) {
        if (file.isDirectory()) {
            File file2 = new File(this.saveFolder + File.separator + string);
            file2.mkdir();
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.searchFolders(new File(file.getAbsolutePath() + File.separator + stringArray[i]), string + File.separator + stringArray[i]);
            }
        } else {
            this.copyPasteFile(file, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPasteFile(File file, String string) {
        FileOutputStream fileOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            File file2 = new File(this.saveFolder + File.separator + string);
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileInputStream = new FileInputStream(file);
            fileOutputStream.getChannel().transferFrom(fileInputStream.getChannel(), 0L, file.length());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static String getMyDocumentFolder() {
        return ZomboidFileSystem.instance.getCacheDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOptions() throws IOException {
        File file = new File(ZomboidFileSystem.instance.getCacheDir() + File.separator + "options.ini");
        if (!file.exists()) {
            file.createNewFile();
        }
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write("version=" + this.fileversion + "\r\n");
            fileWriter.write("width=" + this.getScreenWidth() + "\r\n");
            fileWriter.write("height=" + this.getScreenHeight() + "\r\n");
            fileWriter.write("fullScreen=" + fullScreen + "\r\n");
            fileWriter.write("frameRate=" + PerformanceSettings.getLockFPS() + "\r\n");
            fileWriter.write("uncappedFPS=" + PerformanceSettings.isUncappedFPS() + "\r\n");
            fileWriter.write("iso_cursor=" + Core.getInstance().getIsoCursorVisibility() + "\r\n");
            fileWriter.write("showCursorWhileAiming=" + OptionShowCursorWhileAiming + "\r\n");
            fileWriter.write("water=" + PerformanceSettings.WaterQuality + "\r\n");
            fileWriter.write("puddles=" + PerformanceSettings.PuddlesQuality + "\r\n");
            fileWriter.write("lighting=" + PerformanceSettings.LightingFrameSkip + "\r\n");
            fileWriter.write("lightFPS=" + PerformanceSettings.LightingFPS + "\r\n");
            fileWriter.write("perfSkybox=" + this.iPerfSkybox_new + "\r\n");
            fileWriter.write("perfPuddles=" + this.iPerfPuddles_new + "\r\n");
            fileWriter.write("bPerfReflections=" + this.bPerfReflections_new + "\r\n");
            fileWriter.write("vidMem=" + this.vidMem + "\r\n");
            fileWriter.write("language=" + this.getOptionLanguageName() + "\r\n");
            fileWriter.write("zoom=" + OptionZoom + "\r\n");
            fileWriter.write("fontSize=" + OptionFontSize + "\r\n");
            fileWriter.write("contextMenuFont=" + OptionContextMenuFont + "\r\n");
            fileWriter.write("inventoryFont=" + OptionInventoryFont + "\r\n");
            fileWriter.write("inventoryContainerSize=" + OptionInventoryContainerSize + "\r\n");
            fileWriter.write("tooltipFont=" + OptionTooltipFont + "\r\n");
            fileWriter.write("clockFormat=" + OptionClockFormat + "\r\n");
            fileWriter.write("clockSize=" + OptionClockSize + "\r\n");
            fileWriter.write("clock24Hour=" + OptionClock24Hour + "\r\n");
            fileWriter.write("measurementsFormat=" + OptionMeasurementFormat + "\r\n");
            Object object = "";
            for (int i = 0; i < 4; ++i) {
                if (!bAutoZoom[i]) continue;
                if (!((String)object).isEmpty()) {
                    object = (String)object + ",";
                }
                object = (String)object + (i + 1);
            }
            fileWriter.write("autozoom=" + (String)object + "\r\n");
            fileWriter.write("vsync=" + OptionVSync + "\r\n");
            fileWriter.write("soundVolume=" + OptionSoundVolume + "\r\n");
            fileWriter.write("ambientVolume=" + OptionAmbientVolume + "\r\n");
            fileWriter.write("musicVolume=" + OptionMusicVolume + "\r\n");
            fileWriter.write("jumpScareVolume=" + OptionJumpScareVolume + "\r\n");
            fileWriter.write("musicActionStyle=" + OptionMusicActionStyle + "\r\n");
            fileWriter.write("musicLibrary=" + OptionMusicLibrary + "\r\n");
            fileWriter.write("vehicleEngineVolume=" + OptionVehicleEngineVolume + "\r\n");
            fileWriter.write("voiceEnable=" + OptionVoiceEnable + "\r\n");
            fileWriter.write("voiceMode=" + OptionVoiceMode + "\r\n");
            fileWriter.write("voiceVADMode=" + OptionVoiceVADMode + "\r\n");
            fileWriter.write("voiceAGCMode=" + OptionVoiceAGCMode + "\r\n");
            fileWriter.write("voiceVolumeMic=" + OptionVoiceVolumeMic + "\r\n");
            fileWriter.write("voiceVolumePlayers=" + OptionVoiceVolumePlayers + "\r\n");
            fileWriter.write("voiceRecordDeviceName=" + OptionVoiceRecordDeviceName + "\r\n");
            fileWriter.write("reloadDifficulty=" + OptionReloadDifficulty + "\r\n");
            fileWriter.write("rackProgress=" + OptionRackProgress + "\r\n");
            for (String string : JoypadManager.instance.ActiveControllerGUIDs) {
                fileWriter.write("controller=" + string + "\r\n");
            }
            fileWriter.write("tutorialDone=" + this.isTutorialDone() + "\r\n");
            fileWriter.write("vehiclesWarningShow=" + this.isVehiclesWarningShow() + "\r\n");
            fileWriter.write("bloodDecals=" + OptionBloodDecals + "\r\n");
            fileWriter.write("borderless=" + OptionBorderlessWindow + "\r\n");
            fileWriter.write("lockCursorToWindow=" + OptionLockCursorToWindow + "\r\n");
            fileWriter.write("textureCompression=" + OptionTextureCompression + "\r\n");
            fileWriter.write("modelTextureMipmaps=" + OptionModelTextureMipmaps + "\r\n");
            fileWriter.write("texture2x=" + OptionTexture2x + "\r\n");
            fileWriter.write("maxTextureSize=" + OptionMaxTextureSize + "\r\n");
            fileWriter.write("maxVehicleTextureSize=" + OptionMaxVehicleTextureSize + "\r\n");
            fileWriter.write("zoomLevels1x=" + OptionZoomLevels1x + "\r\n");
            fileWriter.write("zoomLevels2x=" + OptionZoomLevels2x + "\r\n");
            fileWriter.write("showChatTimestamp=" + OptionShowChatTimestamp + "\r\n");
            fileWriter.write("showChatTitle=" + OptionShowChatTitle + "\r\n");
            fileWriter.write("chatFontSize=" + OptionChatFontSize + "\r\n");
            fileWriter.write("minChatOpaque=" + OptionMinChatOpaque + "\r\n");
            fileWriter.write("maxChatOpaque=" + OptionMaxChatOpaque + "\r\n");
            fileWriter.write("chatFadeTime=" + OptionChatFadeTime + "\r\n");
            fileWriter.write("chatOpaqueOnFocus=" + OptionChatOpaqueOnFocus + "\r\n");
            fileWriter.write("doneNewSaveFolder=" + this.doneNewSaveFolder + "\r\n");
            fileWriter.write("contentTranslationsEnabled=" + OptionEnableContentTranslations + "\r\n");
            fileWriter.write("showYourUsername=" + this.showYourUsername + "\r\n");
            fileWriter.write("rosewoodSpawnDone=" + this.rosewoodSpawnDone + "\r\n");
            if (this.mpTextColor != null) {
                fileWriter.write("mpTextColor=" + this.mpTextColor.r + "," + this.mpTextColor.g + "," + this.mpTextColor.b + "\r\n");
            }
            fileWriter.write("objHighlightColor=" + this.objectHighlitedColor.r + "," + this.objectHighlitedColor.g + "," + this.objectHighlitedColor.b + "\r\n");
            fileWriter.write("seenNews=" + this.getSeenUpdateText() + "\r\n");
            fileWriter.write("toggleToAim=" + this.isToggleToAim() + "\r\n");
            fileWriter.write("toggleToRun=" + this.isToggleToRun() + "\r\n");
            fileWriter.write("toggleToSprint=" + this.isToggleToSprint() + "\r\n");
            fileWriter.write("celsius=" + this.isCelsius() + "\r\n");
            fileWriter.write("riversideDone=" + this.isRiversideDone() + "\r\n");
            fileWriter.write("showFirstTimeSneakTutorial=" + this.isShowFirstTimeSneakTutorial() + "\r\n");
            fileWriter.write("showFirstTimeSearchTutorial=" + this.isShowFirstTimeSearchTutorial() + "\r\n");
            fileWriter.write("termsOfServiceVersion=" + this.termsOfServiceVersion + "\r\n");
            fileWriter.write("uiRenderOffscreen=" + OptionUIFBO + "\r\n");
            fileWriter.write("uiRenderFPS=" + OptionUIRenderFPS + "\r\n");
            fileWriter.write("radialMenuKeyToggle=" + OptionRadialMenuKeyToggle + "\r\n");
            fileWriter.write("reloadRadialInstant=" + OptionReloadRadialInstant + "\r\n");
            fileWriter.write("panCameraWhileAiming=" + OptionPanCameraWhileAiming + "\r\n");
            fileWriter.write("panCameraWhileDriving=" + OptionPanCameraWhileDriving + "\r\n");
            fileWriter.write("temperatureDisplayCelsius=" + OptionTemperatureDisplayCelsius + "\r\n");
            fileWriter.write("doWindSpriteEffects=" + OptionDoWindSpriteEffects + "\r\n");
            fileWriter.write("doDoorSpriteEffects=" + OptionDoDoorSpriteEffects + "\r\n");
            fileWriter.write("doDoContainerOutline=" + OptionDoContainerOutline + "\r\n");
            fileWriter.write("updateSneakButton=" + OptionUpdateSneakButton + "\r\n");
            fileWriter.write("dblTapJogToSprint=" + OptiondblTapJogToSprint + "\r\n");
            fileWriter.write("gotNewBelt=" + this.gotNewBelt + "\r\n");
            fileWriter.write("aimOutline=" + OptionAimOutline + "\r\n");
            fileWriter.write("cycleContainerKey=" + OptionCycleContainerKey + "\r\n");
            fileWriter.write("dropItemsOnSquareCenter=" + OptionDropItemsOnSquareCenter + "\r\n");
            fileWriter.write("timedActionGameSpeedReset=" + OptionTimedActionGameSpeedReset + "\r\n");
            fileWriter.write("shoulderButtonContainerSwitch=" + OptionShoulderButtonContainerSwitch + "\r\n");
            fileWriter.write("singleContextMenu=" + this.getPerPlayerBooleanString(OptionSingleContextMenu) + "\r\n");
            fileWriter.write("renderPrecipIndoors=" + OptionRenderPrecipIndoors + "\r\n");
            fileWriter.write("autoProneAtk=" + OptionAutoProneAtk + "\r\n");
            fileWriter.write("3DGroundItem=" + Option3DGroundItem + "\r\n");
            fileWriter.write("tieredZombieUpdates=" + this.getOptionTieredZombieUpdates() + "\r\n");
            fileWriter.write("progressBar=" + this.isOptionProgressBar() + "\r\n");
            fileWriter.write("corpseShadows=" + this.getOptionCorpseShadows() + "\r\n");
            fileWriter.write("simpleClothingTextures=" + this.getOptionSimpleClothingTextures() + "\r\n");
            fileWriter.write("simpleWeaponTextures=" + this.getOptionSimpleWeaponTextures() + "\r\n");
            fileWriter.write("autoDrink=" + this.getOptionAutoDrink() + "\r\n");
            fileWriter.write("leaveKeyInIgnition=" + this.getOptionLeaveKeyInIgnition() + "\r\n");
            fileWriter.write("autoWalkContainer=" + this.getOptionAutoWalkContainer() + "\r\n");
            fileWriter.write("searchModeOverlayEffect=" + this.getOptionSearchModeOverlayEffect() + "\r\n");
            fileWriter.write("ignoreProneZombieRange=" + this.getOptionIgnoreProneZombieRange() + "\r\n");
            fileWriter.write("fogQuality=" + PerformanceSettings.FogQuality + "\r\n");
            fileWriter.write("renderPrecipitation=" + OptionRenderPrecipitation + "\r\n");
            fileWriter.write("showItemModInfo=" + OptionShowItemModInfo + "\r\n");
            fileWriter.write("showSurvivalGuide=" + this.OptionShowSurvivalGuide + "\r\n");
            fileWriter.write("enableLeftJoystickRadialMenu=" + OptionEnableLeftJoystickRadialMenu + "\r\n");
            fileWriter.write("doContainerOutline=" + OptionDoContainerOutline + "\r\n");
            fileWriter.write("goodHighlightColor=" + this.goodHighlitedColor.r + "," + this.goodHighlitedColor.g + "," + this.goodHighlitedColor.b + "\r\n");
            fileWriter.write("badHighlightColor=" + this.badHighlitedColor.r + "," + this.badHighlitedColor.g + "," + this.badHighlitedColor.b + "\r\n");
        }
    }

    public void setWindowed(boolean bl) {
        RenderThread.invokeOnRenderContext(() -> {
            if (bl != fullScreen) {
                Core.setDisplayMode(this.getScreenWidth(), this.getScreenHeight(), bl);
            }
            fullScreen = bl;
            if (fakefullscreen) {
                Display.setResizable((boolean)false);
            } else {
                Display.setResizable((!bl ? 1 : 0) != 0);
            }
            try {
                this.saveOptions();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        });
    }

    public boolean isFullScreen() {
        return fullScreen;
    }

    public KahluaTable getScreenModes() {
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        KahluaTable kahluaTable = LuaManager.platform.newTable();
        File file = new File(LuaManager.getLuaCacheDir() + File.separator + "screenresolution.ini");
        int n = 1;
        try {
            if (!file.exists()) {
                file.createNewFile();
                FileWriter fileWriter = new FileWriter(file);
                Integer n2 = 0;
                Integer n3 = 0;
                DisplayMode[] displayModeArray = Display.getAvailableDisplayModes();
                for (int i = 0; i < displayModeArray.length; ++i) {
                    n2 = displayModeArray[i].getWidth();
                    if (arrayList.contains(n2 + " x " + (n3 = Integer.valueOf(displayModeArray[i].getHeight())))) continue;
                    kahluaTable.rawset(n, (Object)(n2 + " x " + n3));
                    fileWriter.write(n2 + " x " + n3 + " \r\n");
                    arrayList.add((CallSite)((Object)(n2 + " x " + n3)));
                    ++n;
                }
                fileWriter.close();
            } else {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    kahluaTable.rawset(n, (Object)string.trim());
                    ++n;
                }
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return kahluaTable;
    }

    public static void setDisplayMode(int n, int n2, boolean bl) {
        RenderThread.invokeOnRenderContext(() -> {
            if (Display.getWidth() == n && Display.getHeight() == n2 && Display.isFullscreen() == bl && Display.isBorderlessWindow() == OptionBorderlessWindow) {
                return;
            }
            fullScreen = bl;
            try {
                DisplayMode displayMode = null;
                if (bl) {
                    DisplayMode[] displayModeArray = Display.getAvailableDisplayModes();
                    int n3 = 0;
                    DisplayMode displayMode2 = null;
                    for (DisplayMode displayMode3 : displayModeArray) {
                        if (displayMode3.getWidth() == n && displayMode3.getHeight() == n2 && displayMode3.isFullscreenCapable()) {
                            if (!(displayMode != null && displayMode3.getFrequency() < n3 || displayMode != null && displayMode3.getBitsPerPixel() <= displayMode.getBitsPerPixel())) {
                                displayMode = displayMode3;
                                n3 = displayMode.getFrequency();
                            }
                            if (displayMode3.getBitsPerPixel() == Display.getDesktopDisplayMode().getBitsPerPixel() && displayMode3.getFrequency() == Display.getDesktopDisplayMode().getFrequency()) {
                                displayMode = displayMode3;
                                break;
                            }
                        }
                        if (!displayMode3.isFullscreenCapable() || displayMode2 != null && Math.abs(displayMode3.getWidth() - n) >= Math.abs(displayMode2.getWidth() - n) && (displayMode3.getWidth() != displayMode2.getWidth() || displayMode3.getFrequency() <= n3)) continue;
                        displayMode2 = displayMode3;
                        n3 = displayMode3.getFrequency();
                        System.out.println("closest width=" + displayMode2.getWidth() + " freq=" + displayMode2.getFrequency());
                    }
                    if (displayMode == null && displayMode2 != null) {
                        displayMode = displayMode2;
                    }
                } else if (OptionBorderlessWindow) {
                    if (Display.getWindow() != 0L && Display.isFullscreen()) {
                        Display.setFullscreen((boolean)false);
                    }
                    long l = GLFW.glfwGetPrimaryMonitor();
                    GLFWVidMode gLFWVidMode = GLFW.glfwGetVideoMode((long)l);
                    displayMode = new DisplayMode(gLFWVidMode.width(), gLFWVidMode.height());
                } else {
                    displayMode = new DisplayMode(n, n2);
                }
                if (displayMode == null) {
                    DebugLog.log("Failed to find value mode: " + n + "x" + n2 + " fs=" + bl);
                    return;
                }
                Display.setBorderlessWindow((boolean)OptionBorderlessWindow);
                if (bl) {
                    Display.setDisplayModeAndFullscreen((DisplayMode)displayMode);
                } else {
                    Display.setDisplayMode((DisplayMode)displayMode);
                    Display.setFullscreen((boolean)false);
                }
                if (!bl && OptionBorderlessWindow) {
                    Display.setResizable((boolean)false);
                } else if (!bl && !fakefullscreen) {
                    Display.setResizable((boolean)false);
                    Display.setResizable((boolean)true);
                }
                if (Display.isCreated()) {
                    DebugLog.log("Display mode changed to " + Display.getWidth() + "x" + Display.getHeight() + " freq=" + Display.getDisplayMode().getFrequency() + " fullScreen=" + Display.isFullscreen());
                }
            }
            catch (LWJGLException lWJGLException) {
                DebugLog.log("Unable to setup mode " + n + "x" + n2 + " fullscreen=" + bl + lWJGLException);
            }
        });
    }

    private boolean isFunctionKey(int n) {
        return n >= 59 && n <= 68 || n >= 87 && n <= 105 || n == 113;
    }

    public boolean isDoingTextEntry() {
        if (CurrentTextEntryBox == null) {
            return false;
        }
        if (!Core.CurrentTextEntryBox.IsEditable) {
            return false;
        }
        return Core.CurrentTextEntryBox.DoingTextEntry;
    }

    private void updateKeyboardAux(UITextBox2 uITextBox2, int n) {
        boolean bl;
        boolean bl2 = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        boolean bl3 = bl = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        if (n == 28 || n == 156) {
            boolean bl4 = false;
            if (UIManager.getDebugConsole() != null && uITextBox2 == UIManager.getDebugConsole().CommandLine) {
                bl4 = true;
            }
            UITextBox2 uITextBox22 = uITextBox2;
            if (uITextBox22.multipleLine) {
                if (uITextBox22.Lines.size() < uITextBox22.getMaxLines()) {
                    if (uITextBox22.TextEntryCursorPos != uITextBox22.ToSelectionIndex) {
                        int n2 = Math.min(uITextBox22.TextEntryCursorPos, uITextBox22.ToSelectionIndex);
                        int n3 = Math.max(uITextBox22.TextEntryCursorPos, uITextBox22.ToSelectionIndex);
                        uITextBox22.internalText = uITextBox22.internalText.length() > 0 ? uITextBox22.internalText.substring(0, n2) + "\n" + uITextBox22.internalText.substring(n3) : "\n";
                        uITextBox22.TextEntryCursorPos = n2 + 1;
                    } else {
                        int n4 = uITextBox22.TextEntryCursorPos;
                        String string = uITextBox22.internalText.substring(0, n4) + "\n" + uITextBox22.internalText.substring(n4);
                        uITextBox22.SetText(string);
                        uITextBox22.TextEntryCursorPos = n4 + 1;
                    }
                    uITextBox22.ToSelectionIndex = uITextBox22.TextEntryCursorPos;
                    uITextBox22.CursorLine = uITextBox22.toDisplayLine(uITextBox22.TextEntryCursorPos);
                }
            } else {
                uITextBox2.onCommandEntered();
            }
            if (bl4 && (!GameClient.bClient || GameClient.connection.accessLevel != 1 || GameClient.connection != null && GameClient.connection.isCoopHost)) {
                UIManager.getDebugConsole().ProcessCommand();
            }
            return;
        }
        if (n == 1) {
            uITextBox2.onOtherKey(1);
            GameKeyboard.eatKeyPress(1);
            return;
        }
        if (n == 15) {
            uITextBox2.onOtherKey(15);
            LuaEventManager.triggerEvent("SwitchChatStream");
            return;
        }
        if (n == 58) {
            return;
        }
        if (n == 199) {
            uITextBox2.TextEntryCursorPos = 0;
            if (!uITextBox2.Lines.isEmpty()) {
                uITextBox2.TextEntryCursorPos = uITextBox2.TextOffsetOfLineStart.get(uITextBox2.CursorLine);
            }
            if (!bl) {
                uITextBox2.ToSelectionIndex = uITextBox2.TextEntryCursorPos;
            }
            uITextBox2.resetBlink();
            return;
        }
        if (n == 207) {
            uITextBox2.TextEntryCursorPos = uITextBox2.internalText.length();
            if (!uITextBox2.Lines.isEmpty()) {
                uITextBox2.TextEntryCursorPos = uITextBox2.TextOffsetOfLineStart.get(uITextBox2.CursorLine) + ((String)uITextBox2.Lines.get(uITextBox2.CursorLine)).length();
            }
            if (!bl) {
                uITextBox2.ToSelectionIndex = uITextBox2.TextEntryCursorPos;
            }
            uITextBox2.resetBlink();
            return;
        }
        if (n == 200) {
            if (uITextBox2.CursorLine > 0) {
                int n5 = uITextBox2.TextEntryCursorPos - uITextBox2.TextOffsetOfLineStart.get(uITextBox2.CursorLine);
                --uITextBox2.CursorLine;
                if (n5 > ((String)uITextBox2.Lines.get(uITextBox2.CursorLine)).length()) {
                    n5 = ((String)uITextBox2.Lines.get(uITextBox2.CursorLine)).length();
                }
                uITextBox2.TextEntryCursorPos = uITextBox2.TextOffsetOfLineStart.get(uITextBox2.CursorLine) + n5;
                if (!bl) {
                    uITextBox2.ToSelectionIndex = uITextBox2.TextEntryCursorPos;
                }
            }
            uITextBox2.onPressUp();
            return;
        }
        if (n == 208) {
            if (uITextBox2.Lines.size() - 1 > uITextBox2.CursorLine && uITextBox2.CursorLine + 1 < uITextBox2.getMaxLines()) {
                int n6 = uITextBox2.TextEntryCursorPos - uITextBox2.TextOffsetOfLineStart.get(uITextBox2.CursorLine);
                ++uITextBox2.CursorLine;
                if (n6 > ((String)uITextBox2.Lines.get(uITextBox2.CursorLine)).length()) {
                    n6 = ((String)uITextBox2.Lines.get(uITextBox2.CursorLine)).length();
                }
                uITextBox2.TextEntryCursorPos = uITextBox2.TextOffsetOfLineStart.get(uITextBox2.CursorLine) + n6;
                if (!bl) {
                    uITextBox2.ToSelectionIndex = uITextBox2.TextEntryCursorPos;
                }
            }
            uITextBox2.onPressDown();
            return;
        }
        if (n == 29) {
            return;
        }
        if (n == 157) {
            return;
        }
        if (n == 42) {
            return;
        }
        if (n == 54) {
            return;
        }
        if (n == 56) {
            return;
        }
        if (n == 184) {
            return;
        }
        if (n == 203) {
            --uITextBox2.TextEntryCursorPos;
            if (uITextBox2.TextEntryCursorPos < 0) {
                uITextBox2.TextEntryCursorPos = 0;
            }
            if (!bl) {
                uITextBox2.ToSelectionIndex = uITextBox2.TextEntryCursorPos;
            }
            uITextBox2.resetBlink();
            return;
        }
        if (n == 205) {
            ++uITextBox2.TextEntryCursorPos;
            if (uITextBox2.TextEntryCursorPos > uITextBox2.internalText.length()) {
                uITextBox2.TextEntryCursorPos = uITextBox2.internalText.length();
            }
            if (!bl) {
                uITextBox2.ToSelectionIndex = uITextBox2.TextEntryCursorPos;
            }
            uITextBox2.resetBlink();
            return;
        }
        if (this.isFunctionKey(n)) {
            return;
        }
        if ((n == 211 || n == 14) && uITextBox2.TextEntryCursorPos != uITextBox2.ToSelectionIndex) {
            int n7 = Math.min(uITextBox2.TextEntryCursorPos, uITextBox2.ToSelectionIndex);
            int n8 = Math.max(uITextBox2.TextEntryCursorPos, uITextBox2.ToSelectionIndex);
            uITextBox2.internalText = uITextBox2.internalText.substring(0, n7) + uITextBox2.internalText.substring(n8);
            uITextBox2.CursorLine = uITextBox2.toDisplayLine(n7);
            uITextBox2.ToSelectionIndex = n7;
            uITextBox2.TextEntryCursorPos = n7;
            uITextBox2.onTextChange();
            return;
        }
        if (n == 211) {
            if (uITextBox2.internalText.length() == 0 || uITextBox2.TextEntryCursorPos >= uITextBox2.internalText.length()) {
                return;
            }
            uITextBox2.internalText = uITextBox2.TextEntryCursorPos > 0 ? uITextBox2.internalText.substring(0, uITextBox2.TextEntryCursorPos) + uITextBox2.internalText.substring(uITextBox2.TextEntryCursorPos + 1) : uITextBox2.internalText.substring(1);
            uITextBox2.onTextChange();
            return;
        }
        if (n == 14) {
            if (uITextBox2.internalText.length() == 0 || uITextBox2.TextEntryCursorPos <= 0) {
                return;
            }
            if (uITextBox2.TextEntryCursorPos > uITextBox2.internalText.length()) {
                uITextBox2.internalText = uITextBox2.internalText.substring(0, uITextBox2.internalText.length() - 1);
            } else {
                int n9 = uITextBox2.TextEntryCursorPos;
                uITextBox2.internalText = uITextBox2.internalText.substring(0, n9 - 1) + uITextBox2.internalText.substring(n9);
            }
            --uITextBox2.TextEntryCursorPos;
            uITextBox2.ToSelectionIndex = uITextBox2.TextEntryCursorPos;
            uITextBox2.onTextChange();
            return;
        }
        if (bl2 && n == 47) {
            String string = Clipboard.getClipboard();
            if (string == null) {
                return;
            }
            if (uITextBox2.TextEntryCursorPos != uITextBox2.ToSelectionIndex) {
                int n10 = Math.min(uITextBox2.TextEntryCursorPos, uITextBox2.ToSelectionIndex);
                int n11 = Math.max(uITextBox2.TextEntryCursorPos, uITextBox2.ToSelectionIndex);
                uITextBox2.internalText = uITextBox2.internalText.substring(0, n10) + string + uITextBox2.internalText.substring(n11);
                uITextBox2.ToSelectionIndex = n10 + string.length();
                uITextBox2.TextEntryCursorPos = n10 + string.length();
            } else {
                uITextBox2.internalText = uITextBox2.TextEntryCursorPos < uITextBox2.internalText.length() ? uITextBox2.internalText.substring(0, uITextBox2.TextEntryCursorPos) + string + uITextBox2.internalText.substring(uITextBox2.TextEntryCursorPos) : uITextBox2.internalText + string;
                uITextBox2.TextEntryCursorPos += string.length();
                uITextBox2.ToSelectionIndex += string.length();
            }
            uITextBox2.onTextChange();
            return;
        }
        if (bl2 && n == 46) {
            if (uITextBox2.TextEntryCursorPos == uITextBox2.ToSelectionIndex) {
                return;
            }
            uITextBox2.updateText();
            int n12 = Math.min(uITextBox2.TextEntryCursorPos, uITextBox2.ToSelectionIndex);
            int n13 = Math.max(uITextBox2.TextEntryCursorPos, uITextBox2.ToSelectionIndex);
            String string = uITextBox2.Text.substring(n12, n13);
            if (string != null && string.length() > 0) {
                Clipboard.setClipboard(string);
            }
            return;
        }
        if (bl2 && n == 45) {
            if (uITextBox2.TextEntryCursorPos == uITextBox2.ToSelectionIndex) {
                return;
            }
            uITextBox2.updateText();
            int n14 = Math.min(uITextBox2.TextEntryCursorPos, uITextBox2.ToSelectionIndex);
            int n15 = Math.max(uITextBox2.TextEntryCursorPos, uITextBox2.ToSelectionIndex);
            String string = uITextBox2.Text.substring(n14, n15);
            if (string != null && string.length() > 0) {
                Clipboard.setClipboard(string);
            }
            uITextBox2.internalText = uITextBox2.internalText.substring(0, n14) + uITextBox2.internalText.substring(n15);
            uITextBox2.ToSelectionIndex = n14;
            uITextBox2.TextEntryCursorPos = n14;
            return;
        }
        if (bl2 && n == 30) {
            uITextBox2.selectAll();
            return;
        }
        if (uITextBox2.ignoreFirst) {
            return;
        }
        if (uITextBox2.internalText.length() >= uITextBox2.TextEntryMaxLength) {
            return;
        }
        char c = Keyboard.getEventCharacter();
        if (c == '\u0000') {
            return;
        }
        if (uITextBox2.isOnlyNumbers() && c != '.' && c != '-') {
            try {
                Double.parseDouble(String.valueOf(c));
            }
            catch (Exception exception) {
                return;
            }
        }
        if (uITextBox2.TextEntryCursorPos == uITextBox2.ToSelectionIndex) {
            int n16 = uITextBox2.TextEntryCursorPos;
            uITextBox2.internalText = n16 < uITextBox2.internalText.length() ? uITextBox2.internalText.substring(0, n16) + c + uITextBox2.internalText.substring(n16) : uITextBox2.internalText + c;
            ++uITextBox2.TextEntryCursorPos;
            ++uITextBox2.ToSelectionIndex;
            uITextBox2.onTextChange();
        } else {
            int n17 = Math.min(uITextBox2.TextEntryCursorPos, uITextBox2.ToSelectionIndex);
            int n18 = Math.max(uITextBox2.TextEntryCursorPos, uITextBox2.ToSelectionIndex);
            uITextBox2.internalText = uITextBox2.internalText.length() > 0 ? uITextBox2.internalText.substring(0, n17) + c + uITextBox2.internalText.substring(n18) : "" + c;
            uITextBox2.ToSelectionIndex = n17 + 1;
            uITextBox2.TextEntryCursorPos = n17 + 1;
            uITextBox2.onTextChange();
        }
    }

    public void updateKeyboard() {
        if (!this.isDoingTextEntry()) {
            return;
        }
        while (Keyboard.next()) {
            if (!this.isDoingTextEntry() || !Keyboard.getEventKeyState()) continue;
            int n = Keyboard.getEventKey();
            this.updateKeyboardAux(CurrentTextEntryBox, n);
        }
        if (CurrentTextEntryBox != null && Core.CurrentTextEntryBox.ignoreFirst) {
            Core.CurrentTextEntryBox.ignoreFirst = false;
        }
    }

    public void quit() {
        DebugLog.log("EXITDEBUG: Core.quit 1");
        if (IsoPlayer.getInstance() != null) {
            DebugLog.log("EXITDEBUG: Core.quit 2");
            bExiting = true;
        } else {
            DebugLog.log("EXITDEBUG: Core.quit 3");
            try {
                this.saveOptions();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            GameClient.instance.Shutdown();
            SteamUtils.shutdown();
            DebugLog.log("EXITDEBUG: Core.quit 4");
            System.exit(0);
        }
    }

    public void exitToMenu() {
        DebugLog.log("EXITDEBUG: Core.exitToMenu");
        bExiting = true;
    }

    public void quitToDesktop() {
        DebugLog.log("EXITDEBUG: Core.quitToDesktop");
        GameWindow.closeRequested = true;
    }

    public boolean supportRes(int n, int n2) throws LWJGLException {
        DisplayMode[] displayModeArray = Display.getAvailableDisplayModes();
        boolean bl = false;
        for (int i = 0; i < displayModeArray.length; ++i) {
            if (displayModeArray[i].getWidth() != n || displayModeArray[i].getHeight() != n2 || !displayModeArray[i].isFullscreenCapable()) continue;
            return true;
        }
        return false;
    }

    public void init(int n, int n2) throws LWJGLException {
        System.setProperty("org.lwjgl.opengl.Window.undecorated", OptionBorderlessWindow ? "true" : "false");
        if (!System.getProperty("os.name").contains("OS X") && !System.getProperty("os.name").startsWith("Win")) {
            DebugLog.log("Creating display. If this fails, you may need to install xrandr.");
        }
        Core.setDisplayMode(n, n2, fullScreen);
        try {
            Display.create((PixelFormat)new PixelFormat(32, 0, 24, 8, 0));
        }
        catch (LWJGLException lWJGLException) {
            Display.destroy();
            Display.setDisplayModeAndFullscreen((DisplayMode)Display.getDesktopDisplayMode());
            Display.create((PixelFormat)new PixelFormat(32, 0, 24, 8, 0));
        }
        fullScreen = Display.isFullscreen();
        DebugLog.log("GraphicsCard: " + GL11.glGetString((int)7936) + " " + GL11.glGetString((int)7937));
        DebugLog.log("OpenGL version: " + GL11.glGetString((int)7938));
        DebugLog.log("Desktop resolution " + Display.getDesktopDisplayMode().getWidth() + "x" + Display.getDesktopDisplayMode().getHeight());
        DebugLog.log("Initial resolution " + width + "x" + height + " fullScreen=" + fullScreen);
        GLVertexBufferObject.init();
        DebugLog.General.println("VSync: %s", OptionVSync ? "ON" : "OFF");
        Display.setVSyncEnabled((boolean)OptionVSync);
        GL11.glEnable((int)3553);
        IndieGL.glBlendFunc(770, 771);
        GL32.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private boolean setupMultiFBO() {
        try {
            if (!this.OffscreenBuffer.test()) {
                return false;
            }
            this.OffscreenBuffer.setZoomLevelsFromOption(TileScale == 2 ? OptionZoomLevels2x : OptionZoomLevels1x);
            this.OffscreenBuffer.create(Display.getWidth(), Display.getHeight());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void setScreenSize(int n, int n2) {
        if (width != n || n2 != height) {
            int n3 = width;
            int n4 = height;
            DebugLog.log("Screen resolution changed from " + n3 + "x" + n4 + " to " + n + "x" + n2 + " fullScreen=" + fullScreen);
            width = n;
            height = n2;
            if (this.OffscreenBuffer != null && this.OffscreenBuffer.Current != null) {
                this.OffscreenBuffer.destroy();
                try {
                    this.OffscreenBuffer.setZoomLevelsFromOption(TileScale == 2 ? OptionZoomLevels2x : OptionZoomLevels1x);
                    this.OffscreenBuffer.create(n, n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            try {
                LuaEventManager.triggerEvent("OnResolutionChange", n3, n4, n, n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null) continue;
                isoPlayer.dirtyRecalcGridStackTime = 2.0f;
            }
        }
    }

    public static boolean supportCompressedTextures() {
        return GL.getCapabilities().GL_EXT_texture_compression_latc;
    }

    public void StartFrame() {
        if (LuaManager.thread != null && LuaManager.thread.bStep) {
            return;
        }
        if (this.RenderShader != null && this.OffscreenBuffer.Current != null) {
            this.RenderShader.setTexture(this.OffscreenBuffer.getTexture(0));
        }
        SpriteRenderer.instance.prePopulating();
        UIManager.resize();
        boolean bl = false;
        Texture.BindCount = 0;
        if (!bl) {
            IndieGL.glClear(18176);
            if (DebugOptions.instance.Terrain.RenderTiles.HighContrastBg.getValue()) {
                SpriteRenderer.instance.glClearColor(255, 0, 255, 255);
                SpriteRenderer.instance.glClear(16384);
            }
        }
        if (this.OffscreenBuffer.Current != null) {
            SpriteRenderer.instance.glBuffer(1, 0);
        }
        IndieGL.glDoStartFrame(this.getScreenWidth(), this.getScreenWidth(), this.getCurrentPlayerZoom(), 0);
        this.frameStage = 1;
    }

    public void StartFrame(int n, boolean bl) {
        if (LuaManager.thread.bStep) {
            return;
        }
        this.OffscreenBuffer.update();
        if (this.RenderShader != null && this.OffscreenBuffer.Current != null) {
            this.RenderShader.setTexture(this.OffscreenBuffer.getTexture(n));
        }
        if (bl) {
            SpriteRenderer.instance.prePopulating();
        }
        if (!bl) {
            SpriteRenderer.instance.initFromIsoCamera(n);
        }
        Texture.BindCount = 0;
        IndieGL.glLoadIdentity();
        if (this.OffscreenBuffer.Current != null) {
            SpriteRenderer.instance.glBuffer(1, n);
        }
        IndieGL.glDoStartFrame(this.getScreenWidth(), this.getScreenHeight(), this.getZoom(n), n);
        IndieGL.glClear(17664);
        if (DebugOptions.instance.Terrain.RenderTiles.HighContrastBg.getValue()) {
            SpriteRenderer.instance.glClearColor(255, 0, 255, 255);
            SpriteRenderer.instance.glClear(16384);
        }
        this.frameStage = 1;
    }

    public TextureFBO getOffscreenBuffer() {
        return this.OffscreenBuffer.getCurrent(0);
    }

    public TextureFBO getOffscreenBuffer(int n) {
        return this.OffscreenBuffer.getCurrent(n);
    }

    public void setLastRenderedFBO(TextureFBO textureFBO) {
        this.OffscreenBuffer.FBOrendered = textureFBO;
    }

    public void DoStartFrameStuff(int n, int n2, float f, int n3) {
        this.DoStartFrameStuff(n, n2, f, n3, false);
    }

    public void DoStartFrameStuff(int n, int n2, float f, int n3, boolean bl) {
        this.DoStartFrameStuffInternal(n, n2, f, n3, bl, false, false);
    }

    public void DoEndFrameStuffFx(int n, int n2, int n3) {
        GL11.glPopAttrib();
        --this.stack;
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        --this.stack;
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
    }

    public void DoStartFrameStuffSmartTextureFx(int n, int n2, int n3) {
        this.DoStartFrameStuffInternal(n, n2, 1.0f, n3, false, true, true);
    }

    private void DoStartFrameStuffInternal(int n, int n2, float f, int n3, boolean bl, boolean bl2, boolean bl3) {
        int n4;
        int n5;
        GL32.glEnable((int)3042);
        GL32.glDepthFunc((int)519);
        int n6 = this.getScreenWidth();
        int n7 = this.getScreenHeight();
        if (!bl3 && !bl2) {
            n = n6;
        }
        if (!bl3 && !bl2) {
            n2 = n7;
        }
        if (!bl3 && n3 != -1) {
            n /= IsoPlayer.numPlayers > 1 ? 2 : 1;
            n2 /= IsoPlayer.numPlayers > 2 ? 2 : 1;
        }
        GL32.glMatrixMode((int)5889);
        if (!bl2) {
            while (this.stack > 0) {
                try {
                    GL11.glPopMatrix();
                    GL11.glPopAttrib();
                    this.stack -= 2;
                }
                catch (OpenGLException openGLException) {
                    n5 = GL11.glGetInteger((int)2992);
                    while (n5-- > 0) {
                        GL11.glPopAttrib();
                    }
                    n4 = GL11.glGetInteger((int)2980);
                    while (n4-- > 1) {
                        GL11.glPopMatrix();
                    }
                    this.stack = 0;
                }
            }
        }
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glPushAttrib((int)2048);
        ++this.stack;
        GL11.glPushMatrix();
        ++this.stack;
        GL11.glLoadIdentity();
        if (!bl3 && !bl) {
            GLU.gluOrtho2D((float)0.0f, (float)((float)n * f), (float)((float)n2 * f), (float)0.0f);
        } else {
            GLU.gluOrtho2D((float)0.0f, (float)n, (float)n2, (float)0.0f);
        }
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        if (n3 != -1) {
            int n8;
            n4 = n;
            int n9 = n2;
            if (bl) {
                n8 = n;
                n5 = n2;
            } else {
                n8 = n6;
                n5 = n7;
                if (IsoPlayer.numPlayers > 1) {
                    n8 /= 2;
                }
                if (IsoPlayer.numPlayers > 2) {
                    n5 /= 2;
                }
            }
            if (bl2) {
                n4 = n8;
                n9 = n5;
            }
            float f2 = 0.0f;
            float f3 = n8 * (n3 % 2);
            if (n3 >= 2) {
                f2 += (float)n5;
            }
            if (bl) {
                f2 = (float)(Core.getInstance().getScreenHeight() - n9) - f2;
            }
            GL11.glViewport((int)((int)f3), (int)((int)f2), (int)n4, (int)n9);
            GL11.glEnable((int)3089);
            GL11.glScissor((int)((int)f3), (int)((int)f2), (int)n4, (int)n9);
            SpriteRenderer.instance.setRenderingPlayerIndex(n3);
        } else {
            GL11.glViewport((int)0, (int)0, (int)n, (int)n2);
        }
    }

    public void DoPushIsoStuff(float f, float f2, float f3, float f4, boolean bl) {
        float f5 = Core.getInstance().FloatParamMap.get(0).floatValue();
        float f6 = Core.getInstance().FloatParamMap.get(1).floatValue();
        float f7 = Core.getInstance().FloatParamMap.get(2).floatValue();
        double d = f5;
        double d2 = f6;
        double d3 = f7;
        SpriteRenderState spriteRenderState = SpriteRenderer.instance.getRenderingState();
        int n = spriteRenderState.playerIndex;
        PlayerCamera playerCamera = spriteRenderState.playerCamera[n];
        float f8 = playerCamera.RightClickX;
        float f9 = playerCamera.RightClickY;
        float f10 = playerCamera.getTOffX();
        float f11 = playerCamera.getTOffY();
        float f12 = playerCamera.DeferedX;
        float f13 = playerCamera.DeferedY;
        d -= (double)playerCamera.XToIso(-f10 - f8, -f11 - f9, 0.0f);
        d2 -= (double)playerCamera.YToIso(-f10 - f8, -f11 - f9, 0.0f);
        d += (double)f12;
        d2 += (double)f13;
        double d4 = (float)playerCamera.OffscreenWidth / 1920.0f;
        double d5 = (float)playerCamera.OffscreenHeight / 1920.0f;
        Matrix4f matrix4f = this.tempMatrix4f;
        matrix4f.setOrtho(-((float)d4) / 2.0f, (float)d4 / 2.0f, -((float)d5) / 2.0f, (float)d5 / 2.0f, -10.0f, 10.0f);
        PZGLUtil.pushAndLoadMatrix(5889, matrix4f);
        Matrix4f matrix4f2 = this.tempMatrix4f;
        float f14 = (float)(2.0 / Math.sqrt(2048.0));
        matrix4f2.scaling(0.047085002f);
        matrix4f2.scale((float)TileScale / 2.0f);
        matrix4f2.rotate(0.5235988f, 1.0f, 0.0f, 0.0f);
        matrix4f2.rotate(2.3561945f, 0.0f, 1.0f, 0.0f);
        double d6 = (double)f - d;
        double d7 = (double)f2 - d2;
        matrix4f2.translate(-((float)d6), (float)((double)f3 - d3) * 2.5f, -((float)d7));
        if (bl) {
            matrix4f2.scale(-1.0f, 1.0f, 1.0f);
        } else {
            matrix4f2.scale(-1.5f, 1.5f, 1.5f);
        }
        matrix4f2.rotate(f4 + (float)Math.PI, 0.0f, 1.0f, 0.0f);
        if (!bl) {
            matrix4f2.translate(0.0f, -0.48f, 0.0f);
        }
        PZGLUtil.pushAndLoadMatrix(5888, matrix4f2);
        GL11.glDepthRange((double)0.0, (double)1.0);
    }

    public void DoPushIsoParticleStuff(float f, float f2, float f3) {
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        float f4 = Core.getInstance().FloatParamMap.get(0).floatValue();
        float f5 = Core.getInstance().FloatParamMap.get(1).floatValue();
        float f6 = Core.getInstance().FloatParamMap.get(2).floatValue();
        GL11.glLoadIdentity();
        double d = f4;
        double d2 = f5;
        double d3 = f6;
        double d4 = (float)Math.abs(Core.getInstance().getOffscreenWidth(0)) / 1920.0f;
        double d5 = (float)Math.abs(Core.getInstance().getOffscreenHeight(0)) / 1080.0f;
        GL11.glLoadIdentity();
        GL11.glOrtho((double)(-d4 / 2.0), (double)(d4 / 2.0), (double)(-d5 / 2.0), (double)(d5 / 2.0), (double)-10.0, (double)10.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glScaled((double)0.047085002064704895, (double)0.047085002064704895, (double)0.047085002064704895);
        GL11.glRotatef((float)62.65607f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)-2.72f, (double)0.0);
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)1.7099999f, (float)14.193f, (float)1.7099999f);
        GL11.glScalef((float)0.59f, (float)0.59f, (float)0.59f);
        GL11.glTranslated((double)(-((double)f - d)), (double)((double)f3 - d3), (double)(-((double)f2 - d2)));
        GL11.glDepthRange((double)0.0, (double)1.0);
    }

    public void DoPopIsoStuff() {
        GL11.glEnable((int)3008);
        GL11.glDepthFunc((int)519);
        GL11.glDepthMask((boolean)false);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
    }

    public void DoEndFrameStuff(int n, int n2) {
        try {
            GL11.glPopAttrib();
            --this.stack;
            GL11.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            --this.stack;
        }
        catch (Exception exception) {
            int n3 = GL11.glGetInteger((int)2992);
            while (n3-- > 0) {
                GL11.glPopAttrib();
            }
            GL11.glMatrixMode((int)5889);
            int n4 = GL11.glGetInteger((int)2980);
            while (n4-- > 1) {
                GL11.glPopMatrix();
            }
            this.stack = 0;
        }
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glDisable((int)3089);
    }

    public void RenderOffScreenBuffer() {
        if (LuaManager.thread != null && LuaManager.thread.bStep) {
            return;
        }
        if (this.OffscreenBuffer.Current == null) {
            return;
        }
        IndieGL.disableStencilTest();
        IndieGL.glDoStartFrame(width, height, 1.0f, -1);
        IndieGL.glDisable(3042);
        this.OffscreenBuffer.render();
        IndieGL.glDoEndFrame();
    }

    public void StartFrameText(int n) {
        if (LuaManager.thread != null && LuaManager.thread.bStep) {
            return;
        }
        IndieGL.glDoStartFrame(IsoCamera.getScreenWidth(n), IsoCamera.getScreenHeight(n), 1.0f, n, true);
        this.frameStage = 2;
    }

    public boolean StartFrameUI() {
        if (LuaManager.thread != null && LuaManager.thread.bStep) {
            return false;
        }
        boolean bl = true;
        if (UIManager.useUIFBO) {
            if (UIManager.defaultthread == LuaManager.debugthread) {
                this.UIRenderThisFrame = true;
            } else {
                this.UIRenderAccumulator += GameTime.getInstance().getMultiplier() / 1.6f;
                boolean bl2 = this.UIRenderThisFrame = this.UIRenderAccumulator >= 30.0f / (float)OptionUIRenderFPS;
            }
            if (this.UIRenderThisFrame) {
                SpriteRenderer.instance.startOffscreenUI();
                SpriteRenderer.instance.glBuffer(2, 0);
            } else {
                bl = false;
            }
        }
        IndieGL.glDoStartFrame(width, height, 1.0f, -1);
        IndieGL.glClear(1024);
        UIManager.resize();
        this.frameStage = 3;
        return bl;
    }

    public Map<String, Integer> getKeyMaps() {
        return this.keyMaps;
    }

    public void setKeyMaps(Map<String, Integer> map) {
        this.keyMaps = map;
    }

    public void reinitKeyMaps() {
        this.keyMaps = new HashMap<String, Integer>();
    }

    public int getKey(String string) {
        if (this.keyMaps == null) {
            return 0;
        }
        if (this.keyMaps.get(string) != null) {
            return this.keyMaps.get(string);
        }
        return 0;
    }

    public void addKeyBinding(String string, Integer n) {
        if (this.keyMaps == null) {
            this.keyMaps = new HashMap<String, Integer>();
        }
        this.keyMaps.put(string, n);
    }

    public static boolean isLastStand() {
        return bLastStand;
    }

    public String getVersion() {
        return gameVersion + ".16";
    }

    public GameVersion getGameVersion() {
        return gameVersion;
    }

    public String getSteamServerVersion() {
        return this.steamServerVersion;
    }

    public void DoFrameReady() {
        this.updateKeyboard();
    }

    public float getCurrentPlayerZoom() {
        int n = IsoCamera.frameState.playerIndex;
        return this.getZoom(n);
    }

    public float getZoom(int n) {
        if (this.OffscreenBuffer != null) {
            return this.OffscreenBuffer.zoom[n] * ((float)TileScale / 2.0f);
        }
        return 1.0f;
    }

    public float getNextZoom(int n, int n2) {
        if (this.OffscreenBuffer != null) {
            return this.OffscreenBuffer.getNextZoom(n, n2);
        }
        return 1.0f;
    }

    public float getMinZoom() {
        if (this.OffscreenBuffer != null) {
            return this.OffscreenBuffer.getMinZoom() * ((float)TileScale / 2.0f);
        }
        return 1.0f;
    }

    public float getMaxZoom() {
        if (this.OffscreenBuffer != null) {
            return this.OffscreenBuffer.getMaxZoom() * ((float)TileScale / 2.0f);
        }
        return 1.0f;
    }

    public void doZoomScroll(int n, int n2) {
        if (this.OffscreenBuffer != null) {
            this.OffscreenBuffer.doZoomScroll(n, n2);
        }
    }

    public String getSaveFolder() {
        return this.saveFolder;
    }

    public boolean getOptionZoom() {
        return OptionZoom;
    }

    public void setOptionZoom(boolean bl) {
        OptionZoom = bl;
    }

    public void zoomOptionChanged(boolean bl) {
        if (!bl) {
            SafeMode = SafeModeForced;
            this.OffscreenBuffer.bZoomEnabled = OptionZoom && !SafeModeForced;
            return;
        }
        RenderThread.invokeOnRenderContext(() -> {
            if (!OptionZoom || SafeModeForced) {
                this.OffscreenBuffer.destroy();
                SafeMode = true;
                this.bSupportsFBO = false;
                this.OffscreenBuffer.bZoomEnabled = false;
            } else {
                SafeMode = false;
                this.bSupportsFBO = true;
                this.OffscreenBuffer.bZoomEnabled = true;
                this.supportsFBO();
            }
        });
        DebugLog.log("SafeMode is " + (SafeMode ? "on" : "off"));
    }

    public void zoomLevelsChanged() {
        if (this.OffscreenBuffer.Current != null) {
            RenderThread.invokeOnRenderContext(() -> {
                this.OffscreenBuffer.destroy();
                this.zoomOptionChanged(true);
            });
        }
    }

    public boolean isZoomEnabled() {
        return this.OffscreenBuffer.bZoomEnabled;
    }

    public void initFBOs() {
        if (!OptionZoom || SafeModeForced) {
            SafeMode = true;
            this.OffscreenBuffer.bZoomEnabled = false;
        } else {
            RenderThread.invokeOnRenderContext(this::supportsFBO);
        }
        DebugLog.log("SafeMode is " + (SafeMode ? "on" : "off"));
    }

    public boolean getAutoZoom(int n) {
        return bAutoZoom[n];
    }

    public void setAutoZoom(int n, boolean bl) {
        Core.bAutoZoom[n] = bl;
        if (this.OffscreenBuffer != null) {
            this.OffscreenBuffer.bAutoZoom[n] = bl;
        }
    }

    public boolean getOptionVSync() {
        return OptionVSync;
    }

    public void setOptionVSync(boolean bl) {
        OptionVSync = bl;
        RenderThread.invokeOnRenderContext(() -> Display.setVSyncEnabled((boolean)bl));
    }

    public int getOptionSoundVolume() {
        return OptionSoundVolume;
    }

    public float getRealOptionSoundVolume() {
        return (float)OptionSoundVolume / 10.0f;
    }

    public void setOptionSoundVolume(int n) {
        OptionSoundVolume = Math.max(0, Math.min(10, n));
        if (SoundManager.instance != null) {
            SoundManager.instance.setSoundVolume((float)n / 10.0f);
        }
    }

    public int getOptionMusicVolume() {
        return OptionMusicVolume;
    }

    public void setOptionMusicVolume(int n) {
        OptionMusicVolume = Math.max(0, Math.min(10, n));
        if (SoundManager.instance != null) {
            SoundManager.instance.setMusicVolume((float)n / 10.0f);
        }
    }

    public int getOptionAmbientVolume() {
        return OptionAmbientVolume;
    }

    public void setOptionAmbientVolume(int n) {
        OptionAmbientVolume = Math.max(0, Math.min(10, n));
        if (SoundManager.instance != null) {
            SoundManager.instance.setAmbientVolume((float)n / 10.0f);
        }
    }

    public int getOptionJumpScareVolume() {
        return OptionJumpScareVolume;
    }

    public void setOptionJumpScareVolume(int n) {
        OptionJumpScareVolume = PZMath.clamp(n, 0, 10);
    }

    public int getOptionMusicActionStyle() {
        return OptionMusicActionStyle;
    }

    public void setOptionMusicActionStyle(int n) {
        OptionMusicActionStyle = PZMath.clamp(n, 1, 2);
    }

    public int getOptionMusicLibrary() {
        return OptionMusicLibrary;
    }

    public void setOptionMusicLibrary(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 3) {
            n = 3;
        }
        OptionMusicLibrary = n;
    }

    public int getOptionVehicleEngineVolume() {
        return OptionVehicleEngineVolume;
    }

    public void setOptionVehicleEngineVolume(int n) {
        OptionVehicleEngineVolume = Math.max(0, Math.min(10, n));
        if (SoundManager.instance != null) {
            SoundManager.instance.setVehicleEngineVolume((float)OptionVehicleEngineVolume / 10.0f);
        }
    }

    public boolean getOptionVoiceEnable() {
        return OptionVoiceEnable;
    }

    public void setOptionVoiceEnable(boolean bl) {
        if (OptionVoiceEnable != bl) {
            OptionVoiceEnable = bl;
            VoiceManager.instance.VoiceRestartClient(bl);
        }
    }

    public int getOptionVoiceMode() {
        return OptionVoiceMode;
    }

    public void setOptionVoiceMode(int n) {
        OptionVoiceMode = n;
        VoiceManager.instance.setMode(n);
    }

    public int getOptionVoiceVADMode() {
        return OptionVoiceVADMode;
    }

    public void setOptionVoiceVADMode(int n) {
        OptionVoiceVADMode = n;
        VoiceManager.instance.setVADMode(n);
    }

    public int getOptionVoiceAGCMode() {
        return OptionVoiceAGCMode;
    }

    public void setOptionVoiceAGCMode(int n) {
        OptionVoiceAGCMode = n;
        VoiceManager.instance.setAGCMode(n);
    }

    public int getOptionVoiceVolumeMic() {
        return OptionVoiceVolumeMic;
    }

    public void setOptionVoiceVolumeMic(int n) {
        OptionVoiceVolumeMic = n;
        VoiceManager.instance.setVolumeMic(n);
    }

    public int getOptionVoiceVolumePlayers() {
        return OptionVoiceVolumePlayers;
    }

    public void setOptionVoiceVolumePlayers(int n) {
        OptionVoiceVolumePlayers = n;
        VoiceManager.instance.setVolumePlayers(n);
    }

    public String getOptionVoiceRecordDeviceName() {
        return OptionVoiceRecordDeviceName;
    }

    public void setOptionVoiceRecordDeviceName(String string) {
        OptionVoiceRecordDeviceName = string;
        VoiceManager.instance.UpdateRecordDevice();
    }

    public int getOptionVoiceRecordDevice() {
        if (SoundDisabled || VoiceManager.VoipDisabled) {
            return 0;
        }
        int n = javafmod.FMOD_System_GetRecordNumDrivers();
        for (int i = 0; i < n; ++i) {
            FMOD_DriverInfo fMOD_DriverInfo = new FMOD_DriverInfo();
            javafmod.FMOD_System_GetRecordDriverInfo((int)i, (FMOD_DriverInfo)fMOD_DriverInfo);
            if (!fMOD_DriverInfo.name.equals(OptionVoiceRecordDeviceName)) continue;
            return i + 1;
        }
        return 0;
    }

    public void setOptionVoiceRecordDevice(int n) {
        if (SoundDisabled || VoiceManager.VoipDisabled) {
            return;
        }
        if (n < 1) {
            return;
        }
        FMOD_DriverInfo fMOD_DriverInfo = new FMOD_DriverInfo();
        javafmod.FMOD_System_GetRecordDriverInfo((int)(n - 1), (FMOD_DriverInfo)fMOD_DriverInfo);
        OptionVoiceRecordDeviceName = fMOD_DriverInfo.name;
        VoiceManager.instance.UpdateRecordDevice();
    }

    public int getMicVolumeIndicator() {
        return VoiceManager.instance.getMicVolumeIndicator();
    }

    public boolean getMicVolumeError() {
        return VoiceManager.instance.getMicVolumeError();
    }

    public boolean getServerVOIPEnable() {
        return VoiceManager.instance.getServerVOIPEnable();
    }

    public void setTestingMicrophone(boolean bl) {
        VoiceManager.instance.setTestingMicrophone(bl);
    }

    public int getOptionReloadDifficulty() {
        return 2;
    }

    public void setOptionReloadDifficulty(int n) {
        OptionReloadDifficulty = Math.max(1, Math.min(3, n));
    }

    public boolean getOptionRackProgress() {
        return OptionRackProgress;
    }

    public void setOptionRackProgress(boolean bl) {
        OptionRackProgress = bl;
    }

    public int getOptionFontSize() {
        return OptionFontSize;
    }

    public void setOptionFontSize(int n) {
        OptionFontSize = PZMath.clamp(n, 1, 5);
    }

    public String getOptionContextMenuFont() {
        return OptionContextMenuFont;
    }

    public void setOptionContextMenuFont(String string) {
        OptionContextMenuFont = string;
    }

    public String getOptionInventoryFont() {
        return OptionInventoryFont;
    }

    public void setOptionInventoryFont(String string) {
        OptionInventoryFont = string;
    }

    public int getOptionInventoryContainerSize() {
        return OptionInventoryContainerSize;
    }

    public void setOptionInventoryContainerSize(int n) {
        OptionInventoryContainerSize = n;
    }

    public String getOptionTooltipFont() {
        return OptionTooltipFont;
    }

    public void setOptionTooltipFont(String string) {
        OptionTooltipFont = string;
        ObjectTooltip.checkFont();
    }

    public String getOptionMeasurementFormat() {
        return OptionMeasurementFormat;
    }

    public void setOptionMeasurementFormat(String string) {
        OptionMeasurementFormat = string;
    }

    public int getOptionClockFormat() {
        return OptionClockFormat;
    }

    public int getOptionClockSize() {
        return OptionClockSize;
    }

    public void setOptionClockFormat(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 2) {
            n = 2;
        }
        OptionClockFormat = n;
    }

    public void setOptionClockSize(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 2) {
            n = 2;
        }
        OptionClockSize = n;
    }

    public boolean getOptionClock24Hour() {
        return OptionClock24Hour;
    }

    public void setOptionClock24Hour(boolean bl) {
        OptionClock24Hour = bl;
    }

    public boolean getOptionModsEnabled() {
        return OptionModsEnabled;
    }

    public void setOptionModsEnabled(boolean bl) {
        OptionModsEnabled = bl;
    }

    public int getOptionBloodDecals() {
        return OptionBloodDecals;
    }

    public void setOptionBloodDecals(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 10) {
            n = 10;
        }
        OptionBloodDecals = n;
    }

    public boolean getOptionBorderlessWindow() {
        return OptionBorderlessWindow;
    }

    public void setOptionBorderlessWindow(boolean bl) {
        OptionBorderlessWindow = bl;
    }

    public boolean getOptionLockCursorToWindow() {
        return OptionLockCursorToWindow;
    }

    public void setOptionLockCursorToWindow(boolean bl) {
        OptionLockCursorToWindow = bl;
    }

    public boolean getOptionTextureCompression() {
        return OptionTextureCompression;
    }

    public void setOptionTextureCompression(boolean bl) {
        OptionTextureCompression = bl;
    }

    public boolean getOptionTexture2x() {
        return OptionTexture2x;
    }

    public void setOptionTexture2x(boolean bl) {
        OptionTexture2x = bl;
    }

    public int getOptionMaxTextureSize() {
        return OptionMaxTextureSize;
    }

    public void setOptionMaxTextureSize(int n) {
        OptionMaxTextureSize = PZMath.clamp(n, 1, 4);
    }

    public int getOptionMaxVehicleTextureSize() {
        return OptionMaxVehicleTextureSize;
    }

    public void setOptionMaxVehicleTextureSize(int n) {
        OptionMaxVehicleTextureSize = PZMath.clamp(n, 1, 4);
    }

    public int getMaxTextureSizeFromFlags(int n) {
        if ((n & 0x80) != 0) {
            return this.getMaxTextureSize();
        }
        if ((n & 0x100) != 0) {
            return this.getMaxVehicleTextureSize();
        }
        return 32768;
    }

    public int getMaxTextureSizeFromOption(int n) {
        return switch (n) {
            case 1 -> 256;
            case 2 -> 512;
            case 3 -> 1024;
            case 4 -> 2048;
            default -> throw new IllegalStateException("Unexpected value: " + n);
        };
    }

    public int getMaxTextureSize() {
        return this.getMaxTextureSizeFromOption(OptionMaxTextureSize);
    }

    public int getMaxVehicleTextureSize() {
        return this.getMaxTextureSizeFromOption(OptionMaxVehicleTextureSize);
    }

    public boolean getOptionModelTextureMipmaps() {
        return OptionModelTextureMipmaps;
    }

    public void setOptionModelTextureMipmaps(boolean bl) {
        OptionModelTextureMipmaps = bl;
    }

    public String getOptionZoomLevels1x() {
        return OptionZoomLevels1x;
    }

    public void setOptionZoomLevels1x(String string) {
        OptionZoomLevels1x = string == null ? "" : string;
    }

    public String getOptionZoomLevels2x() {
        return OptionZoomLevels2x;
    }

    public void setOptionZoomLevels2x(String string) {
        OptionZoomLevels2x = string == null ? "" : string;
    }

    public ArrayList<Integer> getDefaultZoomLevels() {
        return this.OffscreenBuffer.getDefaultZoomLevels();
    }

    public void setOptionActiveController(int n, boolean bl) {
        if (n < 0 || n >= GameWindow.GameInput.getControllerCount()) {
            return;
        }
        Controller controller = GameWindow.GameInput.getController(n);
        if (controller != null) {
            JoypadManager.instance.setControllerActive(controller.getGUID(), bl);
        }
    }

    public boolean getOptionActiveController(String string) {
        return JoypadManager.instance.ActiveControllerGUIDs.contains(string);
    }

    public boolean isOptionShowChatTimestamp() {
        return OptionShowChatTimestamp;
    }

    public void setOptionShowChatTimestamp(boolean bl) {
        OptionShowChatTimestamp = bl;
    }

    public boolean isOptionShowChatTitle() {
        return OptionShowChatTitle;
    }

    public String getOptionChatFontSize() {
        return OptionChatFontSize;
    }

    public void setOptionChatFontSize(String string) {
        OptionChatFontSize = string;
    }

    public void setOptionShowChatTitle(boolean bl) {
        OptionShowChatTitle = bl;
    }

    public float getOptionMinChatOpaque() {
        return OptionMinChatOpaque;
    }

    public void setOptionMinChatOpaque(float f) {
        OptionMinChatOpaque = f;
    }

    public float getOptionMaxChatOpaque() {
        return OptionMaxChatOpaque;
    }

    public void setOptionMaxChatOpaque(float f) {
        OptionMaxChatOpaque = f;
    }

    public float getOptionChatFadeTime() {
        return OptionChatFadeTime;
    }

    public void setOptionChatFadeTime(float f) {
        OptionChatFadeTime = f;
    }

    public boolean getOptionChatOpaqueOnFocus() {
        return OptionChatOpaqueOnFocus;
    }

    public void setOptionChatOpaqueOnFocus(boolean bl) {
        OptionChatOpaqueOnFocus = bl;
    }

    public boolean getOptionUIFBO() {
        return OptionUIFBO;
    }

    public void setOptionUIFBO(boolean bl) {
        OptionUIFBO = bl;
        if (GameWindow.states.current == IngameState.instance) {
            UIManager.useUIFBO = Core.getInstance().supportsFBO() && OptionUIFBO;
        }
    }

    public int getOptionAimOutline() {
        return OptionAimOutline;
    }

    public void setOptionAimOutline(int n) {
        OptionAimOutline = PZMath.clamp(n, 1, 3);
    }

    public int getOptionUIRenderFPS() {
        return OptionUIRenderFPS;
    }

    public void setOptionUIRenderFPS(int n) {
        OptionUIRenderFPS = n;
    }

    public void setOptionRadialMenuKeyToggle(boolean bl) {
        OptionRadialMenuKeyToggle = bl;
    }

    public boolean getOptionRadialMenuKeyToggle() {
        return OptionRadialMenuKeyToggle;
    }

    public void setOptionReloadRadialInstant(boolean bl) {
        OptionReloadRadialInstant = bl;
    }

    public boolean getOptionReloadRadialInstant() {
        return OptionReloadRadialInstant;
    }

    public void setOptionPanCameraWhileAiming(boolean bl) {
        OptionPanCameraWhileAiming = bl;
    }

    public boolean getOptionPanCameraWhileAiming() {
        return OptionPanCameraWhileAiming;
    }

    public void setOptionPanCameraWhileDriving(boolean bl) {
        OptionPanCameraWhileDriving = bl;
    }

    public boolean getOptionPanCameraWhileDriving() {
        return OptionPanCameraWhileDriving;
    }

    public String getOptionCycleContainerKey() {
        return OptionCycleContainerKey;
    }

    public void setOptionCycleContainerKey(String string) {
        OptionCycleContainerKey = string;
    }

    public boolean getOptionDropItemsOnSquareCenter() {
        return OptionDropItemsOnSquareCenter;
    }

    public void setOptionDropItemsOnSquareCenter(boolean bl) {
        OptionDropItemsOnSquareCenter = bl;
    }

    public boolean getOptionTimedActionGameSpeedReset() {
        return OptionTimedActionGameSpeedReset;
    }

    public void setOptionTimedActionGameSpeedReset(boolean bl) {
        OptionTimedActionGameSpeedReset = bl;
    }

    public int getOptionShoulderButtonContainerSwitch() {
        return OptionShoulderButtonContainerSwitch;
    }

    public void setOptionShoulderButtonContainerSwitch(int n) {
        OptionShoulderButtonContainerSwitch = n;
    }

    public boolean getOptionSingleContextMenu(int n) {
        return OptionSingleContextMenu[n];
    }

    public void setOptionSingleContextMenu(int n, boolean bl) {
        Core.OptionSingleContextMenu[n] = bl;
    }

    public boolean getOptionAutoDrink() {
        return OptionAutoDrink;
    }

    public void setOptionAutoDrink(boolean bl) {
        OptionAutoDrink = bl;
    }

    public boolean getOptionAutoWalkContainer() {
        return OptionAutoWalkContainer;
    }

    public void setOptionAutoWalkContainer(boolean bl) {
        OptionAutoWalkContainer = bl;
    }

    public boolean getOptionCorpseShadows() {
        return OptionCorpseShadows;
    }

    public void setOptionCorpseShadows(boolean bl) {
        OptionCorpseShadows = bl;
    }

    public boolean getOptionLeaveKeyInIgnition() {
        return OptionLeaveKeyInIgnition;
    }

    public void setOptionLeaveKeyInIgnition(boolean bl) {
        OptionLeaveKeyInIgnition = bl;
    }

    public int getOptionSearchModeOverlayEffect() {
        return OptionSearchModeOverlayEffect;
    }

    public void setOptionSearchModeOverlayEffect(int n) {
        OptionSearchModeOverlayEffect = n;
    }

    public int getOptionSimpleClothingTextures() {
        return OptionSimpleClothingTextures;
    }

    public void setOptionSimpleClothingTextures(int n) {
        OptionSimpleClothingTextures = PZMath.clamp(n, 1, 3);
    }

    public boolean isOptionSimpleClothingTextures(boolean bl) {
        switch (OptionSimpleClothingTextures) {
            case 1: {
                return false;
            }
            case 2: {
                return bl;
            }
        }
        return true;
    }

    public boolean getOptionSimpleWeaponTextures() {
        return OptionSimpleWeaponTextures;
    }

    public void setOptionSimpleWeaponTextures(boolean bl) {
        OptionSimpleWeaponTextures = bl;
    }

    public int getOptionIgnoreProneZombieRange() {
        return OptionIgnoreProneZombieRange;
    }

    public void setOptionIgnoreProneZombieRange(int n) {
        OptionIgnoreProneZombieRange = PZMath.clamp(n, 1, 5);
    }

    public float getIgnoreProneZombieRange() {
        switch (OptionIgnoreProneZombieRange) {
            case 1: {
                return -1.0f;
            }
            case 2: {
                return 1.5f;
            }
            case 3: {
                return 2.0f;
            }
            case 4: {
                return 2.5f;
            }
            case 5: {
                return 3.0f;
            }
        }
        return -1.0f;
    }

    private void readPerPlayerBoolean(String string, boolean[] blArray) {
        Arrays.fill(blArray, false);
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length && i != 4; ++i) {
            blArray[i] = StringUtils.tryParseBoolean(stringArray[i]);
        }
    }

    private String getPerPlayerBooleanString(boolean[] blArray) {
        return String.format("%b,%b,%b,%b", blArray[0], blArray[1], blArray[2], blArray[3]);
    }

    @Deprecated
    public void ResetLua(boolean bl, String string) throws IOException {
        this.ResetLua("default", string);
    }

    public void ResetLua(String string, String string2) throws IOException {
        if (SpriteRenderer.instance != null) {
            GameWindow.DrawReloadingLua = true;
            GameWindow.render();
            GameWindow.DrawReloadingLua = false;
        }
        RenderThread.setWaitForRenderState(false);
        SpriteRenderer.instance.notifyRenderStateQueue();
        ScriptManager.instance.Reset();
        ClothingDecals.Reset();
        BeardStyles.Reset();
        HairStyles.Reset();
        OutfitManager.Reset();
        AnimationSet.Reset();
        GameSounds.Reset();
        VehicleType.Reset();
        LuaEventManager.Reset();
        MapObjects.Reset();
        UIManager.init();
        SurvivorFactory.Reset();
        ProfessionFactory.Reset();
        TraitFactory.Reset();
        ChooseGameInfo.Reset();
        AttachedLocations.Reset();
        BodyLocations.Reset();
        ContainerOverlays.instance.Reset();
        BentFences.getInstance().Reset();
        BrokenFences.getInstance().Reset();
        TileOverlays.instance.Reset();
        LuaHookManager.Reset();
        CustomPerks.Reset();
        PerkFactory.Reset();
        CustomSandboxOptions.Reset();
        SandboxOptions.Reset();
        WorldMap.Reset();
        LuaManager.init();
        JoypadManager.instance.Reset();
        GameKeyboard.doLuaKeyPressed = true;
        Texture.nullTextures.clear();
        ZomboidFileSystem.instance.Reset();
        ZomboidFileSystem.instance.init();
        ZomboidFileSystem.instance.loadMods(string);
        ZomboidFileSystem.instance.loadModPackFiles();
        Languages.instance.init();
        Translator.loadFiles();
        CustomPerks.instance.init();
        CustomPerks.instance.initLua();
        CustomSandboxOptions.instance.init();
        CustomSandboxOptions.instance.initInstance(SandboxOptions.instance);
        ScriptManager.instance.Load();
        ModelManager.instance.initAnimationMeshes(true);
        ModelManager.instance.loadModAnimations();
        ClothingDecals.init();
        BeardStyles.init();
        HairStyles.init();
        OutfitManager.init();
        try {
            TextManager.instance.Init();
            LuaManager.LoadDirBase();
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            GameWindow.DoLoadingText("Reloading Lua - ERRORS!");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ZomboidGlobals.Load();
        RenderThread.setWaitForRenderState(true);
        LuaEventManager.triggerEvent("OnGameBoot");
        LuaEventManager.triggerEvent("OnMainMenuEnter");
        LuaEventManager.triggerEvent("OnResetLua", string2);
    }

    public void DelayResetLua(String string, String string2) {
        this.m_delayResetLua_activeMods = string;
        this.m_delayResetLua_reason = string2;
    }

    public void CheckDelayResetLua() throws IOException {
        if (this.m_delayResetLua_activeMods != null) {
            String string = this.m_delayResetLua_activeMods;
            String string2 = this.m_delayResetLua_reason;
            this.m_delayResetLua_activeMods = null;
            this.m_delayResetLua_reason = null;
            this.ResetLua(string, string2);
        }
    }

    public boolean isShowPing() {
        return this.showPing;
    }

    public void setShowPing(boolean bl) {
        this.showPing = bl;
    }

    public boolean isForceSnow() {
        return this.forceSnow;
    }

    public void setForceSnow(boolean bl) {
        this.forceSnow = bl;
    }

    public boolean isZombieGroupSound() {
        return this.zombieGroupSound;
    }

    public void setZombieGroupSound(boolean bl) {
        this.zombieGroupSound = bl;
    }

    public String getBlinkingMoodle() {
        return this.blinkingMoodle;
    }

    public void setBlinkingMoodle(String string) {
        this.blinkingMoodle = string;
    }

    public boolean isTutorialDone() {
        return this.tutorialDone;
    }

    public void setTutorialDone(boolean bl) {
        this.tutorialDone = bl;
    }

    public boolean isVehiclesWarningShow() {
        return this.vehiclesWarningShow;
    }

    public void setVehiclesWarningShow(boolean bl) {
        this.vehiclesWarningShow = bl;
    }

    public void initPoisonousBerry() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Base.BerryGeneric1");
        arrayList.add("Base.BerryGeneric2");
        arrayList.add("Base.BerryGeneric3");
        arrayList.add("Base.BerryGeneric4");
        arrayList.add("Base.BerryGeneric5");
        arrayList.add("Base.BerryPoisonIvy");
        this.setPoisonousBerry((String)arrayList.get(Rand.Next(0, arrayList.size() - 1)));
    }

    public void initPoisonousMushroom() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Base.MushroomGeneric1");
        arrayList.add("Base.MushroomGeneric2");
        arrayList.add("Base.MushroomGeneric3");
        arrayList.add("Base.MushroomGeneric4");
        arrayList.add("Base.MushroomGeneric5");
        arrayList.add("Base.MushroomGeneric6");
        arrayList.add("Base.MushroomGeneric7");
        this.setPoisonousMushroom((String)arrayList.get(Rand.Next(0, arrayList.size() - 1)));
    }

    public String getPoisonousBerry() {
        return this.poisonousBerry;
    }

    public void setPoisonousBerry(String string) {
        this.poisonousBerry = string;
    }

    public String getPoisonousMushroom() {
        return this.poisonousMushroom;
    }

    public void setPoisonousMushroom(String string) {
        this.poisonousMushroom = string;
    }

    public static String getDifficulty() {
        return difficulty;
    }

    public static void setDifficulty(String string) {
        difficulty = string;
    }

    public boolean isDoneNewSaveFolder() {
        return this.doneNewSaveFolder;
    }

    public void setDoneNewSaveFolder(boolean bl) {
        this.doneNewSaveFolder = bl;
    }

    public static int getTileScale() {
        return TileScale;
    }

    public boolean isSelectingAll() {
        return this.isSelectingAll;
    }

    public void setIsSelectingAll(boolean bl) {
        this.isSelectingAll = bl;
    }

    public boolean getContentTranslationsEnabled() {
        return OptionEnableContentTranslations;
    }

    public void setContentTranslationsEnabled(boolean bl) {
        OptionEnableContentTranslations = bl;
    }

    public boolean isShowYourUsername() {
        return this.showYourUsername;
    }

    public void setShowYourUsername(boolean bl) {
        this.showYourUsername = bl;
    }

    public ColorInfo getMpTextColor() {
        if (this.mpTextColor == null) {
            this.mpTextColor = new ColorInfo((float)(Rand.Next(135) + 120) / 255.0f, (float)(Rand.Next(135) + 120) / 255.0f, (float)(Rand.Next(135) + 120) / 255.0f, 1.0f);
        }
        return this.mpTextColor;
    }

    public void setMpTextColor(ColorInfo colorInfo) {
        if (colorInfo.r < 0.19f) {
            colorInfo.r = 0.19f;
        }
        if (colorInfo.g < 0.19f) {
            colorInfo.g = 0.19f;
        }
        if (colorInfo.b < 0.19f) {
            colorInfo.b = 0.19f;
        }
        this.mpTextColor = colorInfo;
    }

    public boolean isAzerty() {
        return this.isAzerty;
    }

    public void setAzerty(boolean bl) {
        this.isAzerty = bl;
    }

    public ColorInfo getObjectHighlitedColor() {
        return this.objectHighlitedColor;
    }

    public void setObjectHighlitedColor(ColorInfo colorInfo) {
        this.objectHighlitedColor.set(colorInfo);
    }

    public ColorInfo getGoodHighlitedColor() {
        return this.goodHighlitedColor;
    }

    public void setGoodHighlitedColor(ColorInfo colorInfo) {
        this.goodHighlitedColor.set(colorInfo);
    }

    public ColorInfo getBadHighlitedColor() {
        return this.badHighlitedColor;
    }

    public void setBadHighlitedColor(ColorInfo colorInfo) {
        this.badHighlitedColor.set(colorInfo);
    }

    public String getSeenUpdateText() {
        return this.seenUpdateText;
    }

    public void setSeenUpdateText(String string) {
        this.seenUpdateText = string;
    }

    public boolean isToggleToAim() {
        return this.toggleToAim;
    }

    public void setToggleToAim(boolean bl) {
        this.toggleToAim = bl;
    }

    public boolean isToggleToRun() {
        return this.toggleToRun;
    }

    public void setToggleToRun(boolean bl) {
        this.toggleToRun = bl;
    }

    public int getXAngle(int n, float f) {
        double d = Math.toRadians(225.0f + f);
        int n2 = new Long(Math.round((Math.sqrt(2.0) * Math.cos(d) + 1.0) * (double)(n / 2))).intValue();
        return n2;
    }

    public int getYAngle(int n, float f) {
        double d = Math.toRadians(225.0f + f);
        int n2 = new Long(Math.round((Math.sqrt(2.0) * Math.sin(d) + 1.0) * (double)(n / 2))).intValue();
        return n2;
    }

    public boolean isCelsius() {
        return this.celsius;
    }

    public void setCelsius(boolean bl) {
        this.celsius = bl;
    }

    public boolean isInDebug() {
        return bDebug;
    }

    public boolean isRiversideDone() {
        return this.riversideDone;
    }

    public void setRiversideDone(boolean bl) {
        this.riversideDone = bl;
    }

    public boolean isNoSave() {
        return this.noSave;
    }

    public void setNoSave(boolean bl) {
        this.noSave = bl;
    }

    public boolean isShowFirstTimeVehicleTutorial() {
        return this.showFirstTimeVehicleTutorial;
    }

    public void setShowFirstTimeVehicleTutorial(boolean bl) {
        this.showFirstTimeVehicleTutorial = bl;
    }

    public boolean getOptionDisplayAsCelsius() {
        return OptionTemperatureDisplayCelsius;
    }

    public void setOptionDisplayAsCelsius(boolean bl) {
        OptionTemperatureDisplayCelsius = bl;
    }

    public boolean isShowFirstTimeWeatherTutorial() {
        return this.showFirstTimeWeatherTutorial;
    }

    public void setShowFirstTimeWeatherTutorial(boolean bl) {
        this.showFirstTimeWeatherTutorial = bl;
    }

    public boolean getOptionDoWindSpriteEffects() {
        return OptionDoWindSpriteEffects;
    }

    public void setOptionDoWindSpriteEffects(boolean bl) {
        OptionDoWindSpriteEffects = bl;
    }

    public boolean getOptionDoDoorSpriteEffects() {
        return OptionDoDoorSpriteEffects;
    }

    public void setOptionDoDoorSpriteEffects(boolean bl) {
        OptionDoDoorSpriteEffects = bl;
    }

    public boolean getOptionDoContainerOutline() {
        return OptionDoContainerOutline;
    }

    public void setOptionDoContainerOutline(boolean bl) {
        OptionDoContainerOutline = bl;
    }

    public void setOptionUpdateSneakButton(boolean bl) {
        OptionUpdateSneakButton = bl;
    }

    public boolean getOptionUpdateSneakButton() {
        return OptionUpdateSneakButton;
    }

    public boolean isNewReloading() {
        return this.newReloading;
    }

    public void setNewReloading(boolean bl) {
        this.newReloading = bl;
    }

    public boolean isShowFirstTimeSneakTutorial() {
        return this.showFirstTimeSneakTutorial;
    }

    public void setShowFirstTimeSneakTutorial(boolean bl) {
        this.showFirstTimeSneakTutorial = bl;
    }

    public boolean isShowFirstTimeSearchTutorial() {
        return this.showFirstTimeSearchTutorial;
    }

    public void setShowFirstTimeSearchTutorial(boolean bl) {
        this.showFirstTimeSearchTutorial = bl;
    }

    public int getTermsOfServiceVersion() {
        return this.termsOfServiceVersion;
    }

    public void setTermsOfServiceVersion(int n) {
        this.termsOfServiceVersion = n;
    }

    public void setOptiondblTapJogToSprint(boolean bl) {
        OptiondblTapJogToSprint = bl;
    }

    public boolean isOptiondblTapJogToSprint() {
        return OptiondblTapJogToSprint;
    }

    public boolean isToggleToSprint() {
        return this.toggleToSprint;
    }

    public void setToggleToSprint(boolean bl) {
        this.toggleToSprint = bl;
    }

    public int getIsoCursorVisibility() {
        return this.isoCursorVisibility;
    }

    public void setIsoCursorVisibility(int n) {
        this.isoCursorVisibility = n;
    }

    public boolean getOptionShowCursorWhileAiming() {
        return OptionShowCursorWhileAiming;
    }

    public void setOptionShowCursorWhileAiming(boolean bl) {
        OptionShowCursorWhileAiming = bl;
    }

    public boolean gotNewBelt() {
        return this.gotNewBelt;
    }

    public void setGotNewBelt(boolean bl) {
        this.gotNewBelt = bl;
    }

    public void setAnimPopupDone(boolean bl) {
        this.bAnimPopupDone = bl;
    }

    public boolean isAnimPopupDone() {
        return this.bAnimPopupDone;
    }

    public void setModsPopupDone(boolean bl) {
        this.bModsPopupDone = bl;
    }

    public boolean isModsPopupDone() {
        return this.bModsPopupDone;
    }

    public boolean isRenderPrecipIndoors() {
        return OptionRenderPrecipIndoors;
    }

    public void setRenderPrecipIndoors(boolean bl) {
        OptionRenderPrecipIndoors = bl;
    }

    public boolean isCollideZombies() {
        return this.collideZombies;
    }

    public void setCollideZombies(boolean bl) {
        this.collideZombies = bl;
    }

    public boolean isFlashIsoCursor() {
        return this.flashIsoCursor;
    }

    public void setFlashIsoCursor(boolean bl) {
        this.flashIsoCursor = bl;
    }

    public boolean isOptionProgressBar() {
        return true;
    }

    public void setOptionProgressBar(boolean bl) {
        OptionProgressBar = bl;
    }

    public void setOptionLanguageName(String string) {
        OptionLanguageName = string;
    }

    public String getOptionLanguageName() {
        return OptionLanguageName;
    }

    public int getOptionRenderPrecipitation() {
        return OptionRenderPrecipitation;
    }

    public void setOptionRenderPrecipitation(int n) {
        OptionRenderPrecipitation = n;
    }

    public void setOptionAutoProneAtk(boolean bl) {
        OptionAutoProneAtk = bl;
    }

    public boolean isOptionAutoProneAtk() {
        return OptionAutoProneAtk;
    }

    public void setOption3DGroundItem(boolean bl) {
        Option3DGroundItem = bl;
    }

    public boolean isOption3DGroundItem() {
        return Option3DGroundItem;
    }

    public Object getOptionOnStartup(String string) {
        return optionsOnStartup.get(string);
    }

    public void setOptionOnStartup(String string, Object object) {
        optionsOnStartup.put(string, object);
    }

    public void countMissing3DItems() {
        ArrayList<Item> arrayList = ScriptManager.instance.getAllItems();
        int n = 0;
        for (Item item : arrayList) {
            if (item.type == Item.Type.Weapon || item.type == Item.Type.Moveable || item.name.contains("ZedDmg") || item.name.contains("Wound") || item.name.contains("MakeUp") || item.name.contains("Bandage") || item.name.contains("Hat") || item.getObsolete() || !StringUtils.isNullOrEmpty(item.worldObjectSprite) || !StringUtils.isNullOrEmpty(item.worldStaticModel)) continue;
            System.out.println("Missing: " + item.name);
            ++n;
        }
        System.out.println("total missing: " + n + "/" + arrayList.size());
    }

    public boolean getOptionShowItemModInfo() {
        return OptionShowItemModInfo;
    }

    public void setOptionShowItemModInfo(boolean bl) {
        OptionShowItemModInfo = bl;
    }

    public boolean getOptionShowSurvivalGuide() {
        return this.OptionShowSurvivalGuide;
    }

    public void setOptionShowSurvivalGuide(boolean bl) {
        this.OptionShowSurvivalGuide = bl;
    }

    public boolean getOptionEnableLeftJoystickRadialMenu() {
        return OptionEnableLeftJoystickRadialMenu;
    }

    public void setOptionEnableLeftJoystickRadialMenu(boolean bl) {
        OptionEnableLeftJoystickRadialMenu = bl;
    }

    public String getVersionNumber() {
        return gameVersion.toString();
    }

    static {
        fakefullscreen = false;
        gameVersion = new GameVersion(41, 78, "");
        bAltMoveMethod = false;
        OptionShowCursorWhileAiming = false;
        OptionZoom = true;
        OptionModsEnabled = true;
        OptionFontSize = 1;
        OptionContextMenuFont = "Medium";
        OptionInventoryFont = "Medium";
        OptionInventoryContainerSize = 1;
        OptionTooltipFont = "Small";
        OptionMeasurementFormat = "Metric";
        OptionClockFormat = 1;
        OptionClockSize = 2;
        OptionClock24Hour = true;
        OptionVSync = false;
        OptionSoundVolume = 8;
        OptionMusicVolume = 6;
        OptionAmbientVolume = 5;
        OptionJumpScareVolume = 10;
        OptionMusicActionStyle = 0;
        OptionMusicLibrary = 1;
        OptionVoiceEnable = true;
        OptionVoiceMode = 3;
        OptionVoiceVADMode = 3;
        OptionVoiceAGCMode = 2;
        OptionVoiceRecordDeviceName = "";
        OptionVoiceVolumeMic = 10;
        OptionVoiceVolumePlayers = 5;
        OptionVehicleEngineVolume = 5;
        OptionReloadDifficulty = 2;
        OptionRackProgress = true;
        OptionBloodDecals = 10;
        OptionBorderlessWindow = false;
        OptionLockCursorToWindow = false;
        OptionTextureCompression = true;
        OptionModelTextureMipmaps = false;
        OptionTexture2x = true;
        OptionMaxTextureSize = 1;
        OptionMaxVehicleTextureSize = 2;
        OptionZoomLevels1x = "";
        OptionZoomLevels2x = "";
        OptionEnableContentTranslations = true;
        OptionUIFBO = true;
        OptionUIRenderFPS = 20;
        OptionRadialMenuKeyToggle = true;
        OptionReloadRadialInstant = false;
        OptionPanCameraWhileAiming = true;
        OptionPanCameraWhileDriving = false;
        OptionShowChatTimestamp = false;
        OptionShowChatTitle = false;
        OptionChatFontSize = "medium";
        OptionMinChatOpaque = 1.0f;
        OptionMaxChatOpaque = 1.0f;
        OptionChatFadeTime = 0.0f;
        OptionChatOpaqueOnFocus = true;
        OptionTemperatureDisplayCelsius = false;
        OptionDoWindSpriteEffects = true;
        OptionDoDoorSpriteEffects = true;
        OptionDoContainerOutline = true;
        OptionRenderPrecipIndoors = true;
        OptionAutoProneAtk = true;
        Option3DGroundItem = true;
        OptionRenderPrecipitation = 1;
        OptionUpdateSneakButton = true;
        OptiondblTapJogToSprint = false;
        OptionAimOutline = 2;
        OptionCycleContainerKey = "shift";
        OptionDropItemsOnSquareCenter = false;
        OptionTimedActionGameSpeedReset = false;
        OptionShoulderButtonContainerSwitch = 1;
        OptionProgressBar = false;
        OptionLanguageName = null;
        OptionSingleContextMenu = new boolean[4];
        OptionCorpseShadows = true;
        OptionSimpleClothingTextures = 1;
        OptionSimpleWeaponTextures = false;
        OptionAutoDrink = true;
        OptionLeaveKeyInIgnition = false;
        OptionAutoWalkContainer = false;
        OptionSearchModeOverlayEffect = 1;
        OptionIgnoreProneZombieRange = 2;
        OptionShowItemModInfo = true;
        OptionEnableLeftJoystickRadialMenu = true;
        difficulty = "Hardcore";
        TileScale = 2;
        blinkAlpha = 1.0f;
        blinkAlphaIncrease = false;
        optionsOnStartup = new HashMap();
        width = 1280;
        height = 720;
        MaxJukeBoxesActive = 10;
        NumJukeBoxesActive = 0;
        GameMode = "Sandbox";
        glMajorVersion = -1;
        core = new Core();
        bDebug = false;
        CurrentTextEntryBox = null;
        fullScreen = false;
        bAutoZoom = new boolean[4];
        GameMap = "DEFAULT";
        GameSaveWorld = "";
        SafeMode = false;
        SafeModeForced = false;
        SoundDisabled = false;
        xx = 0;
        yy = 0;
        zz = 0;
        bLastStand = false;
        ChallengeID = null;
        bExiting = false;
    }
}

