/*
 * Decompiled with CFR 0.152.
 */
package zombie.core;

import java.io.Serializable;
import zombie.core.Colors;
import zombie.core.math.PZMath;

public final class Color
implements Serializable {
    private static final long serialVersionUID = 1393939L;
    public static final Color transparent = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Color white = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Color yellow = new Color(1.0f, 1.0f, 0.0f, 1.0f);
    public static final Color red = new Color(1.0f, 0.0f, 0.0f, 1.0f);
    public static final Color purple = new Color(196.0f, 0.0f, 171.0f);
    public static final Color blue = new Color(0.0f, 0.0f, 1.0f, 1.0f);
    public static final Color green = new Color(0.0f, 1.0f, 0.0f, 1.0f);
    public static final Color black = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Color gray = new Color(0.5f, 0.5f, 0.5f, 1.0f);
    public static final Color cyan = new Color(0.0f, 1.0f, 1.0f, 1.0f);
    public static final Color darkGray = new Color(0.3f, 0.3f, 0.3f, 1.0f);
    public static final Color lightGray = new Color(0.7f, 0.7f, 0.7f, 1.0f);
    public static final Color pink = new Color(255, 175, 175, 255);
    public static final Color orange = new Color(255, 200, 0, 255);
    public static final Color magenta = new Color(255, 0, 255, 255);
    public static final Color darkGreen = new Color(22, 113, 20, 255);
    public static final Color lightGreen = new Color(55, 148, 53, 255);
    public float a = 1.0f;
    public float b;
    public float g;
    public float r;

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public Color() {
    }

    public Color(Color color) {
        if (color == null) {
            this.r = 0.0f;
            this.g = 0.0f;
            this.b = 0.0f;
            this.a = 1.0f;
            return;
        }
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.a = color.a;
    }

    public Color(float f, float f2, float f3) {
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.a = 1.0f;
    }

    public Color(float f, float f2, float f3, float f4) {
        this.r = PZMath.clamp(f, 0.0f, 1.0f);
        this.g = PZMath.clamp(f2, 0.0f, 1.0f);
        this.b = PZMath.clamp(f3, 0.0f, 1.0f);
        this.a = PZMath.clamp(f4, 0.0f, 1.0f);
    }

    public Color(Color color, Color color2, float f) {
        float f2 = (color2.r - color.r) * f;
        float f3 = (color2.g - color.g) * f;
        float f4 = (color2.b - color.b) * f;
        float f5 = (color2.a - color.a) * f;
        this.r = color.r + f2;
        this.g = color.g + f3;
        this.b = color.b + f4;
        this.a = color.a + f5;
    }

    public void setColor(Color color, Color color2, float f) {
        float f2 = (color2.r - color.r) * f;
        float f3 = (color2.g - color.g) * f;
        float f4 = (color2.b - color.b) * f;
        float f5 = (color2.a - color.a) * f;
        this.r = color.r + f2;
        this.g = color.g + f3;
        this.b = color.b + f4;
        this.a = color.a + f5;
    }

    public Color(int n, int n2, int n3) {
        this.r = (float)n / 255.0f;
        this.g = (float)n2 / 255.0f;
        this.b = (float)n3 / 255.0f;
        this.a = 1.0f;
    }

    public Color(int n, int n2, int n3, int n4) {
        this.r = (float)n / 255.0f;
        this.g = (float)n2 / 255.0f;
        this.b = (float)n3 / 255.0f;
        this.a = (float)n4 / 255.0f;
    }

    public Color(int n) {
        int n2 = (n & 0xFF0000) >> 16;
        int n3 = (n & 0xFF00) >> 8;
        int n4 = n & 0xFF;
        int n5 = (n & 0xFF000000) >> 24;
        if (n5 < 0) {
            n5 += 256;
        }
        if (n5 == 0) {
            n5 = 255;
        }
        this.r = (float)n4 / 255.0f;
        this.g = (float)n3 / 255.0f;
        this.b = (float)n2 / 255.0f;
        this.a = (float)n5 / 255.0f;
    }

    @Deprecated
    public void fromColor(int n) {
        int n2 = (n & 0xFF0000) >> 16;
        int n3 = (n & 0xFF00) >> 8;
        int n4 = n & 0xFF;
        int n5 = (n & 0xFF000000) >> 24;
        if (n5 < 0) {
            n5 += 256;
        }
        if (n5 == 0) {
            n5 = 255;
        }
        this.r = (float)n4 / 255.0f;
        this.g = (float)n3 / 255.0f;
        this.b = (float)n2 / 255.0f;
        this.a = (float)n5 / 255.0f;
    }

    public void setABGR(int n) {
        Color.abgrToColor(n, this);
    }

    public static Color abgrToColor(int n, Color color) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        float f = 0.003921569f * (float)n5;
        float f2 = 0.003921569f * (float)n4;
        float f3 = 0.003921569f * (float)n3;
        float f4 = 0.003921569f * (float)n2;
        color.r = f;
        color.g = f2;
        color.b = f3;
        color.a = f4;
        return color;
    }

    public static int colorToABGR(Color color) {
        return Color.colorToABGR(color.r, color.g, color.b, color.a);
    }

    public static int colorToABGR(float f, float f2, float f3, float f4) {
        f = PZMath.clamp(f, 0.0f, 1.0f);
        f2 = PZMath.clamp(f2, 0.0f, 1.0f);
        f3 = PZMath.clamp(f3, 0.0f, 1.0f);
        f4 = PZMath.clamp(f4, 0.0f, 1.0f);
        int n = (int)(f * 255.0f);
        int n2 = (int)(f2 * 255.0f);
        int n3 = (int)(f3 * 255.0f);
        int n4 = (int)(f4 * 255.0f);
        int n5 = (n4 & 0xFF) << 24 | (n3 & 0xFF) << 16 | (n2 & 0xFF) << 8 | n & 0xFF;
        return n5;
    }

    public static int multiplyABGR(int n, int n2) {
        float f = Color.getRedChannelFromABGR(n);
        float f2 = Color.getGreenChannelFromABGR(n);
        float f3 = Color.getBlueChannelFromABGR(n);
        float f4 = Color.getAlphaChannelFromABGR(n);
        float f5 = Color.getRedChannelFromABGR(n2);
        float f6 = Color.getGreenChannelFromABGR(n2);
        float f7 = Color.getBlueChannelFromABGR(n2);
        float f8 = Color.getAlphaChannelFromABGR(n2);
        return Color.colorToABGR(f * f5, f2 * f6, f3 * f7, f4 * f8);
    }

    public static int multiplyBGR(int n, int n2) {
        float f = Color.getRedChannelFromABGR(n);
        float f2 = Color.getGreenChannelFromABGR(n);
        float f3 = Color.getBlueChannelFromABGR(n);
        float f4 = Color.getAlphaChannelFromABGR(n);
        float f5 = Color.getRedChannelFromABGR(n2);
        float f6 = Color.getGreenChannelFromABGR(n2);
        float f7 = Color.getBlueChannelFromABGR(n2);
        return Color.colorToABGR(f * f5, f2 * f6, f3 * f7, f4);
    }

    public static int blendBGR(int n, int n2) {
        float f = Color.getRedChannelFromABGR(n);
        float f2 = Color.getGreenChannelFromABGR(n);
        float f3 = Color.getBlueChannelFromABGR(n);
        float f4 = Color.getAlphaChannelFromABGR(n);
        float f5 = Color.getRedChannelFromABGR(n2);
        float f6 = Color.getGreenChannelFromABGR(n2);
        float f7 = Color.getBlueChannelFromABGR(n2);
        float f8 = Color.getAlphaChannelFromABGR(n2);
        return Color.colorToABGR(f * (1.0f - f8) + f5 * f8, f2 * (1.0f - f8) + f6 * f8, f3 * (1.0f - f8) + f7 * f8, f4);
    }

    public static int blendABGR(int n, int n2) {
        float f = Color.getRedChannelFromABGR(n);
        float f2 = Color.getGreenChannelFromABGR(n);
        float f3 = Color.getBlueChannelFromABGR(n);
        float f4 = Color.getAlphaChannelFromABGR(n);
        float f5 = Color.getRedChannelFromABGR(n2);
        float f6 = Color.getGreenChannelFromABGR(n2);
        float f7 = Color.getBlueChannelFromABGR(n2);
        float f8 = Color.getAlphaChannelFromABGR(n2);
        return Color.colorToABGR(f * (1.0f - f8) + f5 * f8, f2 * (1.0f - f8) + f6 * f8, f3 * (1.0f - f8) + f7 * f8, f4 * (1.0f - f8) + f8 * f8);
    }

    public static int tintABGR(int n, int n2) {
        float f = Color.getRedChannelFromABGR(n2);
        float f2 = Color.getGreenChannelFromABGR(n2);
        float f3 = Color.getBlueChannelFromABGR(n2);
        float f4 = Color.getAlphaChannelFromABGR(n2);
        float f5 = Color.getRedChannelFromABGR(n);
        float f6 = Color.getGreenChannelFromABGR(n);
        float f7 = Color.getBlueChannelFromABGR(n);
        float f8 = Color.getAlphaChannelFromABGR(n);
        return Color.colorToABGR(f * f4 + f5 * (1.0f - f4), f2 * f4 + f6 * (1.0f - f4), f3 * f4 + f7 * (1.0f - f4), f8);
    }

    public static int lerpABGR(int n, int n2, float f) {
        float f2 = Color.getRedChannelFromABGR(n);
        float f3 = Color.getGreenChannelFromABGR(n);
        float f4 = Color.getBlueChannelFromABGR(n);
        float f5 = Color.getAlphaChannelFromABGR(n);
        float f6 = Color.getRedChannelFromABGR(n2);
        float f7 = Color.getGreenChannelFromABGR(n2);
        float f8 = Color.getBlueChannelFromABGR(n2);
        float f9 = Color.getAlphaChannelFromABGR(n2);
        return Color.colorToABGR(f2 * (1.0f - f) + f6 * f, f3 * (1.0f - f) + f7 * f, f4 * (1.0f - f) + f8 * f, f5 * (1.0f - f) + f9 * f);
    }

    public static float getAlphaChannelFromABGR(int n) {
        int n2 = n >> 24 & 0xFF;
        float f = 0.003921569f * (float)n2;
        return f;
    }

    public static float getBlueChannelFromABGR(int n) {
        int n2 = n >> 16 & 0xFF;
        float f = 0.003921569f * (float)n2;
        return f;
    }

    public static float getGreenChannelFromABGR(int n) {
        int n2 = n >> 8 & 0xFF;
        float f = 0.003921569f * (float)n2;
        return f;
    }

    public static float getRedChannelFromABGR(int n) {
        int n2 = n & 0xFF;
        float f = 0.003921569f * (float)n2;
        return f;
    }

    public static int setAlphaChannelToABGR(int n, float f) {
        f = PZMath.clamp(f, 0.0f, 1.0f);
        int n2 = (int)(f * 255.0f);
        int n3 = (n2 & 0xFF) << 24 | n & 0xFFFFFF;
        return n3;
    }

    public static int setBlueChannelToABGR(int n, float f) {
        f = PZMath.clamp(f, 0.0f, 1.0f);
        int n2 = (int)(f * 255.0f);
        int n3 = (n2 & 0xFF) << 16 | n & 0xFF00FFFF;
        return n3;
    }

    public static int setGreenChannelToABGR(int n, float f) {
        f = PZMath.clamp(f, 0.0f, 1.0f);
        int n2 = (int)(f * 255.0f);
        int n3 = (n2 & 0xFF) << 8 | n & 0xFFFF00FF;
        return n3;
    }

    public static int setRedChannelToABGR(int n, float f) {
        f = PZMath.clamp(f, 0.0f, 1.0f);
        int n2 = (int)(f * 255.0f);
        int n3 = n2 & 0xFF | n & 0xFFFFFF00;
        return n3;
    }

    public static Color random() {
        return Colors.GetRandomColor();
    }

    public static Color decode(String string) {
        return new Color(Integer.decode(string));
    }

    public void add(Color color) {
        this.r += color.r;
        this.g += color.g;
        this.b += color.b;
        this.a += color.a;
    }

    public Color addToCopy(Color color) {
        Color color2 = new Color(this.r, this.g, this.b, this.a);
        color2.r += color.r;
        color2.g += color.g;
        color2.b += color.b;
        color2.a += color.a;
        return color2;
    }

    public Color brighter() {
        return this.brighter(0.2f);
    }

    public Color brighter(float f) {
        this.r = this.r += f;
        this.g = this.g += f;
        this.b = this.b += f;
        return this;
    }

    public Color darker() {
        return this.darker(0.5f);
    }

    public Color darker(float f) {
        this.r = this.r -= f;
        this.g = this.g -= f;
        this.b = this.b -= f;
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof Color) {
            Color color = (Color)object;
            return color.r == this.r && color.g == this.g && color.b == this.b && color.a == this.a;
        }
        return false;
    }

    public Color set(Color color) {
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.a = color.a;
        return this;
    }

    public Color set(float f, float f2, float f3) {
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.a = 1.0f;
        return this;
    }

    public Color set(float f, float f2, float f3, float f4) {
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.a = f4;
        return this;
    }

    public int getAlpha() {
        return (int)(this.a * 255.0f);
    }

    public float getAlphaFloat() {
        return this.a;
    }

    public float getRedFloat() {
        return this.r;
    }

    public float getGreenFloat() {
        return this.g;
    }

    public float getBlueFloat() {
        return this.b;
    }

    public int getAlphaByte() {
        return (int)(this.a * 255.0f);
    }

    public int getBlue() {
        return (int)(this.b * 255.0f);
    }

    public int getBlueByte() {
        return (int)(this.b * 255.0f);
    }

    public int getGreen() {
        return (int)(this.g * 255.0f);
    }

    public int getGreenByte() {
        return (int)(this.g * 255.0f);
    }

    public int getRed() {
        return (int)(this.r * 255.0f);
    }

    public int getRedByte() {
        return (int)(this.r * 255.0f);
    }

    public int hashCode() {
        return (int)(this.r + this.g + this.b + this.a) * 255;
    }

    public Color multiply(Color color) {
        return new Color(this.r * color.r, this.g * color.g, this.b * color.b, this.a * color.a);
    }

    public Color scale(float f) {
        this.r *= f;
        this.g *= f;
        this.b *= f;
        this.a *= f;
        return this;
    }

    public Color scaleCopy(float f) {
        Color color = new Color(this.r, this.g, this.b, this.a);
        color.r *= f;
        color.g *= f;
        color.b *= f;
        color.a *= f;
        return color;
    }

    public String toString() {
        return "Color (" + this.r + "," + this.g + "," + this.b + "," + this.a + ")";
    }

    public void interp(Color color, float f, Color color2) {
        float f2 = color.r - this.r;
        float f3 = color.g - this.g;
        float f4 = color.b - this.b;
        float f5 = color.a - this.a;
        color2.r = this.r + (f2 *= f);
        color2.g = this.g + (f3 *= f);
        color2.b = this.b + (f4 *= f);
        color2.a = this.a + (f5 *= f);
    }

    public void changeHSBValue(float f, float f2, float f3) {
        float[] fArray = java.awt.Color.RGBtoHSB(this.getRedByte(), this.getGreenByte(), this.getBlueByte(), null);
        int n = java.awt.Color.HSBtoRGB(fArray[0] * f, fArray[1] * f2, fArray[2] * f3);
        this.r = (float)(n >> 16 & 0xFF) / 255.0f;
        this.g = (float)(n >> 8 & 0xFF) / 255.0f;
        this.b = (float)(n & 0xFF) / 255.0f;
    }

    public static Color HSBtoRGB(float f, float f2, float f3, Color color) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (f2 == 0.0f) {
            n2 = n3 = (int)(f3 * 255.0f + 0.5f);
            n = n3;
        } else {
            float f4 = (f - (float)Math.floor(f)) * 6.0f;
            float f5 = f4 - (float)Math.floor(f4);
            float f6 = f3 * (1.0f - f2);
            float f7 = f3 * (1.0f - f2 * f5);
            float f8 = f3 * (1.0f - f2 * (1.0f - f5));
            switch ((int)f4) {
                case 0: {
                    n = (int)(f3 * 255.0f + 0.5f);
                    n2 = (int)(f8 * 255.0f + 0.5f);
                    n3 = (int)(f6 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    n = (int)(f7 * 255.0f + 0.5f);
                    n2 = (int)(f3 * 255.0f + 0.5f);
                    n3 = (int)(f6 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    n = (int)(f6 * 255.0f + 0.5f);
                    n2 = (int)(f3 * 255.0f + 0.5f);
                    n3 = (int)(f8 * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    n = (int)(f6 * 255.0f + 0.5f);
                    n2 = (int)(f7 * 255.0f + 0.5f);
                    n3 = (int)(f3 * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    n = (int)(f8 * 255.0f + 0.5f);
                    n2 = (int)(f6 * 255.0f + 0.5f);
                    n3 = (int)(f3 * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    n = (int)(f3 * 255.0f + 0.5f);
                    n2 = (int)(f6 * 255.0f + 0.5f);
                    n3 = (int)(f7 * 255.0f + 0.5f);
                }
            }
        }
        return color.set((float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f);
    }

    public static Color HSBtoRGB(float f, float f2, float f3) {
        return Color.HSBtoRGB(f, f2, f3, new Color());
    }
}

