/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.Collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import zombie.core.Collections.ZomboidHashMap;

public class ZomboidHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    static final long serialVersionUID = -5024744406713321676L;
    private transient ZomboidHashMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public ZomboidHashSet() {
        this.map = new ZomboidHashMap();
    }

    public ZomboidHashSet(Collection<? extends E> collection) {
        this.map = new ZomboidHashMap(Math.max((int)((float)collection.size() / 0.75f) + 1, 16));
        this.addAll(collection);
    }

    public ZomboidHashSet(int n, float f) {
        this.map = new ZomboidHashMap(n);
    }

    public ZomboidHashSet(int n) {
        this.map = new ZomboidHashMap(n);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object object) {
        return this.map.remove(object) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            ZomboidHashSet zomboidHashSet = (ZomboidHashSet)super.clone();
            zomboidHashSet.map = (ZomboidHashMap)this.map.clone();
            return zomboidHashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.map.size());
        Iterator<E> iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

