/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.Collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import zombie.core.Collections.ZomboidAbstractMap;

public class ZomboidHashMap<K, V>
extends ZomboidAbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    Stack<Entry<K, V>> entryStore = new Stack();
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private static final long serialVersionUID = 362498820763181265L;

    public ZomboidHashMap(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        for (int i = 0; i < 100; ++i) {
            this.entryStore.add(new Entry<Object, Object>(0, null, null, null));
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.table = new Entry[n2];
        this.init();
    }

    public ZomboidHashMap(int n) {
        this(n, 0.75f);
    }

    public ZomboidHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.init();
    }

    public ZomboidHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAllForCreate(map);
    }

    void init() {
    }

    static int hash(int n) {
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return this.getForNullKey();
        }
        int n = ZomboidHashMap.hash(object.hashCode());
        Entry entry = this.table[ZomboidHashMap.indexFor(n, this.table.length)];
        while (entry != null) {
            Object k;
            if (entry.hash == n && ((k = entry.key) == object || object.equals(k))) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private V getForNullKey() {
        Entry entry = this.table[0];
        while (entry != null) {
            if (entry.key == null) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    final Entry<K, V> getEntry(Object object) {
        int n = object == null ? 0 : ZomboidHashMap.hash(object.hashCode());
        Entry entry = this.table[ZomboidHashMap.indexFor(n, this.table.length)];
        while (entry != null) {
            Object k;
            if (entry.hash == n && ((k = entry.key) == object || object != null && object.equals(k))) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        if (k == null) {
            return this.putForNullKey(v);
        }
        int n = ZomboidHashMap.hash(k.hashCode());
        int n2 = ZomboidHashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            Object k2;
            if (entry.hash == n && ((k2 = entry.key) == k || k.equals(k2))) {
                Object v2 = entry.value;
                entry.value = v;
                entry.recordAccess(this);
                return v2;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(n, k, v, n2);
        return null;
    }

    private V putForNullKey(V v) {
        Entry entry = this.table[0];
        while (entry != null) {
            if (entry.key == null) {
                Object v2 = entry.value;
                entry.value = v;
                entry.recordAccess(this);
                return v2;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(0, null, v, 0);
        return null;
    }

    private void putForCreate(K k, V v) {
        int n = k == null ? 0 : ZomboidHashMap.hash(k.hashCode());
        int n2 = ZomboidHashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            Object k2;
            if (entry.hash == n && ((k2 = entry.key) == k || k != null && k.equals(k2))) {
                entry.value = v;
                return;
            }
            entry = entry.next;
        }
        this.createEntry(n, k, v, n2);
    }

    private void putAllForCreate(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.putForCreate(entry.getKey(), entry.getValue());
        }
    }

    void resize(int n) {
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = new Entry[n];
        this.transfer(entryArray2);
        this.table = entryArray2;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    void transfer(Entry[] entryArray) {
        Entry[] entryArray2 = this.table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2.next;
                int n2 = ZomboidHashMap.indexFor(entry2.hash, n);
                entry2.next = entryArray[n2];
                entryArray[n2] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            int n2;
            int n3 = (int)((float)n / this.loadFactor + 1.0f);
            if (n3 > 0x40000000) {
                n3 = 0x40000000;
            }
            for (n2 = this.table.length; n2 < n3; n2 <<= 1) {
            }
            if (n2 > this.table.length) {
                this.resize(n2);
            }
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> entry = this.removeEntryForKey(object);
        return entry == null ? null : (V)entry.value;
    }

    final Entry<K, V> removeEntryForKey(Object object) {
        Entry entry;
        int n = object == null ? 0 : ZomboidHashMap.hash(object.hashCode());
        int n2 = ZomboidHashMap.indexFor(n, this.table.length);
        Entry entry2 = entry = this.table[n2];
        while (entry2 != null) {
            Object k;
            Entry entry3 = entry2.next;
            if (entry2.hash == n && ((k = entry2.key) == object || object != null && object.equals(k))) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    this.table[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                entry2.recordRemoval(this);
                entry2.value = null;
                entry2.next = null;
                this.entryStore.push(entry2);
                return entry2;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return entry2;
    }

    final Entry<K, V> removeMapping(Object object) {
        Entry entry;
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry2 = (Map.Entry)object;
        Object k = entry2.getKey();
        int n = k == null ? 0 : ZomboidHashMap.hash(k.hashCode());
        int n2 = ZomboidHashMap.indexFor(n, this.table.length);
        Entry entry3 = entry = this.table[n2];
        while (entry3 != null) {
            Entry entry4 = entry3.next;
            if (entry3.hash == n && entry3.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    this.table[n2] = entry4;
                } else {
                    entry.next = entry4;
                }
                entry3.recordRemoval(this);
                entry3.value = null;
                entry3.next = null;
                this.entryStore.push(entry3);
                return entry3;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return entry3;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            if (entryArray[i] != null) {
                entryArray[i].value = null;
                entryArray[i].next = null;
                this.entryStore.push(entryArray[i]);
            }
            entryArray[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public Object clone() {
        ZomboidHashMap zomboidHashMap = null;
        try {
            zomboidHashMap = (ZomboidHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        zomboidHashMap.table = new Entry[this.table.length];
        zomboidHashMap.entrySet = null;
        zomboidHashMap.modCount = 0;
        zomboidHashMap.size = 0;
        zomboidHashMap.init();
        zomboidHashMap.putAllForCreate(this);
        return zomboidHashMap;
    }

    void addEntry(int n, K k, V v, int n2) {
        Entry entry = this.table[n2];
        if (this.entryStore.isEmpty()) {
            for (int i = 0; i < 100; ++i) {
                this.entryStore.add(new Entry<Object, Object>(0, null, null, null));
            }
        }
        Entry<K, V> entry2 = this.entryStore.pop();
        entry2.hash = n;
        entry2.key = k;
        entry2.value = v;
        entry2.next = entry;
        this.table[n2] = entry2;
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int n, K k, V v, int n2) {
        Entry entry = this.table[n2];
        if (this.entryStore.isEmpty()) {
            for (int i = 0; i < 100; ++i) {
                this.entryStore.add(new Entry<Object, Object>(0, null, null, null));
            }
        }
        Entry<K, V> entry2 = this.entryStore.pop();
        entry2.hash = n;
        entry2.key = k;
        entry2.value = v;
        entry2.next = entry;
        this.table[n2] = entry2;
        ++this.size;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet0();
    }

    private Set<Map.Entry<K, V>> entrySet0() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Iterator<Map.Entry<K, V>> iterator = this.size > 0 ? this.entrySet0().iterator() : null;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.size);
        if (iterator != null) {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                objectOutputStream.writeObject(entry.getKey());
                objectOutputStream.writeObject(entry.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Entry[n];
        this.init();
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.putForCreate(object, object2);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;
        Entry<K, V> next;
        int hash;

        Entry(int n, K k, V v, Entry<K, V> entry) {
            this.value = v;
            this.next = entry;
            this.key = k;
            this.hash = n;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public final boolean equals(Object object) {
            Object v;
            V v2;
            Object k;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            K k2 = this.getKey();
            return (k2 == (k = entry.getKey()) || k2 != null && k2.equals(k)) && ((v2 = this.getValue()) == (v = entry.getValue()) || v2 != null && v2.equals(v));
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(ZomboidHashMap<K, V> zomboidHashMap) {
        }

        void recordRemoval(ZomboidHashMap<K, V> zomboidHashMap) {
        }
    }

    private final class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private final class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return ZomboidHashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return ZomboidHashMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return ZomboidHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return ZomboidHashMap.this.removeEntryForKey(object) != null;
        }

        @Override
        public void clear() {
            ZomboidHashMap.this.clear();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return ZomboidHashMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return ZomboidHashMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return ZomboidHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            ZomboidHashMap.this.clear();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return ZomboidHashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Entry entry2 = ZomboidHashMap.this.getEntry(entry.getKey());
            return entry2 != null && entry2.equals(entry);
        }

        @Override
        public boolean remove(Object object) {
            return ZomboidHashMap.this.removeMapping(object) != null;
        }

        @Override
        public int size() {
            return ZomboidHashMap.this.size;
        }

        @Override
        public void clear() {
            ZomboidHashMap.this.clear();
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<K, V> next;
        int expectedModCount;
        int index;
        Entry<K, V> current;

        HashIterator() {
            this.expectedModCount = ZomboidHashMap.this.modCount;
            if (ZomboidHashMap.this.size > 0) {
                Entry[] entryArray = ZomboidHashMap.this.table;
                while (this.index < entryArray.length && (this.next = entryArray[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextEntry() {
            if (ZomboidHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            this.next = entry.next;
            if (this.next == null) {
                Entry[] entryArray = ZomboidHashMap.this.table;
                while (this.index < entryArray.length && (this.next = entryArray[this.index++]) == null) {
                }
            }
            this.current = entry;
            return entry;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (ZomboidHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.current.key;
            this.current = null;
            ZomboidHashMap.this.removeEntryForKey(k);
            this.expectedModCount = ZomboidHashMap.this.modCount;
        }
    }
}

