/*
 * Decompiled with CFR 0.152.
 */
package zombie.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import zombie.config.ConfigOption;
import zombie.config.StringConfigOption;
import zombie.debug.DebugLog;

public final class ConfigFile {
    protected ArrayList<ConfigOption> options;
    protected int version;

    private void fileError(String string, int n, String string2) {
        DebugLog.log(string + ":" + n + " " + string2);
    }

    public boolean read(String string) {
        this.options = new ArrayList();
        this.version = 0;
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        DebugLog.log("reading " + string);
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String string2;
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                if ((string2 = string2.trim()).isEmpty() || string2.startsWith("#")) continue;
                if (!string2.contains("=")) {
                    this.fileError(string, n, string2);
                    continue;
                }
                String[] stringArray = string2.split("=");
                if ("Version".equals(stringArray[0])) {
                    try {
                        this.version = Integer.parseInt(stringArray[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.fileError(string, n, "expected version number, got \"" + stringArray[1] + "\"");
                    }
                    continue;
                }
                StringConfigOption stringConfigOption = new StringConfigOption(stringArray[0], stringArray.length > 1 ? stringArray[1] : "", -1);
                this.options.add(stringConfigOption);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean write(String string, int n, ArrayList<? extends ConfigOption> arrayList) {
        File file = new File(string);
        DebugLog.log("writing " + string);
        try (FileWriter fileWriter = new FileWriter(file, false);){
            if (n != 0) {
                fileWriter.write("Version=" + n + System.lineSeparator());
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                ConfigOption configOption = arrayList.get(i);
                String string2 = configOption.getTooltip();
                if (string2 != null) {
                    string2 = string2.replaceAll("\n", System.lineSeparator() + "# ");
                    fileWriter.write("# " + string2 + System.lineSeparator());
                }
                fileWriter.write(configOption.getName() + "=" + configOption.getValueAsString() + (String)(i < arrayList.size() - 1 ? System.lineSeparator() + System.lineSeparator() : ""));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public ArrayList<ConfigOption> getOptions() {
        return this.options;
    }

    public int getVersion() {
        return this.version;
    }
}

