/*
 * Decompiled with CFR 0.152.
 */
package zombie.config;

import zombie.config.ConfigOption;
import zombie.debug.DebugLog;

public class BooleanConfigOption
extends ConfigOption {
    protected boolean value;
    protected boolean defaultValue;

    public BooleanConfigOption(String string, boolean bl) {
        super(string);
        this.value = bl;
        this.defaultValue = bl;
    }

    @Override
    public String getType() {
        return "boolean";
    }

    @Override
    public void resetToDefault() {
        this.setValue(this.defaultValue);
    }

    @Override
    public void setDefaultToCurrentValue() {
        this.defaultValue = this.value;
    }

    @Override
    public void parse(String string) {
        if (this.isValidString(string)) {
            this.setValue(string.equalsIgnoreCase("true") || string.equalsIgnoreCase("1"));
        } else {
            DebugLog.log("ERROR BooleanConfigOption.parse() \"" + this.name + "\" string=" + string + "\"");
        }
    }

    @Override
    public String getValueAsString() {
        return String.valueOf(this.value);
    }

    @Override
    public void setValueFromObject(Object object) {
        if (object instanceof Boolean) {
            this.setValue((Boolean)object);
        } else if (object instanceof Double) {
            this.setValue((Double)object != 0.0);
        } else if (object instanceof String) {
            this.parse((String)object);
        }
    }

    @Override
    public Object getValueAsObject() {
        return this.value;
    }

    @Override
    public boolean isValidString(String string) {
        return string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("1") || string.equalsIgnoreCase("0"));
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean bl) {
        this.value = bl;
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getTooltip() {
        return String.valueOf(this.value);
    }
}

