/*
 * Decompiled with CFR 0.152.
 */
package zombie.commands.serverCommands;

import zombie.characters.IsoPlayer;
import zombie.commands.AltCommandArgs;
import zombie.commands.CommandArgs;
import zombie.commands.CommandBase;
import zombie.commands.CommandHelp;
import zombie.commands.CommandName;
import zombie.commands.CommandNames;
import zombie.commands.RequiredRight;
import zombie.core.logger.LoggerManager;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameServer;
import zombie.network.PacketTypes;

@CommandNames(value={@CommandName(name="teleportto"), @CommandName(name="tpto")})
@AltCommandArgs(value={@CommandArgs(required={"(.+)", "(\\d+),(\\d+),(\\d+)"}, argName="Teleport user"), @CommandArgs(required={"(\\d+),(\\d+),(\\d+)"}, argName="teleport me")})
@CommandHelp(helpText="UI_ServerOptionDesc_TeleportTo")
@RequiredRight(requiredRights=62)
public class TeleportToCommand
extends CommandBase {
    public static final String teleportMe = "teleport me";
    public static final String teleportUser = "Teleport user";
    private String username;
    private Float[] coords;

    public TeleportToCommand(String string, String string2, String string3, UdpConnection udpConnection) {
        super(string, string2, string3, udpConnection);
    }

    @Override
    protected String Command() {
        switch (this.argsName) {
            case "teleport me": {
                this.coords = new Float[3];
                for (int i = 0; i < 3; ++i) {
                    this.coords[i] = Float.valueOf(Float.parseFloat(this.getCommandArg(i)));
                }
                return this.TeleportMeToCoords();
            }
            case "Teleport user": {
                this.username = this.getCommandArg(0);
                this.coords = new Float[3];
                for (int i = 0; i < 3; ++i) {
                    this.coords[i] = Float.valueOf(Float.parseFloat(this.getCommandArg(i + 1)));
                }
                return this.TeleportUserToCoords();
            }
        }
        return this.CommandArgumentsNotMatch();
    }

    private String TeleportMeToCoords() {
        float f = this.coords[0].floatValue();
        float f2 = this.coords[1].floatValue();
        float f3 = this.coords[2].floatValue();
        if (this.connection == null) {
            return "Error";
        }
        ByteBufferWriter byteBufferWriter = this.connection.startPacket();
        PacketTypes.PacketType.Teleport.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)0);
        byteBufferWriter.putFloat(f);
        byteBufferWriter.putFloat(f2);
        byteBufferWriter.putFloat(f3);
        PacketTypes.PacketType.Teleport.send(this.connection);
        if (this.connection.players[0] != null && this.connection.players[0].getNetworkCharacterAI() != null) {
            this.connection.players[0].getNetworkCharacterAI().resetSpeedLimiter();
        }
        LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " teleported to " + (int)f + "," + (int)f2 + "," + (int)f3);
        return "teleported to " + (int)f + "," + (int)f2 + "," + (int)f3 + " please wait two seconds to show the map around you.";
    }

    private String TeleportUserToCoords() {
        float f = this.coords[0].floatValue();
        float f2 = this.coords[1].floatValue();
        float f3 = this.coords[2].floatValue();
        if (this.connection != null && this.connection.accessLevel == 2 && !this.username.equals(this.getExecutorUsername())) {
            return "An Observer can only teleport himself";
        }
        IsoPlayer isoPlayer = GameServer.getPlayerByUserNameForCommand(this.username);
        if (isoPlayer == null) {
            return "Can't find player " + this.username;
        }
        UdpConnection udpConnection = GameServer.getConnectionFromPlayer(isoPlayer);
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.Teleport.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)0);
        byteBufferWriter.putFloat(f);
        byteBufferWriter.putFloat(f2);
        byteBufferWriter.putFloat(f3);
        PacketTypes.PacketType.Teleport.send(udpConnection);
        if (isoPlayer.getNetworkCharacterAI() != null) {
            isoPlayer.getNetworkCharacterAI().resetSpeedLimiter();
        }
        LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " teleported to " + (int)f + "," + (int)f2 + "," + (int)f3);
        return this.username + " teleported to " + (int)f + "," + (int)f2 + "," + (int)f3 + " please wait two seconds to show the map around you.";
    }

    private String CommandArgumentsNotMatch() {
        return this.getHelp();
    }
}

