/*
 * Decompiled with CFR 0.152.
 */
package zombie.commands.serverCommands;

import zombie.characters.IsoPlayer;
import zombie.commands.AltCommandArgs;
import zombie.commands.CommandArgs;
import zombie.commands.CommandBase;
import zombie.commands.CommandHelp;
import zombie.commands.CommandName;
import zombie.commands.CommandNames;
import zombie.commands.RequiredRight;
import zombie.core.logger.LoggerManager;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameServer;
import zombie.network.PacketTypes;

@CommandNames(value={@CommandName(name="teleport"), @CommandName(name="tp")})
@AltCommandArgs(value={@CommandArgs(required={"(.+)"}, argName="just port to user"), @CommandArgs(required={"(.+)", "(.+)"}, argName="teleport user1 to user 2")})
@CommandHelp(helpText="UI_ServerOptionDesc_Teleport")
@RequiredRight(requiredRights=62)
public class TeleportCommand
extends CommandBase {
    public static final String justToUser = "just port to user";
    public static final String portUserToUser = "teleport user1 to user 2";
    private String username1;
    private String username2;

    public TeleportCommand(String string, String string2, String string3, UdpConnection udpConnection) {
        super(string, string2, string3, udpConnection);
    }

    @Override
    protected String Command() {
        switch (this.argsName) {
            case "just port to user": {
                this.username1 = this.getCommandArg(0);
                return this.TeleportMeToUser();
            }
            case "teleport user1 to user 2": {
                this.username1 = this.getCommandArg(0);
                this.username2 = this.getCommandArg(1);
                return this.TeleportUser1ToUser2();
            }
        }
        return this.CommandArgumentsNotMatch();
    }

    private String TeleportMeToUser() {
        if (this.connection == null) {
            return "Need player to teleport to, ex /teleport user1 user2";
        }
        IsoPlayer isoPlayer = GameServer.getPlayerByUserNameForCommand(this.username1);
        if (isoPlayer != null) {
            this.username1 = isoPlayer.getDisplayName();
            ByteBufferWriter byteBufferWriter = this.connection.startPacket();
            PacketTypes.PacketType.Teleport.doPacket(byteBufferWriter);
            byteBufferWriter.putByte((byte)0);
            byteBufferWriter.putFloat(isoPlayer.getX());
            byteBufferWriter.putFloat(isoPlayer.getY());
            byteBufferWriter.putFloat(isoPlayer.getZ());
            PacketTypes.PacketType.Teleport.send(this.connection);
            if (this.connection.players[0] != null && this.connection.players[0].getNetworkCharacterAI() != null) {
                this.connection.players[0].getNetworkCharacterAI().resetSpeedLimiter();
            }
            LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " teleport to " + this.username1);
            return "teleported to " + this.username1 + " please wait two seconds to show the map around you.";
        }
        return "Can't find player " + this.username1;
    }

    private String TeleportUser1ToUser2() {
        if (this.getAccessLevel() == 2 && !this.username1.equals(this.getExecutorUsername())) {
            return "An Observer can only teleport himself";
        }
        IsoPlayer isoPlayer = GameServer.getPlayerByUserNameForCommand(this.username1);
        IsoPlayer isoPlayer2 = GameServer.getPlayerByUserNameForCommand(this.username2);
        if (isoPlayer == null) {
            return "Can't find player " + this.username1;
        }
        if (isoPlayer2 == null) {
            return "Can't find player " + this.username2;
        }
        this.username1 = isoPlayer.getDisplayName();
        this.username2 = isoPlayer2.getDisplayName();
        UdpConnection udpConnection = GameServer.getConnectionFromPlayer(isoPlayer);
        if (udpConnection == null) {
            return "No connection for player " + this.username1;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.Teleport.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)isoPlayer.PlayerIndex);
        byteBufferWriter.putFloat(isoPlayer2.getX());
        byteBufferWriter.putFloat(isoPlayer2.getY());
        byteBufferWriter.putFloat(isoPlayer2.getZ());
        PacketTypes.PacketType.Teleport.send(udpConnection);
        if (isoPlayer.getNetworkCharacterAI() != null) {
            isoPlayer.getNetworkCharacterAI().resetSpeedLimiter();
        }
        LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " teleported " + this.username1 + " to " + this.username2);
        return "teleported " + this.username1 + " to " + this.username2;
    }

    private String CommandArgumentsNotMatch() {
        return this.getHelp();
    }
}

