/*
 * Decompiled with CFR 0.152.
 */
package zombie.commands.serverCommands;

import java.sql.SQLException;
import zombie.characters.IsoPlayer;
import zombie.commands.CommandBase;
import zombie.commands.CommandHelp;
import zombie.commands.CommandName;
import zombie.commands.RequiredRight;
import zombie.core.raknet.UdpConnection;
import zombie.iso.areas.SafeHouse;
import zombie.network.GameServer;

@CommandName(name="releasesafehouse")
@CommandHelp(helpText="UI_ServerOptionDesc_SafeHouse")
@RequiredRight(requiredRights=63)
public class ReleaseSafehouseCommand
extends CommandBase {
    public ReleaseSafehouseCommand(String string, String string2, String string3, UdpConnection udpConnection) {
        super(string, string2, string3, udpConnection);
    }

    @Override
    protected String Command() throws SQLException {
        if (this.isCommandComeFromServerConsole()) {
            return ReleaseSafehouseCommand.getCommandName(this.getClass()) + " can be executed only from the game";
        }
        String string = this.getExecutorUsername();
        IsoPlayer isoPlayer = GameServer.getPlayerByUserNameForCommand(string);
        SafeHouse safeHouse = SafeHouse.hasSafehouse(string);
        if (safeHouse != null) {
            if (!safeHouse.isOwner(isoPlayer)) {
                return "Only owner can release safehouse";
            }
            safeHouse.removeSafeHouse(isoPlayer);
            return "Your safehouse was released";
        }
        return "You have no safehouse";
    }
}

