/*
 * Decompiled with CFR 0.152.
 */
package zombie.commands.serverCommands;

import zombie.VirtualZombieManager;
import zombie.ZombieSpawnRecorder;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.commands.CommandArgs;
import zombie.commands.CommandBase;
import zombie.commands.CommandHelp;
import zombie.commands.CommandName;
import zombie.commands.RequiredRight;
import zombie.core.Rand;
import zombie.core.logger.LoggerManager;
import zombie.core.raknet.UdpConnection;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.network.GameServer;

@CommandName(name="createhorde")
@CommandArgs(required={"(\\d+)"}, optional="(.+)")
@CommandHelp(helpText="UI_ServerOptionDesc_CreateHorde")
@RequiredRight(requiredRights=56)
public class CreateHordeCommand
extends CommandBase {
    public CreateHordeCommand(String string, String string2, String string3, UdpConnection udpConnection) {
        super(string, string2, string3, udpConnection);
    }

    @Override
    protected String Command() {
        Integer n = Integer.parseInt(this.getCommandArg(0));
        String string = this.getCommandArg(1);
        IsoPlayer isoPlayer = null;
        if (this.getCommandArgsCount() == 2) {
            isoPlayer = GameServer.getPlayerByUserNameForCommand(string);
            if (isoPlayer == null) {
                return "User \"" + string + "\" not found";
            }
        } else if (this.connection != null) {
            isoPlayer = GameServer.getAnyPlayerFromConnection(this.connection);
        }
        if (n == null) {
            return this.getHelp();
        }
        n = Math.min(n, 500);
        if (isoPlayer != null) {
            for (int i = 0; i < n; ++i) {
                VirtualZombieManager.instance.choices.clear();
                IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(Rand.Next(isoPlayer.getX() - 10.0f, isoPlayer.getX() + 10.0f), Rand.Next(isoPlayer.getY() - 10.0f, isoPlayer.getY() + 10.0f), isoPlayer.getZ());
                VirtualZombieManager.instance.choices.add(isoGridSquare);
                IsoZombie isoZombie = VirtualZombieManager.instance.createRealZombieAlways(IsoDirections.fromIndex(Rand.Next(IsoDirections.Max.index())).index(), false);
                if (isoZombie == null) continue;
                ZombieSpawnRecorder.instance.record(isoZombie, this.getClass().getSimpleName());
            }
            LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " created a horde of " + n + " zombies near " + isoPlayer.getX() + "," + isoPlayer.getY(), "IMPORTANT");
            return "Horde spawned.";
        }
        return "Specify a player to create the horde near to.";
    }
}

