/*
 * Decompiled with CFR 0.152.
 */
package zombie.commands.serverCommands;

import java.sql.SQLException;
import zombie.commands.CommandArgs;
import zombie.commands.CommandBase;
import zombie.commands.CommandHelp;
import zombie.commands.CommandName;
import zombie.commands.RequiredRight;
import zombie.core.logger.LoggerManager;
import zombie.core.raknet.UdpConnection;
import zombie.core.znet.SteamUtils;
import zombie.network.GameServer;
import zombie.network.ServerWorldDatabase;

@CommandName(name="banid")
@CommandArgs(required={"(.+)"})
@CommandHelp(helpText="UI_ServerOptionDesc_BanSteamId")
@RequiredRight(requiredRights=48)
public class BanSteamIDCommand
extends CommandBase {
    public BanSteamIDCommand(String string, String string2, String string3, UdpConnection udpConnection) {
        super(string, string2, string3, udpConnection);
    }

    @Override
    protected String Command() throws SQLException {
        String string = this.getCommandArg(0);
        if (!SteamUtils.isSteamModeEnabled()) {
            return "Server is not in Steam mode";
        }
        if (!SteamUtils.isValidSteamID(string)) {
            return "Expected SteamID but got \"" + string + "\"";
        }
        LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " banned SteamID " + string, "IMPORTANT");
        ServerWorldDatabase.instance.banSteamID(string, "", true);
        long l = SteamUtils.convertStringToSteamID(string);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (udpConnection.steamID != l) continue;
            GameServer.kick(udpConnection, "UI_Policy_Ban", null);
            udpConnection.forceDisconnect("command-ban-sid");
            break;
        }
        return "SteamID " + string + " is now banned";
    }
}

