/*
 * Decompiled with CFR 0.152.
 */
package zombie.commands.serverCommands;

import zombie.commands.AltCommandArgs;
import zombie.commands.CommandArgs;
import zombie.commands.CommandBase;
import zombie.commands.CommandHelp;
import zombie.commands.CommandName;
import zombie.commands.RequiredRight;
import zombie.core.math.PZMath;
import zombie.core.raknet.UdpConnection;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoWorld;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.VehicleScript;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehiclesDB2;

@CommandName(name="addvehicle")
@AltCommandArgs(value={@CommandArgs(required={"([a-zA-Z0-9.-]*[a-zA-Z][a-zA-Z0-9_.-]*)"}, argName="Script Only"), @CommandArgs(required={"([a-zA-Z0-9.-]*[a-zA-Z][a-zA-Z0-9_.-]*)", "(\\d+),(\\d+),(\\d+)"}, argName="Script And Coordinate"), @CommandArgs(required={"([a-zA-Z0-9.-]*[a-zA-Z][a-zA-Z0-9_.-]*)", "(.+)"}, argName="Script And Player")})
@CommandHelp(helpText="UI_ServerOptionDesc_AddVehicle")
@RequiredRight(requiredRights=60)
public class AddVehicleCommand
extends CommandBase {
    public static final String scriptOnly = "Script Only";
    public static final String scriptPlayer = "Script And Player";
    public static final String scriptCoordinate = "Script And Coordinate";

    public AddVehicleCommand(String string, String string2, String string3, UdpConnection udpConnection) {
        super(string, string2, string3, udpConnection);
    }

    @Override
    protected String Command() {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2 = this.getCommandArg(0);
        VehicleScript vehicleScript = ScriptManager.instance.getVehicle((String)object2);
        if (vehicleScript == null) {
            return "Unknown vehicle script \"" + (String)object2 + "\"";
        }
        object2 = vehicleScript.getModule().getName() + "." + vehicleScript.getName();
        if (this.argsName.equals(scriptPlayer)) {
            String string = this.getCommandArg(1);
            object = GameServer.getPlayerByUserNameForCommand(string);
            if (object == null) {
                return "User \"" + string + "\" not found";
            }
            n3 = PZMath.fastfloor(((IsoMovingObject)object).getX());
            n2 = PZMath.fastfloor(((IsoMovingObject)object).getY());
            n = PZMath.fastfloor(((IsoMovingObject)object).getZ());
        } else if (this.argsName.equals(scriptCoordinate)) {
            n3 = PZMath.fastfloor(Float.parseFloat(this.getCommandArg(1)));
            n2 = PZMath.fastfloor(Float.parseFloat(this.getCommandArg(2)));
            n = PZMath.fastfloor(Float.parseFloat(this.getCommandArg(3)));
        } else {
            if (this.connection == null) {
                return "Pass a username or coordinate";
            }
            String string = this.getExecutorUsername();
            object = GameServer.getPlayerByUserNameForCommand(string);
            if (object == null) {
                return "User \"" + string + "\" not found";
            }
            n3 = PZMath.fastfloor(((IsoMovingObject)object).getX());
            n2 = PZMath.fastfloor(((IsoMovingObject)object).getY());
            n = PZMath.fastfloor(((IsoMovingObject)object).getZ());
        }
        if (n > 0) {
            return "Z coordinate must be 0 for now";
        }
        object = ServerMap.instance.getGridSquare(n3, n2, n);
        if (object == null) {
            return "Invalid location " + n3 + "," + n2 + "," + n;
        }
        BaseVehicle baseVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
        baseVehicle.setScriptName((String)object2);
        baseVehicle.setX((float)n3 - 1.0f);
        baseVehicle.setY((float)n2 - 0.1f);
        baseVehicle.setZ((float)n + 0.2f);
        if (IsoChunk.doSpawnedVehiclesInInvalidPosition(baseVehicle)) {
            baseVehicle.setSquare((IsoGridSquare)object);
            baseVehicle.square.chunk.vehicles.add(baseVehicle);
            baseVehicle.chunk = baseVehicle.square.chunk;
            baseVehicle.addToWorld();
            VehiclesDB2.instance.addVehicle(baseVehicle);
            return "Vehicle spawned";
        }
        return "ERROR: I can not spawn the vehicle. Invalid position. Try to change position.";
    }
}

