/*
 * Decompiled with CFR 0.152.
 */
package zombie.chat.defaultChats;

import java.nio.ByteBuffer;
import java.util.Iterator;
import zombie.Lua.LuaEventManager;
import zombie.characters.IsoPlayer;
import zombie.chat.ChatBase;
import zombie.chat.ChatManager;
import zombie.chat.ChatMessage;
import zombie.chat.ChatSettings;
import zombie.chat.ChatTab;
import zombie.chat.ServerChatMessage;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.network.ByteBufferWriter;
import zombie.debug.DebugLog;
import zombie.network.GameClient;
import zombie.network.chat.ChatType;

public class ServerChat
extends ChatBase {
    public ServerChat(ByteBuffer byteBuffer, ChatTab chatTab, IsoPlayer isoPlayer) {
        super(byteBuffer, ChatType.server, chatTab, isoPlayer);
        this.setSettings(ServerChat.getDefaultSettings());
    }

    public ServerChat(int n, ChatTab chatTab) {
        super(n, ChatType.server, chatTab);
        this.setSettings(ServerChat.getDefaultSettings());
    }

    public static ChatSettings getDefaultSettings() {
        ChatSettings chatSettings = new ChatSettings();
        chatSettings.setBold(true);
        chatSettings.setFontColor(new Color(0, 128, 255, 255));
        chatSettings.setShowAuthor(false);
        chatSettings.setShowChatTitle(true);
        chatSettings.setShowTimestamp(false);
        chatSettings.setAllowColors(true);
        chatSettings.setAllowFonts(false);
        chatSettings.setAllowBBcode(false);
        return chatSettings;
    }

    public ChatMessage createMessage(String string, String string2, boolean bl) {
        ChatMessage chatMessage = this.createMessage(string2);
        chatMessage.setAuthor(string);
        if (bl) {
            chatMessage.setServerAlert(true);
        }
        return chatMessage;
    }

    public ServerChatMessage createServerMessage(String string, boolean bl) {
        ServerChatMessage serverChatMessage = this.createServerMessage(string);
        serverChatMessage.setServerAlert(bl);
        return serverChatMessage;
    }

    @Override
    public short getTabID() {
        if (!GameClient.bClient) {
            return super.getTabID();
        }
        return ChatManager.getInstance().getFocusTab().getID();
    }

    @Override
    public ChatMessage unpackMessage(ByteBuffer byteBuffer) {
        ChatMessage chatMessage = super.unpackMessage(byteBuffer);
        chatMessage.setServerAlert(byteBuffer.get() == 1);
        chatMessage.setServerAuthor(byteBuffer.get() == 1);
        return chatMessage;
    }

    @Override
    public void packMessage(ByteBufferWriter byteBufferWriter, ChatMessage chatMessage) {
        super.packMessage(byteBufferWriter, chatMessage);
        byteBufferWriter.putBoolean(chatMessage.isServerAlert());
        byteBufferWriter.putBoolean(chatMessage.isServerAuthor());
    }

    @Override
    public String getMessagePrefix(ChatMessage chatMessage) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getChatSettingsTags());
        boolean bl = false;
        if (this.isShowTitle()) {
            stringBuilder.append("[").append(this.getTitle()).append("]");
            bl = true;
        }
        if (!chatMessage.isServerAuthor() && this.isShowAuthor()) {
            stringBuilder.append("[").append(chatMessage.getAuthor()).append("]");
            bl = true;
        }
        if (bl) {
            stringBuilder.append(": ");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getMessageTextWithPrefix(ChatMessage chatMessage) {
        return this.getMessagePrefix(chatMessage) + " " + chatMessage.getText();
    }

    @Override
    public void showMessage(ChatMessage chatMessage) {
        this.messages.add(chatMessage);
        if (this.isEnabled()) {
            LuaEventManager.triggerEvent("OnAddMessage", chatMessage, this.getTabID());
        }
    }

    @Override
    public void sendMessageToChatMembers(ChatMessage chatMessage) {
        Iterator iterator = this.members.iterator();
        while (iterator.hasNext()) {
            short s = (Short)iterator.next();
            this.sendMessageToPlayer(s, chatMessage);
        }
        if (Core.bDebug) {
            DebugLog.log("New message '" + chatMessage + "' was sent members of chat '" + this.getID() + "'");
        }
    }
}

