/*
 * Decompiled with CFR 0.152.
 */
package zombie.chat.defaultChats;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import zombie.characters.IsoPlayer;
import zombie.chat.ChatBase;
import zombie.chat.ChatElement;
import zombie.chat.ChatMessage;
import zombie.chat.ChatMode;
import zombie.chat.ChatTab;
import zombie.chat.ChatUtility;
import zombie.core.Color;
import zombie.core.fonts.AngelCodeFont;
import zombie.debug.DebugLog;
import zombie.network.GameClient;
import zombie.network.chat.ChatType;
import zombie.ui.TextManager;
import zombie.ui.UIFont;

public abstract class RangeBasedChat
extends ChatBase {
    private static ChatElement overHeadChat = null;
    private static HashMap<String, IsoPlayer> players = null;
    private static String currentPlayerName = null;
    String customTag = "default";

    RangeBasedChat(ByteBuffer byteBuffer, ChatType chatType, ChatTab chatTab, IsoPlayer isoPlayer) {
        super(byteBuffer, chatType, chatTab, isoPlayer);
    }

    RangeBasedChat(ChatType chatType) {
        super(chatType);
    }

    RangeBasedChat(int n, ChatType chatType, ChatTab chatTab) {
        super(n, chatType, chatTab);
    }

    public void Init() {
        currentPlayerName = this.getChatOwnerName();
        if (players != null) {
            players.clear();
        }
        overHeadChat = this.getChatOwner().getChatElement();
    }

    @Override
    public boolean isSendingToRadio() {
        return true;
    }

    @Override
    public ChatMessage createMessage(String string) {
        ChatMessage chatMessage = super.createMessage(string);
        if (this.getMode() == ChatMode.SinglePlayer) {
            chatMessage.setShowInChat(false);
        }
        chatMessage.setOverHeadSpeech(true);
        chatMessage.setShouldAttractZombies(true);
        return chatMessage;
    }

    public ChatMessage createBubbleMessage(String string) {
        ChatMessage chatMessage = super.createMessage(string);
        chatMessage.setOverHeadSpeech(true);
        chatMessage.setShowInChat(false);
        return chatMessage;
    }

    @Override
    public void sendMessageToChatMembers(ChatMessage chatMessage) {
        IsoPlayer isoPlayer = ChatUtility.findPlayer(chatMessage.getAuthor());
        if (this.getRange() == -1.0f) {
            DebugLog.log("Range not set for '" + this.getTitle() + "' chat. Message '" + chatMessage.getText() + "' ignored");
            return;
        }
        Iterator iterator = this.members.iterator();
        while (iterator.hasNext()) {
            short s = (Short)iterator.next();
            IsoPlayer isoPlayer2 = ChatUtility.findPlayer(s);
            if (isoPlayer2 == null || isoPlayer.getOnlineID() == s || !(ChatUtility.getDistance(isoPlayer, isoPlayer2) < this.getRange())) continue;
            this.sendMessageToPlayer(s, chatMessage);
        }
    }

    @Override
    public void showMessage(ChatMessage chatMessage) {
        super.showMessage(chatMessage);
        if (chatMessage.isOverHeadSpeech()) {
            this.showInSpeechBubble(chatMessage);
        }
    }

    protected ChatElement getSpeechBubble() {
        return overHeadChat;
    }

    protected UIFont selectFont(String string) {
        char[] cArray = string.toCharArray();
        UIFont uIFont = UIFont.Dialogue;
        AngelCodeFont angelCodeFont = TextManager.instance.getFontFromEnum(uIFont);
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] <= angelCodeFont.chars.length) continue;
            uIFont = UIFont.Medium;
            break;
        }
        return uIFont;
    }

    protected void showInSpeechBubble(ChatMessage chatMessage) {
        Color color = this.getColor();
        String string = chatMessage.getAuthor();
        IsoPlayer isoPlayer = this.getPlayer(string);
        float f = color.r;
        float f2 = color.g;
        float f3 = color.b;
        if (isoPlayer != null) {
            f = isoPlayer.getSpeakColour().r;
            f2 = isoPlayer.getSpeakColour().g;
            f3 = isoPlayer.getSpeakColour().b;
        }
        String string2 = ChatUtility.parseStringForChatBubble(chatMessage.getText());
        if (string == null || "".equalsIgnoreCase(string) || string.equalsIgnoreCase(currentPlayerName)) {
            overHeadChat.addChatLine(string2, f, f2, f3, this.selectFont(string2), this.getRange(), this.customTag, this.isAllowBBcode(), this.isAllowImages(), this.isAllowChatIcons(), this.isAllowColors(), this.isAllowFonts(), this.isEqualizeLineHeights());
        } else {
            IsoPlayer isoPlayer2;
            if (!players.containsKey(string)) {
                players.put(string, this.getPlayer(string));
            }
            if ((isoPlayer2 = players.get(string)) != null) {
                if (isoPlayer2.isDead()) {
                    isoPlayer2 = this.getPlayer(string);
                    players.replace(string, isoPlayer2);
                }
                isoPlayer2.getChatElement().addChatLine(string2, f, f2, f3, this.selectFont(string2), this.getRange(), this.customTag, this.isAllowBBcode(), this.isAllowImages(), this.isAllowChatIcons(), this.isAllowColors(), this.isAllowFonts(), this.isEqualizeLineHeights());
            }
        }
    }

    private IsoPlayer getPlayer(String string) {
        IsoPlayer isoPlayer;
        IsoPlayer isoPlayer2 = isoPlayer = GameClient.bClient ? GameClient.instance.getPlayerFromUsername(string) : null;
        if (isoPlayer != null) {
            return isoPlayer;
        }
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || !isoPlayer.getUsername().equals(string)) continue;
            return isoPlayer;
        }
        return null;
    }

    static {
        players = new HashMap();
    }
}

