/*
 * Decompiled with CFR 0.152.
 */
package zombie.chat.defaultChats;

import java.nio.ByteBuffer;
import java.util.Iterator;
import zombie.Lua.LuaManager;
import zombie.characters.IsoPlayer;
import zombie.chat.ChatBase;
import zombie.chat.ChatMessage;
import zombie.chat.ChatSettings;
import zombie.chat.ChatTab;
import zombie.chat.ChatUtility;
import zombie.core.Color;
import zombie.core.Translator;
import zombie.core.network.ByteBufferWriter;
import zombie.debug.DebugLog;
import zombie.network.GameServer;
import zombie.network.chat.ChatType;

public class GeneralChat
extends ChatBase {
    private boolean discordEnabled = false;
    private final Color discordMessageColor = new Color(114, 137, 218);

    public GeneralChat(ByteBuffer byteBuffer, ChatTab chatTab, IsoPlayer isoPlayer) {
        super(byteBuffer, ChatType.general, chatTab, isoPlayer);
        if (!this.isCustomSettings()) {
            this.setSettings(GeneralChat.getDefaultSettings());
        }
    }

    public GeneralChat(int n, ChatTab chatTab, boolean bl) {
        super(n, ChatType.general, chatTab);
        this.discordEnabled = bl;
        if (!this.isCustomSettings()) {
            this.setSettings(GeneralChat.getDefaultSettings());
        }
    }

    public GeneralChat() {
        super(ChatType.general);
    }

    public static ChatSettings getDefaultSettings() {
        ChatSettings chatSettings = new ChatSettings();
        chatSettings.setBold(true);
        chatSettings.setFontColor(new Color(255, 165, 0));
        chatSettings.setShowAuthor(true);
        chatSettings.setShowChatTitle(true);
        chatSettings.setShowTimestamp(true);
        chatSettings.setUnique(true);
        chatSettings.setAllowColors(true);
        chatSettings.setAllowFonts(true);
        chatSettings.setAllowBBcode(true);
        return chatSettings;
    }

    @Override
    public void sendMessageToChatMembers(ChatMessage chatMessage) {
        if (this.discordEnabled) {
            IsoPlayer isoPlayer = ChatUtility.findPlayer(chatMessage.getAuthor());
            if (chatMessage.isFromDiscord()) {
                Iterator iterator = this.members.iterator();
                while (iterator.hasNext()) {
                    short s = (Short)iterator.next();
                    this.sendMessageToPlayer(s, chatMessage);
                }
            } else {
                GameServer.discordBot.sendMessage(chatMessage.getAuthor(), chatMessage.getText());
                Iterator iterator = this.members.iterator();
                while (iterator.hasNext()) {
                    short s = (Short)iterator.next();
                    if (isoPlayer != null && isoPlayer.getOnlineID() == s) continue;
                    this.sendMessageToPlayer(s, chatMessage);
                }
            }
        } else {
            super.sendMessageToChatMembers(chatMessage);
        }
        DebugLog.log("New message '" + chatMessage + "' was sent members of chat '" + this.getID() + "'");
    }

    public void sendToDiscordGeneralChatDisabled() {
        GameServer.discordBot.sendMessage("Server", Translator.getText("UI_chat_general_chat_disabled"));
    }

    @Override
    public String getMessagePrefix(ChatMessage chatMessage) {
        StringBuilder stringBuilder = new StringBuilder();
        if (chatMessage.isFromDiscord()) {
            stringBuilder.append(this.getColorTag(this.discordMessageColor));
        } else {
            stringBuilder.append(this.getColorTag());
        }
        stringBuilder.append(" ").append(this.getFontSizeTag()).append(" ");
        if (this.isShowTimestamp()) {
            stringBuilder.append("[").append(LuaManager.getHourMinuteJava()).append("]");
        }
        if (this.isShowTitle()) {
            stringBuilder.append("[").append(this.getTitle()).append("]");
        }
        if (this.isShowAuthor()) {
            stringBuilder.append("[").append(chatMessage.getAuthor()).append("]");
        }
        stringBuilder.append(": ");
        return stringBuilder.toString();
    }

    @Override
    public void packMessage(ByteBufferWriter byteBufferWriter, ChatMessage chatMessage) {
        super.packMessage(byteBufferWriter, chatMessage);
        byteBufferWriter.putBoolean(chatMessage.isFromDiscord());
    }

    @Override
    public ChatMessage unpackMessage(ByteBuffer byteBuffer) {
        ChatMessage chatMessage = super.unpackMessage(byteBuffer);
        if (byteBuffer.get() == 1) {
            chatMessage.makeFromDiscord();
        }
        return chatMessage;
    }
}

