/*
 * Decompiled with CFR 0.152.
 */
package zombie.chat;

import java.util.HashSet;
import zombie.core.Translator;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.PacketTypes;

public class ChatTab {
    private short id;
    private String titleID;
    private String translatedTitle;
    private HashSet<Integer> containedChats;
    private boolean enabled = false;

    public ChatTab(short s, String string) {
        this.id = s;
        this.titleID = string;
        this.translatedTitle = Translator.getText(string);
        this.containedChats = new HashSet();
    }

    public ChatTab(short s, String string, int n) {
        this(s, string);
        this.containedChats.add(n);
    }

    public void RemoveChat(int n) {
        if (!this.containedChats.contains(n)) {
            throw new RuntimeException("Tab '" + this.id + "' doesn't contains a chat id: " + n);
        }
        this.containedChats.remove(n);
    }

    public String getTitleID() {
        return this.titleID;
    }

    public String getTitle() {
        return this.translatedTitle;
    }

    public short getID() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void sendAddTabPacket(UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.AddChatTab.doPacket(byteBufferWriter);
        byteBufferWriter.putShort(this.getID());
        PacketTypes.PacketType.AddChatTab.send(udpConnection);
    }

    public void sendRemoveTabPacket(UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.RemoveChatTab.doPacket(byteBufferWriter);
        byteBufferWriter.putShort(this.getID());
        PacketTypes.PacketType.RemoveChatTab.send(udpConnection);
    }
}

