/*
 * Decompiled with CFR 0.152.
 */
package zombie.chat;

import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.characters.IsoPlayer;
import zombie.chat.ChatMessage;
import zombie.chat.ChatMode;
import zombie.chat.ChatSettings;
import zombie.chat.ChatTab;
import zombie.chat.ChatUtility;
import zombie.chat.ServerChatMessage;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.Translator;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.network.GameClient;
import zombie.network.PacketTypes;
import zombie.network.chat.ChatType;
import zombie.radio.devices.DeviceData;

public abstract class ChatBase {
    private static final int ID_NOT_SET = -29048394;
    private int id = -29048394;
    private final String titleID;
    private final ChatType type;
    private ChatSettings settings;
    private boolean customSettings = false;
    private ChatTab chatTab = null;
    private String translatedTitle;
    protected final ArrayList<Short> members;
    private final ArrayList<Short> justAddedMembers = new ArrayList();
    private final ArrayList<Short> justRemovedMembers = new ArrayList();
    protected final ArrayList<ChatMessage> messages;
    private UdpConnection serverConnection;
    private ChatMode mode;
    private IsoPlayer chatOwner;
    private final Lock memberLock = new ReentrantLock();

    protected ChatBase(ChatType chatType) {
        this.settings = new ChatSettings();
        this.messages = new ArrayList();
        this.titleID = chatType.getTitleID();
        this.type = chatType;
        this.members = new ArrayList();
        this.mode = ChatMode.SinglePlayer;
        this.serverConnection = null;
        this.chatOwner = IsoPlayer.getInstance();
    }

    public ChatBase(ByteBuffer byteBuffer, ChatType chatType, ChatTab chatTab, IsoPlayer isoPlayer) {
        this(chatType);
        this.id = byteBuffer.getInt();
        boolean bl = this.customSettings = byteBuffer.get() == 1;
        if (this.customSettings) {
            this.settings = new ChatSettings(byteBuffer);
        }
        this.chatTab = chatTab;
        this.mode = ChatMode.ClientMultiPlayer;
        this.serverConnection = GameClient.connection;
        this.chatOwner = isoPlayer;
    }

    public ChatBase(int n, ChatType chatType, ChatTab chatTab) {
        this(chatType);
        this.id = n;
        this.chatTab = chatTab;
        this.mode = ChatMode.ServerMultiPlayer;
    }

    public boolean isEnabled() {
        return ChatUtility.chatStreamEnabled(this.type);
    }

    protected String getChatOwnerName() {
        if (this.chatOwner == null) {
            if (this.mode != ChatMode.ServerMultiPlayer) {
                if (Core.bDebug) {
                    throw new NullPointerException("chat owner is null but name quired");
                }
                DebugLog.log("chat owner is null but name quired. Chat: " + this.getType());
            }
            return "";
        }
        return this.chatOwner.username;
    }

    protected IsoPlayer getChatOwner() {
        if (this.chatOwner == null && this.mode != ChatMode.ServerMultiPlayer) {
            if (Core.bDebug) {
                throw new NullPointerException("chat owner is null");
            }
            DebugLog.log("chat owner is null. Chat: " + this.getType());
            return null;
        }
        return this.chatOwner;
    }

    public ChatMode getMode() {
        return this.mode;
    }

    public ChatType getType() {
        return this.type;
    }

    public int getID() {
        return this.id;
    }

    public String getTitleID() {
        return this.titleID;
    }

    public Color getColor() {
        return this.settings.getFontColor();
    }

    public short getTabID() {
        return this.chatTab.getID();
    }

    public float getRange() {
        return this.settings.getRange();
    }

    public boolean isSendingToRadio() {
        return false;
    }

    public float getZombieAttractionRange() {
        return this.settings.getZombieAttractionRange();
    }

    public void setSettings(ChatSettings chatSettings) {
        this.settings = chatSettings;
        this.customSettings = true;
    }

    public void setFontSize(String string) {
        this.settings.setFontSize(string.toLowerCase());
    }

    public void setShowTimestamp(boolean bl) {
        this.settings.setShowTimestamp(bl);
    }

    public void setShowTitle(boolean bl) {
        this.settings.setShowChatTitle(bl);
    }

    protected boolean isCustomSettings() {
        return this.customSettings;
    }

    protected boolean isAllowImages() {
        return this.settings.isAllowImages();
    }

    protected boolean isAllowChatIcons() {
        return this.settings.isAllowChatIcons();
    }

    protected boolean isAllowColors() {
        return this.settings.isAllowColors();
    }

    protected boolean isAllowFonts() {
        return this.settings.isAllowFonts();
    }

    protected boolean isAllowBBcode() {
        return this.settings.isAllowBBcode();
    }

    protected boolean isEqualizeLineHeights() {
        return this.settings.isEqualizeLineHeights();
    }

    protected boolean isShowAuthor() {
        return this.settings.isShowAuthor();
    }

    protected boolean isShowTimestamp() {
        return this.settings.isShowTimestamp();
    }

    protected boolean isShowTitle() {
        return this.settings.isShowChatTitle();
    }

    protected String getFontSize() {
        return this.settings.getFontSize().toString();
    }

    protected String getTitle() {
        if (this.translatedTitle == null) {
            this.translatedTitle = Translator.getText(this.titleID);
        }
        return this.translatedTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Lock lock = this.memberLock;
        synchronized (lock) {
            ArrayList<Short> arrayList = new ArrayList<Short>(this.members);
            for (Short s : arrayList) {
                this.leaveMember(s);
            }
            this.members.clear();
        }
    }

    protected void packChat(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putInt(this.type.getValue());
        byteBufferWriter.putShort(this.getTabID());
        byteBufferWriter.putInt(this.id);
        byteBufferWriter.putBoolean(this.customSettings);
        if (this.customSettings) {
            this.settings.pack(byteBufferWriter);
        }
    }

    public ChatMessage unpackMessage(ByteBuffer byteBuffer) {
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        ChatMessage chatMessage = this.createMessage(string2);
        chatMessage.setAuthor(string);
        return chatMessage;
    }

    public void packMessage(ByteBufferWriter byteBufferWriter, ChatMessage chatMessage) {
        byteBufferWriter.putInt(this.id);
        byteBufferWriter.putUTF(chatMessage.getAuthor());
        byteBufferWriter.putUTF(chatMessage.getText());
    }

    public ChatMessage createMessage(String string) {
        return this.createMessage(this.getChatOwnerName(), string);
    }

    private ChatMessage createMessage(String string, String string2) {
        ChatMessage chatMessage = new ChatMessage(this, string2);
        chatMessage.setAuthor(string);
        chatMessage.setServerAuthor(false);
        return chatMessage;
    }

    public ServerChatMessage createServerMessage(String string) {
        ServerChatMessage serverChatMessage = new ServerChatMessage(this, string);
        serverChatMessage.setServerAuthor(true);
        return serverChatMessage;
    }

    public void showMessage(String string, String string2) {
        ChatMessage chatMessage = new ChatMessage(this, LocalDateTime.now(), string);
        chatMessage.setAuthor(string2);
        this.showMessage(chatMessage);
    }

    public void showMessage(ChatMessage chatMessage) {
        this.messages.add(chatMessage);
        if (this.isEnabled() && chatMessage.isShowInChat() && this.chatTab != null) {
            LuaEventManager.triggerEvent("OnAddMessage", chatMessage, this.getTabID());
        }
    }

    public String getMessageTextWithPrefix(ChatMessage chatMessage) {
        return this.getMessagePrefix(chatMessage) + " " + chatMessage.getTextWithReplacedParentheses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageToChatMembers(ChatMessage chatMessage) {
        IsoPlayer isoPlayer = ChatUtility.findPlayer(chatMessage.getAuthor());
        if (isoPlayer == null) {
            DebugLog.log("Author '" + chatMessage.getAuthor() + "' not found");
            return;
        }
        Lock lock = this.memberLock;
        synchronized (lock) {
            for (short s : this.members) {
                IsoPlayer isoPlayer2 = ChatUtility.findPlayer(s);
                if (isoPlayer2 == null || isoPlayer.getOnlineID() == s) continue;
                this.sendMessageToPlayer(s, chatMessage);
            }
        }
        if (Core.bDebug) {
            DebugLog.log("New message '" + chatMessage + "' was sent members of chat '" + this.getID() + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageToChatMembers(ServerChatMessage serverChatMessage) {
        Lock lock = this.memberLock;
        synchronized (lock) {
            for (short s : this.members) {
                IsoPlayer isoPlayer = ChatUtility.findPlayer(s);
                if (isoPlayer == null) continue;
                this.sendMessageToPlayer(s, (ChatMessage)serverChatMessage);
            }
        }
        if (Core.bDebug) {
            DebugLog.log("New message '" + serverChatMessage + "' was sent members of chat '" + this.getID() + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageToPlayer(UdpConnection udpConnection, ChatMessage chatMessage) {
        Lock lock = this.memberLock;
        synchronized (lock) {
            boolean bl = false;
            short[] sArray = udpConnection.playerIDs;
            int n = sArray.length;
            for (int i = 0; i < n; ++i) {
                Short s = sArray[i];
                if (bl) break;
                bl = this.members.contains(s);
            }
            if (!bl) {
                throw new RuntimeException("Passed connection didn't contained member of chat");
            }
            this.sendChatMessageToPlayer(udpConnection, chatMessage);
        }
    }

    public void sendMessageToPlayer(short s, ChatMessage chatMessage) {
        UdpConnection udpConnection = ChatUtility.findConnection(s);
        if (udpConnection == null) {
            return;
        }
        this.sendChatMessageToPlayer(udpConnection, chatMessage);
        DebugLog.log("Message '" + chatMessage + "' was sent to player with id '" + s + "' of chat '" + this.getID() + "'");
    }

    public String getMessagePrefix(ChatMessage chatMessage) {
        StringBuilder stringBuilder = new StringBuilder(this.getChatSettingsTags());
        if (this.isShowTimestamp()) {
            stringBuilder.append("[").append(LuaManager.getHourMinuteJava()).append("]");
        }
        if (this.isShowTitle()) {
            stringBuilder.append("[").append(this.getTitle()).append("]");
        }
        if (this.isShowAuthor()) {
            stringBuilder.append("[").append(chatMessage.getAuthor()).append("]");
        }
        stringBuilder.append(": ");
        return stringBuilder.toString();
    }

    protected String getColorTag() {
        Color color = this.getColor();
        return this.getColorTag(color);
    }

    protected String getColorTag(Color color) {
        return "<RGB:" + color.r + "," + color.g + "," + color.b + ">";
    }

    protected String getFontSizeTag() {
        return "<SIZE:" + this.settings.getFontSize() + ">";
    }

    protected String getChatSettingsTags() {
        return this.getColorTag() + " " + this.getFontSizeTag() + " ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(short s) {
        Lock lock = this.memberLock;
        synchronized (lock) {
            if (!this.hasMember(s)) {
                this.members.add(s);
                this.justAddedMembers.add(s);
                UdpConnection udpConnection = ChatUtility.findConnection(s);
                if (udpConnection != null) {
                    this.sendPlayerJoinChatPacket(udpConnection);
                    this.chatTab.sendAddTabPacket(udpConnection);
                } else if (Core.bDebug) {
                    throw new RuntimeException("Connection should exist!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveMember(Short s) {
        Lock lock = this.memberLock;
        synchronized (lock) {
            if (this.hasMember(s)) {
                this.justRemovedMembers.add(s);
                UdpConnection udpConnection = ChatUtility.findConnection(s);
                if (udpConnection != null) {
                    this.sendPlayerLeaveChatPacket(udpConnection);
                }
                this.members.remove(s);
            }
        }
    }

    private boolean hasMember(Short s) {
        return this.members.contains(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(Short s) {
        Lock lock = this.memberLock;
        synchronized (lock) {
            if (this.hasMember(s)) {
                this.members.remove(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncMembersByUsernames(ArrayList<String> arrayList) {
        Lock lock = this.memberLock;
        synchronized (lock) {
            this.justAddedMembers.clear();
            this.justRemovedMembers.clear();
            ArrayList<Short> arrayList2 = new ArrayList<Short>(arrayList.size());
            IsoPlayer isoPlayer = null;
            for (String string : arrayList) {
                isoPlayer = ChatUtility.findPlayer(string);
                if (isoPlayer == null) continue;
                arrayList2.add(isoPlayer.getOnlineID());
            }
            this.syncMembers(arrayList2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Short> getJustAddedMembers() {
        Lock lock = this.memberLock;
        synchronized (lock) {
            return this.justAddedMembers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Short> getJustRemovedMembers() {
        Lock lock = this.memberLock;
        synchronized (lock) {
            return this.justRemovedMembers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncMembers(ArrayList<Short> arrayList) {
        for (Short object2 : arrayList) {
            this.addMember(object2);
        }
        ArrayList arrayList2 = new ArrayList();
        Lock lock = this.memberLock;
        synchronized (lock) {
            for (Short s : this.members) {
                if (arrayList.contains(s)) continue;
                arrayList2.add(s);
            }
            Iterator<Short> iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                Short s;
                s = iterator.next();
                this.leaveMember(s);
            }
        }
    }

    public void sendPlayerJoinChatPacket(UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.PlayerJoinChat.doPacket(byteBufferWriter);
        this.packChat(byteBufferWriter);
        PacketTypes.PacketType.PlayerJoinChat.send(udpConnection);
    }

    public void sendPlayerLeaveChatPacket(short s) {
        UdpConnection udpConnection = ChatUtility.findConnection(s);
        this.sendPlayerLeaveChatPacket(udpConnection);
    }

    public void sendPlayerLeaveChatPacket(UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.PlayerLeaveChat.doPacket(byteBufferWriter);
        byteBufferWriter.putInt(this.getID());
        byteBufferWriter.putInt(this.getType().getValue());
        PacketTypes.PacketType.PlayerLeaveChat.send(udpConnection);
    }

    public void sendToServer(ChatMessage chatMessage, DeviceData deviceData) {
        if (this.serverConnection == null) {
            DebugLog.log("Connection to server is null in client chat");
        }
        this.sendChatMessageFromPlayer(this.serverConnection, chatMessage);
    }

    private void sendChatMessageToPlayer(UdpConnection udpConnection, ChatMessage chatMessage) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.ChatMessageToPlayer.doPacket(byteBufferWriter);
        this.packMessage(byteBufferWriter, chatMessage);
        PacketTypes.PacketType.ChatMessageToPlayer.send(udpConnection);
    }

    private void sendChatMessageFromPlayer(UdpConnection udpConnection, ChatMessage chatMessage) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.ChatMessageFromPlayer.doPacket(byteBufferWriter);
        this.packMessage(byteBufferWriter, chatMessage);
        PacketTypes.PacketType.ChatMessageFromPlayer.send(udpConnection);
    }

    protected boolean hasChatTab() {
        return this.chatTab != null;
    }
}

