/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.traits;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import zombie.characters.skills.PerkFactory;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.interfaces.IListBoxItem;

public final class TraitFactory {
    public static LinkedHashMap<String, Trait> TraitMap = new LinkedHashMap();

    public static void init() {
    }

    public static void setMutualExclusive(String string, String string2) {
        TraitFactory.TraitMap.get((Object)string).MutuallyExclusive.add(string2);
        TraitFactory.TraitMap.get((Object)string2).MutuallyExclusive.add(string);
    }

    public static void sortList() {
        LinkedList<Map.Entry<String, Trait>> linkedList = new LinkedList<Map.Entry<String, Trait>>(TraitMap.entrySet());
        Collections.sort(linkedList, new Comparator<Map.Entry<String, Trait>>(){

            @Override
            public int compare(Map.Entry<String, Trait> entry, Map.Entry<String, Trait> entry2) {
                return entry.getValue().name.compareTo(entry2.getValue().name);
            }
        });
        LinkedHashMap<String, Trait> linkedHashMap = new LinkedHashMap<String, Trait>();
        for (Map.Entry entry : linkedList) {
            linkedHashMap.put((String)entry.getKey(), (Trait)entry.getValue());
        }
        TraitMap = linkedHashMap;
    }

    public static Trait addTrait(String string, String string2, int n, String string3, boolean bl) {
        Trait trait = new Trait(string, string2, n, string3, bl, false);
        TraitMap.put(string, trait);
        return trait;
    }

    public static Trait addTrait(String string, String string2, int n, String string3, boolean bl, boolean bl2) {
        Trait trait = new Trait(string, string2, n, string3, bl, bl2);
        TraitMap.put(string, trait);
        return trait;
    }

    public static ArrayList<Trait> getTraits() {
        ArrayList<Trait> arrayList = new ArrayList<Trait>();
        for (Trait trait : TraitMap.values()) {
            arrayList.add(trait);
        }
        return arrayList;
    }

    public static Trait getTrait(String string) {
        if (TraitMap.containsKey(string)) {
            return TraitMap.get(string);
        }
        return null;
    }

    public static void Reset() {
        TraitMap.clear();
    }

    public static class Trait
    implements IListBoxItem {
        public String traitID;
        public String name;
        public int cost;
        public String description;
        public boolean prof;
        public Texture texture = null;
        private boolean removeInMP = false;
        private List<String> freeRecipes = new ArrayList<String>();
        public ArrayList<String> MutuallyExclusive = new ArrayList(0);
        public HashMap<PerkFactory.Perk, Integer> XPBoostMap = new HashMap();

        public void addXPBoost(PerkFactory.Perk perk, int n) {
            if (perk == null || perk == PerkFactory.Perks.None || perk == PerkFactory.Perks.MAX) {
                DebugLog.General.warn("invalid perk passed to Trait.addXPBoost trait=%s perk=%s", this.name, perk);
                return;
            }
            this.XPBoostMap.put(perk, n);
        }

        public List<String> getFreeRecipes() {
            return this.freeRecipes;
        }

        public void setFreeRecipes(List<String> list) {
            this.freeRecipes = list;
        }

        public Trait(String string, String string2, int n, String string3, boolean bl, boolean bl2) {
            this.traitID = string;
            this.name = string2;
            this.cost = n;
            this.description = string3;
            this.prof = bl;
            this.texture = Texture.getSharedTexture("media/ui/Traits/trait_" + this.traitID.toLowerCase(Locale.ENGLISH) + ".png");
            if (this.texture == null) {
                this.texture = Texture.getSharedTexture("media/ui/Traits/trait_generic.png");
            }
            this.removeInMP = bl2;
        }

        public String getType() {
            return this.traitID;
        }

        public Texture getTexture() {
            return this.texture;
        }

        @Override
        public String getLabel() {
            return this.name;
        }

        @Override
        public String getLeftLabel() {
            return this.name;
        }

        @Override
        public String getRightLabel() {
            int n = this.cost;
            if (n == 0) {
                return "";
            }
            String string = "+";
            if (n > 0) {
                string = "-";
            } else if (n == 0) {
                string = "";
            }
            if (n < 0) {
                n = -n;
            }
            return string + new Integer(n).toString();
        }

        public int getCost() {
            return this.cost;
        }

        public boolean isFree() {
            return this.prof;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public ArrayList<String> getMutuallyExclusiveTraits() {
            return this.MutuallyExclusive;
        }

        public HashMap<PerkFactory.Perk, Integer> getXPBoostMap() {
            return this.XPBoostMap;
        }

        public boolean isRemoveInMP() {
            return this.removeInMP;
        }

        public void setRemoveInMP(boolean bl) {
            this.removeInMP = bl;
        }
    }
}

