/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import zombie.util.Lambda;
import zombie.util.StringUtils;
import zombie.util.list.PZArrayUtil;

public class TraitCollection {
    private final List<String> m_activeTraitNames = new ArrayList<String>();
    private final List<TraitSlot> m_traits = new ArrayList<TraitSlot>();

    public boolean remove(Object object) {
        return this.remove(String.valueOf(object));
    }

    public boolean remove(String string) {
        int n = this.indexOfTrait(string);
        if (n > -1) {
            this.deactivateTraitSlot(n);
        }
        return n > -1;
    }

    public void addAll(Collection<? extends String> collection) {
        PZArrayUtil.forEach(collection, this::add);
    }

    public void removeAll(Collection<?> collection) {
        PZArrayUtil.forEach(collection, this::remove);
    }

    public void clear() {
        PZArrayUtil.forEach(this.m_traits, traitSlot -> {
            traitSlot.m_isSet = false;
        });
        this.m_activeTraitNames.clear();
    }

    public int size() {
        return this.m_activeTraitNames.size();
    }

    public boolean isEmpty() {
        return this.m_activeTraitNames.isEmpty();
    }

    public boolean contains(Object object) {
        return this.contains(String.valueOf(object));
    }

    public boolean contains(String string) {
        int n = this.indexOfTrait(string);
        return n > -1 && this.getSlotInternal((int)n).m_isSet;
    }

    public void add(String string) {
        if (string == null) {
            return;
        }
        this.getOrCreateSlotInternal((String)string).m_isSet = true;
        this.m_activeTraitNames.add(string);
    }

    public String get(int n) {
        return this.m_activeTraitNames.get(n);
    }

    public void set(String string, boolean bl) {
        if (bl) {
            this.add(string);
        } else {
            this.remove(string);
        }
    }

    public TraitSlot getTraitSlot(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return null;
        }
        return this.getOrCreateSlotInternal(string);
    }

    private int indexOfTrait(String string) {
        return PZArrayUtil.indexOf(this.m_traits, Lambda.predicate(string, TraitSlot::isName));
    }

    private TraitSlot getSlotInternal(int n) {
        return this.m_traits.get(n);
    }

    private TraitSlot getOrCreateSlotInternal(String string) {
        int n = this.indexOfTrait(string);
        if (n == -1) {
            n = this.m_traits.size();
            this.m_traits.add(new TraitSlot(string));
        }
        return this.getSlotInternal(n);
    }

    private void deactivateTraitSlot(int n) {
        TraitSlot traitSlot = this.getSlotInternal(n);
        traitSlot.m_isSet = false;
        int n2 = PZArrayUtil.indexOf(this.m_activeTraitNames, Lambda.predicate(traitSlot.Name, String::equalsIgnoreCase));
        if (n2 != -1) {
            this.m_activeTraitNames.remove(n2);
        }
    }

    public String toString() {
        return "TraitCollection(" + PZArrayUtil.arrayToString(this.m_activeTraitNames, "", "", ", ") + ")";
    }

    public class TraitSlot {
        public final String Name;
        private boolean m_isSet;

        private TraitSlot(String string) {
            this.Name = string;
            this.m_isSet = false;
        }

        public boolean isName(String string) {
            return StringUtils.equalsIgnoreCase(this.Name, string);
        }

        public boolean isSet() {
            return this.m_isSet;
        }

        public void set(boolean bl) {
            if (this.m_isSet == bl) {
                return;
            }
            TraitCollection.this.set(this.Name, bl);
        }

        public String toString() {
            return "TraitSlot(" + this.Name + ":" + this.m_isSet + ")";
        }
    }
}

