/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.skills;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import se.krka.kahlua.vm.KahluaTable;
import zombie.Lua.LuaManager;
import zombie.ZomboidFileSystem;
import zombie.characters.skills.CustomPerk;
import zombie.characters.skills.PerkFactory;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.debug.DebugLog;
import zombie.gameStates.ChooseGameInfo;
import zombie.scripting.ScriptParser;
import zombie.util.StringUtils;

public final class CustomPerks {
    private static final int VERSION1 = 1;
    private static final int VERSION = 1;
    public static final CustomPerks instance = new CustomPerks();
    private final ArrayList<CustomPerk> m_perks = new ArrayList();

    public void init() {
        Object object;
        Object object2;
        ArrayList<String> arrayList = ZomboidFileSystem.instance.getModIDs();
        for (int i = 0; i < arrayList.size(); ++i) {
            String object3 = arrayList.get(i);
            object2 = ChooseGameInfo.getAvailableModDetails(object3);
            if (object2 == null || !((File)(object = new File(((ChooseGameInfo.Mod)object2).getDir() + File.separator + "media" + File.separator + "perks.txt"))).exists() || ((File)object).isDirectory()) continue;
            this.readFile(((File)object).getAbsolutePath());
        }
        for (CustomPerk customPerk : this.m_perks) {
            object2 = PerkFactory.Perks.FromString(customPerk.m_id);
            if (object2 != null && object2 != PerkFactory.Perks.None && object2 != PerkFactory.Perks.MAX) continue;
            object2 = new PerkFactory.Perk(customPerk.m_id);
            ((PerkFactory.Perk)object2).setCustom();
        }
        for (CustomPerk customPerk : this.m_perks) {
            object2 = PerkFactory.Perks.FromString(customPerk.m_id);
            object = PerkFactory.Perks.FromString(customPerk.m_parent);
            if (object == null || object == PerkFactory.Perks.None || object == PerkFactory.Perks.MAX) {
                object = PerkFactory.Perks.None;
            }
            int[] nArray = customPerk.m_xp;
            PerkFactory.AddPerk((PerkFactory.Perk)object2, customPerk.m_translation, (PerkFactory.Perk)object, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], nArray[6], nArray[7], nArray[8], nArray[9], customPerk.m_bPassive);
        }
    }

    public void initLua() {
        KahluaTable kahluaTable = (KahluaTable)LuaManager.env.rawget((Object)"Perks");
        for (CustomPerk customPerk : this.m_perks) {
            PerkFactory.Perk perk = PerkFactory.Perks.FromString(customPerk.m_id);
            kahluaTable.rawset((Object)perk.getId(), (Object)perk);
        }
    }

    public static void Reset() {
        CustomPerks.instance.m_perks.clear();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean readFile(String string) {
        try (FileReader fileReader = new FileReader(string);){
            boolean bl;
            try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    stringBuilder.append(string2);
                    string2 = bufferedReader.readLine();
                }
                this.parse(stringBuilder.toString());
                bl = true;
            }
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return false;
        }
    }

    private void parse(String string) {
        string = ScriptParser.stripComments(string);
        ScriptParser.Block block = ScriptParser.parse(string);
        int n = -1;
        ScriptParser.Value value = block.getValue("VERSION");
        if (value != null) {
            n = PZMath.tryParseInt(value.getValue(), -1);
        }
        if (n < 1 || n > 1) {
            throw new RuntimeException("invalid or missing VERSION");
        }
        for (ScriptParser.Block block2 : block.children) {
            if (!block2.type.equalsIgnoreCase("perk")) {
                throw new RuntimeException("unknown block type \"" + block2.type + "\"");
            }
            CustomPerk customPerk = this.parsePerk(block2);
            if (customPerk == null) {
                DebugLog.General.warn("failed to parse custom perk \"%s\"", block2.id);
                continue;
            }
            this.m_perks.add(customPerk);
        }
    }

    private CustomPerk parsePerk(ScriptParser.Block block) {
        ScriptParser.Value value;
        ScriptParser.Value value2;
        if (StringUtils.isNullOrWhitespace(block.id)) {
            DebugLog.General.warn("missing or empty perk id");
            return null;
        }
        CustomPerk customPerk = new CustomPerk(block.id);
        ScriptParser.Value value3 = block.getValue("parent");
        if (value3 != null && !StringUtils.isNullOrWhitespace(value3.getValue())) {
            customPerk.m_parent = value3.getValue().trim();
        }
        if ((value2 = block.getValue("translation")) != null) {
            customPerk.m_translation = StringUtils.discardNullOrWhitespace(value2.getValue().trim());
        }
        if (StringUtils.isNullOrWhitespace(customPerk.m_translation)) {
            customPerk.m_translation = customPerk.m_id;
        }
        if ((value = block.getValue("passive")) != null) {
            customPerk.m_bPassive = StringUtils.tryParseBoolean(value.getValue().trim());
        }
        for (int i = 1; i <= 10; ++i) {
            int n;
            ScriptParser.Value value4 = block.getValue("xp" + i);
            if (value4 == null || (n = PZMath.tryParseInt(value4.getValue().trim(), -1)) <= 0) continue;
            customPerk.m_xp[i - 1] = n;
        }
        return customPerk;
    }
}

