/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.professions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import zombie.characters.skills.PerkFactory;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.interfaces.IListBoxItem;

public final class ProfessionFactory {
    public static LinkedHashMap<String, Profession> ProfessionMap = new LinkedHashMap();

    public static void init() {
    }

    public static Profession addProfession(String string, String string2, String string3, int n) {
        Profession profession = new Profession(string, string2, string3, n, "");
        ProfessionMap.put(string, profession);
        return profession;
    }

    public static Profession getProfession(String string) {
        for (Profession profession : ProfessionMap.values()) {
            if (!profession.type.equals(string)) continue;
            return profession;
        }
        return null;
    }

    public static ArrayList<Profession> getProfessions() {
        ArrayList<Profession> arrayList = new ArrayList<Profession>();
        for (Profession profession : ProfessionMap.values()) {
            arrayList.add(profession);
        }
        return arrayList;
    }

    public static void Reset() {
        ProfessionMap.clear();
    }

    public static class Profession
    implements IListBoxItem {
        public String type;
        public String name;
        public int cost;
        public String description;
        public String IconPath;
        public Texture texture = null;
        public Stack<String> FreeTraitStack = new Stack();
        private List<String> freeRecipes = new ArrayList<String>();
        public HashMap<PerkFactory.Perk, Integer> XPBoostMap = new HashMap();

        public Profession(String string, String string2, String string3, int n, String string4) {
            this.type = string;
            this.name = string2;
            this.IconPath = string3;
            if (!string3.equals("")) {
                this.texture = Texture.trygetTexture(string3);
            }
            this.cost = n;
            this.description = string4;
        }

        public Texture getTexture() {
            return this.texture;
        }

        public void addFreeTrait(String string) {
            this.FreeTraitStack.add(string);
        }

        public ArrayList<String> getFreeTraits() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(this.FreeTraitStack);
            return arrayList;
        }

        @Override
        public String getLabel() {
            return this.getName();
        }

        public String getIconPath() {
            return this.IconPath;
        }

        @Override
        public String getLeftLabel() {
            return this.getName();
        }

        @Override
        public String getRightLabel() {
            int n = this.getCost();
            if (n == 0) {
                return "";
            }
            String string = "+";
            if (n > 0) {
                string = "-";
            } else if (n == 0) {
                string = "";
            }
            if (n < 0) {
                n = -n;
            }
            return string + n;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public int getCost() {
            return this.cost;
        }

        public void setCost(int n) {
            this.cost = n;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public void setIconPath(String string) {
            this.IconPath = string;
        }

        public Stack<String> getFreeTraitStack() {
            return this.FreeTraitStack;
        }

        public void addXPBoost(PerkFactory.Perk perk, int n) {
            if (perk == null || perk == PerkFactory.Perks.None || perk == PerkFactory.Perks.MAX) {
                DebugLog.General.warn("invalid perk passed to Profession.addXPBoost profession=%s perk=%s", this.name, perk);
                return;
            }
            this.XPBoostMap.put(perk, n);
        }

        public HashMap<PerkFactory.Perk, Integer> getXPBoostMap() {
            return this.XPBoostMap;
        }

        public void setFreeTraitStack(Stack<String> stack) {
            this.FreeTraitStack = stack;
        }

        public List<String> getFreeRecipes() {
            return this.freeRecipes;
        }

        public void setFreeRecipes(List<String> list) {
            this.freeRecipes = list;
        }
    }
}

