/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.action;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.action.ActionContext;
import zombie.characters.action.IActionCondition;
import zombie.core.Core;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.network.GameClient;
import zombie.util.Lambda;
import zombie.util.PZXmlUtil;
import zombie.util.StringUtils;

public final class ActionTransition
implements Cloneable {
    String transitionTo;
    boolean asSubstate;
    boolean transitionOut;
    boolean forceParent;
    final List<IActionCondition> conditions = new ArrayList<IActionCondition>();

    public static boolean parse(Element element, String string, List<ActionTransition> list) {
        if (element.getNodeName().equals("transitions")) {
            ActionTransition.parseTransitions(element, string, list);
            return true;
        }
        if (element.getNodeName().equals("transition")) {
            ActionTransition.parseTransition(element, list);
            return true;
        }
        return false;
    }

    public static void parseTransition(Element element, List<ActionTransition> list) {
        list.clear();
        ActionTransition actionTransition = new ActionTransition();
        if (actionTransition.load(element)) {
            list.add(actionTransition);
        }
    }

    public static void parseTransitions(Element element2, String string2, List<ActionTransition> list2) {
        list2.clear();
        Lambda.forEachFrom(PZXmlUtil::forEachElement, element2, string2, list2, (element, string, list) -> {
            if (!element.getNodeName().equals("transition")) {
                DebugLog.ActionSystem.warn("Warning: Unrecognised element '" + element.getNodeName() + "' in " + string);
                return;
            }
            ActionTransition actionTransition = new ActionTransition();
            if (actionTransition.load((Element)element)) {
                list.add(actionTransition);
            }
        });
    }

    private boolean load(Element element) {
        try {
            PZXmlUtil.forEachElement(element, element2 -> {
                try {
                    String string = element2.getNodeName();
                    if ("transitionTo".equalsIgnoreCase(string)) {
                        this.transitionTo = element2.getTextContent();
                    } else if ("transitionOut".equalsIgnoreCase(string)) {
                        this.transitionOut = StringUtils.tryParseBoolean(element2.getTextContent());
                    } else if ("forceParent".equalsIgnoreCase(string)) {
                        this.forceParent = StringUtils.tryParseBoolean(element2.getTextContent());
                    } else if ("asSubstate".equalsIgnoreCase(string)) {
                        this.asSubstate = StringUtils.tryParseBoolean(element2.getTextContent());
                    } else if ("conditions".equalsIgnoreCase(string)) {
                        PZXmlUtil.forEachElement(element2, element -> {
                            IActionCondition iActionCondition = IActionCondition.createInstance(element);
                            if (iActionCondition != null) {
                                this.conditions.add(iActionCondition);
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    DebugLog.ActionSystem.error("Error while parsing xml element: " + element2.getNodeName());
                    DebugLog.ActionSystem.error(exception);
                }
            });
            return true;
        }
        catch (Exception exception) {
            DebugLog.ActionSystem.error("Error while loading an ActionTransition element");
            DebugLog.ActionSystem.error(exception);
            return false;
        }
    }

    public String getTransitionTo() {
        return this.transitionTo;
    }

    public boolean passes(ActionContext actionContext, int n) {
        for (int i = 0; i < this.conditions.size(); ++i) {
            IActionCondition iActionCondition = this.conditions.get(i);
            if (iActionCondition.passes(actionContext, n)) continue;
            return false;
        }
        if (Core.bDebug && GameClient.bClient && (DebugOptions.instance.MultiplayerShowPlayerStatus.getValue() && actionContext.getOwner() instanceof IsoPlayer && !((IsoPlayer)actionContext.getOwner()).isGodMod() || DebugOptions.instance.MultiplayerShowZombieStatus.getValue() && actionContext.getOwner() instanceof IsoZombie)) {
            StringBuilder stringBuilder = new StringBuilder("Character ").append(actionContext.getOwner().getClass().getSimpleName()).append(" ").append("id=").append(actionContext.getOwner().getOnlineID()).append(" transition to \"").append(this.transitionTo).append("\":");
            for (IActionCondition iActionCondition : this.conditions) {
                stringBuilder.append(" [").append(iActionCondition.getDescription()).append("]");
            }
            DebugLog.log(DebugType.ActionSystem, stringBuilder.toString());
        }
        return true;
    }

    public ActionTransition clone() {
        ActionTransition actionTransition = new ActionTransition();
        actionTransition.transitionTo = this.transitionTo;
        actionTransition.asSubstate = this.asSubstate;
        actionTransition.transitionOut = this.transitionOut;
        actionTransition.forceParent = this.forceParent;
        for (IActionCondition iActionCondition : this.conditions) {
            actionTransition.conditions.add(iActionCondition.clone());
        }
        return actionTransition;
    }
}

