/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.action;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import org.w3c.dom.Element;
import zombie.characters.action.ActionTransition;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.util.PZXmlUtil;
import zombie.util.StringUtils;
import zombie.util.list.PZArrayUtil;

public final class ActionState {
    public final String name;
    public final ArrayList<ActionTransition> transitions = new ArrayList();
    private String[] m_tags;
    private String[] m_childTags;
    private static final Comparator<ActionTransition> transitionComparator = (actionTransition, actionTransition2) -> actionTransition2.conditions.size() - actionTransition.conditions.size();

    public ActionState(String string) {
        this.name = string;
    }

    public final boolean canHaveSubStates() {
        return !PZArrayUtil.isNullOrEmpty(this.m_childTags);
    }

    public final boolean canBeSubstate() {
        return !PZArrayUtil.isNullOrEmpty(this.m_tags);
    }

    public final boolean canHaveSubState(ActionState actionState) {
        return ActionState.canHaveSubState(this, actionState);
    }

    public static boolean canHaveSubState(ActionState actionState, ActionState actionState2) {
        String[] stringArray = actionState.m_childTags;
        String[] stringArray2 = actionState2.m_tags;
        return ActionState.tagsOverlap(stringArray, stringArray2);
    }

    public static boolean tagsOverlap(String[] stringArray, String[] stringArray2) {
        if (PZArrayUtil.isNullOrEmpty(stringArray)) {
            return false;
        }
        if (PZArrayUtil.isNullOrEmpty(stringArray2)) {
            return false;
        }
        boolean bl = false;
        block0: for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            for (int j = 0; j < stringArray2.length; ++j) {
                String string2 = stringArray2[j];
                if (!StringUtils.equalsIgnoreCase(string, string2)) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    public String getName() {
        return this.name;
    }

    public void load(String string2) {
        File file2 = new File(string2).getAbsoluteFile();
        File[] fileArray = file2.listFiles((file, string) -> string.toLowerCase().endsWith(".xml"));
        if (fileArray == null) {
            return;
        }
        for (File file3 : fileArray) {
            this.parse(file3);
        }
        this.sortTransitions();
    }

    public void parse(File file) {
        ArrayList<ActionTransition> arrayList = new ArrayList<ActionTransition>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        String string = file.getPath();
        try {
            Element element = PZXmlUtil.parseXml(string);
            if (ActionTransition.parse(element, string, arrayList)) {
                this.transitions.addAll(arrayList);
                if (DebugLog.isEnabled(DebugType.ActionSystem)) {
                    DebugLog.ActionSystem.debugln("Loaded transitions from file: %s", string);
                }
                return;
            }
            if (this.parseTags(element, arrayList2, arrayList3)) {
                this.m_tags = PZArrayUtil.concat(this.m_tags, arrayList2.toArray(new String[0]));
                this.m_childTags = PZArrayUtil.concat(this.m_childTags, arrayList3.toArray(new String[0]));
                if (DebugLog.isEnabled(DebugType.ActionSystem)) {
                    DebugLog.ActionSystem.debugln("Loaded tags from file: %s", string);
                }
                return;
            }
            if (DebugLog.isEnabled(DebugType.ActionSystem)) {
                DebugLog.ActionSystem.warn("Unrecognized xml file. It does not appear to be a transition nor a tag(s). %s", string);
            }
        }
        catch (Exception exception) {
            DebugLog.ActionSystem.error("Error loading: " + string);
            DebugLog.ActionSystem.error(exception);
        }
    }

    private boolean parseTags(Element element2, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        arrayList.clear();
        arrayList2.clear();
        if (element2.getNodeName().equals("tags")) {
            PZXmlUtil.forEachElement(element2, element -> {
                if (element.getNodeName().equals("tag")) {
                    arrayList.add(element.getTextContent());
                }
            });
            return true;
        }
        if (element2.getNodeName().equals("childTags")) {
            PZXmlUtil.forEachElement(element2, element -> {
                if (element.getNodeName().equals("tag")) {
                    arrayList.add(element.getTextContent());
                }
            });
            return true;
        }
        return false;
    }

    public void sortTransitions() {
        this.transitions.sort(transitionComparator);
    }

    public void resetForReload() {
        this.transitions.clear();
        this.m_tags = null;
        this.m_childTags = null;
    }
}

