/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.action;

public final class ActionContextEvents {
    private Event m_firstEvent;
    private Event m_eventPool;

    public void add(String string, int n) {
        if (this.contains(string, n, false)) {
            return;
        }
        Event event = this.allocEvent();
        event.name = string;
        event.layer = n;
        event.next = this.m_firstEvent;
        this.m_firstEvent = event;
    }

    public boolean contains(String string, int n) {
        return this.contains(string, n, true);
    }

    public boolean contains(String string, int n, boolean bl) {
        Event event = this.m_firstEvent;
        while (event != null) {
            if (event.name.equalsIgnoreCase(string)) {
                if (n == -1) {
                    return true;
                }
                if (event.layer == n) {
                    return true;
                }
                if (bl && event.layer == -1) {
                    return true;
                }
            }
            event = event.next;
        }
        return false;
    }

    public void clear() {
        if (this.m_firstEvent == null) {
            return;
        }
        Event event = this.m_firstEvent;
        while (event.next != null) {
            event = event.next;
        }
        event.next = this.m_eventPool;
        this.m_eventPool = this.m_firstEvent;
        this.m_firstEvent = null;
    }

    public void clearEvent(String string) {
        Event event = null;
        Event event2 = this.m_firstEvent;
        while (event2 != null) {
            Event event3 = event2.next;
            if (event2.name.equalsIgnoreCase(string)) {
                this.releaseEvent(event2, event);
            } else {
                event = event2;
            }
            event2 = event3;
        }
    }

    private Event allocEvent() {
        if (this.m_eventPool == null) {
            return new Event();
        }
        Event event = this.m_eventPool;
        this.m_eventPool = event.next;
        return event;
    }

    private void releaseEvent(Event event, Event event2) {
        if (event2 == null) {
            assert (event == this.m_firstEvent);
            this.m_firstEvent = event.next;
        } else {
            assert (event != this.m_firstEvent);
            assert (event2.next == event);
            event2.next = event.next;
        }
        event.next = this.m_eventPool;
        this.m_eventPool = event;
    }

    private static final class Event {
        int layer;
        String name;
        Event next;

        private Event() {
        }
    }
}

