/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.util.ArrayList;
import java.util.HashMap;
import se.krka.kahlua.j2se.KahluaTableImpl;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.Lua.LuaManager;
import zombie.PersistentOutfits;
import zombie.characters.AttachedItems.AttachedWeaponDefinitions;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.characters.UnderwearDefinition;
import zombie.core.Rand;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.population.Outfit;
import zombie.core.skinnedmodel.population.OutfitManager;
import zombie.core.skinnedmodel.population.OutfitRNG;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoWorld;
import zombie.network.GameServer;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.util.list.PZArrayUtil;

public final class ZombiesZoneDefinition {
    private static final ArrayList<ZZDZone> s_zoneList = new ArrayList();
    private static final HashMap<String, ZZDZone> s_zoneMap = new HashMap();
    public static boolean bDirty = true;
    private static final PickDefinition pickDef = new PickDefinition();
    private static final HashMap<String, ZZDOutfit> s_customOutfitMap = new HashMap();

    private static void checkDirty() {
        if (bDirty) {
            bDirty = false;
            ZombiesZoneDefinition.init();
        }
    }

    private static void init() {
        s_zoneList.clear();
        s_zoneMap.clear();
        KahluaTableImpl kahluaTableImpl = Type.tryCastTo(LuaManager.env.rawget((Object)"ZombiesZoneDefinition"), KahluaTableImpl.class);
        if (kahluaTableImpl == null) {
            return;
        }
        KahluaTableIterator kahluaTableIterator = kahluaTableImpl.iterator();
        while (kahluaTableIterator.advance()) {
            ZZDZone zZDZone;
            KahluaTableImpl kahluaTableImpl2 = Type.tryCastTo(kahluaTableIterator.getValue(), KahluaTableImpl.class);
            if (kahluaTableImpl2 == null || (zZDZone = ZombiesZoneDefinition.initZone(kahluaTableIterator.getKey().toString(), kahluaTableImpl2)) == null) continue;
            s_zoneList.add(zZDZone);
            s_zoneMap.put(zZDZone.name, zZDZone);
        }
    }

    private static ZZDZone initZone(String string, KahluaTableImpl kahluaTableImpl) {
        ZZDZone zZDZone = new ZZDZone();
        zZDZone.name = string;
        zZDZone.femaleChance = kahluaTableImpl.rawgetInt((Object)"femaleChance");
        zZDZone.maleChance = kahluaTableImpl.rawgetInt((Object)"maleChance");
        zZDZone.chanceToSpawn = kahluaTableImpl.rawgetInt((Object)"chanceToSpawn");
        zZDZone.toSpawn = kahluaTableImpl.rawgetInt((Object)"toSpawn");
        KahluaTableIterator kahluaTableIterator = kahluaTableImpl.iterator();
        while (kahluaTableIterator.advance()) {
            ZZDOutfit zZDOutfit;
            KahluaTableImpl kahluaTableImpl2 = Type.tryCastTo(kahluaTableIterator.getValue(), KahluaTableImpl.class);
            if (kahluaTableImpl2 == null || (zZDOutfit = ZombiesZoneDefinition.initOutfit(kahluaTableImpl2)) == null) continue;
            zZDOutfit.customName = "ZZD." + zZDZone.name + "." + zZDOutfit.name;
            zZDZone.outfits.add(zZDOutfit);
        }
        return zZDZone;
    }

    private static ZZDOutfit initOutfit(KahluaTableImpl kahluaTableImpl) {
        ZZDOutfit zZDOutfit = new ZZDOutfit();
        zZDOutfit.name = kahluaTableImpl.rawgetStr((Object)"name");
        zZDOutfit.chance = kahluaTableImpl.rawgetFloat((Object)"chance");
        zZDOutfit.gender = kahluaTableImpl.rawgetStr((Object)"gender");
        zZDOutfit.toSpawn = kahluaTableImpl.rawgetInt((Object)"toSpawn");
        zZDOutfit.mandatory = kahluaTableImpl.rawgetStr((Object)"mandatory");
        zZDOutfit.room = kahluaTableImpl.rawgetStr((Object)"room");
        zZDOutfit.femaleHairStyles = ZombiesZoneDefinition.initStringChance(kahluaTableImpl.rawgetStr((Object)"femaleHairStyles"));
        zZDOutfit.maleHairStyles = ZombiesZoneDefinition.initStringChance(kahluaTableImpl.rawgetStr((Object)"maleHairStyles"));
        zZDOutfit.beardStyles = ZombiesZoneDefinition.initStringChance(kahluaTableImpl.rawgetStr((Object)"beardStyles"));
        return zZDOutfit;
    }

    private static ArrayList<StringChance> initStringChance(String string) {
        String[] stringArray;
        if (StringUtils.isNullOrWhitespace(string)) {
            return null;
        }
        ArrayList<StringChance> arrayList = new ArrayList<StringChance>();
        for (String string2 : stringArray = string.split(";")) {
            String[] stringArray2 = string2.split(":");
            StringChance stringChance = new StringChance();
            stringChance.str = stringArray2[0];
            stringChance.chance = Float.parseFloat(stringArray2[1]);
            arrayList.add(stringChance);
        }
        return arrayList;
    }

    public static void dressInRandomOutfit(IsoZombie isoZombie) {
        if (isoZombie.isSkeleton()) {
            return;
        }
        IsoGridSquare isoGridSquare = isoZombie.getCurrentSquare();
        if (isoGridSquare == null) {
            return;
        }
        PickDefinition pickDefinition = ZombiesZoneDefinition.pickDefinition(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, isoZombie.isFemale());
        if (pickDefinition == null) {
            String string = isoGridSquare.getRoom() == null ? null : isoGridSquare.getRoom().getName();
            Outfit outfit = ZombiesZoneDefinition.getRandomDefaultOutfit(isoZombie.isFemale(), string);
            isoZombie.dressInPersistentOutfit(outfit.m_Name);
            UnderwearDefinition.addRandomUnderwear(isoZombie);
            return;
        }
        ZombiesZoneDefinition.applyDefinition(isoZombie, pickDefinition.zone, pickDefinition.table, pickDefinition.bFemale);
        UnderwearDefinition.addRandomUnderwear(isoZombie);
    }

    public static IsoMetaGrid.Zone getDefinitionZoneAt(int n, int n2, int n3) {
        ArrayList<IsoMetaGrid.Zone> arrayList = IsoWorld.instance.MetaGrid.getZonesAt(n, n2, n3);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            IsoMetaGrid.Zone zone = arrayList.get(i);
            if (!"ZombiesType".equalsIgnoreCase(zone.type) && !s_zoneMap.containsKey(zone.type)) continue;
            return zone;
        }
        return null;
    }

    public static PickDefinition pickDefinition(int n, int n2, int n3, boolean bl) {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (isoGridSquare == null) {
            return null;
        }
        String string = isoGridSquare.getRoom() == null ? null : isoGridSquare.getRoom().getName();
        ZombiesZoneDefinition.checkDirty();
        IsoMetaGrid.Zone zone = ZombiesZoneDefinition.getDefinitionZoneAt(n, n2, n3);
        if (zone == null) {
            return null;
        }
        if (zone.spawnSpecialZombies == Boolean.FALSE) {
            return null;
        }
        String string2 = StringUtils.isNullOrEmpty(zone.name) ? zone.type : zone.name;
        ZZDZone zZDZone = s_zoneMap.get(string2);
        if (zZDZone == null) {
            return null;
        }
        if (zZDZone.chanceToSpawn != -1) {
            int n4 = zZDZone.chanceToSpawn;
            int n5 = zZDZone.toSpawn;
            ArrayList<Double> arrayList = IsoWorld.instance.getSpawnedZombieZone().get(zone.getName());
            if (arrayList == null) {
                arrayList = new ArrayList();
                IsoWorld.instance.getSpawnedZombieZone().put(zone.getName(), arrayList);
            }
            if (arrayList.contains(zone.id)) {
                zone.spawnSpecialZombies = true;
            }
            if (n5 == -1 || zone.spawnSpecialZombies == null && arrayList.size() < n5) {
                if (Rand.Next(100) < n4) {
                    zone.spawnSpecialZombies = true;
                    arrayList.add(zone.id);
                } else {
                    zone.spawnSpecialZombies = false;
                    zone = null;
                }
            }
        }
        if (zone == null) {
            return null;
        }
        ArrayList<ZZDOutfit> arrayList = new ArrayList<ZZDOutfit>();
        ArrayList<ZZDOutfit> arrayList2 = new ArrayList<ZZDOutfit>();
        int n6 = zZDZone.maleChance;
        int n7 = zZDZone.femaleChance;
        if (n6 > 0 && Rand.Next(100) < n6) {
            bl = false;
        }
        if (n7 > 0 && Rand.Next(100) < n7) {
            bl = true;
        }
        for (int i = 0; i < zZDZone.outfits.size(); ++i) {
            ZZDOutfit zZDOutfit = zZDZone.outfits.get(i);
            String string3 = zZDOutfit.gender;
            String string4 = zZDOutfit.room;
            if (string4 != null && (string == null || !string4.contains(string)) || "male".equalsIgnoreCase(string3) && bl || "female".equalsIgnoreCase(string3) && !bl) continue;
            String string5 = zZDOutfit.name;
            boolean bl2 = Boolean.parseBoolean(zZDOutfit.mandatory);
            if (bl2) {
                Integer n8 = zone.spawnedZombies.get(string5);
                if (n8 == null) {
                    n8 = 0;
                }
                if (n8 >= zZDOutfit.toSpawn) continue;
                arrayList.add(zZDOutfit);
                continue;
            }
            arrayList2.add(zZDOutfit);
        }
        ZZDOutfit zZDOutfit = !arrayList.isEmpty() ? (ZZDOutfit)PZArrayUtil.pickRandom(arrayList) : ZombiesZoneDefinition.getRandomOutfitInSetList(arrayList2, true);
        if (zZDOutfit == null) {
            return null;
        }
        ZombiesZoneDefinition.pickDef.table = zZDOutfit;
        ZombiesZoneDefinition.pickDef.bFemale = bl;
        ZombiesZoneDefinition.pickDef.zone = zone;
        return pickDef;
    }

    public static void applyDefinition(IsoZombie isoZombie, IsoMetaGrid.Zone zone, ZZDOutfit zZDOutfit, boolean bl) {
        isoZombie.setFemaleEtc(bl);
        Outfit outfit = null;
        outfit = !bl ? OutfitManager.instance.FindMaleOutfit(zZDOutfit.name) : OutfitManager.instance.FindFemaleOutfit(zZDOutfit.name);
        String string = zZDOutfit.customName;
        if (outfit == null) {
            outfit = OutfitManager.instance.GetRandomOutfit(bl);
            string = outfit.m_Name;
        } else if (zone != null) {
            Integer n = zone.spawnedZombies.get(outfit.m_Name);
            if (n == null) {
                n = 1;
            }
            zone.spawnedZombies.put(outfit.m_Name, n + 1);
        }
        if (outfit != null) {
            isoZombie.dressInPersistentOutfit(outfit.m_Name);
        }
        ModelManager.instance.ResetNextFrame(isoZombie);
        isoZombie.advancedAnimator.OnAnimDataChanged(false);
    }

    public static Outfit getRandomDefaultOutfit(boolean bl, String string) {
        ZZDOutfit zZDOutfit;
        ArrayList<ZZDOutfit> arrayList = new ArrayList<ZZDOutfit>();
        KahluaTable kahluaTable = (KahluaTable)LuaManager.env.rawget((Object)"ZombiesZoneDefinition");
        ZZDZone zZDZone = s_zoneMap.get("Default");
        for (int i = 0; i < zZDZone.outfits.size(); ++i) {
            zZDOutfit = zZDZone.outfits.get(i);
            String string2 = zZDOutfit.gender;
            String string3 = zZDOutfit.room;
            if (string3 != null && (string == null || !string3.contains(string)) || string2 != null && (!"male".equalsIgnoreCase(string2) || bl) && (!"female".equalsIgnoreCase(string2) || !bl)) continue;
            arrayList.add(zZDOutfit);
        }
        zZDOutfit = ZombiesZoneDefinition.getRandomOutfitInSetList(arrayList, false);
        Outfit outfit = null;
        if (zZDOutfit != null) {
            outfit = bl ? OutfitManager.instance.FindFemaleOutfit(zZDOutfit.name) : OutfitManager.instance.FindMaleOutfit(zZDOutfit.name);
        }
        if (outfit == null) {
            outfit = OutfitManager.instance.GetRandomOutfit(bl);
        }
        return outfit;
    }

    public static ZZDOutfit getRandomOutfitInSetList(ArrayList<ZZDOutfit> arrayList, boolean bl) {
        float f = 0.0f;
        for (int i = 0; i < arrayList.size(); ++i) {
            ZZDOutfit zZDOutfit = arrayList.get(i);
            f += zZDOutfit.chance;
        }
        float f2 = Rand.Next(0.0f, 100.0f);
        if (!bl || f > 100.0f) {
            f2 = Rand.Next(0.0f, f);
        }
        float f3 = 0.0f;
        for (int i = 0; i < arrayList.size(); ++i) {
            ZZDOutfit zZDOutfit = arrayList.get(i);
            if (!(f2 < (f3 += zZDOutfit.chance))) continue;
            return zZDOutfit;
        }
        return null;
    }

    private static String getRandomHairOrBeard(ArrayList<StringChance> arrayList) {
        float f = OutfitRNG.Next(0.0f, 100.0f);
        float f2 = 0.0f;
        for (int i = 0; i < arrayList.size(); ++i) {
            StringChance stringChance = arrayList.get(i);
            if (!(f < (f2 += stringChance.chance))) continue;
            if ("null".equalsIgnoreCase(stringChance.str)) {
                return "";
            }
            return stringChance.str;
        }
        return null;
    }

    public static void registerCustomOutfits() {
        ZombiesZoneDefinition.checkDirty();
        s_customOutfitMap.clear();
        for (ZZDZone zZDZone : s_zoneList) {
            for (ZZDOutfit zZDOutfit : zZDZone.outfits) {
                PersistentOutfits.instance.registerOutfitter(zZDOutfit.customName, true, ZombiesZoneDefinition::ApplyCustomOutfit);
                s_customOutfitMap.put(zZDOutfit.customName, zZDOutfit);
            }
        }
    }

    private static void ApplyCustomOutfit(int n, String string, IsoGameCharacter isoGameCharacter) {
        ZZDOutfit zZDOutfit = s_customOutfitMap.get(string);
        boolean bl = (n & Integer.MIN_VALUE) != 0;
        IsoZombie isoZombie = Type.tryCastTo(isoGameCharacter, IsoZombie.class);
        if (isoZombie != null) {
            isoZombie.setFemaleEtc(bl);
        }
        isoGameCharacter.dressInNamedOutfit(zZDOutfit.name);
        if (isoZombie == null) {
            PersistentOutfits.instance.removeFallenHat(n, isoGameCharacter);
            return;
        }
        AttachedWeaponDefinitions.instance.addRandomAttachedWeapon(isoZombie);
        isoZombie.addRandomBloodDirtHolesEtc();
        boolean bl2 = isoGameCharacter.isFemale();
        if (bl2 && zZDOutfit.femaleHairStyles != null) {
            isoZombie.getHumanVisual().setHairModel(ZombiesZoneDefinition.getRandomHairOrBeard(zZDOutfit.femaleHairStyles));
        }
        if (!bl2 && zZDOutfit.maleHairStyles != null) {
            isoZombie.getHumanVisual().setHairModel(ZombiesZoneDefinition.getRandomHairOrBeard(zZDOutfit.maleHairStyles));
        }
        if (!bl2 && zZDOutfit.beardStyles != null) {
            isoZombie.getHumanVisual().setBeardModel(ZombiesZoneDefinition.getRandomHairOrBeard(zZDOutfit.beardStyles));
        }
        PersistentOutfits.instance.removeFallenHat(n, isoGameCharacter);
    }

    public static int pickPersistentOutfit(IsoGridSquare isoGridSquare) {
        Outfit outfit;
        if (!GameServer.bServer) {
            return 0;
        }
        boolean bl = Rand.Next(2) == 0;
        PickDefinition pickDefinition = ZombiesZoneDefinition.pickDefinition(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, bl);
        if (pickDefinition == null) {
            var4_3 = isoGridSquare.getRoom() == null ? null : isoGridSquare.getRoom().getName();
            outfit = ZombiesZoneDefinition.getRandomDefaultOutfit(bl, var4_3);
        } else {
            bl = pickDefinition.bFemale;
            var4_3 = pickDefinition.table.name;
            outfit = bl ? OutfitManager.instance.FindFemaleOutfit(var4_3) : OutfitManager.instance.FindMaleOutfit(var4_3);
        }
        if (outfit == null) {
            boolean bl2 = true;
        } else {
            int n = PersistentOutfits.instance.pickOutfit(outfit.m_Name, bl);
            if (n == 0) {
                boolean bl3 = true;
            } else {
                return n;
            }
        }
        return 0;
    }

    private static final class ZZDZone {
        String name;
        int femaleChance;
        int maleChance;
        int chanceToSpawn;
        int toSpawn;
        final ArrayList<ZZDOutfit> outfits = new ArrayList();

        private ZZDZone() {
        }
    }

    private static final class ZZDOutfit {
        String name;
        String customName;
        float chance;
        int toSpawn;
        String gender;
        String mandatory;
        String room;
        ArrayList<StringChance> femaleHairStyles;
        ArrayList<StringChance> maleHairStyles;
        ArrayList<StringChance> beardStyles;

        private ZZDOutfit() {
        }
    }

    private static final class StringChance {
        String str;
        float chance;

        private StringChance() {
        }
    }

    public static final class PickDefinition {
        IsoMetaGrid.Zone zone;
        ZZDOutfit table;
        boolean bFemale;
    }
}

