/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.math.PZMath;
import zombie.iso.IsoUtils;
import zombie.network.GameServer;
import zombie.popman.ObjectPool;
import zombie.util.list.PZArrayUtil;

public final class ZombieVocalsManager {
    public static final ZombieVocalsManager instance = new ZombieVocalsManager();
    private final HashSet<IsoZombie> m_added = new HashSet();
    private final ObjectPool<ObjectWithDistance> m_objectPool = new ObjectPool<ObjectWithDistance>(ObjectWithDistance::new);
    private final ArrayList<ObjectWithDistance> m_objects = new ArrayList();
    private final Slot[] m_slots;
    private long m_updateMS = 0L;
    private final Comparator<ObjectWithDistance> comp = new Comparator<ObjectWithDistance>(){

        @Override
        public int compare(ObjectWithDistance objectWithDistance, ObjectWithDistance objectWithDistance2) {
            return Float.compare(objectWithDistance.distSq, objectWithDistance2.distSq);
        }
    };

    public ZombieVocalsManager() {
        int n = 20;
        this.m_slots = PZArrayUtil.newInstance(Slot.class, n, Slot::new);
    }

    public void addCharacter(IsoZombie isoZombie) {
        if (this.m_added.contains(isoZombie)) {
            return;
        }
        this.m_added.add(isoZombie);
        ObjectWithDistance objectWithDistance = this.m_objectPool.alloc();
        objectWithDistance.character = isoZombie;
        this.m_objects.add(objectWithDistance);
    }

    public void update() {
        int n;
        int n2;
        IsoZombie isoZombie;
        int n3;
        if (GameServer.bServer) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.m_updateMS < 500L) {
            return;
        }
        this.m_updateMS = l;
        for (n3 = 0; n3 < this.m_slots.length; ++n3) {
            this.m_slots[n3].playing = false;
        }
        if (this.m_objects.isEmpty()) {
            this.stopNotPlaying();
            return;
        }
        for (n3 = 0; n3 < this.m_objects.size(); ++n3) {
            ObjectWithDistance objectWithDistance = this.m_objects.get(n3);
            isoZombie = objectWithDistance.character;
            objectWithDistance.distSq = this.getClosestListener(isoZombie.x, isoZombie.y, isoZombie.z);
        }
        this.m_objects.sort(this.comp);
        n3 = PZMath.min(this.m_slots.length, this.m_objects.size());
        for (n2 = 0; n2 < n3; ++n2) {
            isoZombie = this.m_objects.get((int)n2).character;
            if (!this.shouldPlay(isoZombie) || (n = this.getExistingSlot(isoZombie)) == -1) continue;
            this.m_slots[n].playSound(isoZombie);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            isoZombie = this.m_objects.get((int)n2).character;
            if (!this.shouldPlay(isoZombie) || (n = this.getExistingSlot(isoZombie)) != -1) continue;
            n = this.getFreeSlot();
            this.m_slots[n].playSound(isoZombie);
        }
        this.stopNotPlaying();
        this.postUpdate();
        this.m_added.clear();
        this.m_objectPool.release((List<ObjectWithDistance>)this.m_objects);
        this.m_objects.clear();
    }

    boolean shouldPlay(IsoZombie isoZombie) {
        return isoZombie.getCurrentSquare() != null;
    }

    int getExistingSlot(IsoZombie isoZombie) {
        for (int i = 0; i < this.m_slots.length; ++i) {
            if (this.m_slots[i].character != isoZombie) continue;
            return i;
        }
        return -1;
    }

    int getFreeSlot() {
        for (int i = 0; i < this.m_slots.length; ++i) {
            if (this.m_slots[i].playing) continue;
            return i;
        }
        return -1;
    }

    void stopNotPlaying() {
        for (int i = 0; i < this.m_slots.length; ++i) {
            Slot slot = this.m_slots[i];
            if (slot.playing) continue;
            slot.stopPlaying();
            slot.character = null;
        }
    }

    public void postUpdate() {
    }

    private float getClosestListener(float f, float f2, float f3) {
        float f4 = Float.MAX_VALUE;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoPlayer.getCurrentSquare() == null) continue;
            float f5 = isoPlayer.getX();
            float f6 = isoPlayer.getY();
            float f7 = isoPlayer.getZ();
            float f8 = IsoUtils.DistanceToSquared(f5, f6, f7 * 3.0f, f, f2, f3 * 3.0f);
            if (isoPlayer.Traits.HardOfHearing.isSet()) {
                f8 *= 4.5f;
            }
            if (!(f8 < f4)) continue;
            f4 = f8;
        }
        return f4;
    }

    public void render() {
        if (Core.bDebug) {
            // empty if block
        }
    }

    public static void Reset() {
        for (int i = 0; i < ZombieVocalsManager.instance.m_slots.length; ++i) {
            ZombieVocalsManager.instance.m_slots[i].stopPlaying();
            ZombieVocalsManager.instance.m_slots[i].character = null;
            ZombieVocalsManager.instance.m_slots[i].playing = false;
        }
    }

    static final class Slot {
        IsoZombie character = null;
        boolean playing = false;

        Slot() {
        }

        void playSound(IsoZombie isoZombie) {
            if (this.character != null && this.character != isoZombie && this.character.vocalEvent != 0L) {
                this.character.getEmitter().stopSoundLocal(this.character.vocalEvent);
                this.character.vocalEvent = 0L;
            }
            this.character = isoZombie;
            this.playing = true;
            if (this.character.vocalEvent == 0L) {
                String string;
                String string2 = string = isoZombie.isFemale() ? "FemaleZombieCombined" : "MaleZombieCombined";
                if (!isoZombie.getFMODParameters().parameterList.contains(isoZombie.parameterZombieState)) {
                    isoZombie.parameterZombieState.update();
                    isoZombie.getFMODParameters().add(isoZombie.parameterZombieState);
                    isoZombie.parameterCharacterInside.update();
                    isoZombie.getFMODParameters().add(isoZombie.parameterCharacterInside);
                    isoZombie.parameterPlayerDistance.update();
                    isoZombie.getFMODParameters().add(isoZombie.parameterPlayerDistance);
                }
                isoZombie.vocalEvent = isoZombie.getEmitter().playVocals(string);
            }
        }

        void stopPlaying() {
            if (this.character == null || this.character.vocalEvent == 0L) {
                return;
            }
            this.character.getEmitter().stopSoundLocal(this.character.vocalEvent);
            this.character.vocalEvent = 0L;
        }
    }

    static final class ObjectWithDistance {
        IsoZombie character;
        float distSq;

        ObjectWithDistance() {
        }
    }
}

