/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import fmod.fmod.FMODManager;
import fmod.fmod.FMOD_STUDIO_PARAMETER_DESCRIPTION;
import zombie.characters.BaseZombieSoundManager;
import zombie.characters.IsoZombie;
import zombie.core.math.PZMath;

public final class ZombieThumpManager
extends BaseZombieSoundManager {
    public static final ZombieThumpManager instance = new ZombieThumpManager();

    public ZombieThumpManager() {
        super(40, 100);
    }

    @Override
    public void playSound(IsoZombie isoZombie) {
        long l = 0L;
        if (isoZombie.thumpFlag == 1) {
            l = isoZombie.getEmitter().playSoundImpl("ZombieThumpGeneric", null);
        } else if (isoZombie.thumpFlag == 2) {
            isoZombie.getEmitter().playSoundImpl("ZombieThumpGeneric", null);
            l = isoZombie.getEmitter().playSoundImpl("ZombieThumpWindow", null);
        } else if (isoZombie.thumpFlag == 3) {
            l = isoZombie.getEmitter().playSoundImpl("ZombieThumpWindow", null);
        } else if (isoZombie.thumpFlag == 4) {
            l = isoZombie.getEmitter().playSoundImpl("ZombieThumpMetal", null);
        } else if (isoZombie.thumpFlag == 5) {
            l = isoZombie.getEmitter().playSoundImpl("ZombieThumpGarageDoor", null);
        }
        FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION = FMODManager.instance.getParameterDescription("ObjectCondition");
        isoZombie.getEmitter().setParameterValue(l, fMOD_STUDIO_PARAMETER_DESCRIPTION, PZMath.ceil(isoZombie.getThumpCondition() * 100.0f));
    }

    @Override
    public void postUpdate() {
        for (int i = 0; i < this.characters.size(); ++i) {
            ((IsoZombie)this.characters.get(i)).setThumpFlag(0);
        }
    }
}

