/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.util.ArrayList;
import zombie.SandboxOptions;
import zombie.ai.ZombieGroupManager;
import zombie.characters.IsoZombie;
import zombie.iso.IsoUtils;

public final class ZombieGroup {
    private final ArrayList<IsoZombie> members = new ArrayList();
    public float lastSpreadOutTime;

    public ZombieGroup reset() {
        this.members.clear();
        this.lastSpreadOutTime = -1.0f;
        return this;
    }

    public void add(IsoZombie isoZombie) {
        if (this.members.contains(isoZombie)) {
            return;
        }
        if (isoZombie.group != null) {
            isoZombie.group.remove(isoZombie);
        }
        this.members.add(isoZombie);
        isoZombie.group = this;
    }

    public void remove(IsoZombie isoZombie) {
        this.members.remove(isoZombie);
        isoZombie.group = null;
    }

    public IsoZombie getLeader() {
        return this.members.isEmpty() ? null : this.members.get(0);
    }

    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    public int size() {
        return this.members.size();
    }

    public void update() {
        int n = SandboxOptions.instance.zombieConfig.RallyTravelDistance.getValue();
        for (int i = 0; i < this.members.size(); ++i) {
            IsoZombie isoZombie = this.members.get(i);
            float f = 0.0f;
            if (i > 0) {
                f = IsoUtils.DistanceToSquared(this.members.get(0).getX(), this.members.get(0).getY(), isoZombie.getX(), isoZombie.getY());
            }
            if (isoZombie.group == this && !(f > (float)(n * n)) && ZombieGroupManager.instance.shouldBeInGroup(isoZombie)) continue;
            if (isoZombie.group == this) {
                isoZombie.group = null;
            }
            this.members.remove(i--);
        }
    }
}

