/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.WornItems;

import java.util.ArrayList;
import java.util.function.Consumer;
import zombie.characters.WornItems.BodyLocationGroup;
import zombie.characters.WornItems.WornItem;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.Clothing;
import zombie.inventory.types.InventoryContainer;
import zombie.util.StringUtils;

public final class WornItems {
    protected final BodyLocationGroup group;
    protected final ArrayList<WornItem> items = new ArrayList();

    public WornItems(BodyLocationGroup bodyLocationGroup) {
        this.group = bodyLocationGroup;
    }

    public WornItems(WornItems wornItems) {
        this.group = wornItems.group;
        this.copyFrom(wornItems);
    }

    public void copyFrom(WornItems wornItems) {
        if (this.group != wornItems.group) {
            throw new RuntimeException("group=" + this.group.id + " other.group=" + wornItems.group.id);
        }
        this.items.clear();
        this.items.addAll(wornItems.items);
    }

    public BodyLocationGroup getBodyLocationGroup() {
        return this.group;
    }

    public WornItem get(int n) {
        return this.items.get(n);
    }

    public void setItem(String string, InventoryItem inventoryItem) {
        int n;
        this.group.checkValid(string);
        if (!this.group.isMultiItem(string) && (n = this.indexOf(string)) != -1) {
            this.items.remove(n);
        }
        for (n = 0; n < this.items.size(); ++n) {
            WornItem wornItem = this.items.get(n);
            if (!this.group.isExclusive(string, wornItem.location)) continue;
            this.items.remove(n--);
        }
        if (inventoryItem == null) {
            return;
        }
        this.remove(inventoryItem);
        n = this.items.size();
        for (int i = 0; i < this.items.size(); ++i) {
            WornItem wornItem = this.items.get(i);
            if (this.group.indexOf(wornItem.getLocation()) <= this.group.indexOf(string)) continue;
            n = i;
            break;
        }
        WornItem wornItem = new WornItem(string, inventoryItem);
        this.items.add(n, wornItem);
    }

    public InventoryItem getItem(String string) {
        this.group.checkValid(string);
        int n = this.indexOf(string);
        if (n == -1) {
            return null;
        }
        return this.items.get((int)n).item;
    }

    public InventoryItem getItemByIndex(int n) {
        if (n < 0 || n >= this.items.size()) {
            return null;
        }
        return this.items.get(n).getItem();
    }

    public void remove(InventoryItem inventoryItem) {
        int n = this.indexOf(inventoryItem);
        if (n == -1) {
            return;
        }
        this.items.remove(n);
    }

    public void clear() {
        this.items.clear();
    }

    public String getLocation(InventoryItem inventoryItem) {
        int n = this.indexOf(inventoryItem);
        if (n == -1) {
            return null;
        }
        return this.items.get(n).getLocation();
    }

    public boolean contains(InventoryItem inventoryItem) {
        return this.indexOf(inventoryItem) != -1;
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void forEach(Consumer<WornItem> consumer) {
        for (int i = 0; i < this.items.size(); ++i) {
            consumer.accept(this.items.get(i));
        }
    }

    public void setFromItemVisuals(ItemVisuals itemVisuals) {
        this.clear();
        for (int i = 0; i < itemVisuals.size(); ++i) {
            ItemVisual itemVisual = (ItemVisual)itemVisuals.get(i);
            String string = itemVisual.getItemType();
            InventoryItem inventoryItem = InventoryItemFactory.CreateItem(string);
            if (inventoryItem == null) continue;
            if (inventoryItem.getVisual() != null) {
                inventoryItem.getVisual().copyFrom(itemVisual);
                inventoryItem.synchWithVisual();
            }
            if (inventoryItem instanceof Clothing && !StringUtils.isNullOrWhitespace(inventoryItem.getBodyLocation())) {
                this.setItem(inventoryItem.getBodyLocation(), inventoryItem);
                continue;
            }
            if (!(inventoryItem instanceof InventoryContainer) || StringUtils.isNullOrWhitespace(((InventoryContainer)inventoryItem).canBeEquipped())) continue;
            this.setItem(((InventoryContainer)inventoryItem).canBeEquipped(), inventoryItem);
        }
    }

    public void getItemVisuals(ItemVisuals itemVisuals) {
        itemVisuals.clear();
        for (int i = 0; i < this.items.size(); ++i) {
            InventoryItem inventoryItem = this.items.get(i).getItem();
            ItemVisual itemVisual = inventoryItem.getVisual();
            if (itemVisual == null) continue;
            itemVisual.setInventoryItem(inventoryItem);
            itemVisuals.add(itemVisual);
        }
    }

    public void addItemsToItemContainer(ItemContainer itemContainer) {
        for (int i = 0; i < this.items.size(); ++i) {
            InventoryItem inventoryItem = this.items.get(i).getItem();
            int n = inventoryItem.getVisual().getHolesNumber();
            inventoryItem.setCondition(inventoryItem.getConditionMax() - n * 3);
            itemContainer.AddItem(inventoryItem);
        }
    }

    private int indexOf(String string) {
        for (int i = 0; i < this.items.size(); ++i) {
            WornItem wornItem = this.items.get(i);
            if (!wornItem.location.equals(string)) continue;
            return i;
        }
        return -1;
    }

    private int indexOf(InventoryItem inventoryItem) {
        for (int i = 0; i < this.items.size(); ++i) {
            WornItem wornItem = this.items.get(i);
            if (wornItem.getItem() != inventoryItem) continue;
            return i;
        }
        return -1;
    }
}

