/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import org.junit.Assert;
import org.junit.Test;
import zombie.characters.NetworkCharacter;
import zombie.iso.Vector2;

public class TestZombieInterpolate
extends Assert {
    @Test
    public void test_predictor_stay() {
        NetworkCharacter.Transform transform;
        int n;
        NetworkCharacter networkCharacter = new NetworkCharacter();
        int n2 = 10000;
        int n3 = 250;
        float f = 100.0f;
        float f2 = 200.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        networkCharacter.predict(n3, n2, f, f2, f3, f4);
        for (n = 0; n < 10; ++n) {
            transform = networkCharacter.predict(n3, n2, f, f2, f3, f4);
            TestZombieInterpolate.assertEquals((float)100.0f, (float)transform.position.x, (float)0.01f);
            TestZombieInterpolate.assertEquals((float)200.0f, (float)transform.position.y, (float)0.01f);
        }
        for (n = 0; n < 10; ++n) {
            transform = networkCharacter.predict(n3, n2 += n3, f, f2, f3, f4);
            TestZombieInterpolate.assertEquals((float)100.0f, (float)transform.position.x, (float)0.01f);
            TestZombieInterpolate.assertEquals((float)200.0f, (float)transform.position.y, (float)0.01f);
        }
    }

    @Test
    public void test_predictor_normal_go() {
        NetworkCharacter networkCharacter = new NetworkCharacter();
        int n = 10000;
        int n2 = 250;
        float f = 100.0f;
        float f2 = 200.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        NetworkCharacter.Transform transform = networkCharacter.predict(n2, n, f, f2, f3, f4);
        TestZombieInterpolate.assertEquals((float)100.0f, (float)transform.position.x, (float)0.01f);
        TestZombieInterpolate.assertEquals((float)200.0f, (float)transform.position.y, (float)0.01f);
        for (int i = 0; i < 30; ++i) {
            transform = networkCharacter.predict(n2, n += n2, f += 10.0f, f2 -= 2.5f, f3, f4);
            TestZombieInterpolate.assertEquals((float)(f + 10.0f), (float)transform.position.x, (float)0.01f);
            TestZombieInterpolate.assertEquals((float)(f2 - 2.5f), (float)transform.position.y, (float)0.01f);
        }
    }

    @Test
    public void test_predictor() {
        NetworkCharacter networkCharacter = new NetworkCharacter();
        int n = 10000;
        int n2 = 200;
        float f = 100.0f;
        float f2 = 200.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        NetworkCharacter.Transform transform = networkCharacter.predict(n2, n, f, f2, f3, f4);
        TestZombieInterpolate.assertEquals((float)100.0f, (float)transform.position.x, (float)0.01f);
        TestZombieInterpolate.assertEquals((float)200.0f, (float)transform.position.y, (float)0.01f);
        transform = networkCharacter.predict(n2, n += n2, f += 200.0f, f2 += 100.0f, f3, f4);
        TestZombieInterpolate.assertEquals((float)500.0f, (float)transform.position.x, (float)0.01f);
        TestZombieInterpolate.assertEquals((float)400.0f, (float)transform.position.y, (float)0.01f);
        f = 500.0f;
        f2 = 500.0f;
        transform = networkCharacter.predict(n2, n += 10000, f, f2, f3, f4);
        TestZombieInterpolate.assertEquals((float)500.0f, (float)transform.position.x, (float)0.01f);
        TestZombieInterpolate.assertEquals((float)500.0f, (float)transform.position.y, (float)0.01f);
        f = 400.0f;
        f2 = 300.0f;
        transform = networkCharacter.predict(n2, n += n2, f, f2, f3, f4);
        TestZombieInterpolate.assertEquals((float)300.0f, (float)transform.position.x, (float)0.01f);
        TestZombieInterpolate.assertEquals((float)100.0f, (float)transform.position.y, (float)0.01f);
    }

    @Test
    public void test_predictor_normal_rotate() {
        int n;
        NetworkCharacter networkCharacter = new NetworkCharacter();
        int n2 = 10000;
        int n3 = 250;
        float f = 100.0f;
        float f2 = 200.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        NetworkCharacter.Transform transform = networkCharacter.predict(n3, n2, f, f2, f3, f4);
        TestZombieInterpolate.assertEquals((float)100.0f, (float)transform.position.x, (float)0.01f);
        TestZombieInterpolate.assertEquals((float)200.0f, (float)transform.position.y, (float)0.01f);
        for (n = 0; n < 10; ++n) {
            transform = networkCharacter.predict(n3, n2 += n3, f += 10.0f, f2 -= 2.5f, f3, f4);
            TestZombieInterpolate.assertEquals((float)(f + 10.0f), (float)transform.position.x, (float)0.01f);
            TestZombieInterpolate.assertEquals((float)(f2 - 2.5f), (float)transform.position.y, (float)0.01f);
        }
        for (n = 0; n < 10; ++n) {
            transform = networkCharacter.predict(n3, n2 += n3, f -= 10.0f, f2 += 2.5f, f3, f4);
            TestZombieInterpolate.assertEquals((float)(f - 10.0f), (float)transform.position.x, (float)0.01f);
            TestZombieInterpolate.assertEquals((float)(f2 + 2.5f), (float)transform.position.y, (float)0.01f);
        }
    }

    @Test
    public void test_reconstructor_stay() {
        int n;
        NetworkCharacter networkCharacter = new NetworkCharacter(0.0f, 100.0f, 0L);
        NetworkCharacter.Transform transform = networkCharacter.transform;
        int n2 = 10000;
        int n3 = 250;
        float f = 100.0f;
        float f2 = 200.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        networkCharacter.updateInterpolationPoint(n2, f, f2, f3, f4);
        for (n = 0; n < 10; ++n) {
            networkCharacter.updateInterpolationPoint(n2, f, f2, f3, f4);
            transform = networkCharacter.reconstruct(n2, transform.position.x, transform.position.y, transform.rotation.x, transform.rotation.y);
            TestZombieInterpolate.assertEquals((float)100.0f, (float)transform.position.x, (float)0.01f);
            TestZombieInterpolate.assertEquals((float)200.0f, (float)transform.position.y, (float)0.01f);
        }
        for (n = 0; n < 10; ++n) {
            networkCharacter.updateInterpolationPoint(n2 += n3, f, f2, f3, f4);
            transform = networkCharacter.reconstruct(n2, transform.position.x, transform.position.y, transform.rotation.x, transform.rotation.y);
            if (Float.isNaN(transform.position.x)) {
                TestZombieInterpolate.assertEquals((float)100.0f, (float)transform.position.x, (float)0.01f);
            }
            TestZombieInterpolate.assertEquals((float)200.0f, (float)transform.position.y, (float)0.01f);
        }
    }

    @Test
    public void test_reconstructor_normal_go() {
        int n;
        NetworkCharacter networkCharacter = new NetworkCharacter(0.0f, 100.0f, 0L);
        NetworkCharacter.Transform transform = networkCharacter.transform;
        int n2 = n = 10000;
        int n3 = 250;
        float f = 100.0f;
        float f2 = 200.0f;
        float f3 = 4.0f;
        float f4 = -1.0f;
        networkCharacter.updateInterpolationPoint(n, f, f2, f3, f4);
        for (int i = 0; i < 30; ++i) {
            networkCharacter.updateInterpolationPoint(n += n3, f += 10.0f, f2 -= 2.5f, f3, f4);
            transform = networkCharacter.reconstruct(n2, transform.position.x, transform.position.y, transform.rotation.x, transform.rotation.y);
            for (int j = 0; j < 5; ++j) {
                transform = networkCharacter.reconstruct(n2 += n3 / 5, transform.position.x, transform.position.y, transform.rotation.x, transform.rotation.y);
                System.out.print("transform:(" + transform.position.x + ", " + transform.position.y + ") rotation:(" + transform.rotation.x + ", " + transform.rotation.y + ") t:" + n2 + "\n");
                TestZombieInterpolate.assertEquals((float)(f + (float)(j + 1) * 2.0f - 10.0f), (float)transform.position.x, (float)0.9f);
                TestZombieInterpolate.assertEquals((float)(f2 - (float)(j + 1) * 0.5f + 2.5f), (float)transform.position.y, (float)0.9f);
            }
        }
    }

    @Test
    public void test_reconstructor_unnormal_go() {
        int n;
        int n2;
        NetworkCharacter.Transform transform = new NetworkCharacter.Transform();
        transform.position = new Vector2();
        transform.rotation = new Vector2();
        NetworkCharacter networkCharacter = new NetworkCharacter(0.0f, 100.0f, 0L);
        NetworkCharacter.Transform transform2 = networkCharacter.transform;
        int n3 = n2 = 10000;
        int n4 = 250;
        float f = 100.0f;
        float f2 = 200.0f;
        float f3 = 4.0f;
        float f4 = -1.0f;
        System.out.print("update x:" + f + " y:" + f2 + " t:" + n2 + "\n");
        networkCharacter.updateInterpolationPoint(n2, f, f2, f3, f4);
        System.out.print("update x:" + (f += 10.0f) + " y:" + (f2 -= 2.5f) + " t:" + (n2 += n4) + "\n");
        networkCharacter.updateInterpolationPoint(n2, f, f2, f3, f4);
        transform2 = networkCharacter.reconstruct(n3, transform2.position.x, transform2.position.y, transform2.rotation.x, transform2.rotation.y);
        for (n = 0; n < 5; ++n) {
            transform2 = networkCharacter.reconstruct(n3 += n4 / 5, transform2.position.x, transform2.position.y, transform2.rotation.x, transform2.rotation.y);
            System.out.print("transform:(" + transform2.position.x + ", " + transform2.position.y + ")\n");
            TestZombieInterpolate.assertEquals((float)(f + (float)(n + 1) * 2.0f - 10.0f), (float)transform2.position.x, (float)1.9f);
            TestZombieInterpolate.assertEquals((float)(f2 - (float)(n + 1) * 0.5f + 2.5f), (float)transform2.position.y, (float)1.5f);
        }
        for (n = 0; n < 30; ++n) {
            System.out.print("update x:" + (f += 10.0f) + " y:" + (f2 -= 2.5f) + " t:" + (n2 += n4) + "\n");
            networkCharacter.updateInterpolationPoint(n2, f, f2, f3, f4);
            for (int i = 0; i < 5; ++i) {
                transform2 = networkCharacter.reconstruct(n3 += n4 / 5, transform2.position.x, transform2.position.y, transform2.rotation.x, transform2.rotation.y);
                System.out.print("transform:(" + transform2.position.x + ", " + transform2.position.y + ")\n");
                TestZombieInterpolate.assertEquals((float)(f + (float)(i + 1) * 2.0f - 10.0f), (float)transform2.position.x, (float)1.1f);
                TestZombieInterpolate.assertEquals((float)(f2 - (float)(i + 1) * 0.5f + 2.5f), (float)transform2.position.y, (float)1.1f);
                transform.position.set(transform2.position);
                transform.rotation.set(transform2.rotation);
            }
        }
    }

    @Test
    public void test_all() {
        int n;
        int n2;
        int n3;
        NetworkCharacter networkCharacter = new NetworkCharacter(0.0f, 100.0f, 0L);
        NetworkCharacter.Transform transform = networkCharacter.transform;
        int n4 = n3 = 10000;
        int n5 = 250;
        float f = 100.0f;
        float f2 = 200.0f;
        float f3 = 0.04f;
        float f4 = -0.01f;
        System.out.print("update x:" + f + " y:" + f2 + " t:" + n3 + "\n");
        networkCharacter.updateInterpolationPoint(n3, f, f2, f3, f4);
        System.out.print("Normal interpolate\n");
        for (n2 = 0; n2 < 10; ++n2) {
            System.out.print("update x:" + (f += 10.0f) + " y:" + (f2 -= 2.5f) + " t:" + (n3 += n5) + "\n");
            networkCharacter.updateInterpolationPoint(n3, f, f2, f3, f4);
            for (n = 0; n < 5; ++n) {
                transform = networkCharacter.reconstruct(n4 += n5 / 5, transform.position.x, transform.position.y, transform.rotation.x, transform.rotation.y);
                System.out.print("transform:(" + transform.position.x + ", " + transform.position.y + ") rotation:(" + transform.rotation.x + ", " + transform.rotation.y + ") t:" + n4 + "\n");
            }
        }
        System.out.print("Extrapolate\n");
        for (n2 = 0; n2 < 20; ++n2) {
            transform = networkCharacter.reconstruct(n4 += n5 / 5, transform.position.x, transform.position.y, transform.rotation.x, transform.rotation.y);
            System.out.print("transform:(" + transform.position.x + ", " + transform.position.y + ") rotation:(" + transform.rotation.x + ", " + transform.rotation.y + ") t:" + n4 + "\n");
        }
        System.out.print("Teleport\n");
        System.out.print("update x:" + (f += 100.0f) + " y:" + (f2 -= 25.0f) + " t:" + (n3 += n5 * 10) + "\n");
        networkCharacter.updateInterpolationPoint(n3, f, f2, f3, f4);
        for (n2 = 0; n2 < 30; ++n2) {
            transform = networkCharacter.reconstruct(n4 += n5 / 5, transform.position.x, transform.position.y, transform.rotation.x, transform.rotation.y);
            System.out.print("transform:(" + transform.position.x + ", " + transform.position.y + ") rotation:(" + transform.rotation.x + ", " + transform.rotation.y + ") t:" + n4 + "\n");
        }
        System.out.print("Normal interpolate\n");
        for (n2 = 0; n2 < 10; ++n2) {
            System.out.print("update x:" + (f += 10.0f) + " y:" + (f2 -= 2.5f) + " t:" + (n3 += n5) + "\n");
            networkCharacter.updateInterpolationPoint(n3, f, f2, f3, f4);
            for (n = 0; n < 5; ++n) {
                transform = networkCharacter.reconstruct(n4 += n5 / 5, transform.position.x, transform.position.y, transform.rotation.x, transform.rotation.y);
                System.out.print("transform:(" + transform.position.x + ", " + transform.position.y + ") rotation:(" + transform.rotation.x + ", " + transform.rotation.y + ") t:" + n4 + "\n");
            }
        }
        System.out.print("Extrapolate\n");
        for (n2 = 0; n2 < 20; ++n2) {
            transform = networkCharacter.reconstruct(n4 += n5, transform.position.x, transform.position.y, transform.rotation.x, transform.rotation.y);
            System.out.print("transform:(" + transform.position.x + ", " + transform.position.y + ") rotation:(" + transform.rotation.x + ", " + transform.rotation.y + ") t:" + n4 + "\n");
        }
        n3 += n5 * 20;
        f += 200.0f;
        f2 -= 50.0f;
        System.out.print("Normal interpolate\n");
        for (n2 = 0; n2 < 10; ++n2) {
            System.out.print("update x:" + (f += 10.0f) + " y:" + (f2 -= 2.5f) + " t:" + (n3 += n5) + "\n");
            networkCharacter.updateInterpolationPoint(n3, f, f2, f3, f4);
            for (n = 0; n < 5; ++n) {
                transform = networkCharacter.reconstruct(n4 += n5 / 5, transform.position.x, transform.position.y, transform.rotation.x, transform.rotation.y);
                System.out.print("transform:(" + transform.position.x + ", " + transform.position.y + ") rotation:(" + transform.rotation.x + ", " + transform.rotation.y + ") t:" + n4 + "\n");
            }
        }
    }

    @Test
    public void test_case1() {
        NetworkCharacter.Transform transform = new NetworkCharacter.Transform();
        transform.position = new Vector2();
        transform.rotation = new Vector2();
        long[] lArray = new long[]{982999607L, 982999623L, 982999640L, 982999656L, 982999674L, 982999690L, 982999706L, 982999723L, 982999740L, 982999756L, 982999773L, 982999791L, 982999807L, 982999823L, 982999840L, 982999856L, 982999872L};
        NetworkCharacter networkCharacter = new NetworkCharacter(0.0f, 100.0f, 0L);
        NetworkCharacter.Transform transform2 = networkCharacter.transform;
        System.out.print("update x:10593.158 y:9952.486 t:982998656\n");
        System.out.print("update x:10593.23 y:9950.746 t:982999872\n");
        networkCharacter.updateInterpolationPoint(982998656, 10593.158f, 9952.486f, 0.0f, -0.0014706347f);
        networkCharacter.updateInterpolationPoint(982999872, 10593.23f, 9950.746f, 0.0f, -0.0014323471f);
        int n = (int)lArray[0];
        for (long l : lArray) {
            transform2 = networkCharacter.reconstruct((int)l, transform2.position.x, transform2.position.y, transform2.rotation.x, transform2.rotation.y);
            System.out.print("transform:(" + transform2.position.x + ", " + transform2.position.y + ") rotation:(" + transform2.rotation.x + ", " + transform2.rotation.y + ") t:" + l + " t':" + (l - (long)n) + "\n");
            if (l > lArray[0]) {
                // empty if block
            }
            transform.position.set(transform2.position);
            transform.rotation.set(transform2.rotation);
            n = (int)l;
        }
    }
}

