/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.nio.ByteBuffer;
import zombie.characters.IsoGameCharacter;
import zombie.core.math.PZMath;
import zombie.iso.areas.NonPvpZone;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerOptions;

public class Safety {
    protected boolean enabled;
    protected boolean last;
    protected float cooldown;
    protected float toggle;
    protected IsoGameCharacter character;

    public Safety() {
    }

    public Safety(IsoGameCharacter isoGameCharacter) {
        this.character = isoGameCharacter;
        this.enabled = true;
        this.last = true;
        this.cooldown = 0.0f;
        this.toggle = 0.0f;
    }

    public void copyFrom(Safety safety) {
        this.enabled = safety.enabled;
        this.last = safety.last;
        this.cooldown = safety.cooldown;
        this.toggle = safety.toggle;
    }

    public Object getCharacter() {
        return this.character;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean bl) {
        this.last = bl;
    }

    public float getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(float f) {
        this.cooldown = f;
    }

    public float getToggle() {
        return this.toggle;
    }

    public void setToggle(float f) {
        this.toggle = f;
    }

    public boolean isToggleAllowed() {
        return ServerOptions.getInstance().PVP.getValue() && NonPvpZone.getNonPvpZone(PZMath.fastfloor(this.character.getX()), PZMath.fastfloor(this.character.getY())) == null && (!ServerOptions.getInstance().SafetySystem.getValue() || this.getCooldown() == 0.0f && this.getToggle() == 0.0f);
    }

    public void toggleSafety() {
        if (this.isToggleAllowed()) {
            if (GameClient.bClient) {
                GameClient.sendChangeSafety(this);
            } else {
                this.setToggle(ServerOptions.getInstance().SafetyToggleTimer.getValue());
                this.setLast(this.isEnabled());
                if (this.isEnabled()) {
                    this.setEnabled(!this.isEnabled());
                }
                if (GameServer.bServer) {
                    GameServer.sendChangeSafety(this);
                }
            }
        }
    }

    public void load(ByteBuffer byteBuffer, int n) {
        this.enabled = byteBuffer.get() != 0;
        this.last = byteBuffer.get() != 0;
        this.cooldown = byteBuffer.getFloat();
        this.toggle = byteBuffer.getFloat();
    }

    public void save(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)(this.enabled ? 1 : 0));
        byteBuffer.put((byte)(this.last ? 1 : 0));
        byteBuffer.putFloat(this.cooldown);
        byteBuffer.putFloat(this.toggle);
    }

    public String getDescription() {
        return "enabled=" + this.enabled + " last=" + this.last + " cooldown=" + this.cooldown + " toggle=" + this.toggle;
    }
}

