/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import zombie.GameTime;
import zombie.characters.CharacterTimedActions.BaseAction;
import zombie.characters.HitReactionNetworkAI;
import zombie.characters.IsoGameCharacter;
import zombie.characters.NetworkTeleport;
import zombie.core.Core;
import zombie.core.raknet.UdpConnection;
import zombie.core.utils.UpdateLimit;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.iso.IsoUtils;
import zombie.iso.Vector2;
import zombie.network.GameServer;
import zombie.network.NetworkVariables;
import zombie.network.PacketValidator;
import zombie.network.packets.DeadCharacterPacket;
import zombie.network.packets.hit.IMovable;
import zombie.network.packets.hit.VehicleHitPacket;

public abstract class NetworkCharacterAI {
    private static final short VEHICLE_HIT_DELAY_MS = 500;
    private final SpeedChecker speedChecker = new SpeedChecker();
    public NetworkVariables.PredictionTypes predictionType;
    protected DeadCharacterPacket deadBody;
    protected VehicleHitPacket vehicleHit;
    protected float timestamp;
    protected BaseAction action;
    protected String performingAction;
    protected long noCollisionTime;
    protected boolean wasLocal;
    protected final HitReactionNetworkAI hitReaction;
    private final IsoGameCharacter character;
    public NetworkTeleport.NetworkTeleportDebug teleportDebug;
    public final HashMap<Integer, String> debugData = new LinkedHashMap<Integer, String>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, String> entry) {
            return this.size() > 10;
        }
    };

    public NetworkCharacterAI(IsoGameCharacter isoGameCharacter) {
        this.character = isoGameCharacter;
        this.deadBody = null;
        this.wasLocal = false;
        this.vehicleHit = null;
        this.noCollisionTime = 0L;
        this.hitReaction = new HitReactionNetworkAI(isoGameCharacter);
        this.predictionType = NetworkVariables.PredictionTypes.None;
        this.clearTeleportDebug();
        this.speedChecker.reset();
    }

    public void reset() {
        this.deadBody = null;
        this.wasLocal = false;
        this.vehicleHit = null;
        this.noCollisionTime = 0L;
        this.hitReaction.finish();
        this.predictionType = NetworkVariables.PredictionTypes.None;
        this.clearTeleportDebug();
        this.speedChecker.reset();
    }

    public void setLocal(boolean bl) {
        this.wasLocal = bl;
    }

    public boolean wasLocal() {
        return this.wasLocal;
    }

    public NetworkTeleport.NetworkTeleportDebug getTeleportDebug() {
        return this.teleportDebug;
    }

    public void clearTeleportDebug() {
        this.teleportDebug = null;
        this.debugData.clear();
    }

    public void setTeleportDebug(NetworkTeleport.NetworkTeleportDebug networkTeleportDebug) {
        this.teleportDebug = networkTeleportDebug;
        this.debugData.entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.naturalOrder())).forEach(entry -> {
            if (Core.bDebug) {
                DebugLog.log(DebugType.Multiplayer, "==> " + (String)entry.getValue());
            }
        });
        if (Core.bDebug) {
            DebugLog.log(DebugType.Multiplayer, String.format("NetworkTeleport %s id=%d distance=%.3f prediction=%s", new Object[]{this.character.getClass().getSimpleName(), this.character.getOnlineID(), Float.valueOf(networkTeleportDebug.getDistance()), this.predictionType}));
        }
    }

    public void addTeleportData(int n, String string) {
        this.debugData.put(n, string);
    }

    public void processDeadBody() {
        if (this.isSetDeadBody() && !this.hitReaction.isSetup() && !this.hitReaction.isStarted()) {
            this.deadBody.process();
            this.setDeadBody(null);
        }
    }

    public void setDeadBody(DeadCharacterPacket deadCharacterPacket) {
        this.deadBody = deadCharacterPacket;
        DebugLog.Death.trace(deadCharacterPacket == null ? "processed" : "postpone");
    }

    public boolean isSetDeadBody() {
        return this.deadBody != null && this.deadBody.isConsistent();
    }

    public void setPerformingAction(String string) {
        this.performingAction = string;
    }

    public String getPerformingAction() {
        return this.performingAction;
    }

    public void setAction(BaseAction baseAction) {
        this.action = baseAction;
    }

    public BaseAction getAction() {
        return this.action;
    }

    public void startAction() {
        if (this.action != null) {
            this.action.start();
        }
    }

    public void stopAction() {
        if (this.action != null) {
            this.setOverride(false, null, null);
            this.action.stop();
        }
    }

    public void setOverride(boolean bl, String string, String string2) {
        if (this.action != null) {
            this.action.chr.forceNullOverride = bl;
            this.action.chr.overridePrimaryHandModel = string;
            this.action.chr.overrideSecondaryHandModel = string2;
            this.action.chr.resetModelNextFrame();
        }
    }

    public void processVehicleHit() {
        this.vehicleHit.tryProcessInternal();
        this.setVehicleHit(null);
    }

    public void setVehicleHit(VehicleHitPacket vehicleHitPacket) {
        this.vehicleHit = vehicleHitPacket;
        this.timestamp = TimeUnit.NANOSECONDS.toMillis(GameTime.getServerTime());
        DebugLog.Damage.noise(vehicleHitPacket == null ? "processed" : "postpone");
    }

    public boolean isSetVehicleHit() {
        return this.vehicleHit != null && this.vehicleHit.isConsistent();
    }

    public void resetVehicleHitTimeout() {
        this.timestamp = TimeUnit.NANOSECONDS.toMillis(GameTime.getServerTime()) - 500L;
        if (this.vehicleHit == null) {
            DebugLog.Damage.noise("VehicleHit is not set");
        }
    }

    public boolean isVehicleHitTimeout() {
        boolean bl;
        boolean bl2 = bl = (float)TimeUnit.NANOSECONDS.toMillis(GameTime.getServerTime()) - this.timestamp >= 500.0f;
        if (bl) {
            DebugLog.Damage.noise("VehicleHit timeout");
        }
        return bl;
    }

    public void updateHitVehicle() {
        if (this.isSetVehicleHit() && this.isVehicleHitTimeout()) {
            this.processVehicleHit();
        }
    }

    public boolean isCollisionEnabled() {
        return this.noCollisionTime == 0L;
    }

    public boolean isNoCollisionTimeout() {
        boolean bl;
        boolean bl2 = bl = GameTime.getServerTimeMills() > this.noCollisionTime;
        if (bl) {
            this.setNoCollision(0L);
        }
        return bl;
    }

    public void setNoCollision(long l) {
        if (l == 0L) {
            this.noCollisionTime = 0L;
            if (Core.bDebug) {
                DebugLog.log(DebugType.Multiplayer, "SetNoCollision: disabled");
            }
        } else {
            this.noCollisionTime = GameTime.getServerTimeMills() + l;
            if (Core.bDebug) {
                DebugLog.log(DebugType.Multiplayer, "SetNoCollision: enabled for " + l + " ms");
            }
        }
    }

    public boolean checkPosition(UdpConnection udpConnection, IsoGameCharacter isoGameCharacter, float f, float f2) {
        if (GameServer.bServer && isoGameCharacter.isAlive()) {
            this.speedChecker.set(f, f2, isoGameCharacter.isSeatedInVehicle());
            boolean bl = PacketValidator.checkSpeed(udpConnection, this.speedChecker, isoGameCharacter.getClass().getSimpleName() + SpeedChecker.class.getSimpleName());
            if (32 == udpConnection.accessLevel) {
                bl = true;
            }
            return bl;
        }
        return true;
    }

    public void resetSpeedLimiter() {
        this.speedChecker.reset();
    }

    private static class SpeedChecker
    implements IMovable {
        private static final int checkDelay = 5000;
        private static final int checkInterval = 1000;
        private final UpdateLimit updateLimit = new UpdateLimit(5000L);
        private final Vector2 position = new Vector2();
        private boolean isInVehicle;
        private float speed;

        private SpeedChecker() {
        }

        @Override
        public float getSpeed() {
            return this.speed;
        }

        @Override
        public boolean isVehicle() {
            return this.isInVehicle;
        }

        private void set(float f, float f2, boolean bl) {
            if (this.updateLimit.Check()) {
                if (5000L == this.updateLimit.getDelay()) {
                    this.updateLimit.Reset(1000L);
                    this.position.set(0.0f, 0.0f);
                    this.speed = 0.0f;
                }
                this.isInVehicle = bl;
                if (this.position.getLength() != 0.0f) {
                    this.speed = IsoUtils.DistanceTo(this.position.x, this.position.y, f, f2);
                }
                this.position.set(f, f2);
            }
        }

        private void reset() {
            this.updateLimit.Reset(5000L);
            this.isInVehicle = false;
            this.position.set(0.0f, 0.0f);
            this.speed = 0.0f;
        }

        public String getDescription() {
            return "SpeedChecker: speed=" + this.speed + " x=" + this.position.x + " y=" + this.position.y + " vehicle=" + this.isInVehicle;
        }
    }
}

