/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import zombie.iso.Vector2;

public class NetworkCharacter {
    float minMovement;
    float maxMovement;
    long deltaTime;
    public final Transform transform = new Transform();
    final Vector2 movement = new Vector2();
    final Point d1 = new Point();
    final Point d2 = new Point();

    public NetworkCharacter() {
        this.minMovement = 0.075f;
        this.maxMovement = 0.5f;
        this.deltaTime = 10L;
    }

    NetworkCharacter(float f, float f2, long l) {
        this.minMovement = f;
        this.maxMovement = f2;
        this.deltaTime = l;
    }

    public void updateTransform(float f, float f2, float f3, float f4) {
        this.transform.position.x = f;
        this.transform.position.y = f2;
        this.transform.rotation.x = f3;
        this.transform.rotation.y = f4;
    }

    public void updateInterpolationPoint(int n, float f, float f2, float f3, float f4) {
        if (this.d2.t == 0) {
            this.updateTransform(f, f2, f3, f4);
        }
        this.d2.t = n;
        this.d2.px = f;
        this.d2.py = f2;
        this.d2.rx = f3;
        this.d2.ry = f4;
    }

    public void updatePointInternal(float f, float f2, float f3, float f4) {
        this.d1.px = f;
        this.d1.py = f2;
        this.d1.rx = f3;
        this.d1.ry = f4;
    }

    public void updateExtrapolationPoint(int n, float f, float f2, float f3, float f4) {
        if (n > this.d1.t) {
            this.d2.t = this.d1.t;
            this.d2.px = this.d1.px;
            this.d2.py = this.d1.py;
            this.d2.rx = this.d1.rx;
            this.d2.ry = this.d1.ry;
            this.d1.t = n;
            this.d1.px = f;
            this.d1.py = f2;
            this.d1.rx = f3;
            this.d1.ry = f4;
        }
    }

    void extrapolate(int n) {
        float f = (float)(n - this.d1.t) / (float)(this.d1.t - this.d2.t);
        float f2 = this.d1.px - this.d2.px;
        float f3 = this.d1.py - this.d2.py;
        this.movement.x = f2 * f;
        this.movement.y = f3 * f;
        if (f2 > this.minMovement || f3 > this.minMovement || -f2 > this.minMovement || -f3 > this.minMovement) {
            this.transform.moving = true;
            this.transform.rotation.x = this.movement.x;
            this.transform.rotation.y = this.movement.y;
            this.transform.rotation.normalize();
        }
        this.transform.position.x = this.d1.px + this.movement.x;
        this.transform.position.y = this.d1.py + this.movement.y;
        this.transform.operation = Operation.EXTRAPOLATION;
    }

    void extrapolateInternal(int n, float f, float f2) {
        float f3 = (float)(n - this.d1.t) / (float)(n - this.d1.t);
        float f4 = f - this.d1.px;
        float f5 = f2 - this.d1.py;
        this.movement.x = f4 * f3;
        this.movement.y = f5 * f3;
        if (this.movement.getLength() > this.maxMovement) {
            this.movement.setLength(this.maxMovement);
        }
        if (f4 > this.minMovement || f5 > this.minMovement || -f4 > this.minMovement || -f5 > this.minMovement) {
            this.transform.moving = true;
            this.transform.rotation.x = this.movement.x;
            this.transform.rotation.y = this.movement.y;
            this.transform.rotation.normalize();
        }
        this.transform.position.x = f + this.movement.x;
        this.transform.position.y = f2 + this.movement.y;
        this.transform.operation = Operation.EXTRAPOLATION;
    }

    void interpolate(int n) {
        float f = (float)(n - this.d1.t) / (float)(this.d2.t - this.d1.t);
        float f2 = this.d2.px - this.d1.px;
        float f3 = this.d2.py - this.d1.py;
        this.movement.x = f2 * f;
        this.movement.y = f3 * f;
        if (this.movement.getLength() > this.maxMovement) {
            this.movement.setLength(this.maxMovement);
        }
        if (f2 > this.minMovement || f3 > this.minMovement || -f2 > this.minMovement || -f3 > this.minMovement) {
            this.transform.moving = true;
            this.transform.rotation.x = this.movement.x;
            this.transform.rotation.y = this.movement.y;
            this.transform.rotation.normalize();
        }
        this.transform.position.x = this.d1.px + this.movement.x;
        this.transform.position.y = this.d1.py + this.movement.y;
        this.transform.operation = Operation.INTERPOLATION;
    }

    public Transform predict(int n, int n2, float f, float f2, float f3, float f4) {
        this.transform.moving = false;
        this.transform.operation = Operation.NONE;
        this.transform.time = n2 + n;
        this.updateExtrapolationPoint(n2, f, f2, f3, f4);
        if (this.d1.t != 0 && this.d2.t != 0) {
            this.extrapolate(n + n2);
        } else {
            this.updateTransform(f, f2, f3, f4);
        }
        return this.transform;
    }

    public Transform reconstruct(int n, float f, float f2, float f3, float f4) {
        this.transform.moving = false;
        this.transform.operation = Operation.NONE;
        if (this.d2.t != 0) {
            if ((long)n + this.deltaTime <= (long)this.d2.t) {
                this.updatePointInternal(f, f2, f3, f4);
                if (this.d1.t != 0 && this.d1.t != n) {
                    this.interpolate(n);
                }
                this.d1.t = n;
            } else if (n > this.d2.t && n < this.d2.t + 2000) {
                this.extrapolateInternal(n, f, f2);
                this.updatePointInternal(f, f2, f3, f4);
                this.d1.t = n;
            }
        }
        return this.transform;
    }

    public void checkReset(int n) {
        if (n > 2000 + this.d2.t) {
            this.reset();
        }
    }

    public void checkResetPlayer(int n) {
        if (n > 2000 + this.d1.t) {
            this.reset();
        }
    }

    public void reset() {
        this.d1.t = 0;
        this.d1.px = 0.0f;
        this.d1.py = 0.0f;
        this.d1.rx = 0.0f;
        this.d1.ry = 0.0f;
        this.d2.t = 0;
        this.d2.px = 0.0f;
        this.d2.py = 0.0f;
        this.d2.rx = 0.0f;
        this.d2.ry = 0.0f;
    }

    public static class Transform {
        public Vector2 position = new Vector2();
        public Vector2 rotation = new Vector2();
        public Operation operation = Operation.NONE;
        public boolean moving = false;
        public int time = 0;
    }

    static class Point {
        public float px = 0.0f;
        public float py = 0.0f;
        public float rx = 0.0f;
        public float ry = 0.0f;
        public int t = 0;

        Point() {
        }
    }

    public static enum Operation {
        INTERPOLATION,
        EXTRAPOLATION,
        NONE;

    }
}

