/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.Moodles;

import java.util.Stack;
import zombie.characters.IsoGameCharacter;
import zombie.characters.Moodles.Moodle;
import zombie.characters.Moodles.MoodleType;
import zombie.core.Color;

public final class Moodles {
    boolean MoodlesStateChanged = false;
    private Stack<Moodle> MoodleList = new Stack();
    private final IsoGameCharacter Parent;

    public Moodles(IsoGameCharacter isoGameCharacter) {
        this.Parent = isoGameCharacter;
        this.MoodleList.add(new Moodle(MoodleType.Endurance, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Tired, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Hungry, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Panic, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Sick, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Bored, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Unhappy, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Bleeding, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Wet, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.HasACold, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Angry, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Stress, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Thirst, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Injured, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Pain, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.HeavyLoad, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Drunk, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Dead, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Zombie, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.FoodEaten, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.Hyperthermia, this.Parent, 3));
        this.MoodleList.add(new Moodle(MoodleType.Hypothermia, this.Parent, 3));
        this.MoodleList.add(new Moodle(MoodleType.Windchill, this.Parent));
        this.MoodleList.add(new Moodle(MoodleType.CantSprint, this.Parent));
    }

    public int getGoodBadNeutral(int n) {
        return MoodleType.GoodBadNeutral(((Moodle)this.MoodleList.get((int)n)).Type);
    }

    public String getMoodleDisplayString(int n) {
        return MoodleType.getDisplayName(((Moodle)this.MoodleList.get((int)n)).Type, ((Moodle)this.MoodleList.get(n)).getLevel());
    }

    public String getMoodleDescriptionString(int n) {
        return MoodleType.getDescriptionText(((Moodle)this.MoodleList.get((int)n)).Type, ((Moodle)this.MoodleList.get(n)).getLevel());
    }

    public int getMoodleLevel(int n) {
        return ((Moodle)this.MoodleList.get(n)).getLevel();
    }

    public int getMoodleLevel(MoodleType moodleType) {
        return ((Moodle)this.MoodleList.get(MoodleType.ToIndex(moodleType))).getLevel();
    }

    public int getMoodleChevronCount(int n) {
        return ((Moodle)this.MoodleList.get(n)).getChevronCount();
    }

    public boolean getMoodleChevronIsUp(int n) {
        return ((Moodle)this.MoodleList.get(n)).isChevronIsUp();
    }

    public Color getMoodleChevronColor(int n) {
        return ((Moodle)this.MoodleList.get(n)).getChevronColor();
    }

    public MoodleType getMoodleType(int n) {
        return ((Moodle)this.MoodleList.get((int)n)).Type;
    }

    public int getNumMoodles() {
        return this.MoodleList.size();
    }

    public void Randomise() {
    }

    public boolean UI_RefreshNeeded() {
        if (this.MoodlesStateChanged) {
            this.MoodlesStateChanged = false;
            return true;
        }
        return false;
    }

    public void setMoodlesStateChanged(boolean bl) {
        this.MoodlesStateChanged = bl;
    }

    public void Update() {
        for (int i = 0; i < this.MoodleList.size(); ++i) {
            if (!((Moodle)this.MoodleList.get(i)).Update()) continue;
            this.MoodlesStateChanged = true;
        }
    }
}

